/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.util;

import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import java.util.ArrayList;
import java.util.List;

public class SetIdForExpressionUtil {
    public static void setIdForExpression(Module module) {
        List filterList;
        List calcList;
        if (module == null) {
            return;
        }
        List qsList = module.basicGetQuerySubject();
        if (qsList != null) {
            for (QuerySubject qs : qsList) {
                if (qs.basicGetIdForExpression() == null) {
                    qs.setIdForExpression(qs.getIdentifier());
                }
                SetIdForExpressionUtil.setIdForExpressionItemTypeList(qs.basicGetItem());
            }
        }
        if ((calcList = module.basicGetCalculation()) != null) {
            for (Calculation c : calcList) {
                if (c.basicGetIdForExpression() == null) {
                    c.setIdForExpression(c.getIdentifier());
                }
                SetIdForExpressionUtil.setIdForExpressionItemTypeList(c.basicGetItem());
            }
        }
        if ((filterList = module.basicGetFilter()) != null) {
            for (Filter flt : filterList) {
                if (flt.basicGetIdForExpression() != null) continue;
                flt.setIdForExpression(flt.getIdentifier());
            }
        }
    }

    protected static void setIdForExpressionItemTypeList(List<ItemType> itemTypeList) {
        if (itemTypeList == null) {
            return;
        }
        for (ItemType itm : itemTypeList) {
            ItemType.Folder folder;
            Filter flt;
            Calculation c;
            QueryItem queryItem = itm.getQueryItem();
            if (queryItem != null && queryItem.basicGetIdForExpression() == null) {
                String idForExpr = SetIdForExpressionUtil.generateIdForExpression((ObjectType)queryItem);
                queryItem.setIdForExpression(idForExpr);
                SetIdForExpressionUtil.setIdForExpressionItemTypeList(queryItem.basicGetItem());
            }
            if ((c = itm.getCalculation()) != null && c.basicGetIdForExpression() == null) {
                String idForExpr = SetIdForExpressionUtil.generateIdForExpression((ObjectType)c);
                c.setIdForExpression(idForExpr);
                SetIdForExpressionUtil.setIdForExpressionItemTypeList(c.basicGetItem());
            }
            if ((flt = itm.getFilter()) != null && flt.basicGetIdForExpression() == null) {
                String idForExpr = SetIdForExpressionUtil.generateIdForExpression((ObjectType)flt);
                flt.setIdForExpression(idForExpr);
            }
            if ((folder = itm.getFolder()) == null) continue;
            SetIdForExpressionUtil.setIdForExpressionItemTypeList(folder.basicGetItem());
        }
    }

    protected static String generateIdForExpression(ObjectType obj) {
        int s;
        String objType;
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(obj.getIdentifier());
        for (MoserObject parent = obj.getParent(); parent != null && !"Module".equals(objType = parent.getObjectType()); parent = parent.getParent()) {
            if ("QuerySubject".equals(objType)) {
                parts.add(((ObjectType)parent).getIdentifier());
                break;
            }
            if (!"QueryItem".equals(objType) && !"Calculation".equals(objType) && !"Filter".equals(objType)) continue;
            parts.add(((ObjectType)parent).getIdentifier());
        }
        StringBuilder sb = new StringBuilder();
        for (int i = s = parts.size() - 1; i >= 0; --i) {
            if (i != s) {
                sb.append(".");
            }
            sb.append((String)parts.get(i));
        }
        return sb.toString();
    }
}

