/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.metadata.util;

import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.metadata.util.ICodec;
import com.ibm.bi.platform.moser.core.metadata.util.JaxbContextPool;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class XMLCodec
implements ICodec {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String encode(Object o) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            JaxbContextPool.getInstance().marshal(o, bos);
            String string = bos.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    @Override
    public Object decode(Class<?> c, String xml) {
        try {
            return JaxbContextPool.getInstance().unmarshal(xml, c);
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    @Override
    public void encode(Object o, OutputStream os) {
        try {
            JaxbContextPool.getInstance().marshal(o, os);
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    @Override
    public Object decode(Class<?> c, InputStream is) {
        try {
            return JaxbContextPool.getInstance().unmarshal(is, c);
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }
}

