/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.metadata.util.ICodec;
import com.ibm.bi.platform.moser.core.metadata.util.IModuleReaderWriter;
import com.ibm.bi.platform.moser.core.metadata.util.XMLCodec;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileMarshaller
implements IModuleReaderWriter {
    private static final String REASON = "\tReason: ";
    private ICodec codec = new XMLCodec();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object unmarshal(File file, Class<? extends Object> objClass) {
        try (FileInputStream is = new FileInputStream(file);){
            Object object = this.codec.decode(objClass, is);
            return object;
        }
        catch (Exception e) {
            LoggerAdapter.error(FileMarshaller.class, "Failed to unmarshal object '" + objClass.getClass().getName() + "' from file: " + file.getAbsoluteFile() + REASON + e.getLocalizedMessage(), e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean marshal(File file, Object obj) {
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            LoggerAdapter.error(FileMarshaller.class, "Failes to marshal object '" + obj.getClass().getName() + "' to file: " + file.getAbsoluteFile() + REASON + e.getLocalizedMessage(), e);
            return false;
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            this.codec.encode(obj, os);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LoggerAdapter.error(FileMarshaller.class, "Failes to marshal object '" + obj.getClass().getName() + "' to file: " + file.getAbsoluteFile() + REASON + e.getLocalizedMessage(), e);
            return false;
        }
    }

    @Override
    public void setCodec(ICodec codec) {
        this.codec = codec;
    }

    @Override
    public Module read(String moduleFullName) {
        File f = FileMarshaller.getFileFromModuleName(moduleFullName);
        return (Module)this.unmarshal(f, Module.class);
    }

    @Override
    public void write(Module module) {
        String moduleFullName = module.getContainer() + "." + module.getIdentifier();
        this.marshal(FileMarshaller.getFileFromModuleName(moduleFullName), Module.class);
    }

    private static File getFileFromModuleName(String moduleFullName) {
        String[] fileParts;
        StringBuilder fileName = new StringBuilder(MoserConfig.getInstance().getMoserOutputDirectory());
        for (String filePart : fileParts = moduleFullName.split("\\.")) {
            fileName.append(File.separator);
            fileName.append(filePart);
        }
        fileName.append(".xml");
        return new File(fileName.toString());
    }
}

