/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.utils.MoserConnectionSpec;
import com.ibm.bi.platform.moser.core.ma.MoserXQESoapBridge;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.verify.Verifier;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.json.java.JSONObject;
import java.io.File;
import javax.servlet.http.HttpServletRequest;

public abstract class ModuleObjectManager
implements IModuleObjectManager {
    protected final RequestEnvironment runtime;
    MoserConnectionSpec mConnSpec;

    public ModuleObjectManager(RequestEnvironment runtime) {
        this(runtime, null);
    }

    public ModuleObjectManager(RequestEnvironment runtime, MoserConnectionSpec connSpec) {
        this.runtime = runtime;
        this.mConnSpec = connSpec;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.getReqEnvironment().getHttpServletRequest();
    }

    public static String getBaseModuleHRef(String baseId) {
        return "/base_modules/" + baseId;
    }

    public static String getModuleHRef(String moduleId) {
        return "/modules/" + moduleId;
    }

    public static String getContainer(String folder) {
        StringBuilder p = new StringBuilder("\\");
        p.append(File.separator);
        String[] fileParts = folder.split(p.toString());
        boolean modulesFound = false;
        StringBuilder container = new StringBuilder();
        for (String filePart : fileParts) {
            if ("modules".equals(filePart)) {
                modulesFound = true;
            }
            if (!modulesFound) continue;
            container.append(filePart);
            if (filePart.equals(fileParts[fileParts.length - 1])) continue;
            container.append('.');
        }
        return container.toString();
    }

    @Override
    public JSONObject validateModule(Module module, String moduleStoreId, long startTime) {
        Verifier vm = new Verifier(this.runtime, this);
        return vm.verify(module, moduleStoreId, startTime);
    }

    @Override
    public JSONObject checkExpressions(String moduleStoreId, String connSpec) {
        return MoserXQESoapBridge.validateExpressions(this.getReqEnvironment().getHttpServletRequest(), MoserXQESoapBridge.buildBaseURL(this.getReqEnvironment().getHttpServletRequest()), moduleStoreId, this.mConnSpec);
    }

    @Override
    public RequestEnvironment getReqEnvironment() {
        return this.runtime;
    }

    public Module getPhysicalModule(String id) {
        return null;
    }
}

