/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ibm.bi.platform.datasetutils.converters.ParquetConverter;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReadHelper;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.exceptions.http.ForbiddenException;
import com.ibm.bi.platform.moser.common.exceptions.rest.UPSPostTempException;
import com.ibm.bi.platform.moser.common.exceptions.translator.report.ReportNotFoundException;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.EditModeType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.ContentServiceException;
import com.ibm.bi.platform.moser.common.utils.ModuleNotFoundException;
import com.ibm.bi.platform.moser.common.utils.MoserCancelException;
import com.ibm.bi.platform.moser.common.utils.MoserConnectionSpec;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.cm.SearchService;
import com.ibm.bi.platform.moser.core.cm.objects.TempReport;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.ma.MoserXQESoapBridge;
import com.ibm.bi.platform.moser.core.metadata.util.JSONCodec;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.ModuleUseSpecUpdater;
import com.ibm.bi.platform.moser.core.module.Moser304Handler;
import com.ibm.bi.platform.moser.core.module.container.BaseModuleContainer;
import com.ibm.bi.platform.moser.core.module.container.OutputContainer;
import com.ibm.bi.platform.moser.core.module.container.ReportVersionContainer;
import com.ibm.bi.platform.moser.core.module.container.UploadedFileContainer;
import com.ibm.bi.platform.moser.core.module.transformation.PrimaryKeyToItemNormalization;
import com.ibm.bi.platform.moser.core.module.util.BaseOverrides;
import com.ibm.bi.platform.moser.core.module.util.DataModuleExtractor;
import com.ibm.bi.platform.moser.core.module.util.LogicalModuleResolver;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.module.util.MoserMetadataContext;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.RESTUtils;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.ContentServiceUtil;
import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.UserProfileService;
import com.ibm.bi.platform.moser.core.smarts.SmartsServiceUtil;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.translator.report.ReportTranslator;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserInfoUtil;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.core.utils.Pair;
import com.ibm.bi.platform.wkc.core.utils.WKCUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;

public class ModuleObjectManagerCM
extends ModuleObjectManager {
    private static final String SUCCEEDED = "succeeded";
    private static final String BASE_MODULES = "/base_modules/";
    private static final String HREF = "href";
    private static final String LABEL = "label";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String MODULES = "/modules/";
    private static final String SOURCES = "/sources/";
    public static final String DOT_PHYSICALMODULE = ".physicalmodule";
    public static final String DATASETS_COLON = "datasets:";
    public static final String STR_LIVE_CONNECTION = "liveConnection";
    private static final String STR_DATASETS_DOT = "datasets.";
    private static final String STR_DATASETS_COLON = "datasets:";
    private static final String INVALID_MODULE_ERROR = "Invalid module: ";
    private static final String LW_OLAP_MODULE = "lightweightOLAP";
    private static final String EMPTY_STRING = "";
    public static final String PARQUET_UPGRADE = "parquet upgrade";
    private static Configuration conf = new Configuration();
    TaskStatus lastTaskStatus = null;
    private static final String[] CM_FIELDS;
    private static final Cache<String, UseSpecType> objectTypeCache;
    private Map<Pair<String, String>, Module> mModulesFromXQE = new HashMap<Pair<String, String>, Module>();
    private Map<String, String> mOLAPRoutingInfo = new HashMap<String, String>();
    private Moser304Handler m304Handler = null;

    public ModuleObjectManagerCM(RequestEnvironment runtime) {
        this(runtime, null);
    }

    public ModuleObjectManagerCM(RequestEnvironment runtime, MoserConnectionSpec connSpec) {
        super(runtime, connSpec);
        this.create304Handler(runtime);
    }

    private void create304Handler(RequestEnvironment reqEnv) {
        this.m304Handler = new Moser304Handler(reqEnv.getDependencyService(), reqEnv.getVersionService(), this.getModuleStorageCM());
    }

    @Override
    public int saveBaseModulesForDatabase(BaseModuleContainer baseModule) {
        return this.getModuleStorageCM().saveBaseModuleForDatabase(baseModule, MoserConfig.getStoreModuleZipped());
    }

    @Override
    public Module getBaseModule(String id, UseSpecType type) {
        return this.getBaseModule(id, type, "baseDefinition", null);
    }

    @Override
    public Module getBaseModule(String id, UseSpecType type, List<String> ids) {
        return this.getBaseModule(id, type, "baseDefinition", ids);
    }

    @Override
    public Module getBaseModuleForReport(String id) {
        ReportTranslator translator = new ReportTranslator(this.runtime, null);
        Module module = translator.translate(id);
        if (translator.isSessionReport(id)) {
            this.m304Handler.addSessionDependency(id, Long.toString(translator.getLastModified()));
        } else {
            this.m304Handler.addDependency(id, translator.getVersion(id), translator.getLastModified());
        }
        RESTClientResponse resp = new RESTClientResponse(Response.Status.OK.getStatusCode());
        resp.setResponseHeader("ETag", translator.getEtag());
        this.getModuleStorageCM().setRestClientResponse(resp);
        return module;
    }

    @Override
    public Module getBaseModuleForPackage(String id, String moduleAlias) {
        return this.getBaseModuleFromXQEAddSmarts(id, UseSpecType.PACKAGE, moduleAlias, null);
    }

    @Override
    public Module getBaseModuleForPackage(String id, String moduleAlias, List<String> ids) {
        return this.getBaseModuleFromXQEAddSmarts(id, UseSpecType.PACKAGE, moduleAlias, ids);
    }

    private Module getBaseModuleFromXQEAddSmarts(String id, UseSpecType type, String moduleAlias, List<String> ids) {
        Pair<String, String> idAndAlias = new Pair<String, String>(id, moduleAlias);
        Module result = this.mModulesFromXQE.get(idAndAlias);
        if (result != null) {
            return result;
        }
        JSONObject moduleObject = type == UseSpecType.PACKAGE ? this.getBaseModuleJSONObjectForPackage(id, moduleAlias, ids) : this.getBaseModuleJSONObjectForOLAP(id, moduleAlias, ids);
        if (moduleObject != null) {
            result = ModuleObjectManagerCM.decodeModuleJSON(moduleObject.toString());
        }
        if (result == null) {
            return result;
        }
        this.addSmartsToPackageOrLWOLAPModule(result, id, type, moduleAlias);
        ModuleUtil.adjustExpressionsForUnsupportedDataTypes(result);
        ModuleUtil.setEditMode((MoserObject)result, EditModeType.RO);
        this.mModulesFromXQE.put(idAndAlias, result);
        return result;
    }

    private void addSmartsToPackageOrLWOLAPModule(Module module, String id, UseSpecType type, String moduleAlias) {
        String[] fields = new String[]{"baseDefinition", "baseOverrides"};
        JSONObject jBaseModule = type == UseSpecType.PACKAGE ? this.getModuleStorageCM().getBaseModuleChild(id, fields) : this.getModuleStorageCM().getObjectFromCM(id, fields);
        if (jBaseModule != null) {
            Module overridesModule;
            String overridesDef;
            Module smartsModule;
            String baseDef = (String)jBaseModule.get((Object)"baseDefinition");
            if (baseDef != null && (smartsModule = this.decodeModule(baseDef, null, null)) != null) {
                SmartsServiceUtil.mergeSmarts(module, smartsModule, moduleAlias);
            }
            if ((overridesDef = (String)jBaseModule.get((Object)"baseOverrides")) != null && (overridesModule = this.decodeModule(overridesDef, null, null)) != null) {
                SmartsServiceUtil.mergeSmarts(module, overridesModule, moduleAlias);
            }
        }
    }

    @Override
    public String getSearchPathForPackage(String id, String[] rtPackageName) {
        JSONObject cmObject = this.getModuleStorageCM().getObjectFromCM(id, "searchPath", "defaultName", "version", "ancestors", "routingServerGroup");
        if (cmObject == null || cmObject.get((Object)"searchPath") == null) {
            return null;
        }
        String modelPath = (String)cmObject.get((Object)"searchPath");
        if (rtPackageName != null) {
            rtPackageName[0] = (String)cmObject.get((Object)"defaultName");
        }
        this.m304Handler.addDependency(cmObject);
        this.runtime.addAncestorsMap(id, (JSONArray)cmObject.get((Object)"ancestors"));
        this.runtime.addRoutingServerGroupsMap(id, "routingServerGroup");
        return modelPath;
    }

    private JSONObject getBaseModuleJSONObjectForPackage(String id, String alias, List<String> ids) {
        JSONObject cmObject;
        String storeId = id;
        if (ModuleObjectManagerCM.isSearchPath(id)) {
            List<String> properties = Arrays.asList("defaultName", "searchPath", "routingServerGroup", "id", "version", "ancestors");
            cmObject = this.getModuleStorageCM().getObjectSearchPath(id, properties);
            if (cmObject != null) {
                storeId = (String)cmObject.get((Object)"id");
            }
        } else {
            cmObject = this.getModuleStorageCM().getObjectFromCM(id, "searchPath", "defaultName", "routingServerGroup", "modificationTime", "permissions", "version", "ancestors");
            if (cmObject != null) {
                JSONArray permissions = (JSONArray)cmObject.get((Object)"permissions");
                if (!this.getModuleStorageCM().isTrusted() && permissions != null && !permissions.contains((Object)"read")) {
                    String defaultName = cmObject.get((Object)"defaultName").toString();
                    MoserException error = new MoserException(MoserError.MSR_MODULE_ACCESS_DENIED, defaultName);
                    error.setHTTPStatus(Response.Status.FORBIDDEN.getStatusCode());
                    throw error;
                }
            }
        }
        JSONObject result = null;
        if (cmObject != null) {
            String routingServerGroup;
            String defaultName;
            if (!"package".equals(cmObject.get((Object)"type"))) {
                return null;
            }
            String modelPath = (String)cmObject.get((Object)"searchPath");
            result = this.getBaseModuleJSONObjectForPackage(modelPath, defaultName = (String)cmObject.get((Object)"defaultName"), routingServerGroup = (String)cmObject.get((Object)"routingServerGroup"), alias, ids);
            if (result != null) {
                this.m304Handler.addDependency(cmObject);
                this.runtime.addAncestorsMap(storeId, (JSONArray)cmObject.get((Object)"ancestors"));
                this.runtime.addRoutingServerGroupsMap(storeId, routingServerGroup);
                JSONObject baseModule = this.getModuleStorageCM().getBaseModule(storeId, "id", "modificationTime");
                if (baseModule != null) {
                    this.m304Handler.addDependency(baseModule);
                }
            }
        }
        return result;
    }

    public static int getVersion(JSONObject cmObject) {
        return cmObject.containsKey((Object)"version") ? ((Long)cmObject.get((Object)"version")).intValue() : 0;
    }

    private JSONObject getBaseModuleJSONObjectForOLAP(String id, String alias, List<String> ids) {
        JSONObject baseModule = this.getBaseModuleJSONObjectForDatabase(id, "physicalDefinition");
        if (baseModule == null) {
            return null;
        }
        Module physicalModule = this.decodeModule((String)baseModule.get((Object)"physicalDefinition"), null, null);
        if (physicalModule == null) {
            return null;
        }
        List dsList = physicalModule.getDataSource();
        if (dsList == null || dsList.size() != 1) {
            return null;
        }
        DataSource ds = (DataSource)dsList.get(0);
        if (ds == null) {
            return null;
        }
        String routingServerGroup = this.getRequest().getHeader("X-CA-Routing");
        if (routingServerGroup == null || routingServerGroup.isEmpty()) {
            routingServerGroup = this.getOLAPRoutingInfo(id);
        }
        return MoserXQESoapBridge.getOLAPMetadata(this.getRequest(), ds.getCmDataSource(), ds.getCatalog(), ds.getSchema(), alias, ds.getDatabaseType(), routingServerGroup, this.mConnSpec, ids);
    }

    private JSONObject getBaseModuleJSONObjectForPackage(String modelPath, String defaultName, String routingServerGroup, String moduleAlias, List<String> ids) {
        JSONObject result = null;
        try {
            URI baseURI = new URI(this.getRequest().getContextPath() + this.getRequest().getServletPath());
            result = MoserXQESoapBridge.getPackageMetadata(null, this.getRequest(), baseURI.getPath(), modelPath, defaultName, moduleAlias, "4", routingServerGroup, this.mConnSpec, ids);
        }
        catch (URISyntaxException e) {
            LoggerAdapter.error(this, "Invalid URI.");
            LoggerAdapter.errorExceptionStack(this, e);
        }
        return result;
    }

    private void updateDataSource(Module ret, String id) {
        ModuleStorageCM contentManager = this.getReqEnvironment().createModuleStorageCM();
        String key = "ancestors";
        JSONObject object = contentManager.getObjectFromCM(id, key);
        if (object == null) {
            if (contentManager.getRestClientResponse().getResponseCode() == 304) {
                return;
            }
            throw new ModuleNotFoundException(MoserError.MSR_MODULE_NOT_FOUND, id);
        }
        JSONArray ancestors = (JSONArray)object.get((Object)key);
        this.updateDataSourceFromAncestor(ret, ancestors);
    }

    public void updateDataSourceFromAncestor(Module ret, JSONArray ancestors) {
        for (Object ancestor : ancestors) {
            JSONObject obj = (JSONObject)ancestor;
            if (!"dataSource".equals(obj.get((Object)"type"))) continue;
            DataSource ds = (DataSource)ret.getDataSource().get(0);
            ds.setCmDataSource((String)obj.get((Object)"defaultName"));
            break;
        }
    }

    private JSONObject getBaseModuleJSONObject(String id, UseSpecType type, String property) {
        return this.getBaseModuleJSONObject(id, type, property, null);
    }

    private JSONObject getBaseModuleJSONObject(String id, UseSpecType type, String property, List<String> ids) {
        JSONObject baseModule = null;
        UseSpecType moduleType = type;
        if (moduleType == null) {
            moduleType = this.getModuleType(id, null);
        }
        if (moduleType != null) {
            switch (moduleType) {
                case PACKAGE: {
                    baseModule = this.getBaseModuleJSONObjectForPackage(id, null, ids);
                    break;
                }
                case LW_OLAP: {
                    baseModule = this.getBaseModuleJSONObjectForOLAP(id, null, ids);
                    break;
                }
                case DATABASE: {
                    baseModule = this.getBaseModuleJSONObjectForDatabase(id, property);
                    break;
                }
                case FILE: 
                case DATASET: {
                    baseModule = this.getBaseModuleJSONObjectForDatasetOrFile(id, property);
                    break;
                }
            }
        }
        return baseModule;
    }

    private Module getBaseModule(String id, UseSpecType type, String property, List<String> ids) {
        if (!this.moduleOrDependentModuleModified(this.getETagFromRequestHeader())) {
            return null;
        }
        Module ret = null;
        UseSpecType moduleType = this.getModuleType(id, type == null ? null : type.value());
        if (moduleType == null && this.isResourceNotModified(id)) {
            return null;
        }
        if (UseSpecType.REPORT.equals((Object)moduleType)) {
            return this.getBaseModuleForReport(id);
        }
        JSONObject baseModule = this.getBaseModuleJSONObject(id, moduleType, property, ids);
        if (baseModule != null) {
            if (ModuleUtil.isPackageOrLWModule(moduleType)) {
                ret = ModuleObjectManagerCM.decodeModuleJSON(baseModule.toString());
                ModuleUtil.adjustExpressionsForUnsupportedDataTypes(ret);
                ModuleUtil.setEditMode((MoserObject)ret, EditModeType.RO);
            } else {
                String module = (String)baseModule.get((Object)property);
                if (module != null) {
                    String defaultName = null;
                    if (UseSpecType.FILE.equals((Object)moduleType) && "baseDefinition".equals(property)) {
                        defaultName = ContentServiceUtil.getAncestorName(this.runtime.getAncestorsMap().get(id), "uploadedFile");
                    }
                    ret = this.decodeModule(module, null, defaultName);
                    if (UseSpecType.DATABASE.equals((Object)moduleType) && ModuleUtil.moduleNeedUpgradeForPK(ret)) {
                        this.generateItemNormalizationFromPrimaryKey(ret, id, baseModule);
                    }
                    if (ret != null) {
                        if ("physicalDefinition".equals(property)) {
                            this.updateDataSource(ret, id);
                        }
                        if ("reportOutput".equals(ret.getContainer())) {
                            ModuleObjectManagerCM.updateDatasetLabel(ret, baseModule);
                        }
                        ret = this.applyOverrides(ret, baseModule);
                    }
                }
            }
        }
        if (ret != null) {
            String etag = this.m304Handler.postDependencies();
            this.setEtagAndLastModifiedInResponseHeader(etag);
        }
        return ret;
    }

    public void generateItemNormalizationFromPrimaryKey(Module baseModule, String id, JSONObject baseModuleDef) {
        JSONObject jObj;
        String physicalDef = null;
        if (baseModuleDef != null) {
            physicalDef = (String)baseModuleDef.get((Object)"physicalDefinition");
        }
        if (physicalDef == null && (jObj = this.getBaseModuleJSONObjectForDatabaseNoETag(id, "physicalDefinition")) != null) {
            physicalDef = (String)jObj.get((Object)"physicalDefinition");
        }
        if (physicalDef == null || physicalDef.isEmpty()) {
            return;
        }
        Module physicalModule = this.decodeModule(physicalDef, null, null);
        if (physicalModule != null) {
            PrimaryKeyToItemNormalization t = new PrimaryKeyToItemNormalization(physicalModule);
            t.apply(baseModule);
        }
    }

    public Module applyOverrides(Module ret, JSONObject baseModule) {
        Module module;
        String overrides = (String)baseModule.get((Object)"baseOverrides");
        if (overrides != null && !overrides.isEmpty() && (module = this.decodeModule(overrides, null, null)) != null) {
            return BaseOverrides.mergeSecurityFilters(ret, module);
        }
        return ret;
    }

    private static void updateDatasetLabel(Module ret, JSONObject value) {
        if (ret == null) {
            return;
        }
        String label = ContentServiceUtil.getAncestorName(value, "dataSet2");
        if (label == null) {
            return;
        }
        ret.setLabel(label);
        List qs = ret.getQuerySubject();
        if (!qs.isEmpty()) {
            ((QuerySubject)qs.get(0)).setLabel(label);
        }
    }

    private JSONObject getBaseModuleJSONObjectForDatasetOrFile(String id, String ... properties) {
        String storeId = MoserUtil.stripToStoreID(id);
        String[] propsWithVersion = ContentService.appendFields(properties, "version", "ancestors", "routingServerGroup");
        JSONObject response = this.getModuleStorageCM().getBaseModuleFromDefaultOutput(storeId, propsWithVersion);
        if (response != null) {
            this.m304Handler.addDependency(response);
            this.runtime.addAncestorsMap(storeId, (JSONArray)response.get((Object)"ancestors"));
            this.runtime.addRoutingServerGroupsMap(storeId, (String)response.get((Object)"routingServerGroup"));
            return response;
        }
        if (this.getModuleStorageCM().getRestClientResponse().getResponseCode() == 304) {
            return null;
        }
        response = this.getBaseModuleJSONForLegacyFile(id, storeId, propsWithVersion);
        if (response != null) {
            this.m304Handler.addDependency(response);
            this.runtime.addAncestorsMap(storeId, (JSONArray)response.get((Object)"ancestors"));
            this.runtime.addRoutingServerGroupsMap(storeId, (String)response.get((Object)"routingServerGroup"));
        }
        return response;
    }

    @Override
    public boolean deleteBaseModule(String id) {
        JSONObject fileUpload;
        String storeID = null;
        boolean isBaseModuleForFileUpload = false;
        if (id.startsWith("datasets:")) {
            String sid = id.replaceFirst("datasets:", EMPTY_STRING);
            isBaseModuleForFileUpload = true;
            if (MoserUtil.isStoreId(sid)) {
                storeID = sid;
            }
        } else if (MoserUtil.isStoreId(id)) {
            storeID = id;
        }
        if (storeID == null) {
            if (isBaseModuleForFileUpload) {
                fileUpload = this.getFileUploadObject(id.replaceFirst("datasets:", EMPTY_STRING), ".my_folders", null);
                if (fileUpload != null) {
                    storeID = (String)fileUpload.get((Object)"id");
                }
            } else {
                JSONObject baseModule = this.getBaseModuleJSONObject(id, null, null);
                if (baseModule != null) {
                    storeID = (String)baseModule.get((Object)"id");
                }
            }
        }
        if (storeID != null) {
            if (!isBaseModuleForFileUpload && (fileUpload = this.getModuleStorageCM().getObjectFromCM(storeID, new String[0])) == null) {
                return false;
            }
            return this.getModuleStorageCM().deleteObject(storeID);
        }
        return false;
    }

    @Override
    public boolean deleteBusinessModule(String id) {
        String storeId = this.getStoreID(id);
        if (storeId == null) {
            return false;
        }
        return this.getModuleStorageCM().deleteBusinessModule(storeId);
    }

    @Override
    public boolean delete(String id, boolean force, boolean recursive) {
        RESTClientResponse response = this.getModuleStorageCM().delete(id, force, recursive);
        int responseCode = response.getResponseCode();
        return responseCode == 200 || responseCode == 204;
    }

    private String getStoreID(String id) {
        if (!MoserUtil.isStoreId(id) && !UserProfileService.isSessionModule(id)) {
            JSONObject jObj;
            if (ModuleObjectManagerCM.isSearchPath(id)) {
                ArrayList<String> properties = new ArrayList<String>();
                properties.add("type");
                properties.add("id");
                jObj = this.getModuleStorageCM().getObjectSearchPath(id, properties);
            } else {
                jObj = this.getObjectByNameAndTypeFromMyFolders(id, "module", null);
            }
            return jObj != null ? (String)jObj.get((Object)"id") : null;
        }
        return id;
    }

    private JSONObject getObjectByNameAndTypeFromDestination(String objectName, String destinationPath, String objectType, String[] fields) {
        JSONArray modules = this.getModuleStorageCM().getChildrenFromCMFilterByType(destinationPath, fields, objectType);
        if (modules != null) {
            for (Object c : modules) {
                JSONObject current = (JSONObject)c;
                String name = (String)current.get((Object)"defaultName");
                if (objectName.equalsIgnoreCase(name)) {
                    return current;
                }
                try {
                    if (!objectName.equals(name = URLEncoder.encode(name, "UTF-8"))) continue;
                    return current;
                }
                catch (UnsupportedEncodingException e) {
                    LoggerAdapter.errorExceptionStack(this, e);
                }
            }
        }
        return null;
    }

    private JSONObject getObjectByNameAndTypeFromMyFolders(String objectName, String objectType, String[] fields) {
        return this.getObjectByNameAndTypeFromDestination(objectName, ".my_folders", objectType, fields);
    }

    @Override
    public Module getBusinessModuleMetadata(String moduleId, UseSpecType type) {
        return this.getBusinessModuleMetadata(moduleId, type, null, MoserMetadataContext.METADATA);
    }

    @Override
    public Module getBusinessModuleMetadata(String moduleId, UseSpecType type, List<String> ids) {
        return this.getBusinessModuleMetadata(moduleId, type, ids, MoserMetadataContext.METADATA);
    }

    @Override
    public Module getBusinessModuleMetadata(String moduleId, UseSpecType type, List<String> ids, MoserMetadataContext context) {
        if (!this.moduleOrDependentModuleModified(this.getETagFromRequestHeader())) {
            return null;
        }
        UseSpecType moduleType = this.getModuleType(moduleId, type == null ? null : type.value());
        Module module = this.getBusinessModule(moduleId, moduleType, ids);
        if (!ModuleUtil.isPackageOrLWModuleOrReport(moduleType)) {
            module = LogicalModuleResolver.resolveLogicalModule(this, module, ids, context);
        }
        if (module != null) {
            String etag = this.m304Handler.postDependencies();
            this.setEtagAndLastModifiedInResponseHeader(etag);
        }
        return module;
    }

    public boolean moduleOrDependentModuleModified(String eTagFromRequestHeader) {
        return this.m304Handler.modulesOrDependenciesModified(eTagFromRequestHeader);
    }

    public String getETagFromRequestHeader() {
        return this.getRequest().getHeader("If-None-Match");
    }

    @Override
    public Module getBusinessModule(String moduleId, UseSpecType type) {
        if (!this.moduleOrDependentModuleModified(this.getETagFromRequestHeader())) {
            return null;
        }
        Module module = this.getBusinessModule(moduleId, type, null);
        if (module != null) {
            String etag = this.m304Handler.postDependencies();
            this.setEtagAndLastModifiedInResponseHeader(etag);
        }
        return module;
    }

    @Override
    public Module getBusinessModule(String moduleId, UseSpecType type, List<String> ids) {
        Module ret;
        String[] moduleXML = new String[]{null};
        JSONArray[] deploymentRefs = new JSONArray[]{null};
        String[] moduleDefaultName = new String[]{null};
        if (UseSpecType.PACKAGE.equals((Object)type)) {
            ret = this.getBaseModuleForPackage(moduleId, null, ids);
        } else if (UseSpecType.REPORT.equals((Object)type)) {
            ret = this.getBaseModuleForReport(moduleId);
        } else {
            String[] routingInfo = new String[]{null};
            this.getModuleDefinitionFromCM(moduleId, moduleXML, deploymentRefs, moduleDefaultName, routingInfo);
            if (moduleXML[0] == null) {
                return null;
            }
            ret = this.decodeModule(moduleXML[0], deploymentRefs[0], moduleDefaultName[0]);
            if (ModuleObjectManagerCM.isOLAPModule(ret)) {
                this.setOLAPRoutingInfo(ret, routingInfo[0]);
            }
        }
        return ret;
    }

    private void setOLAPRoutingInfo(Module module, String routingInfo) {
        Module.UseSpec useSpec = (Module.UseSpec)module.getUseSpec().get(0);
        this.mOLAPRoutingInfo.put(useSpec.getStoreID(), routingInfo);
    }

    private String getOLAPRoutingInfo(String storeID) {
        return this.mOLAPRoutingInfo.get(storeID);
    }

    protected boolean getModuleXMLDefinition(JSONObject jModule, String[] rtModuleXML) {
        rtModuleXML[0] = null;
        if (jModule == null) {
            return false;
        }
        rtModuleXML[0] = (String)jModule.get((Object)"definition");
        if (rtModuleXML[0] != null) {
            return true;
        }
        rtModuleXML[0] = (String)jModule.get((Object)"baseDefinition");
        return false;
    }

    protected boolean isStoreId(String id) {
        return MoserUtil.isStoreId(id) || ModuleObjectManagerCM.isSession(id);
    }

    public static boolean isSession(String id) {
        return UserProfileService.isSessionModule(id) || UserProfileService.isSessionReport(id);
    }

    protected void getModuleDefinitionFromCM(String moduleId, String[] rtModuleXML, JSONArray[] rtDeploymentRefs, String[] moduleDefaultName, String[] routingInfo) {
        rtModuleXML[0] = null;
        rtDeploymentRefs[0] = null;
        moduleDefaultName[0] = null;
        String storeId = null;
        String modificationTime = null;
        if (ModuleObjectManagerCM.isSearchPath(moduleId)) {
            JSONObject jModule = this.getModuleStorageCM().getObjectSearchPath(moduleId, Arrays.asList(CM_FIELDS));
            if (jModule == null) {
                return;
            }
            routingInfo[0] = (String)jModule.get((Object)"routingServerGroup");
            storeId = (String)jModule.get((Object)"id");
            this.runtime.addAncestorsMap(storeId, (JSONArray)jModule.get((Object)"ancestors"));
            this.runtime.addRoutingServerGroupsMap(storeId, routingInfo[0]);
            String type = (String)jModule.get((Object)"type");
            if ("uploadedFile".equals(type) || "dataSet2".equals(type)) {
                jModule = this.getBaseModuleJSONForDatasetProperties(storeId, "baseDefinition");
                if (jModule != null) {
                    rtModuleXML[0] = (String)jModule.get((Object)"baseDefinition");
                }
                return;
            }
            boolean isBusinessModule = this.getModuleXMLDefinition(jModule, rtModuleXML);
            if (rtModuleXML[0] != null) {
                if (isBusinessModule) {
                    rtDeploymentRefs[0] = (JSONArray)jModule.get((Object)"deploymentReferences");
                }
                moduleDefaultName[0] = (String)jModule.get((Object)"defaultName");
                this.m304Handler.addDependency(jModule);
            }
            return;
        }
        JSONObject result = null;
        if (this.isStoreId(moduleId)) {
            storeId = moduleId;
            result = this.getModuleJSONWithFields(moduleId, CM_FIELDS);
            boolean isBusinessModule = this.getModuleXMLDefinition(result, rtModuleXML);
            if (rtModuleXML[0] != null) {
                if (isBusinessModule) {
                    rtDeploymentRefs[0] = (JSONArray)result.get((Object)"deploymentReferences");
                }
                moduleDefaultName[0] = (String)result.get((Object)"defaultName");
                modificationTime = this.getModificationTime(result, moduleId);
                routingInfo[0] = (String)result.get((Object)"routingServerGroup");
                this.runtime.addAncestorsMap(storeId, (JSONArray)result.get((Object)"ancestors"));
                this.runtime.addRoutingServerGroupsMap(moduleId, routingInfo[0]);
            } else {
                ModuleObjectManagerCM.checkPermissions(result);
            }
        } else {
            JSONArray modules = this.getModuleStorageCM().getChildrenFromCMFilterByType(".my_folders", null, "module");
            if (modules != null) {
                for (Object c : modules) {
                    JSONObject current = (JSONObject)c;
                    String name = (String)current.get((Object)"defaultName");
                    if (!moduleId.equals(name)) continue;
                    String moduleStoreID = (String)current.get((Object)"id");
                    result = this.getModuleJSONWithFields(moduleStoreID, CM_FIELDS);
                    break;
                }
            }
            boolean isBusinessModule = this.getModuleXMLDefinition(result, rtModuleXML);
            if (result != null) {
                if (isBusinessModule) {
                    rtDeploymentRefs[0] = (JSONArray)result.get((Object)"deploymentReferences");
                }
                moduleDefaultName[0] = (String)result.get((Object)"defaultName");
                storeId = (String)result.get((Object)"id");
                routingInfo[0] = (String)result.get((Object)"routingServerGroup");
                this.runtime.addAncestorsMap(storeId, (JSONArray)result.get((Object)"ancestors"));
                this.runtime.addRoutingServerGroupsMap(moduleId, routingInfo[0]);
            }
        }
        if (rtModuleXML[0] != null) {
            if (MoserUtil.isStoreId(storeId)) {
                this.m304Handler.addDependency(result);
            } else if (UserProfileService.isSessionModule(storeId) && modificationTime != null) {
                this.m304Handler.addSessionDependency(storeId, modificationTime);
            }
        }
    }

    private static void checkPermissions(JSONObject result) {
        if (result == null) {
            return;
        }
        JSONArray permissions = (JSONArray)result.get((Object)"permissions");
        if (permissions != null && !permissions.contains((Object)"read")) {
            String defaultName = result.get((Object)"defaultName").toString();
            MoserException e = new MoserException(MoserError.MSR_MODULE_ACCESS_DENIED, defaultName);
            e.setHTTPStatus(Response.Status.FORBIDDEN.getStatusCode());
            throw e;
        }
    }

    private static void fixDataRetrievalMode(Module module) {
        if (module.getDataRetrievalMode() != null) {
            module.setDataRetrievalMode(STR_LIVE_CONNECTION);
        }
    }

    public RESTClientResponse setEtagAndLastModifiedInResponseHeader(String etag) {
        this.setCompositeEtagInResponseHeader(etag);
        this.setLastModifiedInResponseHeader();
        return this.getModuleStorageCM().getRestClientResponse();
    }

    private void setCompositeEtagInResponseHeader(String etag) {
        RESTClientResponse response;
        if (etag != null && (response = this.getModuleStorageCM().getRestClientResponse()) != null) {
            response.setResponseHeader("ETag", etag);
        }
    }

    private void setLastModifiedInResponseHeader() {
        RESTClientResponse response;
        String lastModified = this.m304Handler.generateLastModified();
        if (lastModified != null && (response = this.getModuleStorageCM().getRestClientResponse()) != null) {
            response.setResponseHeader("Last-Modified", lastModified);
        }
    }

    private static boolean isSearchPath(String moduleId) {
        return moduleId.startsWith("CAMID") || moduleId.startsWith("/content");
    }

    @Override
    public List<JSONObject> getModuleList() {
        ArrayList<JSONObject> moduleList = new ArrayList<JSONObject>();
        SearchService ss = this.getReqEnvironment().getSearchService();
        ss.setFields("id", "defaultName", "modificationTime", "ancestors", "defaultDescription");
        ss.setFilter("type", "module");
        ss.httpGet();
        JSONArray modules = ss.getResults();
        if (modules != null) {
            for (Object c : modules) {
                JSONObject current = (JSONObject)c;
                moduleList.add(ModuleObjectManagerCM.cmJSONtoMoserJSON(current, "module"));
            }
        }
        return moduleList;
    }

    public static JSONObject cmJSONtoMoserJSON(JSONObject current, String type) {
        JSONObject moserCurrent = new JSONObject();
        moserCurrent.put((Object)"id", current.get((Object)"id"));
        moserCurrent.put((Object)LABEL, current.get((Object)"defaultName"));
        if ("module".equals(type)) {
            moserCurrent.put((Object)"name", current.get((Object)"defaultName"));
            moserCurrent.put((Object)HREF, (Object)(MODULES + (String)current.get((Object)"id")));
        } else if ("dataSource".equals(type)) {
            moserCurrent.put((Object)HREF, (Object)(SOURCES + (String)current.get((Object)"id")));
        } else {
            moserCurrent.put((Object)HREF, (Object)(BASE_MODULES + (String)current.get((Object)"id")));
        }
        moserCurrent.put((Object)LAST_MODIFIED, current.get((Object)"modificationTime"));
        JSONArray srcAncestors = (JSONArray)current.get((Object)"ancestors");
        if (srcAncestors != null) {
            JSONArray ancestors = new JSONArray();
            for (Object a : srcAncestors) {
                JSONObject srcAncestor = (JSONObject)a;
                JSONObject ancestor = new JSONObject();
                ancestor.put((Object)"id", srcAncestor.get((Object)"id"));
                ancestor.put((Object)"name", srcAncestor.get((Object)"defaultName"));
                ancestor.put((Object)"type", srcAncestor.get((Object)"type"));
                ancestors.add((Object)ancestor);
            }
            moserCurrent.put((Object)"ancestors", (Object)ancestors);
        }
        moserCurrent.put((Object)"defaultDescription", current.get((Object)"defaultDescription"));
        return moserCurrent;
    }

    @Override
    public Response postBusinessModule(String location, Module businessModule, boolean bTemp, Locale locale, boolean overwrite) {
        RESTClientResponse resp;
        if (!bTemp) {
            this.createSearchPath(businessModule);
        }
        if ((resp = this.getModuleStorageCM().saveBusinessModule(this.runtime, location, businessModule, bTemp, overwrite)).getResponseCode() != 201) {
            throw new ContentServiceException(resp.getJSONObjectResponse(), resp.getResponseCode());
        }
        String id = RESTUtils.getLocationStoreId(resp);
        String name = businessModule.getLabel();
        String href = MODULES + id;
        MoserInfo info = MoserInfoUtil.createMoserInfo(href, id, null, name, MoserUtil.getCurrentTimeGregorian());
        return MoserUtil.getResponse(Response.Status.OK, (Object)info);
    }

    private void createSearchPath(Module businessModule) {
        List useSpec = businessModule.getUseSpec();
        if (useSpec != null) {
            for (Module.UseSpec use : useSpec) {
                if (use.getSearchPath() != null && !use.getSearchPath().isEmpty()) continue;
                String storeid = use.getStoreID();
                JSONObject object = this.getModuleStorageCM().getObjectFromCM(storeid, "searchPath");
                if (object == null) continue;
                String path = (String)object.get((Object)"searchPath");
                use.setSearchPath(path);
            }
        }
    }

    @Override
    public boolean updateBaseModule(String id, Module module) {
        return this.getModuleStorageCM().updateBaseModule(id, module);
    }

    @Override
    public int updateBaseModule(String id, Module baseDefinition, Module baseOverrides) {
        BaseModuleContainer bmContainer = new BaseModuleContainer();
        bmContainer.setParentId(id);
        bmContainer.setBaseBusinessModule(baseDefinition);
        bmContainer.setBaseModuleOverride(baseOverrides);
        bmContainer.setStatus(SUCCEEDED);
        return this.getModuleStorageCM().putBaseModule(bmContainer, MoserConfig.getStoreModuleZipped());
    }

    @Override
    public boolean updateBusinessModule(String id, Module module) {
        if (id == null) {
            return false;
        }
        String storeid = this.getStoreID(id);
        if (!UserProfileService.isSessionModule(storeid)) {
            this.createSearchPath(module);
        }
        return this.getModuleStorageCM().updateBusinessModule(storeid, module);
    }

    public String getModificationTime(JSONObject jSON, String moduleId) {
        return UserProfileService.isSessionModule(moduleId) ? (String)jSON.get((Object)"timestamp") : (String)jSON.get((Object)"modificationTime");
    }

    @Override
    public MoserInfo getModuleInfo(String moduleId, List<String> attributes) {
        JSONObject module;
        String label = null;
        XMLGregorianCalendar dateTime = null;
        boolean xqeMoser = attributes != null && attributes.remove("xqemoser");
        boolean getLabel = attributes == null || attributes.isEmpty() || attributes.contains(LABEL);
        boolean getLastModified = attributes == null || attributes.isEmpty() || attributes.contains(LAST_MODIFIED);
        String[] cmAttributes = new String[]{"type", "id", "defaultName", "modificationTime"};
        if (attributes != null && attributes.contains("ancestors")) {
            cmAttributes = ContentService.appendFields(cmAttributes, "ancestors");
        }
        if ((module = this.getModuleById(moduleId, cmAttributes)) == null && xqeMoser) {
            module = this.getBaseModuleJSONObject(moduleId, null, null);
        }
        if (module == null) {
            return null;
        }
        if (getLabel) {
            label = (String)module.get((Object)"defaultName");
        }
        if (getLastModified) {
            String modDate = this.getModificationTime(module, moduleId);
            dateTime = MoserUtil.getTimeGregorian(modDate);
        }
        String id = MoserUtil.isStoreId(moduleId) || UserProfileService.isSessionModule(moduleId) ? moduleId : (String)module.get((Object)"id");
        MoserInfo info = MoserInfoUtil.createMoserInfo(MODULES + id, id, null, label, dateTime);
        if (attributes != null && attributes.contains("type")) {
            String type = "module";
            Module m = this.getBusinessModule(id, UseSpecType.MODULE);
            if (ModuleObjectManagerCM.isOLAPModule(m)) {
                type = LW_OLAP_MODULE;
            }
            info.setType(type);
        }
        if ("package".equals(module.get((Object)"type"))) {
            this.setPackageInfo(moduleId, info);
        }
        return info;
    }

    private void setPackageInfo(String packageId, MoserInfo info) {
        JSONObject packageInfo = this.getModuleStorageCM().getPackageInfo(packageId);
        if (packageInfo == null) {
            return;
        }
        info.setLastAnalysisCollection((String)packageInfo.get((Object)"lastAnalysisCollection"));
        info.setLastOverrideUpdate((String)packageInfo.get((Object)"lastOverrideUpdate"));
        info.setLastPublished((String)packageInfo.get((Object)"lastPublishDate"));
        info.setLoadOptions((String)packageInfo.get((Object)"specification"));
    }

    private static boolean isOLAPModule(Module m) {
        return m != null && m.getUseSpec().size() == 1 && UseSpecType.LW_OLAP.equals((Object)((Module.UseSpec)m.getUseSpec().get(0)).getType());
    }

    @Override
    public Module getBusinessModuleMetadataById(String moduleId) {
        if (moduleId.endsWith(".base") || moduleId.endsWith(DOT_PHYSICALMODULE)) {
            String databaseID = moduleId.substring(0, moduleId.lastIndexOf("."));
            String moduleType = moduleId.substring(moduleId.lastIndexOf(".") + 1);
            if (MoserUtil.isStoreId(databaseID)) {
                if ("base".equals(moduleType)) {
                    return this.getBaseModule(databaseID, null, "baseDefinition", null);
                }
                return this.getBaseModule(databaseID, null, "physicalDefinition", null);
            }
            if (moduleId.startsWith(STR_DATASETS_DOT)) {
                String tempID = moduleId.replaceFirst(STR_DATASETS_DOT, "datasets:");
                String datasetID = tempID.substring(0, tempID.indexOf("."));
                if (moduleId.endsWith(".base")) {
                    return this.getBaseModuleForDataset(datasetID, "baseDefinition");
                }
                return this.getBaseModuleForDataset(datasetID, "physicalDefinition");
            }
            if ("base".equals(moduleType)) {
                return this.getBaseModuleForDatabase(databaseID, "baseDefinition");
            }
            return this.getBaseModuleForDatabase(databaseID, "physicalDefinition");
        }
        if (moduleId.startsWith("datasets:") || moduleId.startsWith(STR_DATASETS_DOT)) {
            return this.getBaseModuleForDataset(moduleId, "baseDefinition");
        }
        return this.getBusinessModuleMetadata(moduleId, null);
    }

    private JSONObject getModuleById(String id, String ... extraAttribute) {
        String moduleId = id;
        if (moduleId.endsWith(".base") || moduleId.endsWith(DOT_PHYSICALMODULE)) {
            if (moduleId.startsWith(STR_DATASETS_DOT)) {
                String tempID = moduleId.replaceFirst(STR_DATASETS_DOT, "datasets:");
                String datasetID = tempID.substring(0, tempID.indexOf("."));
                return this.getBaseModuleJSONForDatasetProperties(datasetID, extraAttribute);
            }
            String databaseID = moduleId.substring(0, moduleId.lastIndexOf("."));
            return this.getBaseModuleJSONObjectForDatabase(databaseID, extraAttribute);
        }
        if (moduleId.startsWith("datasets:")) {
            return this.getBaseModuleJSONForDatasetProperties(moduleId, extraAttribute);
        }
        if (ModuleObjectManagerCM.isSearchPath(moduleId)) {
            JSONObject module = this.getModuleStorageCM().getObjectSearchPath(moduleId, Arrays.asList("defaultName", "id", "modificationTime", "type"));
            return module;
        }
        if (UserProfileService.isSessionModule(moduleId)) {
            return this.getModuleStorageCM().getObjectFromUPS(moduleId);
        }
        JSONObject module = this.getModuleStorageCM().getObjectFromCM(moduleId, extraAttribute);
        if (module == null) {
            RESTClientResponse resp = this.getModuleStorageCM().getRestClientResponse();
            if (resp != null && resp.getResponseCode() == 304) {
                return null;
            }
            if (!MoserUtil.isStoreId(moduleId)) {
                return this.getObjectByNameAndTypeFromMyFolders(moduleId, "module", extraAttribute);
            }
        }
        return module;
    }

    protected JSONObject getBaseModuleJSONObjectForDatabaseStoreIdByProperty(String id, String[] properties) {
        JSONObject jObj = this.getModuleStorageCM().getBaseModuleForDataSourceSchema(id, properties);
        if (jObj == null && this.getModuleStorageCM().getRestClientResponse().getResponseCode() != 304) {
            jObj = this.getModuleStorageCM().getObjectFromCM(id, properties);
        }
        return jObj;
    }

    public JSONObject getBaseModuleJSONObjectForDatabase(String moduleId, String ... fields) {
        JSONObject jObj = this.getBaseModuleJSONObjectForDatabaseNoETag(moduleId, ContentService.appendFields(fields, "version", "ancestors", "routingServerGroup"));
        if (jObj != null) {
            this.m304Handler.addDependency(jObj);
            this.runtime.addAncestorsMap(moduleId, (JSONArray)jObj.get((Object)"ancestors"));
            this.runtime.addRoutingServerGroupsMap(moduleId, (String)jObj.get((Object)"routingServerGroup"));
        }
        return jObj;
    }

    public JSONObject getBaseModuleJSONObjectForDatabaseNoETag(String moduleId, String ... fields) {
        String[] idParts;
        String id = moduleId;
        if (MoserUtil.isStoreId(id)) {
            return this.getBaseModuleJSONObjectForDatabaseStoreIdByProperty(id, fields);
        }
        if (!id.contains(":") && id.contains(".")) {
            id = id.replaceAll("\\.", ":");
        }
        if ((idParts = id.split(":")).length < 4) {
            return null;
        }
        JSONObject baseModule = null;
        String storeID = this.getConnectionStoreID(id);
        if (storeID != null) {
            String catalog = idParts[2];
            String schema = idParts[3];
            baseModule = this.getModuleStorageCM().getBaseModuleForDatasourceConnection(storeID, catalog, schema, fields);
        }
        return baseModule;
    }

    private static Module decodeModuleJSON(String moduleJSON) {
        Module result = null;
        try {
            JSONCodec jCodec = new JSONCodec();
            result = (Module)jCodec.decode(Module.class, moduleJSON);
        }
        catch (MoserException e) {
            LoggerAdapter.error(ModuleObjectManagerCM.class, INVALID_MODULE_ERROR + moduleJSON, e);
        }
        return result;
    }

    public Module decodeModule(String moduleXML, JSONArray deploymentRefs, String moduleDefaultName) {
        if (moduleXML == null) {
            return null;
        }
        try {
            Module module = (Module)MoserUtil.decode(Module.class, moduleXML);
            if (module == null) {
                return null;
            }
            if (StringUtils.isNotEmpty((CharSequence)moduleDefaultName)) {
                module.setLabel(moduleDefaultName);
            }
            ModuleObjectManagerCM.verifyAndUpdateStoreIDs(module, deploymentRefs);
            ModuleObjectManagerCM.fixDataRetrievalMode(module);
            return module;
        }
        catch (MoserException e) {
            LoggerAdapter.error(ModuleObjectManagerCM.class, INVALID_MODULE_ERROR + moduleXML, e);
            return null;
        }
    }

    private static void verifyAndUpdateStoreIDs(Module module, JSONArray deploymentRefs) {
        List useList = module.getUseSpec();
        if (deploymentRefs != null) {
            Map<String, String> deploymentRefMap = ModuleObjectManagerCM.createDeploymentRefMap(deploymentRefs, module.getExpressionLocale());
            for (Module.UseSpec use : useList) {
                String storeId = deploymentRefMap.get(use.getIdentifier());
                if (!StringUtils.isNotEmpty((CharSequence)storeId)) continue;
                use.setStoreID(storeId);
            }
        }
    }

    private static Map<String, String> createDeploymentRefMap(JSONArray deploymentRefs, String expressionLocale) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object o : deploymentRefs) {
            JSONObject reference;
            String storeID;
            JSONObject ref = (JSONObject)o;
            JSONObject names = (JSONObject)ref.get((Object)"name");
            String name = (String)names.get((Object)expressionLocale);
            JSONArray objects = (JSONArray)ref.get((Object)"objects");
            if (StringUtils.isEmpty((CharSequence)name) || objects == null || StringUtils.isEmpty((CharSequence)(storeID = (String)(reference = (JSONObject)objects.get(0)).get((Object)"id")))) continue;
            map.put(name, storeID);
        }
        return map;
    }

    private String getConnectionStoreID(String databaseId) {
        String[] idParts = databaseId.split(":");
        String datasource = idParts[0];
        String connection = idParts[1];
        JSONObject dsConn = this.getReqEnvironment().getAdminDatabaseService().getDatasourceConnection(datasource, connection);
        if (dsConn == null) {
            return null;
        }
        return (String)dsConn.get((Object)"id");
    }

    @Override
    public Module getBaseModuleForDataset(String datasetID, String property) {
        JSONObject baseModuleObject = this.getBaseModuleJSONForDatasetProperties(datasetID, property);
        if (baseModuleObject == null) {
            return null;
        }
        String moduleXML = (String)baseModuleObject.get((Object)property);
        if (moduleXML == null) {
            return null;
        }
        Module module = this.decodeModule(moduleXML, null, null);
        ModuleObjectManagerCM.updateDatasetLabel(module, baseModuleObject);
        return module;
    }

    private JSONObject getBaseModuleJSONForLegacyFile(String id, String storeId, String ... properties) {
        JSONObject response = this.getModuleStorageCM().getObjectFromCM(storeId, ContentService.appendFields(properties, "defaultName"));
        if (response != null) {
            String type = (String)response.get((Object)"type");
            if ("dataSet2".equals(type)) {
                String defaultName = (String)response.get((Object)"defaultName");
                response = this.waitUntilModuleIsRefreshed(storeId, properties);
                if (response == null) {
                    MoserException e = new MoserException(MoserError.DATASET_MODULE_NOT_FOUND, defaultName);
                    e.setHTTPStatus(Response.Status.BAD_REQUEST.getStatusCode());
                    throw e;
                }
                return response;
            }
            if ("uploadedFile".equals(type)) {
                JSONArray children = this.getModuleStorageCM().getChildrenFromCMFilterByType(storeId, properties, "baseModule");
                if (this.getModuleStorageCM().getRestClientResponse().getResponseCode() == 304) {
                    return null;
                }
                if (children != null && !children.isEmpty()) {
                    response = (JSONObject)children.get(0);
                } else {
                    String defaultName = (String)response.get((Object)"defaultName");
                    MoserException e = new MoserException(MoserError.MSR_FILE_MODULE_NOT_FOUND, defaultName);
                    e.setHTTPStatus(Response.Status.BAD_REQUEST.getStatusCode());
                    throw e;
                }
            }
        }
        return response;
    }

    private JSONObject waitUntilModuleIsRefreshed(String storeId, String ... properties) {
        int maxWaitTime = MoserConfig.getMaxWaitTimeDataset2Refresh();
        LoggerAdapter.trace(ModuleObjectManagerCM.class, "Check if module is being refreshed. Waiting at most " + maxWaitTime + "ms");
        if (!this.reportVersionModifiedRecently(storeId)) {
            LoggerAdapter.trace(ModuleObjectManagerCM.class, "Dataset not modified recently.");
            return null;
        }
        JSONObject response = null;
        int sleepTime = 1000;
        int maxTries = maxWaitTime / sleepTime;
        long startTime = System.currentTimeMillis();
        for (int numTries = 0; numTries < maxTries; ++numTries) {
            String baseDefinition;
            try {
                Thread.sleep(sleepTime);
                response = this.getModuleStorageCM().getBaseModuleFromDefaultOutput(storeId, properties);
            }
            catch (InterruptedException e) {
                LoggerAdapter.info(ModuleObjectManagerCM.class, e.getLocalizedMessage(), e);
            }
            if (response != null && (baseDefinition = (String)response.get((Object)"baseDefinition")) != null && !baseDefinition.isEmpty()) break;
        }
        long endTime = System.currentTimeMillis();
        if (response != null) {
            LoggerAdapter.trace(ModuleObjectManagerCM.class, "Module is refreshed. Waited " + (endTime - startTime) + "ms.");
        } else {
            LoggerAdapter.trace(ModuleObjectManagerCM.class, "Module still not refreshed after waiting " + (endTime - startTime) + "ms.");
        }
        return response;
    }

    private boolean reportVersionModifiedRecently(String dataset2StoreID) {
        int lastModifiedThreshold = MoserConfig.getDataset2LastModifiedThreshold();
        boolean modifiedRecently = false;
        JSONArray dataset2Children = this.getModuleStorageCM().getChildrenFromCMFilterByType(dataset2StoreID, new String[]{"modificationTime"}, "reportVersion");
        for (Object o : dataset2Children) {
            JSONObject current = (JSONObject)o;
            String type = (String)current.get((Object)"type");
            if (!"reportVersion".equals(type)) continue;
            String modificationTime = (String)current.get((Object)"modificationTime");
            long lastModified = MoserUtil.getTimeInMillis(modificationTime);
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastModified > (long)lastModifiedThreshold) continue;
            modifiedRecently = true;
            break;
        }
        return modifiedRecently;
    }

    public JSONObject getBaseModuleJSONForDatasetProperties(String datasetID, String ... properties) {
        return this.getBaseModuleJSONObjectForDatasetOrFile(datasetID, properties);
    }

    public void addModuleMissingDependency(String searchPath) {
        this.m304Handler.addMissingDependency(searchPath);
    }

    public String getReturnedEtagFromLastRequest() {
        return this.getModuleStorageCM().getRestClientResponse().getResponseHeader("ETag");
    }

    @Override
    public Module getBaseModuleForDatabase(String databaseID, String property) {
        JSONObject baseModule = this.getBaseModuleJSONObjectForDatabase(databaseID, property);
        if (baseModule != null) {
            Object moduleXML = baseModule.get((Object)property);
            if (moduleXML == null) {
                try {
                    LoggerAdapter.error(ModuleObjectManagerCM.class, "DatabaseId ='" + databaseID + "', property = '" + property + "', baseModule :" + baseModule.toString());
                }
                catch (Exception e) {
                    LoggerAdapter.error(ModuleObjectManagerCM.class, "Logger error", e);
                }
                return null;
            }
            return this.decodeModule((String)moduleXML, null, null);
        }
        return null;
    }

    @Override
    public Collection<JSONObject> getUsedModules(String moduleId) {
        return this.getUsedModulesMap(moduleId, null).values();
    }

    public Map<String, JSONObject> getUsedModulesMap(String moduleId, Module toSave) {
        ArrayList<Module.UseSpec> ids;
        List newUseList = null;
        List newUseSpecList = null;
        LinkedHashMap<String, JSONObject> moduleList = new LinkedHashMap<String, JSONObject>();
        Module module = null;
        if (StringUtils.isNotEmpty((CharSequence)moduleId) && (module = this.getBusinessModuleMetadata(moduleId, null)) != null) {
            newUseList = module.getUse();
            newUseSpecList = module.getUseSpec();
        }
        if (module == null && toSave == null) {
            throw new ModuleNotFoundException(MoserError.MSR_MODULE_NOT_FOUND, moduleId);
        }
        if (toSave != null) {
            newUseList = toSave.getUse();
            newUseSpecList = toSave.getUseSpec();
        }
        if ((newUseList == null || newUseList.isEmpty()) && (newUseSpecList == null || newUseSpecList.isEmpty())) {
            return moduleList;
        }
        if (newUseSpecList != null && !newUseSpecList.isEmpty()) {
            ids = new ArrayList(newUseSpecList);
        } else {
            ids = new ArrayList<Module.UseSpec>();
            for (String use : newUseList) {
                Module.UseSpec useSpec = new Module.UseSpec();
                useSpec.setStoreID(use);
                ids.add(useSpec);
            }
        }
        for (Module.UseSpec useSpec : ids) {
            if (StringUtils.isEmpty((CharSequence)useSpec.getStoreID()) && StringUtils.isEmpty((CharSequence)useSpec.getSearchPath())) continue;
            JSONObject useModule = null;
            if (newUseSpecList != null && !newUseSpecList.isEmpty()) {
                ModuleUseSpecUpdater updater;
                if (StringUtils.isNotEmpty((CharSequence)useSpec.getStoreID())) {
                    useModule = this.getModuleStorageCM().getObjectFromCM(useSpec.getStoreID(), new String[0]);
                }
                if (useModule == null && StringUtils.isNotEmpty((CharSequence)useSpec.getSearchPath()) && (updater = new ModuleUseSpecUpdater(this.runtime, useSpec)).update()) {
                    useModule = this.getModuleStorageCM().getObjectFromCM(useSpec.getStoreID(), new String[0]);
                }
            } else {
                useModule = this.getModuleById(useSpec.getStoreID(), new String[0]);
            }
            if (useModule == null) {
                moduleList.put(useSpec.getStoreID(), ModuleObjectManagerCM.generateEntryForInvalidStoreID(useSpec.getStoreID(), newUseSpecList));
                continue;
            }
            String id = (String)useModule.get((Object)"id");
            String defaultName = (String)useModule.get((Object)"defaultName");
            JSONObject json = new JSONObject();
            switch ((String)useModule.get((Object)"type")) {
                case "module": {
                    json.put((Object)HREF, (Object)(MODULES + id));
                    json.put((Object)"id", (Object)id);
                    json.put((Object)LABEL, (Object)defaultName);
                    json.put((Object)LAST_MODIFIED, useModule.get((Object)"modificationTime"));
                    json.put((Object)"type", useModule.get((Object)"type"));
                    break;
                }
                case "baseModule": 
                case "dataSourceSchema": 
                case "package": 
                case "uploadedFile": 
                case "dataSet": 
                case "dataSet2": {
                    json.put((Object)HREF, (Object)(BASE_MODULES + id));
                    json.put((Object)"id", (Object)id);
                    json.put((Object)LABEL, (Object)defaultName);
                    json.put((Object)LAST_MODIFIED, useModule.get((Object)"modificationTime"));
                    json.put((Object)"type", useModule.get((Object)"type"));
                    break;
                }
            }
            json.put((Object)"status", (Object)"valid");
            moduleList.put(useSpec.getStoreID(), json);
        }
        return moduleList;
    }

    private static JSONObject generateEntryForInvalidStoreID(String use, List<Module.UseSpec> useSpecs) {
        JSONObject jo = new JSONObject();
        if (useSpecs != null) {
            for (Module.UseSpec useSpec : useSpecs) {
                String toSearch;
                String searchPath;
                int lastNameIndex;
                if (!useSpec.getStoreID().equals(use) || (lastNameIndex = (searchPath = useSpec.getSearchPath()).lastIndexOf(toSearch = "@name='")) < 0) continue;
                String ss = searchPath.substring(lastNameIndex + toSearch.length());
                jo.put((Object)LABEL, (Object)ss.substring(0, ss.indexOf(39)));
            }
        }
        jo.put((Object)"id", (Object)use);
        jo.put((Object)"status", (Object)"invalid");
        return jo;
    }

    @Override
    public BaseModuleContainer createBaseModuleForDatabase(String databaseId, String parent) {
        BaseModuleContainer baseModule = new BaseModuleContainer();
        baseModule.setStartTime(MoserUtil.getCurrentTimeGregorianUTC());
        baseModule.setDatabaseId(databaseId);
        String catalog = null;
        String schema = null;
        String owner = parent;
        if (owner == null) {
            String[] idParts = databaseId.split(":");
            String datasource = idParts[0];
            String connection = idParts[1];
            catalog = idParts[2];
            schema = idParts[3];
            JSONObject dsConn = this.getReqEnvironment().getAdminDatabaseService().getDatasourceConnection(datasource, connection);
            owner = (String)dsConn.get((Object)"id");
        }
        baseModule.setStatus("executing");
        baseModule.setCatalog(catalog);
        baseModule.setSchema(schema);
        RESTClientResponse resp = this.getModuleStorageCM().createBaseModuleForDatabase(owner, baseModule);
        if (resp == null || resp.getResponseCode() != 201) {
            if (resp != null && 403 == resp.getResponseCode()) {
                throw new MoserException(MoserError.MSR_DS_CONNECTION_ACCESS).setHTTPStatus(Response.Status.FORBIDDEN.getStatusCode());
            }
            throw new MoserException(MoserError.MSR_BASE_MODULE_CREATE_FAILED, databaseId);
        }
        baseModule.setStoreId(RESTUtils.getLocationStoreId(resp));
        return baseModule;
    }

    @Override
    public int putBaseModule(String id, Module baseModule) {
        JSONObject cmBaseModule = this.getBaseModuleJSONObject(id, null, null);
        if (baseModule == null) {
            LoggerAdapter.error(ModuleObjectManagerCM.class, "BaseModule: " + id + " not found in ContentStore");
            return 500;
        }
        BaseModuleContainer baseModuleContainer = new BaseModuleContainer();
        Module moduleOverride = BaseOverrides.extractSecurityFilters(baseModule);
        baseModuleContainer.setBaseBusinessModule(baseModule);
        baseModuleContainer.setBaseModuleOverride(moduleOverride);
        String storeId = (String)cmBaseModule.get((Object)"id");
        baseModuleContainer.setStoreId(storeId);
        return this.getModuleStorageCM().saveBaseModuleForDatabase(baseModuleContainer, MoserConfig.getStoreModuleZipped());
    }

    @Override
    public String getBaseModuleStoreID(String id) {
        return this.getModuleStorageCM().getBaseModuleStoreID(id);
    }

    @Override
    public UseSpecType getModuleType(String id, String type) {
        UseSpecType result = null;
        if (type != null) {
            result = ModuleObjectManagerCM.mapUseSpecType(type, false);
        }
        if (result == null && id != null) {
            if (UserProfileService.isSessionModule(id)) {
                result = UseSpecType.MODULE;
            } else if (UserProfileService.isSessionReport(id)) {
                result = UseSpecType.REPORT;
            } else if (id.startsWith("datasets:") || id.startsWith(STR_DATASETS_DOT)) {
                result = UseSpecType.DATASET;
            } else {
                String storeId = MoserUtil.stripToStoreID(id);
                if (!this.isStoreId(storeId)) {
                    String objectType = MoserUtil.getObjectType(storeId);
                    if (objectType != null) {
                        result = ModuleObjectManagerCM.mapUseSpecType(objectType, false);
                    }
                    if (result == null) {
                        String[] parts = storeId.split(":");
                        result = parts != null && parts.length > 2 ? UseSpecType.DATABASE : UseSpecType.MODULE;
                    }
                }
                if (result == null) {
                    result = this.getTypeFromCM(storeId);
                }
            }
        }
        return result;
    }

    private static UseSpecType mapUseSpecType(String type, boolean includeDefaultCase) {
        UseSpecType result = null;
        switch (type) {
            case "module": {
                result = UseSpecType.MODULE;
                break;
            }
            case "uploadedFile": {
                result = UseSpecType.FILE;
                break;
            }
            case "dataSet2": {
                result = UseSpecType.DATASET;
                break;
            }
            case "package": {
                result = UseSpecType.PACKAGE;
                break;
            }
            default: {
                if (UseSpecType.FILE.value().equals(type)) {
                    result = UseSpecType.FILE;
                    break;
                }
                if (UseSpecType.DATASET.value().equals(type)) {
                    result = UseSpecType.DATASET;
                    break;
                }
                if (UseSpecType.REPORT.value().equals(type)) {
                    result = UseSpecType.REPORT;
                    break;
                }
                if (!includeDefaultCase) break;
                result = UseSpecType.DATABASE;
            }
        }
        return result;
    }

    private UseSpecType getTypeFromCM(String storeId) {
        String baseServiceType;
        UseSpecType result = (UseSpecType)objectTypeCache.getIfPresent((Object)storeId);
        if (result != null) {
            LoggerAdapter.debug((Object)this, "UseSpecType cache hit: {}", storeId);
            return result;
        }
        LoggerAdapter.debug((Object)this, "UseSpecType cache miss: {}", storeId);
        JSONObject cmObject = this.getModuleStorageCM().getObjectFromCM(storeId, new String[0]);
        if (cmObject != null && (baseServiceType = (String)cmObject.get((Object)"type")) != null) {
            result = ModuleObjectManagerCM.mapUseSpecType(baseServiceType, true);
            objectTypeCache.put((Object)storeId, (Object)result);
        }
        return result;
    }

    @Override
    public JSONObject getFileUploadObject(String key, String locationPath, String[] fields) {
        Object record;
        JSONObject fileUploadObject;
        if (MoserUtil.isStoreId(key) && (fileUploadObject = this.getModuleStorageCM().getObjectFromCM(key, fields)) != null && "uploadedFile".equals(fileUploadObject.get((Object)"type"))) {
            return fileUploadObject;
        }
        fileUploadObject = this.getObjectByNameAndTypeFromDestination(key, locationPath, "uploadedFile", fields);
        if (fileUploadObject == null) {
            return null;
        }
        JSONArray history = (JSONArray)fileUploadObject.get((Object)"history");
        if (history != null && !history.isEmpty() && (record = history.get(0)) != null) {
            try {
                history.set(0, (Object)JSONObject.parse((String)record.toString()));
            }
            catch (IOException e) {
                LoggerAdapter.errorExceptionStack(ModuleObjectManagerCM.class, e);
            }
        }
        return fileUploadObject;
    }

    @Override
    public String getDefaultName(String cmID) {
        ModuleStorageCM contentManager = this.getReqEnvironment().createModuleStorageCM();
        JSONObject result = contentManager.getObjectFromCM(cmID, "defaultName");
        if (result == null) {
            return null;
        }
        return (String)result.get((Object)"defaultName");
    }

    private static JSONObject createHistoryJSON() {
        JSONObject historyDetailObject = new JSONObject();
        historyDetailObject.put((Object)"type", (Object)"history");
        historyDetailObject.put((Object)"status", (Object)SUCCEEDED);
        return historyDetailObject;
    }

    private static JSONObject createHistoryDetailJSON(String id, String searchPath) {
        JSONObject historyDetailObject = new JSONObject();
        historyDetailObject.put((Object)"type", (Object)"historyDetailReportService");
        JSONObject output = new JSONObject();
        output.put((Object)"id", (Object)id);
        output.put((Object)"searchPath", (Object)searchPath);
        output.put((Object)"type", (Object)"reportVersion");
        JSONArray outputs = new JSONArray();
        outputs.add((Object)output);
        historyDetailObject.put((Object)"output", (Object)outputs);
        return historyDetailObject;
    }

    /*
     * Exception decompiling
     */
    private int loadDataFileFromCMOnDisk(File dataFile, String outputId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RESTClientResponse upgradeParquetFile(String outputId, String tempDir, TaskStatus status) {
        File tmpDir = null;
        try {
            tmpDir = MoserUtil.createTempDirectory(tempDir);
            File tmpFile = File.createTempFile(outputId, ".tmp", tmpDir);
            BaseMoserTask.throwIfCancelled(status, PARQUET_UPGRADE);
            if (this.loadDataFileFromCMOnDisk(tmpFile, outputId) != 200) {
                RESTClientResponse rESTClientResponse = new RESTClientResponse(500);
                return rESTClientResponse;
            }
            DatasetParquetReadHelper readHelper = new DatasetParquetReadHelper();
            readHelper.readFooter(new Path(tmpFile.getPath()), conf);
            Map keyValue = readHelper.getKeyValueMetadata();
            String value = (String)keyValue.get("parquet.ca.version");
            if (value != null && ParquetVersionEnum.VERSION_1.toString().equals(value)) {
                RESTClientResponse rESTClientResponse = new RESTClientResponse(200);
                return rESTClientResponse;
            }
            String absOutPath = tmpFile.getPath() + "n";
            ParquetConverter pc = new ParquetConverter(absOutPath);
            try {
                pc.initialize(tmpFile.getPath(), MoserConfig.createParquetConfig());
                pc.convert();
            }
            finally {
                pc.release();
            }
            BaseMoserTask.throwIfCancelled(status, PARQUET_UPGRADE);
            RESTClientResponse rESTClientResponse = ModuleObjectManagerCM.postParquetFile(this.getReqEnvironment().createModuleStorageCM(), outputId, new File(absOutPath));
            return rESTClientResponse;
        }
        catch (Exception e) {
            LoggerAdapter.errorExceptionStack(ModuleObjectManagerCM.class, e);
            RESTClientResponse rESTClientResponse = new RESTClientResponse(500, e);
            return rESTClientResponse;
        }
        finally {
            FileUtils.deleteQuietly((File)tmpDir);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RESTClientResponse postParquetFile(ModuleStorageCM contentManager, String outputId, File tmpFile) {
        try (FileInputStream fis = new FileInputStream(tmpFile);){
            RESTClientResponse rESTClientResponse = contentManager.putData(outputId, "application/vnd.ibm.bi.pq", tmpFile.length(), fis);
            return rESTClientResponse;
        }
        catch (IOException e) {
            return new RESTClientResponse(500, e);
        }
    }

    @Override
    public RESTClientResponse postUploadedFile(String parentId, UploadedFileContainer uploadedFile, TaskStatus status) {
        JSONObject json = uploadedFile.toJSON();
        RESTClientResponse resp = this.getModuleStorageCM().postItems(parentId, json);
        if (resp.getResponseCode() != 201) {
            return resp;
        }
        String uploadedFileStoreId = RESTUtils.getLocationStoreId(resp);
        uploadedFile.updatePhysicalDatasources(uploadedFileStoreId);
        uploadedFile.setStoreId(uploadedFileStoreId);
        try {
            BaseMoserTask.throwIfCancelled(status, "file upload");
            ReportVersionContainer reportVersion = uploadedFile.getReportVersion();
            json = reportVersion.toJSON();
            RESTClientResponse childResp = this.getModuleStorageCM().postItems(uploadedFileStoreId, json);
            if (childResp.getResponseCode() != 201) {
                this.getModuleStorageCM().delete(uploadedFileStoreId, true, true);
                return childResp;
            }
            BaseMoserTask.throwIfCancelled(status, "file upload");
            String reportVersionStoreId = RESTUtils.getLocationStoreId(childResp);
            json = reportVersion.getBaseModule().toJSON();
            childResp = this.getModuleStorageCM().postItems(reportVersionStoreId, json);
            if (childResp.getResponseCode() != 201) {
                this.getModuleStorageCM().delete(uploadedFileStoreId, true, true);
                return childResp;
            }
            BaseMoserTask.throwIfCancelled(status, "file upload");
            for (OutputContainer output : reportVersion.getOutputs()) {
                childResp = this.postOutput(reportVersionStoreId, output);
                if (childResp.getResponseCode() == 201 || childResp.getResponseCode() == 200) continue;
                this.getModuleStorageCM().delete(uploadedFileStoreId, true, true);
                return childResp;
            }
            BaseMoserTask.throwIfCancelled(status, "file upload");
            childResp = this.postHistory(uploadedFileStoreId, reportVersionStoreId);
            if (childResp.getResponseCode() != 201 && childResp.getResponseCode() != 200) {
                this.getModuleStorageCM().delete(uploadedFileStoreId, true, true);
                return childResp;
            }
            BaseMoserTask.throwIfCancelled(status, "file upload");
            return resp;
        }
        catch (MoserCancelException e) {
            this.getModuleStorageCM().delete(uploadedFileStoreId, true, true);
            throw e;
        }
    }

    public Object buildResponseNotChange(Request context, String etagStr, String moduleId) {
        EntityTag etag = EntityTag.valueOf((String)etagStr);
        Response.ResponseBuilder builder = context.evaluatePreconditions(etag);
        if (builder != null) {
            LoggerAdapter.trace(ModuleObjectManagerCM.class, "Module '{}' is not modified. Returning status 304", moduleId);
            CacheControl cc = new CacheControl();
            cc.setMustRevalidate(true);
            cc.setPrivate(true);
            return builder.cacheControl(cc).build();
        }
        return null;
    }

    @Override
    public Object buildModuleResponse(Request context, Module module, String moduleId, String etagStr) {
        String serverGroup;
        String lm;
        Object r;
        RESTClientResponse resp = this.getModuleStorageCM().getRestClientResponse();
        if (etagStr != null && module == null && !this.m304Handler.isResourceModified() && (r = this.buildResponseNotChange(context, etagStr, moduleId)) != null) {
            return r;
        }
        if (module == null) {
            return null;
        }
        Response.ResponseBuilder builder = Response.ok((Object)module, (String)"application/json");
        LoggerAdapter.trace(ModuleObjectManagerCM.class, "Got module '{}'. Returning status 200", moduleId);
        String etag = this.m304Handler.getGeneratedEtag();
        Date lastModified = new Date(0L);
        if (resp != null && (lm = resp.getResponseHeader("Last-Modified")) != null && !lm.isEmpty()) {
            try {
                lastModified = DateUtil.parseDate((String)lm);
            }
            catch (DateParseException e) {
                LoggerAdapter.errorExceptionStack(ModuleObjectManagerCM.class, e);
            }
        }
        if (etag != null) {
            CacheControl cc = new CacheControl();
            cc.setMustRevalidate(true);
            cc.setPrivate(true);
            builder = builder.tag(etag).lastModified(lastModified).cacheControl(cc);
        }
        if ((serverGroup = this.getRoutingServerGroup(module, moduleId)) != null && !serverGroup.isEmpty()) {
            builder.header("X-CA-Routing", (Object)serverGroup);
        }
        return builder.build();
    }

    private String getRoutingServerGroup(Module module, String moduleId) {
        Map<String, String> routingMap;
        String moduleIdRouting = moduleId;
        if (ModuleUtil.isEmbeddedModule(module)) {
            moduleIdRouting = ModuleUtil.getEmbeddedModuleSource(module);
        }
        if ((routingMap = this.runtime.getRoutingServerGroupsMap()).containsKey(moduleIdRouting)) {
            String routingServerGroup = routingMap.get(moduleIdRouting);
            return "__IBMCOGNOS_EMPTY_ROUTING_SERVER_GROUP__".equals(routingServerGroup) ? null : routingServerGroup;
        }
        JSONObject routing = UserProfileService.isSessionModule(moduleIdRouting) ? this.getModuleStorageCM().getObjectFromUPS(moduleIdRouting) : this.getModuleStorageCM().getObjectFromCM(moduleIdRouting, "routingServerGroup");
        String serverGroup = null;
        if (routing != null) {
            serverGroup = (String)routing.get((Object)"routingServerGroup");
        }
        return serverGroup;
    }

    public Object buildModulesResponseXQE(Map<String, Object> subModules, String moduleId) {
        Response.ResponseBuilder builder = Response.ok(subModules, (String)"application/json");
        LoggerAdapter.trace(ModuleObjectManagerCM.class, "Got modules XQE '{}'. Returning status 200", moduleId);
        RESTClientResponse resp = this.getModuleStorageCM().getRestClientResponse();
        String etagStr = this.m304Handler.getGeneratedEtag();
        Date lastModified = new Date(0L);
        String lm = resp.getResponseHeader("Last-Modified");
        if (lm != null && !lm.isEmpty()) {
            try {
                lastModified = DateUtil.parseDate((String)lm);
            }
            catch (DateParseException e) {
                LoggerAdapter.errorExceptionStack(ModuleObjectManagerCM.class, e);
            }
        }
        if (etagStr != null) {
            CacheControl cc = new CacheControl();
            cc.setMustRevalidate(true);
            cc.setPrivate(true);
            builder = builder.tag(etagStr).lastModified(lastModified).cacheControl(cc);
        }
        return builder.build();
    }

    @Override
    public boolean isResourceNotModified(String moduleId) {
        return !this.m304Handler.isResourceModified();
    }

    @Override
    public RESTClientResponse putUploadedFile(String uploadedFileStoreId, UploadedFileContainer uploadedFile) {
        JSONObject json = uploadedFile.toJSON();
        RESTClientResponse resp = this.getModuleStorageCM().putResource(uploadedFileStoreId, json);
        if (resp.getResponseCode() != 204) {
            return resp;
        }
        uploadedFile.updatePhysicalDatasources(uploadedFileStoreId);
        uploadedFile.setStoreId(uploadedFileStoreId);
        ReportVersionContainer reportVersion = uploadedFile.getReportVersion();
        json = reportVersion.toJSON();
        RESTClientResponse childResp = this.getModuleStorageCM().postItems(uploadedFileStoreId, json);
        if (childResp.getResponseCode() != 201) {
            return childResp;
        }
        String reportVersionStoreId = RESTUtils.getLocationStoreId(childResp);
        json = reportVersion.getBaseModule().toJSON();
        childResp = this.getModuleStorageCM().postItems(reportVersionStoreId, json);
        if (childResp.getResponseCode() != 201) {
            this.getModuleStorageCM().delete(reportVersionStoreId, true, true);
            return childResp;
        }
        for (OutputContainer output : reportVersion.getOutputs()) {
            childResp = this.postOutput(reportVersionStoreId, output);
            if (childResp.getResponseCode() == 201 || childResp.getResponseCode() == 200) continue;
            this.getModuleStorageCM().delete(reportVersionStoreId, true, true);
            return childResp;
        }
        childResp = this.postHistory(uploadedFileStoreId, reportVersionStoreId);
        if (childResp.getResponseCode() != 201 && childResp.getResponseCode() != 200) {
            this.getModuleStorageCM().delete(reportVersionStoreId, true, true);
            return childResp;
        }
        return resp;
    }

    private RESTClientResponse postOutput(String reportVersionStoreId, OutputContainer output) {
        JSONObject json = output.toJSON();
        File data = output.getData();
        return this.createOutput(reportVersionStoreId, json, data);
    }

    private RESTClientResponse createOutput(String reportVersionStoreId, JSONObject json, File data) {
        RESTClientResponse childResp = this.getModuleStorageCM().postItems(reportVersionStoreId, json);
        if (childResp.getResponseCode() != 201) {
            return childResp;
        }
        String outputStoreId = RESTUtils.getLocationStoreId(childResp);
        return ModuleObjectManagerCM.postParquetFile(this.getModuleStorageCM(), outputStoreId, data);
    }

    private RESTClientResponse postHistory(String uploadedFileStoreId, String reportVersionStoreId) {
        JSONObject json = ModuleObjectManagerCM.createHistoryJSON();
        RESTClientResponse childResp = this.getModuleStorageCM().postItems(uploadedFileStoreId, json);
        if (childResp.getResponseCode() != 201) {
            return childResp;
        }
        String historyStoreId = RESTUtils.getLocationStoreId(childResp);
        childResp = this.getModuleStorageCM().getResource(reportVersionStoreId, "searchPath");
        if (childResp.getResponseCode() != 200) {
            return childResp;
        }
        String reportVersionSearchPath = (String)((JSONObject)((JSONArray)childResp.getJSONObjectResponse().get((Object)"data")).get(0)).get((Object)"searchPath");
        json = ModuleObjectManagerCM.createHistoryDetailJSON(reportVersionStoreId, reportVersionSearchPath);
        return this.getModuleStorageCM().postItems(historyStoreId, json);
    }

    @Override
    public JSONObject getUploadedFileJSON(String uploadedFileStoreId) {
        return this.getModuleStorageCM().getBaseModuleFromDefaultOutput(uploadedFileStoreId, "physicalDefinition");
    }

    @Override
    public Module getModulesXQE(String id, Map<String, Module> subModules, String[] storeId, UseSpecType type, long[] lifeTime) {
        String moduleId = id;
        UseSpecType moduleType = moduleId.startsWith(STR_DATASETS_DOT) || moduleId.startsWith("datasets:") ? UseSpecType.DATASET : type;
        moduleId = MoserUtil.stripToStoreID(moduleId);
        Module module = null;
        if (ModuleObjectManagerCM.isSearchPath(moduleId)) {
            module = this.getModulesXQESearchPath(moduleId, subModules, storeId, lifeTime);
        } else if (this.isStoreId(moduleId) || UserProfileService.isSessionReport(moduleId)) {
            module = this.getModulesXQEStoreId(moduleId, subModules, storeId, moduleType, lifeTime);
        }
        if (module != null) {
            String etag = this.m304Handler.postDependencies();
            this.setEtagAndLastModifiedInResponseHeader(etag);
        }
        return module;
    }

    private void addModuleEtagModificationTime(String modificationTime) {
        if (modificationTime != null) {
            this.m304Handler.updateLastModified(MoserUtil.getTimeInMillis(modificationTime));
        } else {
            this.m304Handler.updateLastModified(0L);
        }
    }

    private Module getModulesXQESearchPath(String moduleId, Map<String, Module> subModules, String[] storeId, long[] lifeTime) {
        JSONObject jModule = this.getModuleStorageCM().getObjectSearchPath(moduleId, Arrays.asList(CM_FIELDS));
        if (jModule == null) {
            return null;
        }
        storeId[0] = (String)jModule.get((Object)"id");
        String type = (String)jModule.get((Object)"type");
        if ("uploadedFile".equals(type) || "dataSet2".equals(type)) {
            return this.getBaseModulesXQEUploadedFile(storeId[0], subModules);
        }
        String businessModuleDef = (String)jModule.get((Object)"definition");
        if (businessModuleDef != null) {
            String moduleDefaultName;
            JSONArray deploymentRefs = (JSONArray)jModule.get((Object)"deploymentReferences");
            Module retBusiness = this.decodeModule(businessModuleDef, deploymentRefs, moduleDefaultName = (String)jModule.get((Object)"defaultName"));
            if (retBusiness != null) {
                if (!UserProfileService.isSessionModule(storeId[0])) {
                    this.m304Handler.addDependency(jModule);
                } else {
                    this.m304Handler.addSessionDependency(storeId[0], this.getModificationTime(jModule, storeId[0]));
                }
                this.addModuleEtagModificationTime((String)jModule.get((Object)"modificationTime"));
            }
            retBusiness = LogicalModuleResolver.resolveLogicalModuleXQE(this, storeId[0], retBusiness, subModules, lifeTime, UseSpecType.MODULE);
            return retBusiness;
        }
        String baseDef = (String)jModule.get((Object)"baseDefinition");
        String physicalDef = (String)jModule.get((Object)"physicalDefinition");
        if (baseDef == null || baseDef.isEmpty() || physicalDef == null || physicalDef.isEmpty()) {
            ModuleObjectManagerCM.checkPermissions(jModule);
            return null;
        }
        Module retBase = this.decodeModule(baseDef, null, null);
        Module retPhysical = this.decodeModule(physicalDef, null, null);
        this.updateDataSourceFromAncestor(retPhysical, (JSONArray)jModule.get((Object)"ancestors"));
        WKCUtil.updateJDBCConnection(this, retPhysical);
        subModules.put(storeId[0] + DOT_PHYSICALMODULE, retPhysical);
        this.addModuleEtagModificationTime((String)jModule.get((Object)"modificationTime"));
        if (lifeTime != null) {
            lifeTime[0] = MoserConfig.getXQEModuleLifetime();
        }
        return retBase;
    }

    private Module getBaseModulesXQEUploadedFile(String storeId, Map<String, Module> subModules) {
        String[] moduleDefs = new String[]{"baseDefinition", "physicalDefinition"};
        JSONObject jModule = this.getBaseModuleJSONForDatasetProperties(storeId, moduleDefs);
        if (jModule == null) {
            return null;
        }
        String baseDef = (String)jModule.get((Object)"baseDefinition");
        String physicalDef = (String)jModule.get((Object)"physicalDefinition");
        if (baseDef == null || baseDef.isEmpty() || physicalDef == null || physicalDef.isEmpty()) {
            return null;
        }
        Module retBase = this.decodeModule(baseDef, null, null);
        Module retPhysical = this.decodeModule(physicalDef, null, null);
        subModules.put(storeId + DOT_PHYSICALMODULE, retPhysical);
        return retBase;
    }

    private Module getModulesXQEStoreId(String moduleId, Map<String, Module> subModules, String[] storeId, UseSpecType moduleType, long[] lifeTime) {
        String businessModuleDef;
        storeId[0] = moduleId;
        if (UseSpecType.DATASET.equals((Object)moduleType)) {
            return this.getBaseModulesXQEUploadedFile(storeId[0], subModules);
        }
        if (UseSpecType.REPORT.equals((Object)moduleType)) {
            Module retBusiness = this.getBaseModuleForReport(storeId[0]);
            retBusiness = LogicalModuleResolver.resolveLogicalModuleXQE(this, storeId[0], retBusiness, subModules, lifeTime, moduleType);
            return retBusiness;
        }
        JSONObject result = this.getModuleJSONWithFields(moduleId, CM_FIELDS);
        if (result == null) {
            return null;
        }
        String type = (String)result.get((Object)"type");
        if ("uploadedFile".equals(type) || "dataSet2".equals(type)) {
            return this.getBaseModulesXQEUploadedFile(storeId[0], subModules);
        }
        if ("dataSourceSchema".equals(type)) {
            result = this.getModuleStorageCM().getBaseModuleForDataSourceSchema(moduleId, CM_FIELDS);
        }
        if ((businessModuleDef = (String)result.get((Object)"definition")) != null) {
            String moduleDefaultName;
            JSONArray deploymentRefs = (JSONArray)result.get((Object)"deploymentReferences");
            Module retBusiness = this.decodeModule(businessModuleDef, deploymentRefs, moduleDefaultName = (String)result.get((Object)"defaultName"));
            if (retBusiness != null) {
                if (!UserProfileService.isSessionModule(storeId[0])) {
                    this.m304Handler.addDependency(result);
                } else {
                    this.m304Handler.addSessionDependency(storeId[0], this.getModificationTime(result, storeId[0]));
                }
            }
            retBusiness = LogicalModuleResolver.resolveLogicalModuleXQE(this, storeId[0], retBusiness, subModules, lifeTime, UseSpecType.MODULE);
            return retBusiness;
        }
        String baseDef = (String)result.get((Object)"baseDefinition");
        String physicalDef = (String)result.get((Object)"physicalDefinition");
        if (baseDef == null || baseDef.isEmpty() || physicalDef == null || physicalDef.isEmpty()) {
            return null;
        }
        Module retBase = this.decodeModule(baseDef, null, null);
        this.applyOverrides(retBase, result);
        Module retPhysical = this.decodeModule(physicalDef, null, null);
        this.updateDataSourceFromAncestor(retPhysical, (JSONArray)result.get((Object)"ancestors"));
        WKCUtil.updateJDBCConnection(this, retPhysical);
        subModules.put(storeId[0] + DOT_PHYSICALMODULE, retPhysical);
        if (lifeTime != null) {
            lifeTime[0] = MoserConfig.getXQEModuleLifetime();
        }
        this.m304Handler.addDependency(result);
        return retBase;
    }

    public JSONObject getModuleJSONWithFields(String id, String ... fields) {
        return this.getModuleStorageCM().getModuleJSONWithFields(id, fields);
    }

    @Override
    public String getModulePrettyPath(String moduleId) {
        ModuleStorageCM contentManager = this.getReqEnvironment().createModuleStorageCM();
        StringBuilder ret = new StringBuilder();
        String key = "ancestors";
        JSONObject object = contentManager.getObjectFromCM(moduleId, key, "defaultName");
        JSONArray ancestors = (JSONArray)object.get((Object)key);
        for (Object obj : ancestors) {
            JSONObject ancestor = (JSONObject)obj;
            String type = (String)ancestor.get((Object)"type");
            if (!"content".equals(type) && !"folder".equals(type)) continue;
            ret.append(ancestor.get((Object)"defaultName"));
            ret.append("/");
        }
        ret.append(object.get((Object)"defaultName"));
        return ret.toString();
    }

    @Override
    public Module getBaseModuleForLWOLAP(String storeID, String moduleAlias, List<String> ids) {
        return this.getBaseModuleFromXQEAddSmarts(storeID, UseSpecType.LW_OLAP, moduleAlias, ids);
    }

    @Override
    public Module getPackageTaxonomy(String moduleId) {
        JSONObject jBaseModule = this.getModuleStorageCM().getBaseModuleChild(moduleId, "baseDefinition");
        if (jBaseModule == null) {
            return null;
        }
        String baseDef = (String)jBaseModule.get((Object)"baseDefinition");
        if (baseDef != null) {
            return this.decodeModule(baseDef, null, null);
        }
        return null;
    }

    @Override
    public void updateBaseModuleOverrides(String moduleId, Module module) {
        this.updateBaseModule(moduleId, null, module);
        this.updateResourceHistory(UseSpecType.PACKAGE, moduleId, null, MoserUtil.getCurrentTimeGregorianUTC(), null, null);
    }

    @Override
    public synchronized boolean updateResourceHistory(UseSpecType sourceType, String sourceId, XMLGregorianCalendar lastAnalysisCollection, XMLGregorianCalendar lastOverrideUpdate, String loadOptionsJSON, TaskStatus status) {
        if (this.lastTaskStatus != null && !this.lastTaskStatus.isRunning()) {
            return false;
        }
        String sourceID = sourceId;
        UseSpecType resourceType = sourceType;
        if (resourceType == null) {
            resourceType = this.getModuleType(sourceId, null);
        }
        if (UseSpecType.MODULE.equals((Object)resourceType)) {
            return true;
        }
        if (UseSpecType.PACKAGE.equals((Object)resourceType)) {
            sourceID = this.getBaseModuleStoreID(sourceId);
        }
        if (sourceID == null) {
            return false;
        }
        TaskStatus statusToWrite = null;
        if (status != null) {
            status.setCMUpdateTime(System.currentTimeMillis());
            statusToWrite = status.clone();
            if (!statusToWrite.isRunning()) {
                statusToWrite.setTaskID(null);
            }
        }
        boolean writeStatus = this.getModuleStorageCM().updateResourceHistory(sourceID, lastAnalysisCollection, lastOverrideUpdate, loadOptionsJSON, statusToWrite);
        this.lastTaskStatus = statusToWrite;
        return writeStatus;
    }

    @Override
    public JSONObject getResourceStatusInfo(String resourceID) {
        UseSpecType moduleType = this.getModuleType(resourceID, null);
        String sourceID = resourceID;
        if (UseSpecType.PACKAGE.equals((Object)moduleType)) {
            sourceID = this.getBaseModuleStoreID(resourceID);
        }
        if (sourceID == null) {
            return null;
        }
        JSONObject hmDetailService = this.getModuleStorageCM().getHistoryDetailMoserService(sourceID);
        if (hmDetailService != null) {
            return (JSONObject)hmDetailService.get((Object)"statusInfo");
        }
        return null;
    }

    protected ModuleStorageCM getModuleStorageCM() {
        return this.getReqEnvironment().getModuleStorageCM();
    }

    @Override
    public String getStoreIdBySearchPath(String searchPath) {
        ContentService cs = this.getReqEnvironment().getContentService();
        RESTClientResponse resp = cs.getBySearchPath(searchPath, "id");
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            return null;
        }
        JSONArray data = (JSONArray)resp.getJSONObjectResponse().get((Object)"data");
        JSONObject object = (JSONObject)data.get(0);
        return (String)object.get((Object)"id");
    }

    @Override
    public Response postReportSpec(String id, String spec) {
        ReportTranslator translator = new ReportTranslator(this.getReqEnvironment(), spec);
        String normalizedSpec = translator.getRawSource(id);
        Module module = translator.translate(id);
        String etag = Integer.toUnsignedString(normalizedSpec.hashCode()) + "-" + Long.toUnsignedString(System.currentTimeMillis());
        TempReport body = new TempReport();
        body.setSpecification(normalizedSpec);
        body.setEtag(etag);
        UserProfileService ups = this.getReqEnvironment().getUserProfileService();
        RESTClientResponse resp = ups.post(UserProfileService.UserProfileResource.TEMP, null, UserProfileService.UserProfileSubResource.REPORTS, null, body);
        if (resp.getResponseCode() != Response.Status.CREATED.getStatusCode()) {
            throw new UPSPostTempException(UserProfileService.UserProfileSubResource.REPORTS.toString());
        }
        String tempId = RESTUtils.getLocationStoreId(resp) + "_sessionReport";
        String name = module.getLabel();
        String href = MODULES + tempId;
        MoserInfo info = MoserInfoUtil.createMoserInfo(href, tempId, null, name, MoserUtil.getCurrentTimeGregorian());
        return MoserUtil.getResponse(Response.Status.CREATED, (Object)info);
    }

    @Override
    public Response getReportSpec(String id, String type) {
        String reportId;
        UseSpecType objectType = this.getModuleType(id, type);
        RESTClientResponse lastResp = this.getModuleStorageCM().getRestClientResponse();
        if (lastResp != null && lastResp.getResponseCode() == Response.Status.NOT_MODIFIED.getStatusCode()) {
            return MoserUtil.getResponse(Response.Status.NOT_MODIFIED);
        }
        if (!UseSpecType.MODULE.equals((Object)objectType) && !UseSpecType.REPORT.equals((Object)objectType)) {
            throw new ForbiddenException();
        }
        Header header = this.runtime.getRESTClientConfig().getRequestHeader("If-None-Match");
        String etag = header == null ? null : header.getValue();
        ReportTranslator translator = new ReportTranslator(this.runtime, null);
        String string = reportId = UseSpecType.REPORT.equals((Object)objectType) ? id : this.getReportIdFromEmbeddedModule(id);
        if (!translator.isModified(reportId, etag)) {
            return MoserUtil.getResponse(Response.Status.NOT_MODIFIED);
        }
        String normalizedSpec = translator.getRawSource(reportId);
        return MoserUtil.getResponse(Response.Status.OK, normalizedSpec, MediaType.TEXT_XML_TYPE, translator.getEtag(), translator.getLastModified());
    }

    private String getReportIdFromEmbeddedModule(String id) {
        Module module = this.getBusinessModule(id, UseSpecType.MODULE);
        if (module == null) {
            throw new ReportNotFoundException(id);
        }
        List useSpecs = module.getUseSpec();
        if (!DataModuleExtractor.isEmbeddedModule((List)useSpecs) || !UseSpecType.REPORT.equals((Object)((Module.UseSpec)useSpecs.get(0)).getType())) {
            throw new ForbiddenException();
        }
        return ((Module.UseSpec)useSpecs.get(0)).getStoreID();
    }

    static {
        conf.set("fs.file.impl", "shaded.org.apache.hadoop.fs.RawLocalFileSystem");
        CM_FIELDS = new String[]{"defaultName", "id", "modificationTime", "type", "definition", "baseDefinition", "physicalDefinition", "deploymentReferences", "ancestors", "routingServerGroup", "permissions", "version"};
        objectTypeCache = CacheBuilder.newBuilder().maximumSize(MoserConfig.getObjectTypeCacheSize()).expireAfterAccess(MoserConfig.getObjectTypeCacheExpiry(), TimeUnit.SECONDS).build();
    }
}

