/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module;

import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.metadata.provider.report.GenerateBaseModuleFromReportOutput;
import com.ibm.bi.platform.moser.core.module.FileMarshaller;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.container.BaseModuleContainer;
import com.ibm.bi.platform.moser.core.module.container.OutputContainer;
import com.ibm.bi.platform.moser.core.module.container.UploadedFileContainer;
import com.ibm.bi.platform.moser.core.module.util.LogicalModuleResolver;
import com.ibm.bi.platform.moser.core.module.util.MoserMetadataContext;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserInfoUtil;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ModuleObjectManagerFile
extends ModuleObjectManager {
    private static final String HREF = "href";
    private static final String ID = "id";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String LABEL = "label";
    private static final String DATASETS_SLASH = "datasets/";
    private static final String FILE_INFO = "/fileInfo.json";
    private FileMarshaller moduleReaderWriter = new FileMarshaller();

    public ModuleObjectManagerFile(RequestEnvironment runtime) {
        super(runtime);
    }

    protected String getPhysicalModuleFolder(String id) {
        String path = this.getPhysicalModuleFolder();
        String[] folders = id.split(":");
        StringBuilder folder = new StringBuilder(path);
        for (String current : folders) {
            if (current.isEmpty()) {
                current = "null";
            }
            folder.append(File.separator);
            folder.append(current);
        }
        return folder.toString();
    }

    protected String getPhysicalModuleFolder() {
        return MoserConfig.getInstance().getBaseModulesDirectory();
    }

    protected File getPhysicalModuleFile(String id) {
        String folder = this.getPhysicalModuleFolder(id);
        return ModuleObjectManagerFile.getPhysicalModuleFileByFolder(folder);
    }

    protected static File getPhysicalModuleFileByFolder(String folder) {
        return new File(folder + File.separator + "physicalmodule" + ".xml");
    }

    protected static File getBaseModuleFileByFolder(String folder) {
        return new File(folder + File.separator + "base" + ".xml");
    }

    private File getBaseModuleFile(String id) {
        File file;
        String dbID = id.replaceAll("\\.", ":");
        if (dbID.startsWith("datasets:")) {
            dbID = dbID.replaceFirst("datasets:", "");
            String filename = MoserConfig.getInstance().getBaseModulesDirectory() + "/datasets/" + File.separator + dbID + File.separator + "base.xml";
            file = new File(filename);
        } else {
            String folder = this.getPhysicalModuleFolder(dbID);
            folder = folder + File.separator + "base.xml";
            file = new File(folder);
        }
        return file;
    }

    @Override
    public boolean deleteBaseModule(String id) {
        String folder = this.getPhysicalModuleFolder(id);
        return FileUtils.deleteQuietly((File)new File(folder));
    }

    @Override
    public Module getBaseModule(String id, UseSpecType type) {
        File file = this.getBaseModuleFile(id);
        if (!file.exists()) {
            return null;
        }
        return (Module)this.moduleReaderWriter.unmarshal(file, Module.class);
    }

    @Override
    public Module getBaseModuleForPackage(String id, String alias) {
        return null;
    }

    @Override
    public Module getBaseModuleForReport(String id) {
        return null;
    }

    @Override
    public String getSearchPathForPackage(String id, String[] pkgName) {
        return null;
    }

    @Override
    public Module getPhysicalModule(String id) {
        File file = this.getPhysicalModuleFile(id);
        if (!file.exists()) {
            return null;
        }
        return (Module)this.moduleReaderWriter.unmarshal(file, Module.class);
    }

    private static String getBusinessModuleContainer() {
        return ModuleObjectManagerFile.getContainer(ModuleObjectManagerFile.getBusinessModuleFolder());
    }

    @Override
    public Response postBusinessModule(String location, Module businessModule, boolean bTemp, Locale locale, boolean overwrite) {
        String id;
        String name = id = businessModule.getIdentifier();
        String href = "/modules/" + id;
        File file = ModuleObjectManagerFile.getBusinessModuleFile(id);
        businessModule.setContainer(ModuleObjectManagerFile.getBusinessModuleContainer());
        this.moduleReaderWriter.marshal(file, businessModule);
        XMLGregorianCalendar dateTime = MoserUtil.getTimeGregorian(file.lastModified());
        MoserInfo info = MoserInfoUtil.createMoserInfo(href, id, null, name, dateTime);
        return MoserUtil.getResponse(Response.Status.OK, (Object)info);
    }

    private static File getBusinessModuleFile(String id) {
        String folder = ModuleObjectManagerFile.getBusinessModuleFolder();
        File file = new File(folder);
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(folder + File.separator + id + ".xml");
        return file;
    }

    private static String getBusinessModuleFolder() {
        return MoserConfig.getInstance().getMoserOutputDirectory() + File.separator + "modules" + File.separator + "businessModules";
    }

    @Override
    public List<JSONObject> getModuleList() {
        ArrayList<JSONObject> moduleList = new ArrayList<JSONObject>();
        String folder = ModuleObjectManagerFile.getBusinessModuleFolder();
        File modulesFolder = new File(folder);
        if (!modulesFolder.exists()) {
            return moduleList;
        }
        File[] files = modulesFolder.listFiles();
        if (files == null) {
            return moduleList;
        }
        for (File file : files) {
            String name = FilenameUtils.removeExtension((String)file.getName());
            XMLGregorianCalendar dateTime = MoserUtil.getTimeGregorian(file.lastModified());
            JSONObject json = new JSONObject();
            json.put((Object)HREF, (Object)("/modules" + name));
            json.put((Object)ID, (Object)name);
            json.put((Object)LABEL, (Object)name);
            json.put((Object)LAST_MODIFIED, (Object)dateTime.toString());
            moduleList.add(json);
        }
        return moduleList;
    }

    @Override
    public Module getBusinessModuleMetadata(String moduleId, UseSpecType type) {
        Module module = this.getBusinessModule(moduleId, type);
        module = LogicalModuleResolver.resolveLogicalModule(this, module);
        return module;
    }

    @Override
    public Module getBusinessModule(String moduleId, UseSpecType type) {
        File moduleFile = ModuleObjectManagerFile.getBusinessModuleFile(moduleId);
        if (!moduleFile.exists()) {
            return null;
        }
        return (Module)this.moduleReaderWriter.unmarshal(moduleFile, Module.class);
    }

    @Override
    public boolean deleteBusinessModule(String businessModule) {
        File file = ModuleObjectManagerFile.getBusinessModuleFile(businessModule);
        return FileUtils.deleteQuietly((File)file);
    }

    @Override
    public boolean delete(String id, boolean force, boolean recursive) {
        return false;
    }

    @Override
    public boolean updateBusinessModule(String businessModule, Module module) {
        File file = ModuleObjectManagerFile.getBusinessModuleFile(businessModule);
        return this.moduleReaderWriter.marshal(file, module);
    }

    @Override
    public MoserInfo getModuleInfo(String moduleId, List<String> attributes) {
        String id = moduleId;
        String label = null;
        XMLGregorianCalendar dateTime = null;
        boolean xqeMoser = attributes != null && attributes.remove("xqemoser");
        boolean getLabel = attributes == null || attributes.isEmpty() || attributes.contains(LABEL);
        boolean getLastModified = attributes == null || attributes.isEmpty() || attributes.contains(LAST_MODIFIED);
        File moduleFile = ModuleObjectManagerFile.getBusinessModuleFile(moduleId);
        if (!(moduleFile.exists() || !xqeMoser || (moduleFile = ModuleObjectManagerFile.getBusinessModuleFileById(moduleId)) != null && moduleFile.exists())) {
            moduleFile = this.getBaseModuleFile(moduleId);
        }
        if (!moduleFile.exists()) {
            return null;
        }
        if (getLabel) {
            label = FilenameUtils.removeExtension((String)moduleFile.getName());
        }
        if (getLastModified) {
            dateTime = MoserUtil.getTimeGregorian(moduleFile.lastModified());
        }
        return MoserInfoUtil.createMoserInfo("/modules/" + id, id, null, label, dateTime);
    }

    @Override
    public Module getBusinessModuleMetadataById(String moduleId) {
        File file = ModuleObjectManagerFile.getBusinessModuleFileById(moduleId);
        if (file == null) {
            return null;
        }
        return (Module)this.moduleReaderWriter.unmarshal(file, Module.class);
    }

    private static File getBusinessModuleFileById(String moduleId) {
        String[] paths = moduleId.split("\\.");
        StringBuilder sb = new StringBuilder();
        sb.append(MoserConfig.getInstance().getMoserOutputDirectory());
        for (String p : paths) {
            sb.append(File.separator);
            sb.append(p);
        }
        sb.append(".xml");
        File file = new File(sb.toString());
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    private static void adjustModelContainer(Module m) {
        String prefix = "modules.baseModules.";
        String container = prefix + m.getContainer();
        m.setContainer(container);
        List usages = m.getUse();
        ArrayList copy = new ArrayList(usages);
        usages.clear();
        for (String s : copy) {
            usages.add(prefix + s);
        }
    }

    @Override
    public int saveBaseModulesForDatabase(BaseModuleContainer baseModule) {
        ModuleObjectManagerFile.adjustModelContainer(baseModule.getPhysicalModule());
        ModuleObjectManagerFile.adjustModelContainer(baseModule.getBaseBusinessModule());
        return this.saveBaseModule(baseModule);
    }

    protected String getBaseModuleOutputFolder(String id) {
        return this.getPhysicalModuleFolder(id);
    }

    protected int saveBaseModule(BaseModuleContainer baseModule) {
        Module physicalModule = baseModule.getPhysicalModule();
        Module baseBusinessModule = baseModule.getBaseBusinessModule();
        String folder = this.getBaseModuleOutputFolder(baseModule.getDatabaseId());
        File physicalModuleFile = new File(folder);
        if (!physicalModuleFile.exists()) {
            physicalModuleFile.mkdirs();
        }
        physicalModuleFile = this.getPhysicalModuleFile(baseModule.getDatabaseId());
        FileUtils.deleteQuietly((File)physicalModuleFile);
        if (!this.moduleReaderWriter.marshal(physicalModuleFile, physicalModule)) {
            return 500;
        }
        File baseModuleFile = ModuleObjectManagerFile.getBaseModuleFileByFolder(folder);
        FileUtils.deleteQuietly((File)baseModuleFile);
        if (!this.moduleReaderWriter.marshal(baseModuleFile, baseBusinessModule)) {
            return 500;
        }
        return 201;
    }

    @Override
    public Module getBaseModuleForDataset(String datasetID, String moduleType) {
        if ("physicalDefinition".equals(moduleType)) {
            return this.getPhysicalModule(DATASETS_SLASH + datasetID);
        }
        return this.getBaseModule(DATASETS_SLASH + datasetID, null);
    }

    @Override
    public Module getBaseModuleForDatabase(String databaseID, String moduleType) {
        return this.getBaseModule(databaseID, null);
    }

    @Override
    public Collection<JSONObject> getUsedModules(String moduleId) {
        return Collections.emptyList();
    }

    @Override
    public BaseModuleContainer createBaseModuleForDatabase(String databaseId, String parent) {
        BaseModuleContainer baseModule = new BaseModuleContainer();
        baseModule.setStartTime(MoserUtil.getCurrentTimeGregorianUTC());
        baseModule.setDatabaseId(databaseId);
        baseModule.setStatus("executing");
        String[] idParts = databaseId.split(":");
        String catalog = idParts[2];
        String schema = idParts[3];
        baseModule.setCatalog(catalog);
        baseModule.setSchema(schema);
        return baseModule;
    }

    @Override
    public int putBaseModule(String id, Module baseModule) {
        String strippedKey = MoserUtil.stripInvalidFilenameCharactersIncludingDot(id);
        File file = this.getBaseModuleFile(DATASETS_SLASH + strippedKey);
        boolean success = this.moduleReaderWriter.marshal(file, baseModule);
        return success ? 200 : 500;
    }

    @Override
    public String getBaseModuleStoreID(String id) {
        return id;
    }

    @Override
    public UseSpecType getModuleType(String id, String type) {
        return null;
    }

    @Override
    public JSONObject getFileUploadObject(String key, String locationPath, String[] fields) {
        String strippedKey = MoserUtil.stripInvalidFilenameCharactersIncludingDot(key);
        File file = this.getBaseModuleFile(DATASETS_SLASH + strippedKey);
        if (!file.exists()) {
            return null;
        }
        File f = new File(file.getParentFile().getAbsolutePath() + FILE_INFO);
        try {
            String json = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
            JSONObject fileUploadObject = JSONObject.parse((String)json);
            if (fileUploadObject == null) {
                fileUploadObject = new JSONObject();
                JSONArray history = new JSONArray();
                fileUploadObject.put((Object)"history", (Object)history);
            }
            fileUploadObject.put((Object)"defaultName", (Object)key);
            fileUploadObject.put((Object)"referenceToFileOnSharedDisk", (Object)strippedKey);
            return fileUploadObject;
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(ModuleObjectManagerFile.class, e);
            return null;
        }
    }

    @Override
    public String getDefaultName(String cmID) {
        return cmID;
    }

    @Override
    public RESTClientResponse postUploadedFile(String parentId, UploadedFileContainer uploadedFile, TaskStatus status) {
        BaseModuleContainer baseModule = uploadedFile.getReportVersion().getBaseModule();
        baseModule.getPhysicalModule().setContainer(baseModule.getDatabaseId());
        baseModule.getBaseBusinessModule().setContainer(baseModule.getDatabaseId());
        baseModule.getBaseBusinessModule().getUse().clear();
        GenerateBaseModuleFromReportOutput.addUses(baseModule.getBaseBusinessModule(), baseModule.getPhysicalModule().getContainer(), baseModule.getPhysicalModule().getIdentifier());
        baseModule.setDatabaseId(baseModule.getDatabaseId().replaceAll("\\.", ":"));
        this.saveParquetToDisk(baseModule, uploadedFile);
        uploadedFile.setStoreId(uploadedFile.getDefaultName());
        this.saveUploadedFileInfoToDisk(baseModule, uploadedFile);
        return new RESTClientResponse(this.saveBaseModulesForUploadedFile(baseModule));
    }

    @Override
    public RESTClientResponse putUploadedFile(String parentId, UploadedFileContainer uploadedFile) {
        return this.postUploadedFile(parentId, uploadedFile, null);
    }

    private int saveBaseModulesForUploadedFile(BaseModuleContainer baseModule) {
        return this.saveBaseModulesForDatabase(baseModule);
    }

    protected String getFileInfoOutputFolder(String id) {
        return this.getPhysicalModuleFolder(id);
    }

    private void saveUploadedFileInfoToDisk(BaseModuleContainer baseModule, UploadedFileContainer uploadedFile) {
        String folder = this.getFileInfoOutputFolder(baseModule.getDatabaseId());
        File dir = new File(folder);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            JSONObject json = uploadedFile.toJSON();
            Files.write(Paths.get(folder + FILE_INFO, new String[0]), json.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (FileNotFoundException e) {
            LoggerAdapter.errorExceptionStack(ModuleObjectManagerFile.class, e);
        }
        catch (IOException ex) {
            LoggerAdapter.errorExceptionStack(ModuleObjectManagerFile.class, ex);
        }
    }

    protected String getParquetOutputFolder(String id) {
        return this.getPhysicalModuleFolder(id);
    }

    private void saveParquetToDisk(BaseModuleContainer baseModule, UploadedFileContainer uploadedFile) {
        String folder = this.getParquetOutputFolder(baseModule.getDatabaseId());
        File dir = new File(folder);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (OutputContainer output : uploadedFile.getReportVersion().getOutputs()) {
            File parquetFile = new File(folder, output.getDefaultName() + ".parquet");
            try {
                Files.copy(output.getData().toPath(), parquetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LoggerAdapter.errorExceptionStack(ModuleObjectManagerFile.class, e);
            }
        }
    }

    @Override
    public Object buildModuleResponse(Request context, Module module, String moduleId, String key) {
        return module;
    }

    @Override
    public boolean isResourceNotModified(String moduleId) {
        return false;
    }

    @Override
    public JSONObject getUploadedFileJSON(String uploadedFileStoreId) {
        Module physicalModule = this.getPhysicalModule(DATASETS_SLASH + uploadedFileStoreId);
        if (physicalModule == null) {
            return new JSONObject();
        }
        JSONObject result = new JSONObject();
        result.put((Object)"physicalDefinition", (Object)MoserUtil.encode(physicalModule, false));
        return result;
    }

    @Override
    public boolean updateBaseModule(String id, Module module) {
        String strippedKey = MoserUtil.stripInvalidFilenameCharactersIncludingDot(id);
        File file = this.getBaseModuleFile(DATASETS_SLASH + strippedKey);
        return this.moduleReaderWriter.marshal(file, module);
    }

    @Override
    public String getModulePrettyPath(String moduleId) {
        return moduleId;
    }

    @Override
    public Module getBaseModuleForLWOLAP(String storeID, String alias, List<String> ids) {
        return null;
    }

    @Override
    public RESTClientResponse upgradeParquetFile(String outputId, String tempDir, TaskStatus status) {
        return null;
    }

    @Override
    public Module getPackageTaxonomy(String moduleId) {
        return this.getBaseModule(moduleId, null);
    }

    @Override
    public void updateBaseModuleOverrides(String moduleId, Module module) {
        this.updateBaseModule(moduleId, module, null);
    }

    @Override
    public boolean updateResourceHistory(UseSpecType sourceType, String sourceId, XMLGregorianCalendar lastAnalysisCollection, XMLGregorianCalendar lastOverrideUpdate, String loadOptionsJSON, TaskStatus status) {
        return true;
    }

    @Override
    public int updateBaseModule(String id, Module baseDefinition, Module baseOverrides) {
        return 204;
    }

    @Override
    public Module getBaseModule(String moduleId, UseSpecType moduleType, List<String> ids) {
        return this.getBaseModule(moduleId, moduleType);
    }

    @Override
    public Module getBaseModuleForPackage(String id, String moduleAlias, List<String> ids) {
        return this.getBaseModuleForPackage(id, moduleAlias);
    }

    @Override
    public Module getBusinessModuleMetadata(String moduleId, UseSpecType moduleType, List<String> ids) {
        return this.getBusinessModuleMetadata(moduleId, moduleType);
    }

    @Override
    public JSONObject getResourceStatusInfo(String resourceID) {
        return null;
    }

    @Override
    public JSONObject checkExpressions(String moduleStoreId, String connSpec) {
        return null;
    }

    @Override
    public Module getBusinessModuleMetadata(String moduleId, UseSpecType moduleType, List<String> ids, MoserMetadataContext context) {
        return this.getBusinessModuleMetadata(moduleId, moduleType, ids);
    }

    @Override
    public Module getModulesXQE(String moduleId, Map<String, Module> subModules, String[] storeId, UseSpecType type, long[] lifeTime) {
        return null;
    }

    @Override
    public String getStoreIdBySearchPath(String searchPath) {
        return null;
    }

    @Override
    public Response postReportSpec(String id, String spec) {
        return null;
    }

    @Override
    public Response getReportSpec(String id, String type) {
        return null;
    }

    @Override
    public Module getBusinessModule(String moduleId, UseSpecType type, List<String> ids) {
        return this.getBusinessModule(moduleId, type);
    }
}

