/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ModuleUseSpecUpdater {
    private static final Pattern BASE_MODULE_TYPE = Pattern.compile("(.*/)baseModule(\\[@name=.*)");
    private static final Pattern DATA_SOURCE_SCHEMA_NULL_NAME = Pattern.compile("(.*/dataSourceSchema\\[@name='.*)/null('].*)");
    private final RequestEnvironment requestEnv;
    private final Module.UseSpec useSpec;
    private static final String[] FIELDS = new String[]{"id", "searchPath", "ancestors"};

    public ModuleUseSpecUpdater(RequestEnvironment requestEnv, Module.UseSpec useSpec) {
        this.requestEnv = requestEnv;
        this.useSpec = useSpec;
    }

    public boolean update() {
        JSONObject value = this.getReferencedObject();
        if (value == null) {
            return false;
        }
        String storeId = (String)value.get((Object)"id");
        String previousStoreId = this.useSpec.getStoreID();
        this.useSpec.setStoreID(storeId);
        this.useSpec.setSearchPath((String)value.get((Object)"searchPath"));
        ModuleUseSpecUpdater.setAncestors(this.useSpec, (JSONArray)value.get((Object)"ancestors"));
        return !storeId.equals(previousStoreId);
    }

    protected JSONObject getReferencedObject() {
        String searchPath = this.useSpec.getSearchPath();
        if (StringUtils.isEmpty((CharSequence)searchPath)) {
            return null;
        }
        ContentService contentService = this.requestEnv.getContentService();
        RESTClientResponse resp = contentService.getBySearchPath(searchPath, FIELDS);
        JSONObject value = ContentService.extractData(resp);
        if (value != null) {
            return value;
        }
        if (BASE_MODULE_TYPE.matcher(searchPath).matches() && (value = ContentService.extractData(resp = contentService.getBySearchPath(searchPath = BASE_MODULE_TYPE.matcher(searchPath).replaceAll("$1dataSourceSchema$2"), FIELDS))) != null) {
            return value;
        }
        if (DATA_SOURCE_SCHEMA_NULL_NAME.matcher(searchPath).matches() && (value = ContentService.extractData(resp = contentService.getBySearchPath(searchPath = DATA_SOURCE_SCHEMA_NULL_NAME.matcher(searchPath).replaceAll("$1$2"), FIELDS))) != null) {
            return value;
        }
        return null;
    }

    public static void setAncestors(Module.UseSpec useSpec, JSONArray newAncestors) {
        if (newAncestors == null) {
            return;
        }
        List ancestors = useSpec.getAncestors();
        ancestors.clear();
        ancestors.addAll(MoserCommonUtils.createAncestors((JSONArray)newAncestors, null, null));
    }
}

