/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module;

import com.ibm.bi.platform.moser.core.rest.service.DependencyService;
import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.rest.service.VersionService;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class Moser304Handler {
    protected static final String CM_DEPENDENCIES = "cmDependencies";
    private static final String CM_MISSING_DEPENDENCIES = "cmMissingDependencies";
    private static final String SESSION_DEPENDENCIES = "sessionDependencies";
    private DependencyService ds;
    private VersionService vs;
    private ModuleStorageCM mStorageCM;
    protected Map<String, Long> cmDependencyMap = new HashMap<String, Long>();
    private Map<String, String> sessionDependencyMap = new HashMap<String, String>();
    private Set<String> cmMissingDependencySet = new HashSet<String>();
    private boolean isResourceModified = false;
    protected String mGeneratedEtag;
    private long lastModified = 0L;

    public Moser304Handler(DependencyService dsIn, VersionService vsIn, ModuleStorageCM mSCM) {
        this.ds = dsIn;
        this.vs = vsIn;
        this.mStorageCM = mSCM;
    }

    private String getTimestampFromTempSession(String id) {
        JSONObject sessionObj = this.mStorageCM.getObjectFromUPS(id);
        return sessionObj == null ? null : (String)sessionObj.get((Object)"timestamp");
    }

    public boolean modulesOrDependenciesModified(String id) {
        this.isResourceModified = true;
        if (id == null) {
            LoggerAdapter.trace(this, "Not returning 304. Reason: No ETAG");
            return true;
        }
        JSONObject allDependencies = this.ds.getDependencies(id);
        if (allDependencies == null) {
            LoggerAdapter.trace(this, "Not returning 304. Reason: Dependencies not found in temp service");
            return true;
        }
        JSONObject cmDependencies = (JSONObject)allDependencies.get((Object)CM_DEPENDENCIES);
        ArrayList<String> ids = Moser304Handler.getKeys(cmDependencies.keySet());
        JSONObject cmVersions = this.vs.getVersions(ids);
        if (cmVersions == null) {
            LoggerAdapter.trace(this, "Not returning 304. Reason: Versions not found in CM");
            return true;
        }
        for (String string : Moser304Handler.getKeys(cmDependencies.keySet())) {
            if (Moser304Handler.same(cmDependencies.get((Object)string), cmVersions.get((Object)string))) continue;
            LoggerAdapter.trace(this, "Not returning 304. Reason: version for id " + string + " is different");
            this.ds.deleteDependency(id);
            return true;
        }
        JSONObject sessionDependencies = (JSONObject)allDependencies.get((Object)SESSION_DEPENDENCIES);
        for (String key : Moser304Handler.getKeys(sessionDependencies.keySet())) {
            if (Moser304Handler.same(sessionDependencies.get((Object)key), this.getTimestampFromTempSession(key))) continue;
            LoggerAdapter.trace(this, "Not returning 304. Reason: timestamp for " + key + " is different");
            this.ds.deleteDependency(id);
            return true;
        }
        JSONArray jSONArray = (JSONArray)allDependencies.get((Object)CM_MISSING_DEPENDENCIES);
        for (Object searchPath : jSONArray) {
            if (this.mStorageCM.getObjectSearchPath((String)searchPath, Arrays.asList("version")) == null) continue;
            LoggerAdapter.trace(this, "Not returning 304. Reason: previously missing object " + searchPath + " is now found");
            this.ds.deleteDependency(id);
            return true;
        }
        LoggerAdapter.trace(this, "Moser Returning 304 for etag " + id);
        this.isResourceModified = false;
        return this.isResourceModified;
    }

    private static boolean same(Object first, Object second) {
        return first != null && second != null && first.equals(second);
    }

    public void addDependency(String id, int version, long lm) {
        Long v = version;
        this.cmDependencyMap.put(id, v);
        this.vs.updateCache(id, v);
        this.updateLastModified(lm);
    }

    public void addDependency(JSONObject cmObject) {
        String id = (String)cmObject.get((Object)"id");
        Long version = (Long)cmObject.get((Object)"version");
        this.cmDependencyMap.put(id, version);
        this.vs.updateCache(id, version);
        this.updateLastModified((String)cmObject.get((Object)"modificationTime"));
    }

    public void addSessionDependency(String id, String timestamp) {
        this.sessionDependencyMap.put(id, timestamp);
    }

    public void addMissingDependency(String searchPath) {
        this.cmMissingDependencySet.add(searchPath);
    }

    public String postDependencies() {
        if (this.cmDependencyMap.isEmpty() && this.sessionDependencyMap.isEmpty() && this.cmMissingDependencySet.isEmpty()) {
            return null;
        }
        JSONObject dependencies = new JSONObject();
        JSONObject cmDependencies = new JSONObject();
        cmDependencies.putAll(this.cmDependencyMap);
        JSONObject sessionDependencies = new JSONObject();
        sessionDependencies.putAll(this.sessionDependencyMap);
        JSONArray cmMissingDependencies = new JSONArray();
        cmMissingDependencies.addAll(this.cmMissingDependencySet);
        dependencies.put((Object)CM_DEPENDENCIES, (Object)cmDependencies);
        dependencies.put((Object)SESSION_DEPENDENCIES, (Object)sessionDependencies);
        dependencies.put((Object)CM_MISSING_DEPENDENCIES, (Object)cmMissingDependencies);
        this.mGeneratedEtag = this.ds.postDependency(dependencies);
        return this.mGeneratedEtag;
    }

    public boolean isResourceModified() {
        return this.isResourceModified;
    }

    public String getGeneratedEtag() {
        return this.mGeneratedEtag;
    }

    public void updateLastModified(long lm) {
        if (this.lastModified < lm) {
            this.lastModified = lm;
        }
    }

    public void updateLastModified(String lm) {
        if (lm != null) {
            this.updateLastModified(MoserUtil.getTimeInMillis(lm));
        }
    }

    public void clearLastModified() {
        this.lastModified = 0L;
    }

    public String generateLastModified() {
        return this.getHTTPDate(this.getLastModified());
    }

    public String getHTTPDate(long epochMilliSeconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(epochMilliSeconds);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(calendar.getTime());
    }

    private long getLastModified() {
        return this.lastModified;
    }

    private static ArrayList<String> getKeys(Set<?> s) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object key : s) {
            keys.add((String)key);
        }
        return keys;
    }
}

