/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.SmartsServiceException;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.tasks.TaskStep;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.schema.AnalysisStateType;
import java.util.ArrayList;
import java.util.Locale;

public class SmartsStatusUpdater {
    private static final String TASKNAME = "Smarts Analysis Collection";
    private static final String FAIL = "fail";
    private static final String WARNING = "warning";

    private SmartsStatusUpdater() {
    }

    public static String update(TaskStatus status, JSONObject progressResponse, Locale productLocale) {
        if (status == null) {
            return null;
        }
        if (progressResponse == null) {
            status.setState("ERROR");
            return status.getState();
        }
        if (progressResponse.isEmpty()) {
            status.setState("PENDING");
            return status.getState();
        }
        try {
            int numTables = Integer.parseInt(progressResponse.get((Object)"total").toString());
            TaskStep taskStep = new TaskStep(TASKNAME, numTables);
            int numOverallCompleted = Integer.parseInt(progressResponse.get((Object)"processed").toString());
            taskStep.setNumCompleted(numOverallCompleted);
            if (status.getTaskStep() != null && status.getTaskStep().getCurrentSubTask() != null) {
                status.getTaskStep().setCurrentSubtask(taskStep);
            } else {
                status.setTaskStep(taskStep);
            }
            AnalysisStateType state = AnalysisStateType.valueOf((String)progressResponse.get((Object)"status").toString());
            switch (state) {
                case CANCELED: {
                    status.setState("CANCELLED");
                    break;
                }
                case PARTIAL: 
                case DONE: {
                    status.setState("EXECUTING");
                    taskStep.setConcurrentTasks(SmartsStatusUpdater.updateErrorsAndWarnings(numTables, (JSONArray)progressResponse.get((Object)"message")));
                    return "SUCCESS";
                }
                case IN_PROGRESS: {
                    status.setState("EXECUTING");
                    break;
                }
                case FAILED: {
                    taskStep.setConcurrentTasks(SmartsStatusUpdater.updateErrorsAndWarnings(numTables, (JSONArray)progressResponse.get((Object)"message")));
                    SmartsServiceException error = new SmartsServiceException(MoserError.MSR_SMT_INTERNAL_SMARTS, 424, progressResponse);
                    status.setState("ERROR");
                    status.setResponse(error.getResponse(productLocale));
                    status.setErrorMessage(error.getLocalizedMessage(productLocale));
                    if (!LoggerAdapter.isDebugEnabled(SmartsStatusUpdater.class)) break;
                    LoggerAdapter.debug(SmartsStatusUpdater.class, error.getLocalizedMessage());
                    LoggerAdapter.debug(SmartsStatusUpdater.class, progressResponse.toString());
                    break;
                }
            }
        }
        catch (IllegalArgumentException | NullPointerException e) {
            SmartsStatusUpdater.throwSmartsServiceException(status, progressResponse, productLocale, e);
        }
        return status.getState();
    }

    private static void throwSmartsServiceException(TaskStatus status, JSONObject progressResponse, Locale productLocale, Exception e) {
        SmartsServiceException error = new SmartsServiceException(MoserError.MSR_SMT_INTERNAL_SMARTS_CORRUPT_RESPONSE, 500, progressResponse, e);
        status.setState("ERROR");
        status.setResponse(error.getResponse(productLocale));
        status.setErrorMessage(error.getLocalizedMessage(productLocale));
        LoggerAdapter.error(SmartsStatusUpdater.class, error.getLocalizedMessage());
        LoggerAdapter.error(SmartsStatusUpdater.class, progressResponse.toString());
    }

    private static ArrayList<TaskStep> updateErrorsAndWarnings(int numTables, JSONArray messages) {
        JSONObject infoMessage = new JSONObject();
        JSONArray failTables = new JSONArray();
        JSONArray warningTables = new JSONArray();
        infoMessage.put((Object)FAIL, (Object)failTables);
        infoMessage.put((Object)WARNING, (Object)warningTables);
        TaskStep concurrentTaskStep = new TaskStep("Processing tables", numTables);
        if (messages != null) {
            for (Object object : messages) {
                JSONArray warnings;
                JSONArray errors;
                JSONObject message = (JSONObject)object;
                String tableName = message.get((Object)"table").toString();
                JSONArray jSONArray = errors = message.containsKey((Object)"errors") ? (JSONArray)message.get((Object)"errors") : new JSONArray();
                if (!errors.isEmpty()) {
                    JSONObject errorForTable = new JSONObject();
                    failTables.add((Object)errorForTable);
                    errorForTable.put((Object)"name", (Object)tableName);
                    errorForTable.put((Object)"details", (Object)errors);
                }
                if ((warnings = message.containsKey((Object)"warnings") ? (JSONArray)message.get((Object)"warnings") : new JSONArray()).isEmpty()) continue;
                JSONObject warningForTable = new JSONObject();
                warningTables.add((Object)warningForTable);
                warningForTable.put((Object)"name", (Object)tableName);
                warningForTable.put((Object)"details", (Object)warnings);
            }
        }
        concurrentTaskStep.setStepInfo(infoMessage.toString());
        ArrayList<TaskStep> tasks = new ArrayList<TaskStep>();
        tasks.add(concurrentTaskStep);
        return tasks;
    }

    public static void setComplete(TaskStatus status) {
        if (status == null) {
            return;
        }
        status.setState("SUCCESS");
    }

    private static class SmartsAPIConstants {
        protected static final String TOTAL = "total";
        protected static final String PROCESSED = "processed";
        protected static final String MESSAGE = "message";
        protected static final String STATUS = "status";
        protected static final String TABLE = "table";
        protected static final String ERRORS = "errors";
        protected static final String WARNINGS = "warnings";

        private SmartsAPIConstants() {
        }
    }
}

