/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module;

import com.ibm.bi.platform.moser.core.cm.SearchService;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;

public class UserInfo {
    private final String user;
    private final RequestEnvironment runtime;

    public UserInfo(RequestEnvironment runtime, String uniqueUserId) {
        this.user = uniqueUserId;
        this.runtime = runtime;
    }

    public JSONObject calculateUsage(String excludeModuleId) {
        JSONObject json = new JSONObject();
        json.put((Object)"user", (Object)this.user);
        json.put((Object)"totalSizeOfFile", (Object)0L);
        json.put((Object)"totalSizeOnDisk", (Object)0L);
        this.calculateUploadedFileUsage(excludeModuleId, json);
        long maxStorageMBytes = MoserConfig.getMaxStorageMBytes();
        long maxUploadSizeMBytes = MoserConfig.getMaxUploadSizeMBytes();
        json.put((Object)"DatasetService.maxStorageMBytes", (Object)maxStorageMBytes);
        json.put((Object)"DatasetService.maxUploadSizeMBytes", (Object)maxUploadSizeMBytes);
        json.put((Object)"maxUploadSizeBytes", (Object)(maxUploadSizeMBytes * 1024L * 1024L));
        json.put((Object)"maxStorageBytes", (Object)(maxStorageMBytes * 1024L * 1024L));
        return json;
    }

    private void calculateUploadedFileUsage(String excludeModuleId, JSONObject json) {
        SearchService ss = this.runtime.getSearchService();
        ss.setFields("id", "history");
        ss.setFilter("type", "uploadedFile", "owner", this.user);
        ss.httpGet();
        JSONArray jsonArray = ss.getResults();
        long totalSizeOfFile = (Long)json.get((Object)"totalSizeOfFile");
        long totalSizeOnDisk = (Long)json.get((Object)"totalSizeOnDisk");
        if (jsonArray != null) {
            for (Object o : jsonArray) {
                JSONObject obj = (JSONObject)o;
                JSONArray history = (JSONArray)obj.get((Object)"history");
                String moduleId = (String)obj.get((Object)"id");
                if (moduleId.equals(excludeModuleId) || history == null) continue;
                for (Object h : history) {
                    try {
                        JSONObject hist = JSONObject.parse((String)((String)h));
                        if (Boolean.FALSE.equals(hist.get((Object)"countedInQuota"))) continue;
                        totalSizeOfFile += Long.parseLong((String)hist.get((Object)"sizeOfFile"));
                        totalSizeOnDisk += Long.parseLong((String)hist.get((Object)"sizeOnDisk"));
                    }
                    catch (IOException e) {
                        LoggerAdapter.errorExceptionStack(UserInfo.class, e);
                    }
                }
            }
        }
        json.put((Object)"totalSizeOfFile", (Object)totalSizeOfFile);
        json.put((Object)"totalSizeOnDisk", (Object)totalSizeOnDisk);
    }
}

