/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.builder;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.metadata.provider.report.GenerateBaseModuleFromReportOutput;
import com.ibm.bi.platform.moser.core.module.container.BaseModuleContainer;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.RESTUtils;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.SmartsService;
import com.ibm.bi.platform.moser.core.smarts.SmartsServiceUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Optional;

public class BaseModuleBuilderForDataset2 {
    private static final String BASE_MODULE = "baseModule";
    private RequestEnvironment requestEnv;

    public BaseModuleBuilderForDataset2(RequestEnvironment requestEnv) {
        this.requestEnv = requestEnv;
    }

    public boolean buildBaseModuleForDataset2(String versionId) {
        JSONArray children = this.requestEnv.getModuleStorageCM().getChildrenFromCMFilterByType(versionId, null, BASE_MODULE);
        if (children != null && !children.isEmpty()) {
            throw new MoserException(MoserError.INTERNAL_BASEMODULE_ERROR, versionId);
        }
        String key = "metadata";
        JSONArray outputs = this.requestEnv.getModuleStorageCM().getChildrenFromCMFilterByType(versionId, new String[]{key}, "output");
        if (outputs == null) {
            return false;
        }
        GenerateBaseModuleFromReportOutput builder = new GenerateBaseModuleFromReportOutput("report");
        for (Object o : outputs) {
            JSONObject mds = (JSONObject)o;
            String s = (String)mds.get((Object)key);
            if (builder.addMasterDataSet(s)) continue;
            return false;
        }
        Module baseModule = builder.getBaseModule();
        Module physicalModule = builder.getPhysicalModule();
        BaseModuleContainer baseModuleContainer = new BaseModuleContainer();
        baseModuleContainer.setBaseBusinessModule(baseModule);
        baseModuleContainer.setPhysicalModule(physicalModule);
        RESTClientResponse resp = this.requestEnv.getModuleStorageCM().createBaseModuleForDatabase(versionId, baseModuleContainer);
        if (resp == null || resp.getResponseCode() != 201) {
            throw new MoserException(MoserError.MSR_IE_BASE_MODULE_CREATE_DS, versionId);
        }
        String storeID = RESTUtils.getLocationStoreId(resp);
        if (storeID != null) {
            baseModuleContainer.setStoreId(storeID);
            int status = this.requestEnv.getModuleStorageCM().saveBaseModuleForDatabase(baseModuleContainer, true);
            if (status == 204 || status == 200) {
                JSONObject dataSet2Parent = this.requestEnv.getModuleStorageCM().getParent(versionId, "id");
                String dataSet2Id = (String)dataSet2Parent.get((Object)"id");
                SmartsServiceUtil.createSmartsModule(dataSet2Id, baseModule, UseSpecType.DATASET, Optional.of(storeID), SmartsService.AnalysisMode.DEEP, this.requestEnv, t -> {});
                status = this.requestEnv.getModuleStorageCM().saveBaseModuleForDatabase(baseModuleContainer, true);
            }
            return status == 204 || status == 200;
        }
        return false;
    }
}

