/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.container;

import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.moser.core.module.container.BaseContainer;
import com.ibm.json.java.JSONObject;
import java.io.File;
import javax.xml.datatype.XMLGregorianCalendar;

public class OutputContainer
extends BaseContainer {
    private static final String CONTAINER = "container";
    private static final String ELAPSED_TIME = "elapsedTime";
    private static final String NUM_COLUMNS = "numColumns";
    private static final String NUM_ROWS = "numRows";
    private File data;
    private String containerName;
    private String format;
    private XMLGregorianCalendar startTime;
    private XMLGregorianCalendar endTime;
    private Long numRows;
    private Long numColumns;
    private ParquetVersionEnum version;

    public Long getElsapsedTime() {
        long elapsedTime = this.endTime.toGregorianCalendar().getTimeInMillis() - this.startTime.toGregorianCalendar().getTimeInMillis();
        return elapsedTime;
    }

    public File getData() {
        return this.data;
    }

    public void setData(File data) {
        this.data = data;
    }

    public String getContainer() {
        return this.containerName;
    }

    public void setContainer(String container) {
        this.containerName = container;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public XMLGregorianCalendar getStartTime() {
        return this.startTime;
    }

    public void setStartTime(XMLGregorianCalendar startTime) {
        this.startTime = startTime;
    }

    public XMLGregorianCalendar getEndTime() {
        return this.endTime;
    }

    public void setEndTime(XMLGregorianCalendar endTime) {
        this.endTime = endTime;
    }

    public Long getNumRows() {
        return this.numRows;
    }

    public void setNumRows(Long numRows) {
        this.numRows = numRows;
    }

    public Long getNumColumns() {
        return this.numColumns;
    }

    public void setNumColumns(Long numColumns) {
        this.numColumns = numColumns;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public void setVersion(ParquetVersionEnum version) {
        this.version = version;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = super.toJSON();
        result.put((Object)"type", (Object)"output");
        if (this.format != null) {
            result.put((Object)"format", (Object)this.format);
        }
        JSONObject datasetDescriptor = new JSONObject();
        datasetDescriptor.put((Object)CONTAINER, (Object)this.containerName);
        datasetDescriptor.put((Object)ELAPSED_TIME, (Object)this.getElsapsedTime());
        datasetDescriptor.put((Object)NUM_ROWS, (Object)this.numRows);
        datasetDescriptor.put((Object)NUM_COLUMNS, (Object)this.numColumns);
        datasetDescriptor.put((Object)"version", (Object)this.version.getValue());
        result.put((Object)"dataDescriptor", (Object)datasetDescriptor);
        return result;
    }
}

