/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.split;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.SplitConfig;
import com.ibm.bi.platform.moser.common.generated.metadata.SplitRule;
import com.ibm.bi.platform.moser.common.generated.metadata.SplitType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.util.TextUtils;

public class MoserColumnSplitter {
    private MoserColumnSplitter() {
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }

    private static SplitConfig getSplitConfig() {
        String splitConfig = MoserConfig.getColumnSplitConfig();
        SplitConfig config = null;
        try {
            config = (SplitConfig)MoserColumnSplitter.getObjectMapper().readValue(splitConfig, SplitConfig.class);
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(MoserColumnSplitter.class, e);
        }
        return config;
    }

    public static JSONObject getSplitComponents(Module module, String srcColumnName, IModuleObjectManager mm) {
        SplitConfig config = MoserColumnSplitter.getSplitConfig();
        JSONObject json = new JSONObject();
        if (config == null) {
            return json;
        }
        QueryItem srcColumn = (QueryItem)ModuleUtil.findQueryItemOrColumn(module, srcColumnName);
        if (srcColumn == null) {
            return json;
        }
        for (SplitRule rule : config.getSplitRules()) {
            QuerySubject lookupTable;
            Module lookupModule;
            boolean matchDataType;
            String dataType = rule.getDatatype();
            String columnNamePattern = rule.getColumnNamePattern();
            boolean matchName = TextUtils.isEmpty((CharSequence)columnNamePattern) || Pattern.matches(columnNamePattern, srcColumn.getIdentifier());
            boolean bl = matchDataType = TextUtils.isEmpty((CharSequence)dataType) || dataType.equals(srcColumn.getDatatype());
            if (!matchName || !matchDataType || (lookupModule = mm.getBusinessModuleMetadata(rule.getLookupModule(), null)) == null || (lookupTable = (QuerySubject)ModuleUtil.getTableOrQuerySubject(rule.getLookupTableId(), lookupModule)) == null) continue;
            Module.UseSpec useSpec = MoserColumnSplitter.fillUseSpec(mm, module, rule.getLookupModule(), json);
            MoserColumnSplitter.fillSplitDefinition(useSpec, lookupTable, srcColumnName, rule, json);
        }
        return json;
    }

    private static Module.UseSpec fillUseSpec(IModuleObjectManager mm, Module module, String lookupModuleId, JSONObject json) {
        MoserInfo info;
        String storeId = MoserUtil.isStoreId(lookupModuleId) ? lookupModuleId : ((info = mm.getModuleInfo(lookupModuleId, null)) == null ? lookupModuleId : info.getId());
        Module.UseSpec useSpec = null;
        HashSet<String> usedUseSpecIds = new HashSet<String>();
        for (Module.UseSpec moduleUseSpec : module.getUseSpec()) {
            if (storeId.equals(moduleUseSpec.getStoreID())) {
                useSpec = moduleUseSpec;
                break;
            }
            usedUseSpecIds.add(moduleUseSpec.getIdentifier());
        }
        if (useSpec == null) {
            int i = 1;
            String useSpecId = "M" + i;
            while (usedUseSpecIds.contains(useSpecId)) {
                useSpecId = "M" + ++i;
            }
            String[] packagename = new String[]{null};
            String searchPath = mm.getSearchPathForPackage(storeId, packagename);
            useSpec = new Module.UseSpec();
            useSpec.setIdentifier(useSpecId);
            useSpec.setType(UseSpecType.MODULE);
            useSpec.setStoreID(storeId);
            useSpec.setSearchPath(searchPath);
            json.put((Object)"useSpec", (Object)useSpec.toJSON());
        }
        return useSpec;
    }

    private static void fillSplitDefinition(Module.UseSpec useSpec, QuerySubject lookupTable, String srcColumnName, SplitRule rule, JSONObject json) {
        SplitType splitDef = new SplitType();
        String lookupTableRef = useSpec.getIdentifier() + "." + rule.getLookupTableId();
        splitDef.setRef(lookupTableRef);
        List splitDefQIList = splitDef.getItem();
        for (ItemType item : lookupTable.getItem()) {
            String qiId;
            QueryItem qi = item.getQueryItem();
            if (qi == null || (qiId = qi.getIdentifier()).equals(rule.getLookupColumnId())) continue;
            QueryItem newQI = new QueryItem();
            newQI.setRef(lookupTableRef + "." + qi.getIdentifier());
            newQI.setInstanceType(InstanceType.REFERENCE);
            newQI.setIdentifier(qi.getIdentifier());
            newQI.setLabel(qi.getLabel());
            ItemType newItem = new ItemType();
            newItem.setQueryItem(newQI);
            splitDefQIList.add(newItem);
        }
        String getJoinRelationship = rule.getJoinRelationship();
        String lookupColumnRef = lookupTableRef + "." + rule.getLookupColumnId();
        String relRef = TextUtils.isEmpty((CharSequence)getJoinRelationship) ? srcColumnName + " = " + lookupColumnRef : MessageFormat.format(getJoinRelationship, srcColumnName, lookupColumnRef);
        splitDef.setRelationshipRef(relRef);
        json.put((Object)"splitDefinition", (Object)splitDef.toJSON());
    }
}

