/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.taxonomy;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.TaxonomyType;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class TaxonomyUtil {
    private static final Map<String, TaxonomyType> AF_TAXONOMY_MAP = new HashMap<String, TaxonomyType>();
    private static final Map<String, TaxonomyType> CF_TAXONOMY_MAP = new HashMap<String, TaxonomyType>();
    public static final String C_DOMAIN = "cognos";
    public static final String CC_TIME = "cTime";
    public static final String CC_GEOLOCATION = "cGeoLocation";
    public static final String CC_NONE = "cNone";
    public static final String CF_NONE = "cNone";
    public static final String CF_DATE = "cDate";
    public static final String CF_YEAR = "cYear";
    public static final String CF_QUARTER = "cQuarter";
    public static final String CF_SEASON = "cSeason";
    public static final String CF_MONTH = "cMonth";
    public static final String CF_WEEK = "cWeek";
    public static final String CF_DAY = "cDay";
    public static final String CF_HOUR = "cHour";
    public static final String CF_MINUTE = "cMinute";
    public static final String CF_SECOND = "cSecond";
    public static final String CF_CONTINENT = "cContinent";
    public static final String CF_SUBCONTINENT = "cSubContinent";
    public static final String CF_COUNTRY = "cCountry";
    public static final String CF_REGION = "cRegion";
    public static final String CF_STATEPROVINCE = "cStateProvince";
    public static final String CF_COUNTY = "cCounty";
    public static final String CF_CITY = "cCity";
    public static final String CF_POSTALCODE = "cPostalCode";
    public static final String CF_STREETADDRESS = "cStreetAddress";
    public static final String CF_POSITION = "cPosition";
    public static final String CF_LATITUDE = "cLatitude";
    public static final String CF_LONGITUDE = "cLongitude";
    public static final String AF_NONE = "None";
    public static final String AF_DATE = "Date";
    public static final String AF_DATEOFBIRTH = "DateOfBirth";
    public static final String AF_YEAR = "Year";
    public static final String AF_QUARTER = "Quarter";
    public static final String AF_YEARQUARTER = "YearQuarter";
    public static final String AF_SEASON = "Season";
    public static final String AF_MONTH = "Month";
    public static final String AF_YEARMONTH = "YearMonth";
    public static final String AF_WEEK = "Week";
    public static final String AF_DAYOFWEEK = "DayOfWeek";
    public static final String AF_DAYOFMONTH = "DayOfMonth";
    public static final String AF_DAYOFYEAR = "DayOfYear";
    public static final String AF_HOUR = "Hour";
    public static final String AF_MINUTE = "Minute";
    public static final String AF_SECOND = "Second";
    public static final String AF_CONTINENT = "Continent";
    public static final String AF_SUBCONTINENT = "SubContinent";
    public static final String AF_COUNTRY = "Country";
    public static final String AF_COUNTRYREGION = "CountryRegion";
    public static final String AF_STATEPROVINCE = "StateProvince";
    public static final String AF_COUNTY = "County";
    public static final String AF_CITY = "City";
    public static final String AF_POSTALCODE = "PostalCode";
    public static final String AF_STREETADDRESS = "StreetAddress";
    public static final String AF_COORDINATE = "Coordinate";
    public static final String AF_LONGITUDE = "Longitude";
    public static final String AF_LATITUDE = "Latitude";
    private static final String LABEL = "label";
    private static final String CLAZZ = "class";
    private static final String FAMILY = "family";
    private static final String IDENTIFIER = "identifier";
    private static final String DOMAIN = "domain";
    public static final String TAXONOMY = "taxonomy";
    private static final String DATA = "data";
    private static final String MSG = "msg";
    private static final String TEXT = "text";
    private static final String TYPE = "type";
    private static final Map<String, Map<String, List<String>>> STRUCTURE = new HashMap<String, Map<String, List<String>>>();

    private TaxonomyUtil() {
    }

    private static TaxonomyType initTaxonomyType(TaxonomyType taxonomyType, String domain, String clazz, String family) {
        List<String> families;
        taxonomyType.setDomain(domain);
        taxonomyType.setClazz(clazz);
        taxonomyType.setFamily(family);
        CF_TAXONOMY_MAP.put(family, taxonomyType);
        Map<String, List<String>> clazzes = STRUCTURE.get(domain);
        if (clazzes == null) {
            clazzes = new HashMap<String, List<String>>();
            STRUCTURE.put(domain, clazzes);
        }
        if ((families = clazzes.get(clazz)) == null) {
            families = new ArrayList<String>();
            clazzes.put(clazz, families);
        }
        families.add(family);
        return taxonomyType;
    }

    public static TaxonomyType getTaxonomy(String concept) {
        return CF_TAXONOMY_MAP.get(concept);
    }

    public static void overwriteLogicalModuleQueryItemsTaxonomy(QueryItem queryItem, QueryItem overwriteQueryItem) {
        if (!overwriteQueryItem.getTaxonomy().isEmpty()) {
            HashMap<String, TaxonomyType> overwrittenTaxonomyDictionary = new HashMap<String, TaxonomyType>();
            for (TaxonomyType tx : overwriteQueryItem.getTaxonomy()) {
                overwrittenTaxonomyDictionary.put(tx.getDomain(), tx);
                queryItem.getPropertyOverride().add("taxonomy." + tx.getDomain());
            }
            for (int i = 0; i < queryItem.getTaxonomy().size(); ++i) {
                TaxonomyType originalTaxonomy = (TaxonomyType)queryItem.getTaxonomy().get(i);
                TaxonomyType overwrittenTaxonomy = (TaxonomyType)overwrittenTaxonomyDictionary.remove(originalTaxonomy.getDomain());
                if (overwrittenTaxonomy == null) continue;
                queryItem.getTaxonomy().set(i, overwrittenTaxonomy);
            }
            queryItem.getTaxonomy().addAll(overwrittenTaxonomyDictionary.values());
        }
    }

    public static boolean validateValues(TaxonomyType taxonomyType) {
        TaxonomyType tx;
        if (taxonomyType != null && C_DOMAIN.equals(taxonomyType.getDomain()) && !StringUtils.isBlank((CharSequence)taxonomyType.getClazz()) && !StringUtils.isBlank((CharSequence)taxonomyType.getFamily()) && (tx = CF_TAXONOMY_MAP.get(taxonomyType.getFamily())) != null) {
            return tx.getClazz().equals(taxonomyType.getClazz());
        }
        return false;
    }

    public static JSONObject createTaxonomy(Locale productLocale) {
        JSONObject base = new JSONObject();
        JSONObject taxonomy = new JSONObject();
        JSONObject msg = new JSONObject();
        Map<String, String> translation = TaxonomyUtil.getTranslation(productLocale);
        JSONArray domainArr = new JSONArray();
        JSONObject domainObj = new JSONObject();
        for (Map.Entry<String, Map<String, List<String>>> entry : STRUCTURE.entrySet()) {
            String domainName = entry.getKey();
            JSONObject domainVal = new JSONObject();
            domainVal.put((Object)IDENTIFIER, (Object)domainName);
            domainVal.put((Object)LABEL, (Object)translation.get(domainName));
            JSONArray cArray = new JSONArray();
            for (Map.Entry<String, List<String>> clazz : entry.getValue().entrySet()) {
                JSONObject classObj = new JSONObject();
                JSONArray families = new JSONArray();
                String clazzName = clazz.getKey();
                classObj.put((Object)IDENTIFIER, (Object)clazzName);
                classObj.put((Object)LABEL, (Object)translation.get(clazzName));
                for (String family : clazz.getValue()) {
                    JSONObject familyObj = new JSONObject();
                    familyObj.put((Object)IDENTIFIER, (Object)family);
                    familyObj.put((Object)LABEL, (Object)translation.get(family));
                    families.add((Object)familyObj);
                }
                classObj.put((Object)FAMILY, (Object)families);
                cArray.add((Object)classObj);
            }
            domainVal.put((Object)CLAZZ, (Object)cArray);
            domainArr.add((Object)domainVal);
        }
        domainObj.put((Object)DOMAIN, (Object)domainArr);
        taxonomy.put((Object)TAXONOMY, (Object)domainObj);
        base.put((Object)DATA, (Object)taxonomy);
        msg.put((Object)TYPE, (Object)"info");
        msg.put((Object)TEXT, (Object)("This request response is in " + productLocale.getDisplayLanguage()));
        base.put((Object)MSG, (Object)msg);
        return base;
    }

    private static Map<String, String> getTranslation(Locale productLocale) {
        HashMap<String, String> translated = new HashMap<String, String>();
        translated.put(CF_DATE, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_DATE, (Locale)productLocale));
        translated.put(CF_YEAR, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_YEAR, (Locale)productLocale));
        translated.put(CF_QUARTER, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_QUARTER, (Locale)productLocale));
        translated.put(CF_SEASON, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_SEASON, (Locale)productLocale));
        translated.put(CF_MONTH, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_MONTH, (Locale)productLocale));
        translated.put(CF_WEEK, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_WEEK, (Locale)productLocale));
        translated.put(CF_DAY, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_DAY, (Locale)productLocale));
        translated.put(CF_HOUR, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_HOUR, (Locale)productLocale));
        translated.put(CF_MINUTE, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_MINUTE, (Locale)productLocale));
        translated.put(CF_SECOND, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_SECOND, (Locale)productLocale));
        translated.put(CF_CONTINENT, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_CONTINENT, (Locale)productLocale));
        translated.put(CF_SUBCONTINENT, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_SUBCONTINENT, (Locale)productLocale));
        translated.put(CF_COUNTRY, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_COUNTRY, (Locale)productLocale));
        translated.put(CF_REGION, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_REGION, (Locale)productLocale));
        translated.put(CF_STATEPROVINCE, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_STATEPROVINCE, (Locale)productLocale));
        translated.put(CF_COUNTY, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_COUNTY, (Locale)productLocale));
        translated.put(CF_CITY, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_CITY, (Locale)productLocale));
        translated.put(CF_POSTALCODE, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_POSTALCODE, (Locale)productLocale));
        translated.put(CF_STREETADDRESS, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_STREETADDRESS, (Locale)productLocale));
        translated.put(CF_POSITION, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_POSITION, (Locale)productLocale));
        translated.put(CF_LATITUDE, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_LATITUDE, (Locale)productLocale));
        translated.put(CF_LONGITUDE, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_LONGITUDE, (Locale)productLocale));
        translated.put(CC_TIME, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_TIME, (Locale)productLocale));
        translated.put(CC_GEOLOCATION, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_GEOLOCATION, (Locale)productLocale));
        translated.put(C_DOMAIN, MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_DOMAIN, (Locale)productLocale));
        translated.put("cNone", MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_LBL_NONE, (Locale)productLocale));
        return translated;
    }

    public static TaxonomyType getAFTaxonomy(String concept) {
        return AF_TAXONOMY_MAP.get(concept);
    }

    static {
        ObjectFactory factory = new ObjectFactory();
        AF_TAXONOMY_MAP.put(AF_NONE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, "cNone", "cNone"));
        AF_TAXONOMY_MAP.put(AF_DATE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_DATE));
        AF_TAXONOMY_MAP.put(AF_DATEOFBIRTH, AF_TAXONOMY_MAP.get(AF_DATE));
        AF_TAXONOMY_MAP.put(AF_YEAR, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_YEAR));
        AF_TAXONOMY_MAP.put(AF_QUARTER, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_QUARTER));
        AF_TAXONOMY_MAP.put(AF_YEARQUARTER, AF_TAXONOMY_MAP.get(AF_QUARTER));
        AF_TAXONOMY_MAP.put(AF_SEASON, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_SEASON));
        AF_TAXONOMY_MAP.put(AF_MONTH, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_MONTH));
        AF_TAXONOMY_MAP.put(AF_YEARMONTH, AF_TAXONOMY_MAP.get(AF_MONTH));
        AF_TAXONOMY_MAP.put(AF_WEEK, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_WEEK));
        AF_TAXONOMY_MAP.put(AF_DAYOFWEEK, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_DAY));
        AF_TAXONOMY_MAP.put(AF_DAYOFMONTH, AF_TAXONOMY_MAP.get(AF_DAYOFWEEK));
        AF_TAXONOMY_MAP.put(AF_DAYOFYEAR, AF_TAXONOMY_MAP.get(AF_DAYOFWEEK));
        AF_TAXONOMY_MAP.put(AF_HOUR, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_HOUR));
        AF_TAXONOMY_MAP.put(AF_MINUTE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_MINUTE));
        AF_TAXONOMY_MAP.put(AF_SECOND, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_TIME, CF_SECOND));
        AF_TAXONOMY_MAP.put(AF_CONTINENT, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_CONTINENT));
        AF_TAXONOMY_MAP.put(AF_SUBCONTINENT, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_SUBCONTINENT));
        AF_TAXONOMY_MAP.put(AF_COUNTRY, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_COUNTRY));
        AF_TAXONOMY_MAP.put(AF_COUNTRYREGION, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_REGION));
        AF_TAXONOMY_MAP.put(AF_STATEPROVINCE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_STATEPROVINCE));
        AF_TAXONOMY_MAP.put(AF_COUNTY, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_COUNTY));
        AF_TAXONOMY_MAP.put(AF_CITY, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_CITY));
        AF_TAXONOMY_MAP.put(AF_POSTALCODE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_POSTALCODE));
        AF_TAXONOMY_MAP.put(AF_STREETADDRESS, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_STREETADDRESS));
        AF_TAXONOMY_MAP.put(AF_COORDINATE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_POSITION));
        AF_TAXONOMY_MAP.put(AF_LATITUDE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_LATITUDE));
        AF_TAXONOMY_MAP.put(AF_LONGITUDE, TaxonomyUtil.initTaxonomyType(factory.createTaxonomyType(), C_DOMAIN, CC_GEOLOCATION, CF_LONGITUDE));
    }
}

