/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.transformation;

import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityEnum;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityType;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.ForeignKey;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.bi.platform.moser.core.importer.file.VendorFormatToV5FormatConverter;
import com.ibm.bi.platform.moser.core.module.transformation.IModuleTransformation;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;

public class PhysicalToBaseModule
implements IModuleTransformation {
    private List<String> emptyTables;
    private Map<String, QuerySubject> tableNameToQuerySubject;
    private CaseInsensitiveMap seenQS;
    private Set<String> seenRel;

    @Override
    public Module apply(Module physicalModule) {
        this.emptyTables = new ArrayList<String>();
        this.tableNameToQuerySubject = new HashMap<String, QuerySubject>();
        this.seenQS = new CaseInsensitiveMap();
        this.seenRel = new HashSet<String>();
        String container = physicalModule.getContainer();
        String use = (container == null ? "" : container + ".") + physicalModule.getIdentifier();
        String identifier = ModuleUtil.buildUniqueModuleIdentifier(use, "base");
        Module module = new Module();
        module.setVersion("11.1");
        module.setExpressionLocale(physicalModule.getExpressionLocale());
        module.setContainer(container);
        module.getUse().add(use);
        module.setIdentifier(identifier);
        String dataSourceName = null;
        String catalogName = null;
        String schemaName = null;
        for (DataSource dataSource : physicalModule.getDataSource()) {
            if (dataSourceName == null) {
                dataSourceName = dataSource.getName();
                catalogName = dataSource.getCatalog();
                schemaName = dataSource.getSchema();
            }
            for (Table table : dataSource.getTable()) {
                if (table.getTableItem().stream().noneMatch(item -> item.getColumn() != null)) {
                    this.emptyTables.add(table.getName());
                    continue;
                }
                QuerySubject qs = this.buildQuerySubject(table);
                this.tableNameToQuerySubject.put(table.getName(), qs);
                module.getQuerySubject().add(qs);
            }
            List relationships = module.getRelationship();
            for (Table table : dataSource.getTable()) {
                relationships.addAll(this.buildRelationships(table, schemaName));
            }
        }
        module.setLabel(PhysicalToBaseModule.buildLabel(dataSourceName, catalogName, schemaName, module.getIdentifier()));
        return module;
    }

    private static String buildLabel(String dataSourceName, String catalogName, String schemaName, String identifier) {
        if (dataSourceName == null && catalogName == null && schemaName == null) {
            return identifier;
        }
        if (schemaName != null) {
            return schemaName;
        }
        if (catalogName != null) {
            return catalogName;
        }
        return dataSourceName;
    }

    private QuerySubject buildQuerySubject(Table table) {
        QuerySubject qs = new QuerySubject();
        String qsId = IdentifierUtil.makeUniqueAndValidIdentifier((String)table.getName(), (CaseInsensitiveMap)this.seenQS);
        this.seenQS.put((Object)qsId, (Object)Boolean.TRUE);
        qs.setIdentifier(qsId);
        qs.setLabel(table.getOriginalName() == null ? table.getName() : table.getOriginalName());
        qs.getRef().add(table.getName());
        qs.setComment(table.getDescription());
        CaseInsensitiveMap seenQI = new CaseInsensitiveMap();
        for (TableItemType tableItemType : table.getTableItem()) {
            Column column = tableItemType.getColumn();
            QueryItem qi = new QueryItem();
            String qiId = IdentifierUtil.makeUniqueAndValidIdentifier((String)column.getName(), (CaseInsensitiveMap)seenQI);
            seenQI.put((Object)qiId, (Object)Boolean.TRUE);
            qi.setIdentifier(qiId);
            qi.setLabel(column.getOriginalName() == null ? column.getName() : column.getOriginalName());
            qi.setDescription(column.getDescription());
            qi.setComment(column.getDescription());
            qi.setDatatype(column.getDatatype());
            qi.setExpression(column.getName());
            qi.setNullable(column.isNullable());
            qi.setHidden(Boolean.TRUE.equals(column.isHidden()) ? Boolean.TRUE : null);
            try {
                String format = VendorFormatToV5FormatConverter.getV5Format(column.getVendorFormat());
                if (StringUtils.isNotEmpty((CharSequence)format)) {
                    qi.setFormat(format);
                }
            }
            catch (Exception e) {
                LoggerAdapter.error((Object)this, "Failed convert vendorFormat: " + e.getLocalizedMessage(), e);
            }
            HighLevelDataType hld = MoserCommonUtils.generateHighlevelDatatype((String)qi.getDatatype());
            qi.setUsage(MoserCommonUtils.getUsageFromHighLevelDataType((HighLevelDataType)hld));
            qi.setRegularAggregate(MoserCommonUtils.getRegularAggregateTypeFromUsageAndHighLevelDataType((UsageType)qi.getUsage(), (HighLevelDataType)hld));
            ItemType item = new ItemType();
            item.setQueryItem(qi);
            qs.getItem().add(item);
        }
        return qs;
    }

    private List<Relationship> buildRelationships(Table table, String schemaName) {
        QuerySubject querySubject = this.tableNameToQuerySubject.get(table.getName());
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (ForeignKey fk : table.getForeignKey()) {
            Relationship relationShip = null;
            for (ForeignKey.FkColumn fkColumn : fk.getFkColumn()) {
                String fkQueryItemId;
                String pkQueryItemId;
                QuerySubject pkQS;
                String pkSchema = fkColumn.getPkSchema();
                if (!ModuleUtil.isMatching(pkSchema, schemaName) || (pkQS = this.tableNameToQuerySubject.get(fkColumn.getPkTable())) == null) continue;
                String pkQuerySubjectId = pkQS.getIdentifier();
                Optional<ItemType> pkQI = pkQS.getItem().stream().filter(item -> item.getQueryItem() != null && item.getQueryItem().getExpression().equals(fkColumn.getPkColumn())).findFirst();
                String string = pkQueryItemId = pkQI.isPresent() ? pkQI.get().getQueryItem().getIdentifier() : null;
                if (pkQueryItemId == null) continue;
                CardinalityType left = new CardinalityType();
                left.setRef(pkQuerySubjectId);
                left.setMincard(CardinalityEnum.ONE);
                left.setMaxcard(CardinalityEnum.ONE);
                String fkQuerySubjectId = querySubject.getIdentifier();
                Optional<ItemType> fkQI = querySubject.getItem().stream().filter(item -> item.getQueryItem() != null && item.getQueryItem().getExpression().equals(fkColumn.getColumnName())).findFirst();
                String string2 = fkQueryItemId = fkQI.isPresent() ? fkQI.get().getQueryItem().getIdentifier() : null;
                if (fkQueryItemId == null) continue;
                CardinalityType right = new CardinalityType();
                right.setRef(fkQuerySubjectId);
                right.setMincard(CardinalityEnum.ONE);
                right.setMaxcard(CardinalityEnum.MANY);
                if (relationShip == null) {
                    String relationShipId = pkQuerySubjectId + "_" + fkQuerySubjectId;
                    relationShipId = PhysicalToBaseModule.makeUnique(relationShipId, this.seenRel);
                    relationShip = new Relationship();
                    relationShip.setIdentifier(relationShipId);
                    relationShip.setLeft(left);
                    relationShip.setRight(right);
                    String relationShipName = pkQuerySubjectId + "<-->" + fkQuerySubjectId;
                    relationShip.setDescription(relationShipName);
                    relationShip.setLabel(relationShipName);
                    relationships.add(relationShip);
                }
                Relationship.Link link = new Relationship.Link();
                link.setLeftRef(pkQueryItemId);
                link.setRightRef(fkQueryItemId);
                relationShip.getLink().add(link);
            }
        }
        return relationships;
    }

    private static String makeUnique(String id, Set<String> seen) {
        String uniqueId = id;
        int seq = 1;
        while (!seen.add(uniqueId)) {
            uniqueId = id + "_" + seq++;
        }
        return uniqueId;
    }

    public List<String> getEmptyTables() {
        return this.emptyTables;
    }
}

