/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.transformation;

import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationGroupType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.KeyCompositionType;
import com.ibm.bi.platform.moser.common.generated.metadata.KeyConstraintType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.PrimaryKey;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.SqlOperatorType;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.core.module.transformation.IModuleTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PrimaryKeyToItemNormalization
implements IModuleTransformation {
    public static final String ID_PREFIX = "grp_4_PK_";
    private static final String LABEL_PREFIX = "primary key: ";
    private Module physicalModule;

    public PrimaryKeyToItemNormalization(Module pModule) {
        this.physicalModule = pModule;
    }

    @Override
    public Module apply(Module baseModule) {
        if (this.physicalModule == null) {
            return baseModule;
        }
        List datasources = this.physicalModule.basicGetDataSource();
        if (datasources == null) {
            return baseModule;
        }
        DataSource ds = (DataSource)datasources.get(0);
        if ("PARQUET".equals(ds.getDatabaseType())) {
            return baseModule;
        }
        HashMap<String, Table> tabNameToTable = new HashMap<String, Table>();
        for (DataSource aDS : datasources) {
            List tables = aDS.basicGetTable();
            if (tables == null) continue;
            for (Table tab : tables) {
                tabNameToTable.put(tab.getName(), tab);
            }
        }
        if (tabNameToTable.isEmpty()) {
            return baseModule;
        }
        this.generateItemNormalizationFromPK(baseModule, tabNameToTable);
        return baseModule;
    }

    protected void generateItemNormalizationFromPK(Module baseModule, Map<String, Table> tabNameToTable) {
        List querySubjects = baseModule.basicGetQuerySubject();
        if (querySubjects == null) {
            return;
        }
        for (QuerySubject aQS : querySubjects) {
            List pkeys;
            Table tab;
            List ref;
            List items = aQS.basicGetItem();
            if (items == null || items.isEmpty() || (ref = aQS.getRef()) == null || ref.size() != 1 || (tab = tabNameToTable.get(ref.get(0))) == null || (pkeys = tab.basicGetPrimaryKey()) == null || pkeys.isEmpty()) continue;
            PrimaryKey pk = null;
            for (PrimaryKey k : pkeys) {
                List keyCols = k.basicGetKeyedColumn();
                if (keyCols == null || keyCols.isEmpty() || pk != null && pk.basicGetKeyedColumn().size() <= keyCols.size()) continue;
                pk = k;
            }
            if (pk == null) continue;
            ArrayList<QueryItem> keyQIs = new ArrayList<QueryItem>();
            ArrayList<QueryItem> attrQIs = new ArrayList<QueryItem>();
            this.getKeyAndAttributeQueryItems(items, pk, keyQIs, attrQIs);
            if (keyQIs.isEmpty()) continue;
            ItemNormalizationType itemNorm = this.addItemNormalizationType(aQS);
            ItemNormalizationGroupType parentGrp = this.buildParentGroups(keyQIs, itemNorm);
            QueryItem lastKeyQI = keyQIs.get(keyQIs.size() - 1);
            ItemNormalizationGroupType grp = new ItemNormalizationGroupType();
            itemNorm.getItemNormalizationGroup().add(grp);
            grp.setIdentifier(ID_PREFIX + lastKeyQI.getIdentifier());
            grp.setLabel(LABEL_PREFIX + lastKeyQI.getLabel());
            ItemNormalizationGroupType.Key k = new ItemNormalizationGroupType.Key();
            k.setItemRef(lastKeyQI.getIdentifier());
            k.setKeyConstraint(KeyConstraintType.UNIQUE);
            grp.setKey(k);
            if (parentGrp == null) {
                k.setKeyComposition(KeyCompositionType.INDEPENDENT);
            } else {
                k.setKeyComposition(KeyCompositionType.USE_PARENT);
                grp.addParentGroupRef(parentGrp.getIdentifier());
            }
            for (QueryItem attQI : attrQIs) {
                this.addAttribute(attQI, grp);
            }
        }
    }

    protected void getKeyAndAttributeQueryItems(List<ItemType> items, PrimaryKey pk, List<QueryItem> keyQIs, List<QueryItem> attrQIs) {
        HashSet keyColNames = new HashSet(pk.basicGetKeyedColumn());
        for (ItemType itm : items) {
            QueryItem qi = itm.getQueryItem();
            if (keyColNames.contains(qi.getExpression())) {
                keyQIs.add(qi);
                continue;
            }
            attrQIs.add(qi);
        }
    }

    protected ItemNormalizationGroupType buildParentGroups(List<QueryItem> keyQIs, ItemNormalizationType itemNorm) {
        ItemNormalizationGroupType parentGrp = null;
        for (int i = 0; i < keyQIs.size() - 1; ++i) {
            ItemNormalizationGroupType grp = new ItemNormalizationGroupType();
            itemNorm.getItemNormalizationGroup().add(grp);
            grp.setIdentifier(ID_PREFIX + keyQIs.get(i).getIdentifier());
            grp.setLabel(LABEL_PREFIX + keyQIs.get(i).getLabel());
            ItemNormalizationGroupType.Key k = new ItemNormalizationGroupType.Key();
            k.setItemRef(keyQIs.get(i).getIdentifier());
            k.setKeyConstraint(KeyConstraintType.REPEATING);
            k.setKeyComposition(KeyCompositionType.USE_PARENT);
            grp.setKey(k);
            if (parentGrp != null) {
                grp.addParentGroupRef(parentGrp.getIdentifier());
            }
            parentGrp = grp;
        }
        return parentGrp;
    }

    protected ItemNormalizationType addItemNormalizationType(QuerySubject aQS) {
        ItemNormalizationType itemNorm = aQS.getItemNormalization();
        if (itemNorm == null) {
            itemNorm = new ItemNormalizationType();
            aQS.setItemNormalization(itemNorm);
        } else {
            itemNorm.getItemNormalizationGroup().clear();
        }
        return itemNorm;
    }

    protected void addAttribute(QueryItem qi, ItemNormalizationGroupType grp) {
        ItemNormalizationGroupType.Attribute att = new ItemNormalizationGroupType.Attribute();
        att.setItemRef(qi.getIdentifier());
        att.setSqlOperator(SqlOperatorType.MINIMUM);
        grp.getAttribute().add(att);
    }
}

