/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.transformation;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.SelectListControlType;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.bi.platform.moser.core.module.transformation.IModuleTransformation;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import java.util.HashMap;
import java.util.Map;

public class UnsupportedTypes
implements IModuleTransformation {
    private final Module physicalModule;
    private final Map<String, Map<String, Column>> tableColumnMap;

    public UnsupportedTypes(Module physicalModule) {
        this.physicalModule = physicalModule;
        this.tableColumnMap = new HashMap<String, Map<String, Column>>();
        this.init();
    }

    private void init() {
        for (Table table : ((DataSource)this.physicalModule.getDataSource().get(0)).getTable()) {
            HashMap<String, Column> columnMap = new HashMap<String, Column>();
            this.tableColumnMap.put(table.getName(), columnMap);
            for (TableItemType tableItem : table.getTableItem()) {
                Column column = tableItem.getColumn();
                if (column == null) continue;
                columnMap.put(column.getName(), column);
            }
        }
    }

    @Override
    public Module apply(Module module) {
        for (QuerySubject qs : module.getQuerySubject()) {
            boolean bUnsupportDT = false;
            Map<String, Column> columnMap = this.tableColumnMap.get(qs.getRef().get(0));
            for (ItemType item : qs.getItem()) {
                QueryItem qi = item.getQueryItem();
                if (qi == null) continue;
                bUnsupportDT = ModuleUtil.adjustExpressionIfNotSupported((BaseQueryItemType)qi, columnMap.get(qi.getExpression())) || bUnsupportDT;
            }
            if (!bUnsupportDT) continue;
            qs.setSelectListControl(SelectListControlType.USED_QUERY_ITEMS);
        }
        return module;
    }
}

