/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.util;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.TaxonomyType;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseOverrides {
    private BaseOverrides() {
    }

    public static Module generateTaxonomyDiffs(Module moduleToSave, Module existingTaxonomy) {
        ObjectFactory objectFactory = new ObjectFactory();
        Module diffModule = objectFactory.createModule();
        diffModule.setVersion("11.1");
        diffModule.setIdentifier(moduleToSave.getIdentifier());
        HashMap<String, QuerySubject> qsMap = new HashMap<String, QuerySubject>();
        HashMap<String, Calculation> calcMap = new HashMap<String, Calculation>();
        BaseOverrides.addExistingTaxonomy(moduleToSave, objectFactory, diffModule, qsMap, calcMap);
        if (existingTaxonomy != null) {
            BaseOverrides.diffWithExistingTaxonomy(existingTaxonomy, objectFactory, diffModule, qsMap, calcMap);
        }
        return diffModule;
    }

    private static void diffWithExistingTaxonomy(Module existingTaxonomy, ObjectFactory objectFactory, Module diffModule, Map<String, QuerySubject> qsMap, Map<String, Calculation> calcMap) {
        for (QuerySubject existingTaxonomyQS : existingTaxonomy.getQuerySubject()) {
            QuerySubject diffQS = qsMap.get(existingTaxonomyQS.getIdentifier());
            if (diffQS == null) {
                diffQS = objectFactory.createQuerySubject();
                diffQS.setIdentifier(existingTaxonomyQS.getIdentifier());
                diffModule.addQuerySubject(diffQS);
            }
            for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)existingTaxonomyQS)) {
                boolean qiTaxonomyFound = false;
                for (QueryItem overrideQI : MoserObjectUtils.getQueryItems((QuerySubject)diffQS)) {
                    if (!overrideQI.getIdentifier().equals(qi.getIdentifier())) continue;
                    qiTaxonomyFound = true;
                    if (!BaseOverrides.allTaxonomySame((BaseQueryItemType)qi, (BaseQueryItemType)overrideQI)) break;
                    MoserObjectUtils.removeQueryItem((QuerySubject)diffQS, (QueryItem)overrideQI);
                    break;
                }
                if (qiTaxonomyFound) continue;
                BaseOverrides.addEmptyTaxonomy(objectFactory, diffQS, qi);
            }
            if (!MoserObjectUtils.getQueryItems((QuerySubject)diffQS).isEmpty()) continue;
            diffModule.getQuerySubject().remove(diffQS);
        }
        for (Calculation existingTaxonomyCalc : existingTaxonomy.getCalculation()) {
            Calculation diffCalc = calcMap.get(existingTaxonomyCalc.getIdentifier());
            if (diffCalc == null) {
                diffCalc = objectFactory.createCalculation();
                BaseOverrides.addEmptyTaxonomy(objectFactory, (BaseQueryItemType)existingTaxonomyCalc, (BaseQueryItemType)diffCalc);
                diffModule.addCalculation(diffCalc);
                continue;
            }
            if (!BaseOverrides.allTaxonomySame((BaseQueryItemType)existingTaxonomyCalc, (BaseQueryItemType)diffCalc)) continue;
            diffModule.removeCalculation(diffCalc);
        }
    }

    private static void addExistingTaxonomy(Module moduleToSave, ObjectFactory objectFactory, Module diffModule, Map<String, QuerySubject> qsMap, Map<String, Calculation> calcMap) {
        for (QuerySubject qs : moduleToSave.getQuerySubject()) {
            QuerySubject newQS = null;
            for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
                if (qi.basicGetTaxonomy() == null || qi.basicGetTaxonomy().isEmpty()) continue;
                if (newQS == null) {
                    newQS = objectFactory.createQuerySubject();
                    newQS.setIdentifier(qs.getIdentifier());
                    diffModule.addQuerySubject(newQS);
                    qsMap.put(newQS.getIdentifier(), newQS);
                }
                QueryItem newQI = objectFactory.createQueryItem();
                ItemType item = objectFactory.createItemType();
                item.setQueryItem(newQI);
                newQI.setIdentifier(qi.getIdentifier());
                newQS.addItem(item);
                BaseOverrides.copyTaxonomy((BaseQueryItemType)qi, (BaseQueryItemType)newQI);
            }
        }
        for (Calculation calc : moduleToSave.getCalculation()) {
            if (calc.basicGetTaxonomy() == null || calc.basicGetTaxonomy().isEmpty()) continue;
            Calculation newCalc = objectFactory.createCalculation();
            newCalc.setIdentifier(calc.getIdentifier());
            BaseOverrides.copyTaxonomy((BaseQueryItemType)calc, (BaseQueryItemType)newCalc);
            calcMap.put(newCalc.getIdentifier(), newCalc);
            diffModule.addCalculation(newCalc);
        }
    }

    private static void copyTaxonomy(BaseQueryItemType qi, BaseQueryItemType newQI) {
        List qiTaxonomy = qi.basicGetTaxonomy();
        if (qiTaxonomy == null) {
            return;
        }
        for (TaxonomyType taxonomy : qiTaxonomy) {
            try {
                newQI.addTaxonomy((TaxonomyType)taxonomy.clone());
            }
            catch (CloneNotSupportedException e) {
                LoggerAdapter.errorExceptionStack(BaseOverrides.class, e);
            }
        }
    }

    private static boolean allTaxonomySame(BaseQueryItemType qi, BaseQueryItemType overrideQI) {
        boolean allQITaxonomySame = true;
        if (overrideQI.getTaxonomy().size() != qi.getTaxonomy().size()) {
            allQITaxonomySame = false;
        }
        for (int i = 0; allQITaxonomySame && i < qi.getTaxonomy().size(); ++i) {
            TaxonomyType qiTaxonomy = (TaxonomyType)qi.getTaxonomy().get(i);
            TaxonomyType overrideTaxonomy = (TaxonomyType)overrideQI.getTaxonomy().get(i);
            if (qiTaxonomy.getDomain().equals(overrideTaxonomy.getDomain()) && qiTaxonomy.getFamily().equals(overrideTaxonomy.getFamily()) && qiTaxonomy.getClazz().equals(overrideTaxonomy.getClazz())) continue;
            allQITaxonomySame = false;
        }
        return allQITaxonomySame;
    }

    private static void addEmptyTaxonomy(ObjectFactory objectFactory, QuerySubject overridesQS, QueryItem qi) {
        QueryItem overrideQI = objectFactory.createQueryItem();
        BaseOverrides.addEmptyTaxonomy(objectFactory, (BaseQueryItemType)qi, (BaseQueryItemType)overrideQI);
        ItemType item = objectFactory.createItemType();
        item.setQueryItem(overrideQI);
        overridesQS.addItem(item);
    }

    private static void addEmptyTaxonomy(ObjectFactory objectFactory, BaseQueryItemType qi, BaseQueryItemType overrideQI) {
        TaxonomyType emptyTaxonomy = objectFactory.createTaxonomyType();
        emptyTaxonomy.setDomain("cognos");
        emptyTaxonomy.setClazz("cNone");
        emptyTaxonomy.setFamily("cNone");
        overrideQI.addTaxonomy(emptyTaxonomy);
        overrideQI.setIdentifier(qi.getIdentifier());
    }

    public static Module extractSecurityFilters(Module module) {
        ObjectFactory objectFactory = new ObjectFactory();
        Module moduleFilters = objectFactory.createModule();
        moduleFilters.setVersion("11.1");
        for (QuerySubject qs : module.getQuerySubject()) {
            List sf = qs.basicGetSecurityFilter();
            if (sf == null || sf.isEmpty()) continue;
            QuerySubject newQS = objectFactory.createQuerySubject();
            newQS.setIdentifier(qs.getIdentifier());
            sf.forEach(f -> newQS.addSecurityFilter(f));
            qs.basicGetSecurityFilter().clear();
            moduleFilters.addQuerySubject(newQS);
        }
        return moduleFilters;
    }

    public static Module mergeSecurityFilters(Module toModule, Module from) {
        HashMap qsMap = new HashMap();
        from.getQuerySubject().stream().filter(qs -> qs.basicGetSecurityFilter() != null && !qs.basicGetSecurityFilter().isEmpty()).forEach(qs -> qsMap.put(qs.getIdentifier(), qs.basicGetSecurityFilter()));
        toModule.getQuerySubject().stream().filter(qs -> qsMap.get(qs.getIdentifier()) != null).forEach(qs -> ((List)qsMap.get(qs.getIdentifier())).forEach(f -> qs.addSecurityFilter(f)));
        return toModule;
    }
}

