/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.util;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.CalculatedMemberType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemHierarchy;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationGroupType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.KeyConstraintType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.ParameterValueSet;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertySetter;
import com.ibm.bi.platform.moser.common.generated.metadata.PropertyType;
import com.ibm.bi.platform.moser.common.generated.metadata.QsClassifierType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.SecurityFilter;
import com.ibm.bi.platform.moser.common.generated.metadata.SplitType;
import com.ibm.bi.platform.moser.common.generated.metadata.SqlOperatorType;
import com.ibm.bi.platform.moser.common.generated.metadata.TaxonomyType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.bi.platform.moser.common.utils.ModuleNotFoundException;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.common.utils.ReferenceResolver;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.metadata.util.CommonResolverUtil;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManagerCM;
import com.ibm.bi.platform.moser.core.module.ModuleUseSpecUpdater;
import com.ibm.bi.platform.moser.core.module.transformation.PrimaryKeyToItemNormalization;
import com.ibm.bi.platform.moser.core.module.util.DataModuleExtractor;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.module.util.MoserMetadataContext;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.wkc.core.utils.WKCUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang3.StringUtils;

public class LogicalModuleResolver {
    public static final String MODULE_ALIAS_PREFIX = "M";
    public static final String EMBEDDED_MODULE_ALIAS = "ES";
    public static final String RESOLVED_BASE_MODULE_ALIAS_PREFIX = "__Base";
    public static final String WA_ASSETID = "wa_assetId";
    public static final String IMPORT_ALL = "*";
    protected static final String STR_SEMICOLON = ";";
    protected LinkedHashMap<String, ResolverModuleWrapper> seenModules = new LinkedHashMap();
    protected final MoserMetadataContext metadataContext;
    protected boolean bLoadLeafNodes = true;
    protected HashMap<String, TreeSet<String>> requiredObjects = new HashMap();
    private List<String> metadataIDs = null;
    private static final HashSet<UseSpecType> TYPES_NOT_LEAF = new HashSet();
    private static final HashSet<UseSpecType> TYPES_PKG_REPORT = new HashSet();

    protected LogicalModuleResolver(MoserMetadataContext context) {
        this.metadataContext = context;
    }

    protected LogicalModuleResolver(MoserMetadataContext context, List<String> ids) {
        this.metadataContext = context;
        this.metadataIDs = ids;
    }

    private static ResolverModuleWrapper createModuleWrapper() {
        return new ResolverModuleWrapper();
    }

    protected static boolean embeddedModuleOnly(ResolverModuleWrapper currentModule, long[] lifeTime, UseSpecType orgType) {
        boolean b;
        if (!LogicalModuleResolver.isEmbeddedModule(currentModule) || !MoserConfig.getXQEEmbeddedModuleOnly()) {
            if (lifeTime != null && !ModuleObjectManagerCM.isSession(currentModule.storeId) && orgType == UseSpecType.MODULE) {
                lifeTime[0] = MoserConfig.getXQEModuleLifetime();
            }
            return false;
        }
        List<Module.UseSpec> useSpecs = currentModule.getUseSpec();
        if (useSpecs.size() != 1) {
            return false;
        }
        UseSpecType tp = useSpecs.get(0).getType();
        boolean bl = b = tp == UseSpecType.DATABASE || tp == UseSpecType.FILE || tp == UseSpecType.MODULE || tp == UseSpecType.DATASET;
        if (b) {
            PropertyType prop = new PropertyType();
            prop.setName("_XQE_embedded_Module");
            prop.setValue("true");
            currentModule.getModule().addProperty(prop);
        }
        return b;
    }

    public static Module resolveLogicalModuleXQE(IModuleObjectManager mm, String storeId, Module module, Map<String, Module> subModules, long[] lifeTime, UseSpecType orgType) {
        if (module == null) {
            return null;
        }
        ResolverModuleWrapper moduleWrapper = LogicalModuleResolver.createModuleWrapper();
        moduleWrapper.topModule = true;
        moduleWrapper.type = UseSpecType.MODULE;
        moduleWrapper.storeId = storeId;
        moduleWrapper.theModule = module;
        if (LogicalModuleResolver.embeddedModuleOnly(moduleWrapper, lifeTime, orgType)) {
            return module;
        }
        LogicalModuleResolver resolver = new LogicalModuleResolver(MoserMetadataContext.XQEWHOLE);
        resolver.seenModules.put(storeId, moduleWrapper);
        List<String> dependencyStack = resolver.getDependencyStack(mm, storeId);
        ResolverModuleWrapper rt = resolver.resolveLogicalModule(mm, dependencyStack);
        boolean b = resolver.distributeReferencedObjects(rt, null);
        if (!b) {
            resolver.returnAllSubModules(mm, subModules);
        } else {
            resolver.returnRequiredModules(mm, subModules);
        }
        Set<String> subModuleIds = subModules.keySet();
        LogicalModuleResolver.cleanUseSpec(module, subModuleIds);
        for (Module sub : subModules.values()) {
            LogicalModuleResolver.cleanUseSpec(sub, subModuleIds);
        }
        return rt.theModule;
    }

    public static Module resolveLogicalModule(IModuleObjectManager mm, Module sourceModule) {
        return LogicalModuleResolver.resolveLogicalModule(mm, sourceModule, null, MoserMetadataContext.METADATA);
    }

    public static Module resolveLogicalModule(IModuleObjectManager mm, Module sourceModule, List<String> ids, MoserMetadataContext context) {
        if (sourceModule == null) {
            return null;
        }
        Module module = ModuleUtil.cloneModule(sourceModule);
        LogicalModuleResolver resolver = new LogicalModuleResolver(context, ids);
        String id = module.getIdentifier();
        ResolverModuleWrapper moduleWrapper = LogicalModuleResolver.createModuleWrapper();
        moduleWrapper.topModule = true;
        moduleWrapper.type = UseSpecType.MODULE;
        moduleWrapper.storeId = id;
        moduleWrapper.theModule = module;
        resolver.seenModules.put(id, moduleWrapper);
        List<String> dependencyStack = resolver.getDependencyStack(mm, id);
        ResolverModuleWrapper rt = resolver.resolveLogicalModule(mm, dependencyStack);
        return rt.theModule;
    }

    public static List<String> getDependencyStack(IModuleObjectManager mm, Module module) {
        LogicalModuleResolver resolver = new LogicalModuleResolver(MoserMetadataContext.METADATA);
        String id = module.getIdentifier();
        ResolverModuleWrapper moduleWrapper = LogicalModuleResolver.createModuleWrapper();
        moduleWrapper.topModule = true;
        moduleWrapper.type = UseSpecType.MODULE;
        moduleWrapper.storeId = id;
        moduleWrapper.theModule = module;
        resolver.seenModules.put(id, moduleWrapper);
        return resolver.getDependencyStack(mm, id);
    }

    private List<String> getDependencyStack(IModuleObjectManager mm, String moduleId) {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        ArrayList<String> dependencyStack = new ArrayList<String>();
        boolean traceEnabled = LoggerAdapter.isDebugEnabled(LogicalModuleResolver.class);
        if (traceEnabled) {
            LoggerAdapter.trace(LogicalModuleResolver.class, "Start building dependency stack.\n");
        }
        this.buildDependencyStack(mm, stack, dependencyStack, moduleId);
        if (traceEnabled) {
            LoggerAdapter.trace(LogicalModuleResolver.class, "Finish building dependency stack.\n");
            LoggerAdapter.trace(LogicalModuleResolver.class, this.dumpDependencyStack(dependencyStack, null).toString());
        }
        return dependencyStack;
    }

    private static void getBusinessModule(IModuleObjectManager mm, ResolverModuleWrapper wrapper, Module.UseSpec useSpec) {
        UseSpecType type;
        String storeId = useSpec.getStoreID();
        Module module = mm.getBusinessModule(storeId, type = useSpec.getType(), null);
        if (module == null) {
            return;
        }
        LogicalModuleResolver.populateWrapper(wrapper, module, type, storeId, useSpec.getSearchPath());
    }

    private Map<String, QuerySubject> getPKQuerySubjectsFromSubModule(Module dataModule) {
        HashMap<String, QuerySubject> rt = new HashMap<String, QuerySubject>();
        for (Module.UseSpec use : dataModule.getUseSpec()) {
            List subQSs;
            ResolverModuleWrapper referencedModule;
            UseSpecType tp = use.getType();
            if (tp != UseSpecType.DATABASE && tp != UseSpecType.MODULE || (referencedModule = this.getModuleWrapper(use.getStoreID())) == null || referencedModule.theModule == null || (subQSs = referencedModule.theModule.basicGetQuerySubject()) == null || subQSs.isEmpty()) continue;
            String moduleAlias = use.getIdentifier();
            for (QuerySubject subQ : subQSs) {
                List subGrp;
                ItemNormalizationType subItemNorm = subQ.getItemNormalization();
                if (subItemNorm == null || (subGrp = subItemNorm.basicGetItemNormalizationGroup()) == null || subGrp.isEmpty()) continue;
                int lastGrpIdx = subGrp.size() - 1;
                boolean bFromPK = true;
                for (int i = 0; i <= lastGrpIdx; ++i) {
                    ItemNormalizationGroupType g = (ItemNormalizationGroupType)subGrp.get(i);
                    String gId = g.getIdentifier();
                    if (!gId.startsWith("grp_4_PK_")) {
                        bFromPK = false;
                        break;
                    }
                    ItemNormalizationGroupType.Key k = g.getKey();
                    if (k == null || k.getItemRef() == null || k.getItemRef().isEmpty()) {
                        bFromPK = false;
                        break;
                    }
                    if (i != lastGrpIdx || k.getKeyConstraint() == KeyConstraintType.UNIQUE) continue;
                    bFromPK = false;
                    break;
                }
                if (!bFromPK) continue;
                rt.put(moduleAlias + "." + subQ.getIdentifier(), subQ);
            }
        }
        return rt;
    }

    private static ItemNormalizationType generateItemNormalizationFromSrcQS(QuerySubject qs, QuerySubject srcQS) {
        List allQIs = MoserObjectUtils.getQueryItems((QuerySubject)qs);
        TreeSet<String> qiIds = new TreeSet<String>();
        for (QueryItem qi : allQIs) {
            if (qi.getRegularAggregate() == RegularAggregateType.CALCULATED) continue;
            qiIds.add(qi.getIdentifier());
        }
        ItemNormalizationType itemNorm = new ItemNormalizationType();
        ItemNormalizationType srcItemNorm = srcQS.getItemNormalization();
        List srcGrps = srcItemNorm.basicGetItemNormalizationGroup();
        ItemNormalizationGroupType lastGrp = null;
        for (ItemNormalizationGroupType srcG : srcGrps) {
            ItemNormalizationGroupType.Key srcKey = srcG.getKey();
            if (!qiIds.contains(srcKey.getItemRef())) {
                return null;
            }
            qiIds.remove(srcKey.getItemRef());
            ItemNormalizationGroupType grp = new ItemNormalizationGroupType();
            if (lastGrp != null) {
                grp.addParentGroupRef(lastGrp.getIdentifier());
            }
            lastGrp = grp;
            itemNorm.getItemNormalizationGroup().add(grp);
            grp.setIdentifier(srcG.getIdentifier());
            grp.setLabel(srcG.getLabel());
            ItemNormalizationGroupType.Key key = new ItemNormalizationGroupType.Key();
            key.setItemRef(srcKey.getItemRef());
            key.setKeyConstraint(srcKey.getKeyConstraint());
            key.setKeyComposition(srcKey.getKeyComposition());
            grp.setKey(key);
            List srcAtts = srcG.basicGetAttribute();
            if (srcAtts == null || srcAtts.isEmpty()) continue;
            for (ItemNormalizationGroupType.Attribute srcA : srcAtts) {
                if (!qiIds.contains(srcA.getItemRef())) continue;
                qiIds.remove(srcA.getItemRef());
                ItemNormalizationGroupType.Attribute att = new ItemNormalizationGroupType.Attribute();
                att.setItemRef(srcA.getItemRef());
                att.setSqlOperator(srcA.getSqlOperator());
                grp.getAttribute().add(att);
            }
        }
        if (lastGrp == null) {
            return null;
        }
        for (String id : qiIds) {
            ItemNormalizationGroupType.Attribute att = new ItemNormalizationGroupType.Attribute();
            att.setItemRef(id);
            att.setSqlOperator(SqlOperatorType.MINIMUM);
            lastGrp.getAttribute().add(att);
        }
        return itemNorm;
    }

    private static void populateWrapper(ResolverModuleWrapper wrapper, Module module, UseSpecType type, String storeId, String searchPath) {
        wrapper.theModule = module;
        wrapper.type = type;
        wrapper.storeId = storeId;
        wrapper.searchPath = searchPath;
    }

    private ResolverModuleWrapper addBusinessModule(Module module, String storeId, String searchPath) {
        ResolverModuleWrapper wrapper = new ResolverModuleWrapper();
        LogicalModuleResolver.populateWrapper(wrapper, module, UseSpecType.MODULE, storeId, searchPath);
        this.seenModules.put(storeId, wrapper);
        return wrapper;
    }

    private static void getBaseModuleForDatabase(IModuleObjectManager mm, ResolverModuleWrapper wrapper, Module.UseSpec useSpec, MoserMetadataContext metadataContext) {
        Module module = null;
        JSONObject json = null;
        String storeId = useSpec.getStoreID();
        if (metadataContext != MoserMetadataContext.XQEWHOLE || !(mm instanceof ModuleObjectManagerCM)) {
            module = mm.getBaseModuleForDatabase(storeId, "baseDefinition");
            if (ModuleUtil.moduleNeedUpgradeForPK(module)) {
                if (mm instanceof ModuleObjectManagerCM) {
                    ModuleObjectManagerCM cm = (ModuleObjectManagerCM)mm;
                    cm.generateItemNormalizationFromPrimaryKey(module, storeId, json);
                } else if (mm instanceof ModuleObjectManager) {
                    Module physicalModule;
                    ModuleObjectManager f = (ModuleObjectManager)mm;
                    List u = module.basicGetUse();
                    if (u != null && u.size() == 1 && (physicalModule = f.getPhysicalModule((String)u.get(0))) != null) {
                        PrimaryKeyToItemNormalization t = new PrimaryKeyToItemNormalization(physicalModule);
                        t.apply(module);
                    }
                }
            }
        } else {
            ModuleObjectManagerCM cm = (ModuleObjectManagerCM)mm;
            json = cm.getBaseModuleJSONObjectForDatabase(storeId, "baseDefinition", "physicalDefinition");
            if (json != null) {
                module = cm.decodeModule((String)json.get((Object)"baseDefinition"), null, null);
            }
            if (module != null) {
                if (ModuleUtil.moduleNeedUpgradeForPK(module)) {
                    cm.generateItemNormalizationFromPrimaryKey(module, storeId, json);
                }
                module = cm.applyOverrides(module, json);
            }
        }
        if (module == null) {
            return;
        }
        LogicalModuleResolver.populateWrapper(wrapper, module, useSpec.getType(), storeId, useSpec.getSearchPath());
        wrapper.theModuleDef = json;
    }

    private static void getModuleWrapperForPackage(IModuleObjectManager mm, ResolverModuleWrapper wrapper, Module.UseSpec useSpec, MoserMetadataContext metadataContext, ResolverModuleWrapper currentModuleWrapper, List<String> metadataIDs) {
        boolean bLoadFM;
        String[] packagename;
        String storeId = useSpec.getStoreID();
        String searchPath = mm.getSearchPathForPackage(storeId, packagename = new String[]{null});
        if (searchPath == null) {
            return;
        }
        if (!storeId.equals(searchPath)) {
            useSpec.setSearchPath(searchPath);
        }
        LogicalModuleResolver.populateWrapper(wrapper, null, useSpec.getType(), storeId, searchPath);
        wrapper.packageName = packagename[0];
        boolean bl = bLoadFM = metadataContext == MoserMetadataContext.METADATA && !currentModuleWrapper.getQuerySubject().isEmpty();
        if (bLoadFM) {
            List<String> metadataIDsPlusQSRefsToPackage = metadataIDs;
            if (metadataIDs != null && !metadataIDs.isEmpty()) {
                metadataIDsPlusQSRefsToPackage = LogicalModuleResolver.appendMetadataIDsFromQSRefs(useSpec, currentModuleWrapper, metadataIDs);
            }
            wrapper.theModule = mm.getBaseModuleForPackage(wrapper.storeId, useSpec.getIdentifier(), metadataIDsPlusQSRefsToPackage);
        }
    }

    private static List<String> appendMetadataIDsFromQSRefs(Module.UseSpec useSpec, ResolverModuleWrapper currentModuleWrapper, List<String> metadataIDs) {
        ArrayList<String> metadataIDsPlus = new ArrayList<String>(metadataIDs);
        for (QuerySubject qs : currentModuleWrapper.getQuerySubject()) {
            List refs = qs.getRef();
            if (refs == null) continue;
            for (String ref : refs) {
                String alias = ReferenceResolver.getFirstPart((String)ref);
                if (!useSpec.getIdentifier().equals(alias)) continue;
                String referencedQSId = ReferenceResolver.getSecondPart((String)ref);
                metadataIDsPlus.add(referencedQSId);
            }
        }
        return metadataIDsPlus;
    }

    private static void getBaseModule(IModuleObjectManager mm, ResolverModuleWrapper wrapper, Module.UseSpec useSpec, MoserMetadataContext metadataContext) {
        String storeId = useSpec.getStoreID();
        UseSpecType type = useSpec.getType();
        Module module = null;
        JSONObject json = null;
        if (metadataContext != MoserMetadataContext.XQEWHOLE || !(mm instanceof ModuleObjectManagerCM)) {
            switch (type) {
                case FILE: 
                case DATASET: {
                    module = mm.getBaseModuleForDataset(storeId, "baseDefinition");
                    break;
                }
                case WA_DATA_ASSET: 
                case URL: {
                    module = mm.getBaseModule(storeId, type);
                    break;
                }
            }
        } else {
            ModuleObjectManagerCM cm = (ModuleObjectManagerCM)mm;
            switch (type) {
                case FILE: 
                case DATASET: {
                    json = cm.getBaseModuleJSONForDatasetProperties(storeId, "baseDefinition", "physicalDefinition");
                    break;
                }
            }
            if (json != null) {
                module = cm.decodeModule((String)json.get((Object)"baseDefinition"), null, null);
            }
        }
        if (module == null) {
            return;
        }
        LogicalModuleResolver.populateWrapper(wrapper, module, type, storeId, useSpec.getSearchPath());
        wrapper.theModuleDef = json;
    }

    public static void checkCircularReference(IModuleObjectManager mm, String storeId, Module module) {
        LogicalModuleResolver resolver = new LogicalModuleResolver(MoserMetadataContext.METADATA);
        resolver.bLoadLeafNodes = false;
        ArrayDeque<String> stack = new ArrayDeque<String>();
        ArrayList<String> dependencyStack = new ArrayList<String>();
        resolver.addBusinessModule(module, storeId, null);
        resolver.buildDependencyStack(mm, stack, dependencyStack, storeId);
    }

    private void buildDependencyStack(IModuleObjectManager mm, Deque<String> stack, List<String> dependencyStack, String moduleId) {
        String currentVertex = moduleId;
        stack.push(moduleId);
        dependencyStack.add(moduleId);
        ResolverModuleWrapper currentModuleWrapper = this.getModuleWrapper(currentVertex);
        LoggerAdapter.trace(LogicalModuleResolver.class, "Processing " + LogicalModuleResolver.getStoreId(currentModuleWrapper) + "-" + LogicalModuleResolver.getModuleIdentifier(currentModuleWrapper) + "\n");
        if (!LogicalModuleResolver.isLeafVertex(currentModuleWrapper)) {
            List<Module.UseSpec> useSpecs = currentModuleWrapper.getUseSpec();
            this.loadUseSpecs(mm, useSpecs, currentModuleWrapper);
            for (Module.UseSpec useSpec : useSpecs) {
                String vertex;
                String storeId = useSpec.getStoreID();
                UseSpecType type = useSpec.getType();
                ResolverModuleWrapper wrapper = null;
                if (!UseSpecType.MODULE.equals((Object)type) && !this.bLoadLeafNodes) continue;
                wrapper = this.getModuleWrapper(storeId);
                if (wrapper == null) {
                    String alias = useSpec.getIdentifier();
                    String searchPath = useSpec.getSearchPath();
                    if (searchPath != null && mm instanceof ModuleObjectManagerCM) {
                        ModuleObjectManagerCM cm = (ModuleObjectManagerCM)mm;
                        cm.addModuleMissingDependency(searchPath);
                    }
                    LoggerAdapter.info(LogicalModuleResolver.class, "Failed to retrieve module " + alias + "\n SearchPath=" + searchPath + "\n StoreID=" + storeId + "\n");
                }
                if (stack.contains(vertex = storeId)) {
                    stack.push(vertex);
                    StringBuilder msg = LogicalModuleResolver.dumpStack(mm, stack);
                    MoserException e = new MoserException(MoserError.CIRCULAR_DEPENDENCY, LogicalModuleResolver.getModuleIdentifier(currentModuleWrapper), LogicalModuleResolver.getModuleIdentifier(wrapper), msg.toString());
                    e.setHTTPStatus(Response.Status.FORBIDDEN.getStatusCode());
                    throw e;
                }
                if (dependencyStack.contains(vertex)) {
                    int pos = dependencyStack.indexOf(vertex);
                    if (dependencyStack.indexOf(currentVertex) <= pos) continue;
                    for (String ancestor : stack) {
                        int ancestorPos = dependencyStack.indexOf(ancestor);
                        if (ancestorPos <= pos) continue;
                        dependencyStack.remove(ancestorPos);
                        dependencyStack.add(pos, ancestor);
                    }
                    continue;
                }
                this.buildDependencyStack(mm, stack, dependencyStack, vertex);
            }
        }
        stack.pop();
    }

    private void loadUseSpecs(IModuleObjectManager mm, List<Module.UseSpec> useSpecs, ResolverModuleWrapper currentModuleWrapper) {
        if (useSpecs.isEmpty()) {
            return;
        }
        ArrayBlockingQueue<Boolean> threadQueue = new ArrayBlockingQueue<Boolean>(MoserConfig.getContentServiceMaxConcurrentRequests());
        ArrayList<ModuleWrapperLoader> loaders = new ArrayList<ModuleWrapperLoader>();
        for (Module.UseSpec useSpec : useSpecs) {
            LogicalModuleResolver.validateStoreId(mm, useSpec);
            this.createLoader(mm, useSpec, loaders, currentModuleWrapper, threadQueue);
        }
        if (loaders.size() == 1) {
            ((ModuleWrapperLoader)loaders.get(0)).run();
            this.cleanSeenMap(loaders);
            LogicalModuleResolver.setAncestors(mm.getReqEnvironment(), loaders);
            return;
        }
        RequestEnvironment requestEnv = mm.getReqEnvironment();
        ExecutorService executor = requestEnv.getExecutorService();
        ArrayList futures = new ArrayList(loaders.size());
        for (ModuleWrapperLoader moduleWrapperLoader : loaders) {
            futures.add(executor.submit(moduleWrapperLoader));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LoggerAdapter.error((Object)this, "Failed to load a Module from the UseSpec: " + useSpecs.toString(), e);
            }
        }
        this.cleanSeenMap(loaders);
        LogicalModuleResolver.setAncestors(mm.getReqEnvironment(), loaders);
    }

    private static void setAncestors(RequestEnvironment requestEnv, List<ModuleWrapperLoader> loaders) {
        Map<String, JSONArray> ancestorsMap = requestEnv.getAncestorsMap();
        if (ancestorsMap.isEmpty()) {
            return;
        }
        for (ModuleWrapperLoader loader : loaders) {
            if (loader.getWrapper().isEmpty()) continue;
            Module.UseSpec useSpec = loader.getUseSpec();
            ModuleUseSpecUpdater.setAncestors(useSpec, ancestorsMap.get(useSpec.getStoreID()));
        }
    }

    private void cleanSeenMap(List<ModuleWrapperLoader> loaders) {
        for (ModuleWrapperLoader loader : loaders) {
            String storeId = loader.getUseSpec().getStoreID();
            if (loader.getWrapper().isEmpty()) {
                this.seenModules.remove(storeId);
                continue;
            }
            if (this.seenModules.containsKey(storeId)) continue;
            this.seenModules.put(storeId, loader.getWrapper());
        }
    }

    private void createLoader(IModuleObjectManager mm, Module.UseSpec useSpec, List<ModuleWrapperLoader> loaders, ResolverModuleWrapper currentModuleWrapper, ArrayBlockingQueue<Boolean> threadQueue) {
        if (!this.bLoadLeafNodes && !UseSpecType.MODULE.equals((Object)useSpec.getType())) {
            return;
        }
        String storeId = useSpec.getStoreID();
        if (StringUtils.isEmpty((CharSequence)storeId)) {
            storeId = useSpec.getSearchPath();
        }
        if (StringUtils.isEmpty((CharSequence)storeId)) {
            return;
        }
        ResolverModuleWrapper wrapper = this.getModuleWrapper(storeId);
        if (wrapper != null) {
            return;
        }
        wrapper = LogicalModuleResolver.createModuleWrapper();
        this.seenModules.put(storeId, wrapper);
        ModuleWrapperLoader loader = new ModuleWrapperLoader(mm, useSpec, wrapper, currentModuleWrapper, this.metadataContext, this.metadataIDs, threadQueue);
        loaders.add(loader);
    }

    private static void validateStoreId(IModuleObjectManager mm, Module.UseSpec useSpec) {
        String storeId = useSpec.getStoreID();
        if (StringUtils.isEmpty((CharSequence)storeId) && StringUtils.isNotEmpty((CharSequence)useSpec.getSearchPath())) {
            storeId = mm.getStoreIdBySearchPath(useSpec.getSearchPath());
            useSpec.setStoreID(storeId);
        }
    }

    private static void getModuleWrapperForLWOLAP(IModuleObjectManager mm, ResolverModuleWrapper wrapper, Module.UseSpec useSpec) {
        String storeId = useSpec.getStoreID();
        Module module = null;
        ModuleObjectManagerCM cm = (ModuleObjectManagerCM)mm;
        JSONObject json = cm.getBaseModuleJSONObjectForDatabase(storeId, "baseDefinition", "physicalDefinition");
        if (json != null) {
            module = cm.decodeModule((String)json.get((Object)"baseDefinition"), null, null);
        }
        if (module == null) {
            return;
        }
        LogicalModuleResolver.populateWrapper(wrapper, module, useSpec.getType(), storeId, useSpec.getSearchPath());
        wrapper.theModuleDef = json;
    }

    private static void getModuleWrapperForReport(IModuleObjectManager mm, ResolverModuleWrapper wrapper, Module.UseSpec useSpec) {
        String storeId = useSpec.getStoreID();
        Module module = mm.getBaseModuleForReport(storeId);
        LogicalModuleResolver.populateWrapper(wrapper, module, useSpec.getType(), storeId, useSpec.getSearchPath());
    }

    private static StringBuilder dumpStack(IModuleObjectManager mm, Deque<String> stack) {
        StringBuilder msg = new StringBuilder();
        Iterator<String> it = stack.descendingIterator();
        while (it.hasNext()) {
            String moduleId = it.next();
            msg.append(mm.getModulePrettyPath(moduleId));
            if (!it.hasNext()) continue;
            msg.append(" -> ");
        }
        return msg;
    }

    private ResolverModuleWrapper getModuleWrapper(String moduleId) {
        return this.seenModules.get(moduleId);
    }

    private static String getModuleIdentifier(ResolverModuleWrapper wrapper) {
        Module module;
        String moduleIdentifier = "missing";
        if (wrapper != null && (module = wrapper.getModule()) != null) {
            moduleIdentifier = module.getIdentifier();
        }
        return moduleIdentifier;
    }

    private static String getStoreId(ResolverModuleWrapper wrapper) {
        String storeId = "missing storeId";
        if (wrapper != null) {
            storeId = wrapper.getStoreId();
        }
        return storeId;
    }

    private ResolverModuleWrapper resolveLogicalModule(IModuleObjectManager mm, List<String> dependencyStack) {
        String currentModule = null;
        ListIterator<String> it = dependencyStack.listIterator(dependencyStack.size());
        while (it.hasPrevious()) {
            currentModule = it.previous();
            ResolverModuleWrapper currentWrapper = this.getModuleWrapper(currentModule);
            if (LogicalModuleResolver.isLeafVertex(currentWrapper)) continue;
            boolean traceEnabled = LoggerAdapter.isTraceEnabled(LogicalModuleResolver.class);
            if (traceEnabled) {
                LoggerAdapter.trace(LogicalModuleResolver.class, "Start resolving " + currentWrapper.getStoreId() + "-" + LogicalModuleResolver.getModuleIdentifier(currentWrapper) + "\n");
                LoggerAdapter.trace(LogicalModuleResolver.class, "Current Module: \n" + currentWrapper.getModule().toString());
            }
            this.resolveLogicalModule(mm, currentModule);
            if (!traceEnabled) continue;
            LoggerAdapter.trace(LogicalModuleResolver.class, "Finish resolving " + currentWrapper.getStoreId() + "-" + LogicalModuleResolver.getModuleIdentifier(currentWrapper) + "\n");
            LoggerAdapter.trace(LogicalModuleResolver.class, "Logical Module: \n" + currentWrapper.getModule().toString());
        }
        return this.getModuleWrapper(currentModule);
    }

    private void resolveLogicalModule(IModuleObjectManager mm, String module) {
        this.processModuleImports(module);
        this.resolveLogicalModuleRelationships(module);
        this.resolveLogicalModuleQuerySubjects(module);
        this.resolvePackageMDTV(mm, module);
    }

    private static <T extends ObjectType> void processImports(List<T> srcList, List<T> dstList, List<String> newPackageUseSpecList) {
        for (ObjectType obj : srcList) {
            String packageAlias = ReferenceResolver.getFirstPart((String)obj.getIdentifier());
            if (newPackageUseSpecList.contains(packageAlias)) continue;
            try {
                ObjectType newObj = (ObjectType)obj.clone();
                newObj.getPropertyOverride().clear();
                newObj.addPropertyOverride("Imported");
                dstList.add(newObj);
            }
            catch (CloneNotSupportedException e) {
                LoggerAdapter.errorExceptionStack(LogicalModuleResolver.class, e);
            }
        }
    }

    private static boolean isEmbeddedModule(ResolverModuleWrapper currentModule) {
        return DataModuleExtractor.isEmbeddedModule(currentModule.getUseSpec());
    }

    private void relinkEmbeddedQuerySubject(ResolverModuleWrapper currentModule) {
        Module.UseSpec useSpec;
        UseSpecType useSpecType;
        if (currentModule.getQuerySubject().size() == 1 && (UseSpecType.FILE.equals((Object)(useSpecType = (useSpec = currentModule.getUseSpec().get(0)).getType())) || UseSpecType.DATASET.equals((Object)useSpecType) || UseSpecType.WA_DATA_ASSET.equals((Object)useSpecType) || UseSpecType.URL.equals((Object)useSpecType))) {
            QuerySubject moduleQS = currentModule.getQuerySubject().get(0);
            ResolverModuleWrapper referencedModule = this.getModuleWrapper(useSpec.getStoreID());
            if (referencedModule != null && referencedModule.getQuerySubject().size() == 1) {
                String newIdentifier;
                QuerySubject referencedQS = referencedModule.getQuerySubject().get(0);
                String currentIdentifier = moduleQS.getIdentifier();
                if (!currentIdentifier.equals(newIdentifier = referencedQS.getIdentifier())) {
                    moduleQS.getRef().clear();
                    moduleQS.getRef().add(useSpec.getIdentifier() + "." + newIdentifier);
                    moduleQS.setIdentifier(newIdentifier);
                    String currentModuleId = currentModule.getModule().getIdentifier();
                    String newModuleId = referencedModule.getModule().getIdentifier();
                    LogicalModuleResolver.adjustQSFilterExpression(moduleQS, currentIdentifier, newIdentifier, currentModuleId, newModuleId);
                }
            }
        }
    }

    private static String replaceQuerySubjectId(String expression, String currentQSId, String newQSId, String currentModuleId, String newModuleId) {
        if (!currentQSId.equals(newQSId)) {
            String currValue = null;
            String newValue = null;
            if (currentModuleId != null && !currentModuleId.isEmpty()) {
                currValue = "." + currentModuleId + "." + currentQSId + ".";
            }
            if (currValue != null && expression.contains(currValue)) {
                newValue = "." + newModuleId + "." + newQSId + ".";
            } else if (expression.contains(currentQSId)) {
                currValue = currentQSId + ".";
                newValue = newQSId + ".";
            }
            if (currValue != null && newValue != null) {
                return expression.replaceAll(currValue, newValue);
            }
        }
        return expression;
    }

    private static Map<String, QuerySubject> createQuerySubjectRefMap(ResolverModuleWrapper currentModule) {
        HashMap<String, QuerySubject> qsMap = new HashMap<String, QuerySubject>();
        for (QuerySubject qs : currentModule.getQuerySubject()) {
            for (String ref : qs.getRef()) {
                qsMap.put(ref, qs);
            }
        }
        return qsMap;
    }

    private void processModuleImports(String module) {
        ResolverModuleWrapper currentModule = this.getModuleWrapper(module);
        for (Module.UseSpec u : currentModule.getUseSpec()) {
            UseSpecType t;
            String dataCacheExpiry = u.getDataCacheExpiry();
            if (dataCacheExpiry != null && !dataCacheExpiry.isEmpty() || (t = u.getType()) != UseSpecType.FILE && t != UseSpecType.DATASET) continue;
            u.setDataCacheExpiry("0");
        }
        if (!LogicalModuleResolver.isEmbeddedModule(currentModule)) {
            return;
        }
        Module.UseSpec use = currentModule.getUseSpec().get(0);
        if (!ModuleUtil.isPackageOrLWModuleOrReport(use.getType())) {
            ResolverModuleWrapper referencedModule = this.getModuleWrapper(use.getStoreID());
            if (referencedModule != null) {
                this.relinkEmbeddedQuerySubject(currentModule);
                ArrayList<String> newPackageAliasList = new ArrayList<String>();
                LogicalModuleResolver.bringImportedModulePackages(currentModule, referencedModule, newPackageAliasList);
                String refPrefix = use.getIdentifier() + ".";
                LogicalModuleResolver.importQuerySubjects(currentModule, referencedModule, newPackageAliasList, refPrefix);
                LogicalModuleResolver.importRelationships(currentModule, referencedModule, newPackageAliasList, refPrefix);
                LogicalModuleResolver.processImports(referencedModule.getModule().getCalculation(), currentModule.getModule().getCalculation(), newPackageAliasList);
                LogicalModuleResolver.processImports(referencedModule.getModule().getFilter(), currentModule.getModule().getFilter(), newPackageAliasList);
                LogicalModuleResolver.processImports(referencedModule.getModule().getDrillGroup(), currentModule.getModule().getDrillGroup(), newPackageAliasList);
                LogicalModuleResolver.processImports(referencedModule.getModule().getParameterMap(), currentModule.getModule().getParameterMap(), newPackageAliasList);
                LogicalModuleResolver.processImports(referencedModule.getModule().getNamedSet(), currentModule.getModule().getNamedSet(), newPackageAliasList);
                LogicalModuleResolver.importMDTV(currentModule, use, referencedModule, newPackageAliasList);
                if (use.getType() == UseSpecType.WA_DATA_ASSET || use.getType() == UseSpecType.URL) {
                    LogicalModuleResolver.processImportedWAAsset(currentModule, referencedModule);
                } else {
                    LogicalModuleResolver.copyOverProperties(currentModule, referencedModule);
                }
                this.importParameterValueSet(currentModule, referencedModule);
            } else {
                throw new ModuleNotFoundException(MoserError.MSR_BASE_MODULE_NOT_FOUND, use.getStoreID());
            }
        }
    }

    private void importParameterValueSet(ResolverModuleWrapper currentModule, ResolverModuleWrapper referencedModule) {
        if (this.metadataContext != MoserMetadataContext.XQEWHOLE) {
            return;
        }
        List paramValueSetRefModule = referencedModule.theModule.basicGetParameterValueSet();
        if (paramValueSetRefModule == null || paramValueSetRefModule.isEmpty()) {
            return;
        }
        String refActive = currentModule.theModule.getRefActiveParameterValueSet();
        if (refActive == null || refActive.isEmpty()) {
            String refActiveRefModule = referencedModule.theModule.getRefActiveParameterValueSet();
            if (refActiveRefModule == null || refActiveRefModule.isEmpty()) {
                return;
            }
            currentModule.theModule.setRefActiveParameterValueSet(refActiveRefModule);
        }
        HashSet<String> parameterSetCurrent = new HashSet<String>();
        List paramValueSet = currentModule.theModule.getParameterValueSet();
        for (ParameterValueSet c : paramValueSet) {
            parameterSetCurrent.add(c.getIdentifier());
        }
        for (ParameterValueSet refP : paramValueSetRefModule) {
            if (parameterSetCurrent.contains(refP.getIdentifier())) continue;
            parameterSetCurrent.add(refP.getIdentifier());
            try {
                paramValueSet.add((ParameterValueSet)refP.clone());
            }
            catch (CloneNotSupportedException e) {
                LoggerAdapter.error((Object)refP, "Failed to clone ParameterValueSet: ", e);
            }
        }
    }

    private static void importMDTV(ResolverModuleWrapper currentModule, Module.UseSpec use, ResolverModuleWrapper referencedModule, List<String> newPackageAliasList) {
        List<FolderType> srcMDTV = referencedModule.getModule().getMetadataTreeView();
        UseSpecType useType = use.getType();
        if (srcMDTV.isEmpty() && (useType == UseSpecType.FILE || useType == UseSpecType.DATASET || useType == UseSpecType.WA_DATA_ASSET)) {
            srcMDTV = LogicalModuleResolver.createImportedSourceMDTV(referencedModule);
        }
        if (!srcMDTV.isEmpty()) {
            List dstMDTV = currentModule.getModule().getMetadataTreeView();
            if (dstMDTV.isEmpty()) {
                FolderType f = new FolderType();
                dstMDTV.add(f);
            }
            List srcFIList = srcMDTV.get(0).getFolderItem();
            LogicalModuleResolver.prepareSourceMDTV(srcFIList, newPackageAliasList);
            List currentFIList = ((FolderType)dstMDTV.get(0)).getFolderItem();
            FolderItemType dummyForNewObjects = LogicalModuleResolver.getDummyFolderItemForNewObjects(currentFIList);
            currentFIList.addAll(srcFIList);
            if (dummyForNewObjects != null) {
                LogicalModuleResolver.insertNewObjectsIntoMDTV(currentModule.getModule(), currentFIList, dummyForNewObjects);
            }
        }
    }

    private static FolderItemType getDummyFolderItemForNewObjects(List<FolderItemType> currentFIList) {
        if (currentFIList == null || currentFIList.isEmpty()) {
            return null;
        }
        FolderItemType lastFolderItem = currentFIList.get(currentFIList.size() - 1);
        FolderType f = lastFolderItem.getFolder();
        if (f == null) {
            return null;
        }
        String path = LogicalModuleResolver.getObjectTypePath((ObjectType)f);
        if (path == null || path.isEmpty()) {
            return null;
        }
        String[] parts = path.split(STR_SEMICOLON);
        List newObjs = f.basicGetFolderItem();
        if (newObjs == null || newObjs.size() != parts.length) {
            return null;
        }
        currentFIList.remove(currentFIList.size() - 1);
        return lastFolderItem;
    }

    private static void insertNewObjectsIntoMDTV(Module currentModule, List<FolderItemType> currentFIList, FolderItemType dummyForNewObjects) {
        FolderType f = dummyForNewObjects.getFolder();
        String path = LogicalModuleResolver.getObjectTypePath((ObjectType)f);
        String[] parts = path.split(STR_SEMICOLON);
        List newFIList = f.basicGetFolderItem();
        for (int i = 0; i < parts.length; ++i) {
            String aPath = parts[i];
            FolderItemType aFolderItem = (FolderItemType)newFIList.get(i);
            String[] sPath = aPath.split("\\.");
            if (sPath.length == 2 && IdentifierUtil.isValidIdentifier((String)sPath[0])) {
                FolderType parentFolder = CommonResolverUtil.getFMPlaceHolderInMDTV((Module)currentModule, (String)sPath[0]);
                if (parentFolder == null || parentFolder.basicGetFolderItem() == null) {
                    currentFIList.add(aFolderItem);
                    continue;
                }
                int idx = Integer.parseInt(sPath[1]);
                List fldItems = parentFolder.basicGetFolderItem();
                if (idx < 0 || idx >= fldItems.size()) {
                    fldItems.add(aFolderItem);
                    continue;
                }
                fldItems.add(idx, aFolderItem);
                continue;
            }
            ArrayList<Integer> pos = new ArrayList<Integer>();
            for (String s : sPath) {
                pos.add(Integer.parseInt(s));
            }
            if (LogicalModuleResolver.insertIntoMDTV(aFolderItem, 0, currentFIList, pos)) continue;
            currentFIList.add(aFolderItem);
        }
    }

    private static boolean insertIntoMDTV(FolderItemType aFolderItem, int idx, List<FolderItemType> folderItemList, List<Integer> pos) {
        if (idx == pos.size() - 1) {
            int thePos = pos.get(idx);
            if (thePos < 0 || thePos >= folderItemList.size()) {
                folderItemList.add(aFolderItem);
            } else {
                folderItemList.add(thePos, aFolderItem);
            }
            return true;
        }
        int thePos = pos.get(idx);
        if (thePos < 0 || thePos >= folderItemList.size()) {
            return false;
        }
        FolderItemType theFolderItem = folderItemList.get(thePos);
        FolderType f = theFolderItem.getFolder();
        if (f == null || f.basicGetFolderItem() == null) {
            return false;
        }
        int nextIdx = idx + 1;
        return LogicalModuleResolver.insertIntoMDTV(aFolderItem, nextIdx, f.basicGetFolderItem(), pos);
    }

    private static void prepareSourceMDTV(List<FolderItemType> srcFIList, List<String> newPackageAliasList) {
        if (srcFIList == null) {
            return;
        }
        for (FolderItemType fi : srcFIList) {
            FolderType f = fi.getFolder();
            if (f == null) continue;
            String newId = f.getIdentifier();
            if (newPackageAliasList.contains(newId)) {
                f.setLabel(null);
                f.getFolderItem().clear();
            }
            f.getPropertyOverride().clear();
            f.addPropertyOverride("Imported");
            LogicalModuleResolver.prepareSourceMDTV(f.basicGetFolderItem(), newPackageAliasList);
        }
    }

    private static void importQuerySubjects(ResolverModuleWrapper currentModule, ResolverModuleWrapper referencedModule, List<String> newPackageAliasList, String refPrefix) {
        Map<String, QuerySubject> qsMap = LogicalModuleResolver.createQuerySubjectRefMap(currentModule);
        for (QuerySubject qs : referencedModule.getQuerySubject()) {
            String ref = refPrefix + qs.getIdentifier();
            QuerySubject overrideQS = qsMap.get(ref);
            if (overrideQS == null) {
                String origPackageAlias = ReferenceResolver.getFirstPart((String)qs.getIdentifier());
                if (newPackageAliasList.contains(origPackageAlias)) continue;
                QuerySubject newQS = new QuerySubject();
                newQS.setIdentifier(qs.getIdentifier());
                newQS.setInstanceType(InstanceType.REFERENCE);
                newQS.getRef().add(ref);
                newQS.getPropertyOverride().add("Imported");
                currentModule.getQuerySubject().add(newQS);
                newQS.setParent((MoserObject)currentModule.theModule);
                continue;
            }
            overrideQS.getPropertyOverride().add("Imported");
        }
    }

    private static void importRelationships(ResolverModuleWrapper currentModule, ResolverModuleWrapper referencedModule, List<String> newPackageAliasList, String refPrefix) {
        for (Relationship rel : referencedModule.getRelationship()) {
            Relationship newRel = null;
            String newPackageAlias = ReferenceResolver.getFirstPart((String)rel.getLeft().getRef());
            if (newPackageAliasList.contains(newPackageAlias)) {
                newRel = ModuleUtil.cloneRelationship(rel);
            }
            if (newPackageAliasList.contains(newPackageAlias = ReferenceResolver.getFirstPart((String)rel.getRight().getRef())) && newRel == null) {
                newRel = ModuleUtil.cloneRelationship(rel);
            }
            if (newRel == null) {
                newRel = new Relationship();
                newRel.setIdentifier(rel.getIdentifier());
                newRel.setInstanceType(InstanceType.REFERENCE);
                newRel.setRef(refPrefix + rel.getIdentifier());
            }
            newRel.getPropertyOverride().add("Imported");
            currentModule.getRelationship().add(newRel);
        }
    }

    private static void processImportedWAAsset(ResolverModuleWrapper currentModule, ResolverModuleWrapper referencedModule) {
        for (DataSource ds : referencedModule.getModule().getDataSource()) {
            currentModule.getModule().addDataSource(ds);
        }
        List propertyOverride = currentModule.getModule().getPropertyOverride();
        for (PropertyType prop : currentModule.getModule().getProperty()) {
            if (WA_ASSETID.equals(prop.getName())) continue;
            propertyOverride.add("property." + prop.getName());
        }
        for (PropertyType prop : referencedModule.getModule().getProperty()) {
            if (!WA_ASSETID.equals(prop.getName()) && !LogicalModuleResolver.isEmbeddedModule(currentModule)) continue;
            currentModule.getModule().addProperty(prop);
        }
    }

    private static void copyOverProperties(ResolverModuleWrapper currentModule, ResolverModuleWrapper referencedModule) {
        if (!LogicalModuleResolver.isEmbeddedModule(currentModule)) {
            return;
        }
        List props = referencedModule.getModule().basicGetProperty();
        if (props == null || props.isEmpty()) {
            return;
        }
        List propsCurrent = currentModule.getModule().getProperty();
        HashSet<String> propNames = new HashSet<String>();
        for (PropertyType p : propsCurrent) {
            propNames.add(p.getName());
        }
        for (PropertyType prop : props) {
            if (propNames.contains(prop.getName())) continue;
            propsCurrent.add(prop);
        }
    }

    private static List<FolderType> createImportedSourceMDTV(ResolverModuleWrapper referencedModule) {
        ArrayList<FolderType> srcMDTV = new ArrayList<FolderType>();
        FolderType f = new FolderType();
        srcMDTV.add(f);
        for (QuerySubject qs : referencedModule.getQuerySubject()) {
            FolderItemType fi = new FolderItemType();
            fi.setRef(qs.getIdentifier());
            f.getFolderItem().add(fi);
        }
        return srcMDTV;
    }

    private static void bringImportedModulePackages(ResolverModuleWrapper currentModule, ResolverModuleWrapper referencedModule, List<String> newPackageAliasList) {
        for (Module.UseSpec useSpec : referencedModule.getUseSpec()) {
            if (!ModuleUtil.isPackageOrLWModule(useSpec.getType())) continue;
            try {
                Module.UseSpec localUseSpec = (Module.UseSpec)useSpec.clone();
                newPackageAliasList.add(localUseSpec.getIdentifier());
                currentModule.getUseSpec().add(localUseSpec);
            }
            catch (CloneNotSupportedException e) {
                LoggerAdapter.errorExceptionStack(LogicalModuleResolver.class, e);
            }
        }
    }

    private void resolvePackageMDTV(IModuleObjectManager mm, String module) {
        if (this.metadataContext != MoserMetadataContext.METADATA) {
            return;
        }
        ResolverModuleWrapper currentModule = this.getModuleWrapper(module);
        boolean embeddedForPackageReport = DataModuleExtractor.isEmbeddedModuleForPackage(currentModule.getUseSpec());
        for (Module.UseSpec use : currentModule.getUseSpec()) {
            List fmMDTVs;
            ResolverModuleWrapper referencedModule;
            UseSpecType type = use.getType();
            if (!ModuleUtil.isPackageOrLWModuleOrReport(type) || (referencedModule = this.getModuleWrapper(use.getStoreID())) == null) continue;
            boolean isEmbeddedSource = IMPORT_ALL.equals(use.getImports());
            String moduleAlias = use.getIdentifier();
            FolderType placeHolder = CommonResolverUtil.getFMPlaceHolderInMDTV((Module)currentModule.getModule(), (String)moduleAlias);
            if (placeHolder == null) continue;
            if (embeddedForPackageReport) {
                moduleAlias = null;
            }
            Module mdtvFM = null;
            if (type == UseSpecType.PACKAGE) {
                mdtvFM = mm.getBaseModuleForPackage(referencedModule.getStoreId(), moduleAlias, this.metadataIDs);
            } else if (type == UseSpecType.LW_OLAP) {
                mdtvFM = mm.getBaseModuleForLWOLAP(referencedModule.getStoreId(), moduleAlias, this.metadataIDs);
            } else if (type == UseSpecType.REPORT) {
                mdtvFM = referencedModule.getModule();
            }
            if (mdtvFM == null || (fmMDTVs = mdtvFM.getMetadataTreeView()).size() != 1) continue;
            if (isEmbeddedSource) {
                placeHolder.addPropertyOverride(placeHolder.getIdentifier());
                placeHolder.setIdentifier(null);
            }
            if (TYPES_PKG_REPORT.contains(type)) {
                String label = null;
                label = type == UseSpecType.PACKAGE ? referencedModule.packageName : mdtvFM.getLabel();
                if (label != null && !label.isEmpty()) {
                    placeHolder.setLabel(label);
                }
                if (type == UseSpecType.PACKAGE) {
                    ObjectFactory factory = new ObjectFactory();
                    FolderItemType fi = factory.createFolderItemType();
                    fi.setFolder((FolderType)fmMDTVs.get(0));
                    placeHolder.getFolderItem().add(fi);
                } else {
                    FolderType topFolder = (FolderType)fmMDTVs.get(0);
                    List items = topFolder.basicGetFolderItem();
                    if (items != null) {
                        for (FolderItemType itm : items) {
                            placeHolder.addFolderItem(itm);
                        }
                    }
                }
            } else {
                placeHolder.setLabel(((FolderType)fmMDTVs.get(0)).getLabel());
                FolderType ft = (FolderType)fmMDTVs.get(0);
                placeHolder.getFolderItem().addAll(ft.getFolderItem());
            }
            if (LogicalModuleResolver.isEmbeddedModule(currentModule)) {
                LogicalModuleResolver.markImported(mdtvFM.getQuerySubject());
                LogicalModuleResolver.markImported(mdtvFM.getCalculation());
                LogicalModuleResolver.markImported(mdtvFM.getFilter());
                LogicalModuleResolver.markImported(mdtvFM.getNamedSet());
                LogicalModuleResolver.markImported(mdtvFM.getDrillGroup());
                if (!placeHolder.getPropertyOverride().contains("Imported")) {
                    placeHolder.getPropertyOverride().add("Imported");
                }
            }
            currentModule.getQuerySubject().addAll(mdtvFM.getQuerySubject());
            currentModule.getModule().getCalculation().addAll(mdtvFM.getCalculation());
            currentModule.getModule().getFilter().addAll(mdtvFM.getFilter());
            currentModule.getModule().getNamedSet().addAll(mdtvFM.getNamedSet());
            currentModule.getModule().getDrillGroup().addAll(mdtvFM.getDrillGroup());
            if (mdtvFM.getDataSource().isEmpty()) continue;
            currentModule.getModule().getDataSource().addAll(mdtvFM.getDataSource());
        }
    }

    private static void markImported(List<? extends ObjectType> objList) {
        for (ObjectType objectType : objList) {
            objectType.getPropertyOverride().add("Imported");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resolveLogicalModuleQuerySubjects(String module) {
        ResolverModuleWrapper currentModule = this.getModuleWrapper(module);
        HashMap<String, Object> referencedModuleMap = new HashMap<String, Object>();
        HashMap<String, Map<String, QuerySubject>> querySubjectDictionaries = new HashMap<String, Map<String, QuerySubject>>();
        for (Module.UseSpec use : currentModule.getUseSpec()) {
            Object referencedModule;
            String moduleAlias = use.getIdentifier();
            HashMap<String, QuerySubject> qsDictionary = (HashMap<String, QuerySubject>)querySubjectDictionaries.get(moduleAlias);
            if (qsDictionary == null) {
                qsDictionary = new HashMap<String, QuerySubject>();
                querySubjectDictionaries.put(moduleAlias, qsDictionary);
            }
            if ((referencedModule = this.getModuleWrapper(use.getStoreID())) == null) continue;
            referencedModuleMap.put(moduleAlias, referencedModule);
            for (QuerySubject querySubject : ((ResolverModuleWrapper)referencedModule).getQuerySubject()) {
                String referencedQSID = TYPES_PKG_REPORT.contains(((ResolverModuleWrapper)referencedModule).type) ? querySubject.getIdentifier() : moduleAlias + "." + querySubject.getIdentifier();
                qsDictionary.put(referencedQSID, querySubject);
            }
        }
        Map<String, QuerySubject> subQuerySubjectsPK = null;
        if (currentModule.type == UseSpecType.MODULE && ModuleUtil.moduleNeedUpgradeForPK(currentModule.theModule)) {
            subQuerySubjectsPK = this.getPKQuerySubjectsFromSubModule(currentModule.theModule);
        }
        HashMap<QuerySubject, List<QueryItem>> queryItemWithSplit = new HashMap<QuerySubject, List<QueryItem>>();
        List<QuerySubject> querySubjects = currentModule.getQuerySubject();
        HashMap<String, QuerySubject> qsDictionaryCurrentModule = new HashMap<String, QuerySubject>();
        for (QuerySubject qsThisModule : querySubjects) {
            qsDictionaryCurrentModule.put(qsThisModule.getIdentifier(), qsThisModule);
        }
        for (int i = 0; i < querySubjects.size(); ++i) {
            void var11_17;
            QuerySubject qs = querySubjects.get(i);
            if (!InstanceType.REFERENCE.equals((Object)qs.getInstanceType())) {
                for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
                    List splitDefinition = qi.basicGetSplitDefinition();
                    if (splitDefinition == null) continue;
                    boolean bSp = false;
                    for (SplitType split : splitDefinition) {
                        if (split == null || !LogicalModuleResolver.resolveSplitDefinition(split, querySubjectDictionaries)) continue;
                        bSp = true;
                    }
                    if (bSp) continue;
                    ArrayList<QueryItem> qiLst = (ArrayList<QueryItem>)queryItemWithSplit.get(qs);
                    if (qiLst == null) {
                        qiLst = new ArrayList<QueryItem>();
                        queryItemWithSplit.put(qs, qiLst);
                    }
                    qiLst.add(qi);
                }
            }
            Object var11_16 = null;
            List qsRefs = qs.getRef();
            for (int j = 0; j < qsRefs.size(); ++j) {
                String qsRef = (String)qsRefs.get(j);
                if (!LogicalModuleResolver.isReference((ObjectType)qs, qsRef)) {
                    this.markMissingReference(querySubjectDictionaries, currentModule, qs, j, qsRefs, qsDictionaryCurrentModule);
                    LogicalModuleResolver.generateItemNormalizationFromPK(qs, subQuerySubjectsPK);
                    continue;
                }
                String referencedModuleAlias = ReferenceResolver.getFirstPart((String)qsRef);
                Map qsDictionary = (Map)querySubjectDictionaries.get(referencedModuleAlias);
                QuerySubject referencedQuerySubject = null;
                if (qsDictionary != null && (referencedQuerySubject = (QuerySubject)qsDictionary.get(qsRef)) == null) {
                    referencedQuerySubject = LogicalModuleResolver.retryForFileUpload(qs, qsDictionary, qsRef, j);
                }
                if (LogicalModuleResolver.isReferenceMissing(referencedQuerySubject)) {
                    QuerySubject querySubject;
                    qs.setInstanceType(InstanceType.MISSING);
                    if (var11_17 != null || (querySubject = ModuleUtil.cloneQuerySubject(qs)).getLabel() != null || referencedQuerySubject == null || referencedQuerySubject.getLabel() == null) continue;
                    querySubject.setLabel(referencedQuerySubject.getLabel());
                    querySubject.getPropertyOverride().add("-label");
                    continue;
                }
                boolean bMarkMissing = referencedQuerySubject.getInstanceType() == InstanceType.MISSING && !LogicalModuleResolver.isEmbeddedModule(currentModule);
                ResolverModuleWrapper referencedModule = (ResolverModuleWrapper)referencedModuleMap.get(referencedModuleAlias);
                referencedQuerySubject = ModuleUtil.cloneQuerySubject(referencedQuerySubject);
                if (LogicalModuleResolver.isLeafVertex(referencedModule)) {
                    if (referencedModule != null && (referencedModule.getType() == UseSpecType.WA_DATA_ASSET || referencedModule.getType() == UseSpecType.URL)) {
                        referencedQuerySubject.getOriginalRef().addAll(qs.getRef());
                    } else {
                        referencedQuerySubject.getRef().clear();
                        referencedQuerySubject.getRef().addAll(qs.getRef());
                    }
                } else {
                    LogicalModuleResolver.cleanClonedQuerySubject(referencedQuerySubject);
                    referencedQuerySubject.getOriginalRef().addAll(qs.getRef());
                    LogicalModuleResolver.unwindQuerySubjectRefToBaseModule(referencedQuerySubject, currentModule, referencedModule);
                }
                if (var11_17 == null) {
                    QuerySubject querySubject = referencedQuerySubject;
                } else {
                    var11_17.getRef().addAll(referencedQuerySubject.getRef());
                    var11_17.getItem().addAll(referencedQuerySubject.getItem());
                    var11_17.getFilter().addAll(referencedQuerySubject.getFilter());
                }
                String referencedQSId = ReferenceResolver.getSecondPart((String)qsRef);
                LogicalModuleResolver.adjustQSFilterExpression((QuerySubject)var11_17, referencedQSId, qs.getIdentifier(), null, null);
                if (!bMarkMissing) continue;
                var11_17.setInstanceType(InstanceType.MISSING);
            }
            if (var11_17 == null) continue;
            LogicalModuleResolver.overwriteObjectType((ObjectType)var11_17, (ObjectType)qs);
            var11_17.setInstanceType(qs.getInstanceType());
            LogicalModuleResolver.resolveItems((QuerySubject)var11_17, qs, LogicalModuleResolver.isEmbeddedModule(currentModule));
            LogicalModuleResolver.updateQuerySubjectFilterOverrideList(qs.getFilter());
            var11_17.getFilter().addAll(qs.getFilter());
            querySubjects.set(i, (QuerySubject)var11_17);
        }
        LogicalModuleResolver.resolveSplitDefinitionNew(currentModule, queryItemWithSplit, qsDictionaryCurrentModule);
    }

    private static boolean isReferenceMissing(QuerySubject referencedQuerySubject) {
        if (referencedQuerySubject == null) {
            return true;
        }
        if (referencedQuerySubject.getInstanceType() != InstanceType.MISSING) {
            return false;
        }
        return MoserObjectUtils.getQueryItems((QuerySubject)referencedQuerySubject).isEmpty();
    }

    private static void generateItemNormalizationFromPK(QuerySubject qs, Map<String, QuerySubject> subQuerySubjectsPK) {
        List grps;
        if (subQuerySubjectsPK == null || subQuerySubjectsPK.isEmpty()) {
            return;
        }
        QsClassifierType qsCls = qs.getClassifier();
        if (QsClassifierType.QUERY_SUBJECT != qsCls && qsCls != null) {
            return;
        }
        ItemNormalizationType itemNorm = qs.getItemNormalization();
        if (itemNorm != null && (grps = itemNorm.basicGetItemNormalizationGroup()) != null && !grps.isEmpty()) {
            return;
        }
        List refs = qs.basicGetRef();
        if (refs == null || refs.size() != 1) {
            return;
        }
        QuerySubject srcQS = subQuerySubjectsPK.get(refs.get(0));
        if (srcQS == null) {
            return;
        }
        itemNorm = LogicalModuleResolver.generateItemNormalizationFromSrcQS(qs, srcQS);
        if (itemNorm != null) {
            qs.setItemNormalization(itemNorm);
        }
    }

    private void markMissingReference(Map<String, Map<String, QuerySubject>> querySubjectDictionaries, ResolverModuleWrapper currentModule, QuerySubject qs, int j, List<String> qsRefs, Map<String, QuerySubject> qsDictionaryCurrentModule) {
        String qsRef = qsRefs.get(j);
        String[] parts = qsRef.split("\\.");
        if (this.metadataContext != MoserMetadataContext.METADATA && parts.length >= 2 && this.isPackage(parts[0], currentModule)) {
            return;
        }
        boolean b = this.unwindReference(currentModule, qsRefs, j);
        if (!b) {
            qs.setInstanceType(InstanceType.MISSING);
        } else {
            QuerySubject referencedQuerySubject;
            String referencedModuleAlias = ReferenceResolver.getFirstPart((String)qsRef);
            Map<String, QuerySubject> qsDictionary = querySubjectDictionaries.get(referencedModuleAlias);
            if (qsDictionary != null) {
                referencedQuerySubject = qsDictionary.get(qsRef);
                if (referencedQuerySubject == null) {
                    referencedQuerySubject = LogicalModuleResolver.retryForFileUpload(qs, qsDictionary, qsRef, j);
                }
            } else {
                referencedQuerySubject = qsDictionaryCurrentModule.get(qsRef);
                if (qs == referencedQuerySubject) {
                    referencedQuerySubject = null;
                }
            }
            if (referencedQuerySubject == null || referencedQuerySubject.getInstanceType() == InstanceType.MISSING) {
                qs.setInstanceType(InstanceType.MISSING);
            }
        }
    }

    private static void adjustQSFilterExpression(QuerySubject querySubject, String referencedQSId, String newQSId, String currentModuleId, String newModuleId) {
        if (!referencedQSId.equals(newQSId)) {
            List secFilters;
            List filters = querySubject.basicGetFilter();
            if (filters != null) {
                for (Filter filter : filters) {
                    String expr = filter.getExpression();
                    String newExpr = LogicalModuleResolver.replaceQuerySubjectId(expr, referencedQSId, newQSId, currentModuleId, newModuleId);
                    filter.setExpression(newExpr);
                }
            }
            if ((secFilters = querySubject.basicGetSecurityFilter()) != null) {
                for (SecurityFilter secFilter : secFilters) {
                    String expr = secFilter.getExpression();
                    String newExpr = LogicalModuleResolver.replaceQuerySubjectId(expr, referencedQSId, newQSId, currentModuleId, newModuleId);
                    secFilter.setExpression(newExpr);
                }
            }
        }
    }

    private static void resolveSplitDefinitionNew(ResolverModuleWrapper currentModule, Map<QuerySubject, List<QueryItem>> qsWithSplit, Map<String, QuerySubject> allQS) {
        String[] parts;
        SplitType sp;
        String ref;
        List spDef;
        List<QueryItem> queryItemWithSplit;
        HashSet<QuerySubject> neededQuerySubjects = new HashSet<QuerySubject>();
        for (Map.Entry<QuerySubject, List<QueryItem>> e : qsWithSplit.entrySet()) {
            QuerySubject qs = e.getKey();
            neededQuerySubjects.add(qs);
            queryItemWithSplit = e.getValue();
            for (QueryItem qi : queryItemWithSplit) {
                spDef = qi.getSplitDefinition();
                if (spDef.size() != 1 || (ref = (sp = (SplitType)spDef.get(0)).getRef()) == null || ref.isEmpty() || "none".equalsIgnoreCase(ref) || (parts = sp.getRef().split("\\.")).length != 1 || (qs = allQS.get(parts[0])) == null) continue;
                neededQuerySubjects.add(qs);
            }
        }
        for (QuerySubject qs : neededQuerySubjects) {
            HashMap allQueryItems = new HashMap();
            PropertySetter.ensureIdForExpression((String)qs.getIdentifier(), (List)qs.basicGetItem(), allQueryItems);
            for (QueryItem qi : allQueryItems.values()) {
                HighLevelDataType highlevelDatatype = MoserCommonUtils.generateHighlevelDatatype((String)qi.getDatatype());
                qi.setHighlevelDatatype(highlevelDatatype);
            }
        }
        ArrayList<QueryItem> retry = new ArrayList<QueryItem>();
        for (Map.Entry<QuerySubject, List<QueryItem>> e : qsWithSplit.entrySet()) {
            queryItemWithSplit = e.getValue();
            for (QueryItem qi : queryItemWithSplit) {
                spDef = qi.getSplitDefinition();
                if (spDef.size() != 1 || (ref = (sp = (SplitType)spDef.get(0)).getRef()) == null || ref.isEmpty() || "none".equalsIgnoreCase(ref)) continue;
                parts = sp.getRef().split("\\.");
                if (parts.length > 1) {
                    retry.add(qi);
                    continue;
                }
                PropertySetter.splitToQuerySubject((QueryItem)qi, (SplitType)sp, (Module)currentModule.getModule(), (String)parts[0]);
            }
        }
        for (QueryItem qi : retry) {
            List spDef2 = qi.getSplitDefinition();
            SplitType sp2 = (SplitType)spDef2.get(0);
            String ref2 = sp2.getRef();
            String[] parts2 = sp2.getRef().split("\\.");
            PropertySetter.splitToComparableQueryItem((QueryItem)qi, (SplitType)sp2, (Module)currentModule.getModule(), (String)parts2[0], (String)ref2);
        }
    }

    private static QuerySubject retryForFileUpload(QuerySubject qs, Map<String, QuerySubject> qsDictionary, String qsRef, int j) {
        String qsID = ReferenceResolver.getSecondPart((String)qsRef);
        if (qsID == null) {
            return null;
        }
        if (Character.isDigit(qsID.charAt(0))) {
            CaseInsensitiveMap seenMap = new CaseInsensitiveMap();
            String tableId = IdentifierUtil.makeUniqueAndValidIdentifier((String)qsID, (CaseInsensitiveMap)seenMap);
            String alias = ReferenceResolver.getFirstPart((String)qsRef);
            String oldID = alias + "." + tableId;
            QuerySubject result = qsDictionary.get(oldID);
            if (result == null) {
                tableId = MoserUtil.stripCharactersForR7Uploads(qsID);
                oldID = alias + "." + tableId;
                result = qsDictionary.get(oldID);
            }
            if (result != null) {
                qs.getRef().set(j, oldID);
            }
            return result;
        }
        return null;
    }

    private static void cleanClonedQuerySubject(QuerySubject qs) {
        qs.getPropertyOverride().clear();
        qs.getOriginalRef().clear();
        MoserObjectUtils.getQueryItems((QuerySubject)qs).forEach(qi -> qi.getPropertyOverride().clear());
        qs.getFilter().forEach(f -> f.getPropertyOverride().clear());
    }

    private static Map<String, ObjectType> createItemDictionary(QuerySubject qs) {
        HashMap<String, ObjectType> iDictionary = new HashMap<String, ObjectType>();
        MoserObjectUtils.getItems((ObjectType)qs).forEach(item -> iDictionary.put(item.getIdentifier(), (ObjectType)item));
        return iDictionary;
    }

    private static Map<String, QueryItem> createQIDictionary(QuerySubject qs) {
        HashMap<String, QueryItem> qiDictionary = new HashMap<String, QueryItem>();
        MoserObjectUtils.getQueryItems((QuerySubject)qs).forEach(qi -> qiDictionary.put(qi.getIdentifier(), (QueryItem)qi));
        return qiDictionary;
    }

    private static Map<String, CalculatedMemberType> createCMDictionary(List<CalculatedMemberType> cm) {
        HashMap<String, CalculatedMemberType> cmDictionary = new HashMap<String, CalculatedMemberType>();
        for (CalculatedMemberType calcMember : cm) {
            cmDictionary.put(calcMember.getIdentifier(), calcMember);
        }
        return cmDictionary;
    }

    private static boolean resolveSplitDefinition(SplitType split, Map<String, Map<String, QuerySubject>> querySubjectDictionaries) {
        QuerySubject referencedQuerySubject;
        boolean b = false;
        String qsRef = split.getRef();
        String referencedModuleAlias = ReferenceResolver.getFirstPart((String)qsRef);
        Map<String, QuerySubject> qsDictionary = querySubjectDictionaries.get(referencedModuleAlias);
        if (qsDictionary != null && (referencedQuerySubject = qsDictionary.get(qsRef)) != null) {
            b = true;
            Map<String, QueryItem> qiDictionary = LogicalModuleResolver.createQIDictionary(referencedQuerySubject);
            List qiList = split.getItem();
            for (int i = 0; i < qiList.size(); ++i) {
                QueryItem qi = ((ItemType)qiList.get(i)).getQueryItem();
                if (qi == null) continue;
                QueryItem referencedQI = qiDictionary.get(qi.getIdentifier());
                if (referencedQI == null) {
                    qi.setInstanceType(InstanceType.MISSING);
                    continue;
                }
                referencedQI = ModuleUtil.cloneQueryItem(referencedQI);
                referencedQI.setInstanceType(InstanceType.REFERENCE);
                referencedQI.setRef(qi.getRef());
                referencedQI.getPropertyOverride().clear();
                LogicalModuleResolver.overwriteQueryItem(referencedQI, qi);
                ItemType item = new ItemType();
                item.setQueryItem(referencedQI);
                qiList.set(i, item);
            }
        }
        return b;
    }

    private static void unwindQuerySubjectRefToBaseModule(QuerySubject querySubject, ResolverModuleWrapper currentModule, ResolverModuleWrapper referencedModule) {
        Module.UseSpec referencedUseSpec;
        boolean srcIsView = false;
        List refsInSrc = querySubject.getRef();
        for (String r : refsInSrc) {
            referencedUseSpec = LogicalModuleResolver.getReferencedModuleUseSpec(r, referencedModule.getUseSpec());
            if (referencedUseSpec != null) continue;
            srcIsView = true;
            break;
        }
        if (srcIsView) {
            return;
        }
        for (int j = 0; j < querySubject.getRef().size(); ++j) {
            String aQSRef = (String)querySubject.getRef().get(j);
            referencedUseSpec = LogicalModuleResolver.getReferencedModuleUseSpec(aQSRef, referencedModule.getUseSpec());
            Module.UseSpec localUseSpec = null;
            for (Module.UseSpec useSpec : currentModule.getUseSpec()) {
                if (!useSpec.getStoreID().equals(referencedUseSpec.getStoreID())) continue;
                localUseSpec = useSpec;
                break;
            }
            if (localUseSpec == null) {
                ObjectFactory factory = new ObjectFactory();
                localUseSpec = factory.createModuleUseSpec();
                localUseSpec.setIdentifier(LogicalModuleResolver.getNextResolvedBaseModuleAlias(currentModule));
                localUseSpec.setSearchPath(referencedUseSpec.getSearchPath());
                localUseSpec.setStoreID(referencedUseSpec.getStoreID());
                localUseSpec.setType(referencedUseSpec.getType());
                currentModule.getUseSpec().add(localUseSpec);
            }
            int pos = aQSRef.indexOf(".");
            String newRef = localUseSpec.getIdentifier() + aQSRef.substring(pos);
            querySubject.getRef().set(j, newRef);
        }
    }

    private static String getNextResolvedBaseModuleAlias(List<Module.UseSpec> useSpecList) {
        int nextId = 0;
        for (Module.UseSpec spec : useSpecList) {
            int id;
            if (!spec.getIdentifier().startsWith(RESOLVED_BASE_MODULE_ALIAS_PREFIX) || (id = Integer.parseInt(spec.getIdentifier().substring(RESOLVED_BASE_MODULE_ALIAS_PREFIX.length()))) <= nextId) continue;
            nextId = id;
        }
        return RESOLVED_BASE_MODULE_ALIAS_PREFIX + ++nextId;
    }

    private static String getNextResolvedBaseModuleAlias(ResolverModuleWrapper module) {
        return LogicalModuleResolver.getNextResolvedBaseModuleAlias(module.getUseSpec());
    }

    private static Module.UseSpec getReferencedModuleUseSpec(String qsRef, List<Module.UseSpec> useSpecList) {
        String referencedModuleAlias = ReferenceResolver.getFirstPart((String)qsRef);
        for (Module.UseSpec useSpec : useSpecList) {
            if (!useSpec.getIdentifier().equals(referencedModuleAlias)) continue;
            return useSpec;
        }
        return null;
    }

    private static void resolveItems(QuerySubject querySubject, QuerySubject overwriteQuerySubject, boolean inEmbedModule) {
        Map<String, ObjectType> itemDictionary = LogicalModuleResolver.createItemDictionary(overwriteQuerySubject);
        for (ObjectType item : MoserObjectUtils.getItems((ObjectType)querySubject)) {
            ObjectType overwriteItem = itemDictionary.remove(item.getIdentifier());
            if (overwriteItem == null) continue;
            LogicalModuleResolver.overwriteItemType(item, overwriteItem);
            LogicalModuleResolver.clearObjectTypePath(item);
        }
        Collection<ObjectType> remainingItems = itemDictionary.values();
        if (!remainingItems.isEmpty()) {
            ArrayList<ObjectType> itemsToAdd = new ArrayList<ObjectType>(remainingItems);
            ArrayList<Integer> pos = new ArrayList<Integer>();
            ObjectType item = LogicalModuleResolver.getItemByPath(itemsToAdd, pos);
            boolean bOK = true;
            HashSet<ObjectType> seen = new HashSet<ObjectType>();
            while (item != null) {
                if (!seen.contains(item)) {
                    List propOverride = item.getPropertyOverride();
                    if (!propOverride.contains("NEW")) {
                        propOverride.add("NEW");
                    }
                    ItemType itemType = new ItemType();
                    switch (item.getObjectType()) {
                        case "Filter": {
                            itemType.setFilter((Filter)item);
                            break;
                        }
                        case "Folder": {
                            ItemType.Folder folder = (ItemType.Folder)item;
                            List folderItems = folder.basicGetItem();
                            if (DataModuleExtractor.notEmptyList((List)folderItems)) {
                                folderItems.clear();
                            }
                            itemType.setFolder(folder);
                            break;
                        }
                        case "ItemHierarchy": {
                            itemType.setItemHierarchy((ItemHierarchy)item);
                            break;
                        }
                        case "NamedSet": {
                            itemType.setNamedSet((NamedSet)item);
                            break;
                        }
                        case "Calculation": {
                            itemType.setCalculation((Calculation)item);
                            break;
                        }
                        default: {
                            itemType.setQueryItem((QueryItem)item);
                            if (!inEmbedModule) break;
                            PropertySetter.addQueryItemToItemNormalization((QuerySubject)querySubject, (QueryItem)((QueryItem)item), (ObjectFactory)new ObjectFactory());
                        }
                    }
                    if (!bOK || pos.isEmpty() || !LogicalModuleResolver.insertItemByPos((MoserObject)querySubject, querySubject.getItem(), itemType, pos)) {
                        querySubject.getItem().add(itemType);
                        itemType.setParent((MoserObject)querySubject);
                        bOK = false;
                    }
                    LogicalModuleResolver.clearObjectTypePath(item);
                    seen.add(item);
                    seen.addAll(MoserObjectUtils.getItems((ObjectType)item));
                }
                item = LogicalModuleResolver.getItemByPath(itemsToAdd, pos);
            }
        }
    }

    private static boolean insertItemByPos(MoserObject parentObj, List<ItemType> items, ItemType item, List<Integer> pos) {
        if (pos.size() == 1) {
            int atPos = pos.get(0);
            pos.clear();
            if (atPos >= items.size()) {
                items.add(item);
            } else {
                items.add(atPos, item);
            }
            item.setParent(parentObj);
            return true;
        }
        int currentPos = pos.get(0);
        pos.remove(0);
        if (currentPos >= items.size()) {
            return false;
        }
        ItemType parentItem = items.get(currentPos);
        ItemType.Folder fld = parentItem.getFolder();
        if (fld == null) {
            return false;
        }
        return LogicalModuleResolver.insertItemByPos((MoserObject)fld, fld.getItem(), item, pos);
    }

    private static ObjectType getItemByPath(ArrayList<ObjectType> itemsToAdd, ArrayList<Integer> pos) {
        pos.clear();
        if (itemsToAdd.isEmpty()) {
            return null;
        }
        ObjectType rt = null;
        ArrayList<Integer> minPos = new ArrayList<Integer>();
        for (ObjectType item : itemsToAdd) {
            String path = LogicalModuleResolver.getObjectTypePath(item);
            if (path == null) {
                rt = item;
                minPos.clear();
                break;
            }
            String[] parts = path.split("\\.");
            ArrayList<Integer> p = new ArrayList<Integer>();
            for (String s : parts) {
                p.add(Integer.parseInt(s));
            }
            if (rt != null && !LogicalModuleResolver.isLess(p, minPos)) continue;
            rt = item;
            minPos.clear();
            minPos.addAll(p);
        }
        itemsToAdd.remove(rt);
        pos.addAll(minPos);
        return rt;
    }

    private static boolean isLess(List<Integer> p, List<Integer> minPos) {
        if (p.size() < minPos.size()) {
            return true;
        }
        if (p.size() > minPos.size()) {
            return false;
        }
        for (int i = 0; i < p.size(); ++i) {
            if (p.get(i) >= minPos.get(i)) continue;
            return true;
        }
        return false;
    }

    private static String getObjectTypePath(ObjectType objectType) {
        List propList = objectType.basicGetProperty();
        if (propList == null) {
            return null;
        }
        for (PropertyType pp : propList) {
            if (!"_path".equals(pp.getName())) continue;
            return pp.getValue();
        }
        return null;
    }

    private static void clearObjectTypePath(ObjectType objectType) {
        List propOverrideList;
        List propList = objectType.basicGetProperty();
        if (propList != null) {
            Iterator iter = propList.iterator();
            while (iter.hasNext()) {
                if (!"_path".equals(((PropertyType)iter.next()).getName())) continue;
                iter.remove();
                break;
            }
        }
        if ((propOverrideList = objectType.basicGetPropertyOverride()) != null) {
            Iterator iter = propOverrideList.iterator();
            while (iter.hasNext()) {
                if (!"property._path".equals(iter.next())) continue;
                iter.remove();
                break;
            }
        }
    }

    private static void overwriteItemHierarchy(ItemHierarchy itemHierarchy, ItemHierarchy overwriteIH) {
        List calMemberList;
        List propertyOverride = itemHierarchy.getPropertyOverride();
        LogicalModuleResolver.overwriteObjectType((ObjectType)itemHierarchy, (ObjectType)overwriteIH);
        List localRefList = overwriteIH.basicGetLocalRef();
        if (localRefList != null && !localRefList.isEmpty()) {
            List localRef = itemHierarchy.getLocalRef();
            localRef.clear();
            localRef.addAll(localRefList);
            propertyOverride.add("localRef");
        }
        if ((calMemberList = overwriteIH.basicGetCalculatedMember()) != null && !calMemberList.isEmpty()) {
            LogicalModuleResolver.overwriteCalculatedMembers(itemHierarchy.getCalculatedMember(), overwriteIH.getCalculatedMember());
        }
    }

    private static void overwriteCalculatedMembers(List<CalculatedMemberType> calcMembList, List<CalculatedMemberType> overwriteCalcMembList) {
        Map<String, CalculatedMemberType> calculatedMemberDictionary = LogicalModuleResolver.createCMDictionary(overwriteCalcMembList);
        for (CalculatedMemberType calcMember : calcMembList) {
            CalculatedMemberType overwriteCM = calculatedMemberDictionary.remove(calcMember.getIdentifier());
            if (overwriteCM == null) continue;
            LogicalModuleResolver.overwriteObjectType((ObjectType)calcMember, (ObjectType)overwriteCM);
        }
        Collection<CalculatedMemberType> remainingCM = calculatedMemberDictionary.values();
        if (!remainingCM.isEmpty()) {
            for (CalculatedMemberType cm : remainingCM) {
                cm.getPropertyOverride().add("NEW");
                calcMembList.add(cm);
            }
        }
    }

    private static void overwriteObjectType(ObjectType objectType, ObjectType overwriteObjectType) {
        List propertyOverride = objectType.getPropertyOverride();
        objectType.setIdentifier(overwriteObjectType.getIdentifier());
        objectType.setLabel(LogicalModuleResolver.overwriteStringValue(objectType.getLabel(), overwriteObjectType.getLabel(), "label", propertyOverride));
        objectType.setComment(LogicalModuleResolver.overwriteStringValue(objectType.getComment(), overwriteObjectType.getComment(), "comment", propertyOverride));
        objectType.setDescription(LogicalModuleResolver.overwriteStringValue(objectType.getDescription(), overwriteObjectType.getDescription(), "description", propertyOverride));
        objectType.setScreenTip(LogicalModuleResolver.overwriteStringValue(objectType.getScreenTip(), overwriteObjectType.getScreenTip(), "screenTip", propertyOverride));
        if (overwriteObjectType.isHidden() != null) {
            objectType.setHidden(overwriteObjectType.isHidden());
            propertyOverride.add("hidden");
        }
        LogicalModuleResolver.overwriteObjectTypePropertyProperty(objectType, overwriteObjectType);
        for (String s : overwriteObjectType.getPropertyOverride()) {
            if (propertyOverride.contains(s)) continue;
            propertyOverride.add(s);
        }
    }

    private static void overwriteObjectTypePropertyProperty(ObjectType objectType, ObjectType overwriteObjectType) {
        List propertyOverride = objectType.getPropertyOverride();
        for (PropertyType prop : overwriteObjectType.getProperty()) {
            CommonResolverUtil.setProperty((ObjectType)objectType, (String)prop.getName(), (String)prop.getValue());
            propertyOverride.add("property." + prop.getName());
        }
    }

    private static void updateQuerySubjectFilterOverrideList(List<Filter> filters) {
        for (Filter f : filters) {
            f.addPropertyOverride("NEW");
        }
    }

    private static void overwriteItemType(ObjectType item, ObjectType overwriteItem) {
        String objectType = item.getObjectType();
        if (objectType.equals(overwriteItem.getObjectType())) {
            switch (objectType) {
                case "Filter": {
                    LogicalModuleResolver.overwriteFilter((Filter)item, (Filter)overwriteItem);
                    break;
                }
                case "Folder": {
                    LogicalModuleResolver.overwriteFolder((ItemType.Folder)item, (ItemType.Folder)overwriteItem);
                    break;
                }
                case "ItemHierarchy": {
                    LogicalModuleResolver.overwriteItemHierarchy((ItemHierarchy)item, (ItemHierarchy)overwriteItem);
                    break;
                }
                case "NamedSet": {
                    LogicalModuleResolver.overwriteNamedSet((NamedSet)item, (NamedSet)overwriteItem);
                    break;
                }
                case "Calculation": {
                    LogicalModuleResolver.overwriteCalculation((Calculation)item, (Calculation)overwriteItem);
                    break;
                }
                default: {
                    LogicalModuleResolver.overwriteQueryItem((QueryItem)item, (QueryItem)overwriteItem);
                }
            }
        }
    }

    private static void overwriteFilter(Filter filter, Filter overwriteFilter) {
        LogicalModuleResolver.overwriteObjectType((ObjectType)filter, (ObjectType)overwriteFilter);
    }

    private static void overwriteFolder(ItemType.Folder folder, ItemType.Folder overwriteFolder) {
        LogicalModuleResolver.overwriteObjectType((ObjectType)folder, (ObjectType)overwriteFolder);
    }

    private static void overwriteNamedSet(NamedSet namedSet, NamedSet overwriteNamedSet) {
        LogicalModuleResolver.overwriteBaseQueryItemType((BaseQueryItemType)namedSet, (BaseQueryItemType)overwriteNamedSet);
    }

    private static void overwriteCalculation(Calculation calc, Calculation overwriteCalc) {
        LogicalModuleResolver.overwriteBaseQueryItemType((BaseQueryItemType)calc, (BaseQueryItemType)overwriteCalc);
    }

    private static void overwriteQueryItem(QueryItem queryItem, QueryItem overwriteQueryItem) {
        LogicalModuleResolver.overwriteBaseQueryItemType((BaseQueryItemType)queryItem, (BaseQueryItemType)overwriteQueryItem);
        if (overwriteQueryItem.basicGetCalculatedMember() != null) {
            LogicalModuleResolver.overwriteCalculatedMembers(queryItem.getCalculatedMember(), overwriteQueryItem.getCalculatedMember());
        }
    }

    private static void overwriteBaseQueryItemType(BaseQueryItemType baseQueryItemType, BaseQueryItemType overwriteBaseQueryItemType) {
        List propertyOverride = baseQueryItemType.getPropertyOverride();
        if (overwriteBaseQueryItemType.getUsage() != null) {
            baseQueryItemType.setUsage(overwriteBaseQueryItemType.getUsage());
            propertyOverride.add("usage");
        }
        if (overwriteBaseQueryItemType.getRegularAggregate() != null) {
            baseQueryItemType.setRegularAggregate(overwriteBaseQueryItemType.getRegularAggregate());
            propertyOverride.add("regularAggregate");
        }
        if (overwriteBaseQueryItemType.getFacetDefinition() != null) {
            baseQueryItemType.setFacetDefinition(overwriteBaseQueryItemType.getFacetDefinition());
            propertyOverride.add("facetDefinition");
        }
        if (overwriteBaseQueryItemType.getFormat() != null) {
            baseQueryItemType.setFormat(overwriteBaseQueryItemType.getFormat());
            propertyOverride.add("format");
        }
        LogicalModuleResolver.overwriteObjectType((ObjectType)baseQueryItemType, (ObjectType)overwriteBaseQueryItemType);
        LogicalModuleResolver.overwriteBaseQueryItemTypeTaxonomy(baseQueryItemType, overwriteBaseQueryItemType);
    }

    private static void overwriteBaseQueryItemTypeTaxonomy(BaseQueryItemType baseQueryItemType, BaseQueryItemType overwriteBaseQueryItemType) {
        List propOverride = overwriteBaseQueryItemType.basicGetPropertyOverride();
        if (!DataModuleExtractor.propertyOverrideContains((List)propOverride, (String)"taxonomy")) {
            return;
        }
        List overwriteTaxonomy = overwriteBaseQueryItemType.basicGetTaxonomy();
        List originalTaxonomy = baseQueryItemType.basicGetTaxonomy();
        if (originalTaxonomy != null) {
            originalTaxonomy.clear();
        }
        if (overwriteTaxonomy == null || overwriteTaxonomy.isEmpty()) {
            return;
        }
        for (TaxonomyType overwriteT : overwriteTaxonomy) {
            try {
                baseQueryItemType.addTaxonomy((TaxonomyType)overwriteT.clone());
            }
            catch (CloneNotSupportedException e) {
                LoggerAdapter.errorExceptionStack(LogicalModuleResolver.class, e);
            }
        }
    }

    private void resolveLogicalModuleRelationships(String module) {
        ResolverModuleWrapper currentModule = this.getModuleWrapper(module);
        HashMap relationshipDictionaries = new HashMap();
        for (Module.UseSpec use : currentModule.getUseSpec()) {
            ResolverModuleWrapper referencedModule;
            String moduleAlias = use.getIdentifier();
            HashMap<String, Relationship> relationshipDictionary = (HashMap<String, Relationship>)relationshipDictionaries.get(moduleAlias);
            if (relationshipDictionary == null) {
                relationshipDictionary = new HashMap<String, Relationship>();
                relationshipDictionaries.put(moduleAlias, relationshipDictionary);
            }
            if ((referencedModule = this.getModuleWrapper(use.getStoreID())) == null) continue;
            for (Relationship relationship : referencedModule.getRelationship()) {
                String referencedRelationshipID = moduleAlias + "." + relationship.getIdentifier();
                relationshipDictionary.put(referencedRelationshipID, relationship);
            }
        }
        List<Relationship> relationships = currentModule.getRelationship();
        ArrayList<Relationship> toRemove = new ArrayList<Relationship>();
        for (int i = 0; i < relationships.size(); ++i) {
            String relationshipRef;
            Relationship relationship = relationships.get(i);
            if (!LogicalModuleResolver.isReference((ObjectType)relationship, relationshipRef = relationship.getRef())) continue;
            String referencedModuleAlias = ReferenceResolver.getFirstPart((String)relationship.getRef());
            Map relationshipDictionary = (Map)relationshipDictionaries.get(referencedModuleAlias);
            Relationship referencedRelationship = null;
            if (relationshipDictionary == null) {
                relationship.setInstanceType(InstanceType.MISSING);
            } else {
                referencedRelationship = (Relationship)relationshipDictionary.get(relationshipRef);
            }
            if (referencedRelationship == null || referencedRelationship.getInstanceType() == InstanceType.MISSING) {
                relationship.setInstanceType(InstanceType.MISSING);
                toRemove.add(relationship);
                continue;
            }
            referencedRelationship = ModuleUtil.cloneRelationship(referencedRelationship);
            referencedRelationship.getPropertyOverride().clear();
            LogicalModuleResolver.overwriteObjectType((ObjectType)referencedRelationship, (ObjectType)relationship);
            referencedRelationship.setInstanceType(relationship.getInstanceType());
            if (referencedRelationship.getLeft() == null || referencedRelationship.getRight() == null) {
                toRemove.add(relationship);
                continue;
            }
            String leftQSRef = referencedModuleAlias + "." + referencedRelationship.getLeft().getRef();
            String rightQSRef = referencedModuleAlias + "." + referencedRelationship.getRight().getRef();
            QuerySubject leftQS = null;
            QuerySubject rightQS = null;
            for (QuerySubject qs : currentModule.getQuerySubject()) {
                for (String qsRef : qs.getRef()) {
                    if (qsRef.equals(leftQSRef)) {
                        leftQS = qs;
                        continue;
                    }
                    if (!qsRef.equals(rightQSRef)) continue;
                    rightQS = qs;
                }
                if (leftQS == null || rightQS == null) continue;
                break;
            }
            if (leftQS == null || rightQS == null) {
                toRemove.add(relationship);
                continue;
            }
            referencedRelationship.getLeft().setRef(leftQS.getIdentifier());
            referencedRelationship.getRight().setRef(rightQS.getIdentifier());
            referencedRelationship.setRef(relationshipRef);
            relationships.set(i, referencedRelationship);
        }
        relationships.removeAll(toRemove);
    }

    private static String overwriteStringValue(String v1, String v2, String propertyName, List<String> propertyOverride) {
        if (v2 != null && !v2.isEmpty()) {
            propertyOverride.add(propertyName);
            return v2;
        }
        return v1;
    }

    private static boolean isLeafVertex(ResolverModuleWrapper module) {
        return LogicalModuleResolver.isLeafVertexByTypes(module, TYPES_NOT_LEAF);
    }

    private static boolean isLeafVertexByTypes(ResolverModuleWrapper module, Set<UseSpecType> types) {
        if (module == null) {
            return true;
        }
        UseSpecType type = module.getType();
        return !types.contains(type);
    }

    private static boolean isReference(ObjectType obj, String ref) {
        if (ref == null || ref.isEmpty()) {
            return false;
        }
        if (obj instanceof QuerySubject) {
            QuerySubject qs = (QuerySubject)obj;
            if (qs.getInstanceType() == null) {
                return false;
            }
            return qs.getInstanceType().equals((Object)InstanceType.REFERENCE);
        }
        if (obj instanceof Relationship) {
            Relationship re = (Relationship)obj;
            if (re.getInstanceType() == null) {
                return false;
            }
            return re.getInstanceType().equals((Object)InstanceType.REFERENCE);
        }
        return false;
    }

    private StringBuilder dumpDependencyStack(List<String> dependencyStack, String vertex) {
        int i;
        StringBuilder msg = new StringBuilder();
        int n = i = vertex != null ? dependencyStack.indexOf(vertex) : 0;
        while (i < dependencyStack.size()) {
            String stackEntry = dependencyStack.get(i);
            this.buildDependencyStackEntryMessage(stackEntry, msg);
            ++i;
        }
        if (vertex != null) {
            this.buildDependencyStackEntryMessage(vertex, msg);
        }
        return msg;
    }

    private void buildDependencyStackEntryMessage(String vertex, StringBuilder msg) {
        ResolverModuleWrapper wrapper = this.getModuleWrapper(vertex);
        msg.append(LogicalModuleResolver.getStoreId(wrapper));
        msg.append("-");
        msg.append(LogicalModuleResolver.getModuleIdentifier(wrapper));
        msg.append("\n");
    }

    private boolean unwindReference(ResolverModuleWrapper currentModule, List<String> qsRefs, int pos) {
        String ref = qsRefs.get(pos);
        String[] parts = ref.split("\\.");
        if (parts.length < 2) {
            return true;
        }
        if (this.isPackage(parts[0], currentModule)) {
            return true;
        }
        ResolverModuleWrapper srcModule = this.getModuleWrapperByAlias(parts, currentModule);
        if (srcModule == null) {
            return false;
        }
        return this.unwindLegacyRefXQE(currentModule, qsRefs, pos, parts, srcModule);
    }

    private boolean isPackage(String alias, ResolverModuleWrapper moduleWrapper) {
        ResolverModuleWrapper src = this.getChildModuleByAlias(alias, moduleWrapper);
        return src != null && UseSpecType.PACKAGE.equals((Object)src.type);
    }

    private boolean unwindLegacyRefXQE(ResolverModuleWrapper currentModule, List<String> qsRefs, int pos, String[] parts, ResolverModuleWrapper srcModule) {
        if (this.metadataContext != MoserMetadataContext.XQEWHOLE) {
            return true;
        }
        if (parts.length <= 2) {
            return true;
        }
        if (srcModule == null) {
            return false;
        }
        String existAlias = currentModule.getUseSpecAlias(srcModule.getStoreId());
        if (existAlias != null) {
            String ref = existAlias + "." + parts[parts.length - 1];
            qsRefs.set(pos, ref);
            return true;
        }
        String newAlias = LogicalModuleResolver.getNextModuleAlias(currentModule);
        String ref = newAlias + "." + parts[parts.length - 1];
        qsRefs.set(pos, ref);
        ObjectFactory factory = new ObjectFactory();
        Module.UseSpec localUseSpec = factory.createModuleUseSpec();
        localUseSpec.setIdentifier(newAlias);
        localUseSpec.setSearchPath(srcModule.getSearchPath());
        localUseSpec.setStoreID(srcModule.getStoreId());
        localUseSpec.setType(srcModule.getType());
        currentModule.getUseSpec().add(localUseSpec);
        return true;
    }

    private static String getNextModuleAlias(ResolverModuleWrapper currentModule) {
        HashSet<String> exists = new HashSet<String>();
        for (Module.UseSpec use : currentModule.getUseSpec()) {
            String a = use.getIdentifier();
            exists.add(a);
        }
        String m = MODULE_ALIAS_PREFIX;
        int i = 1;
        String alias = m + i;
        while (exists.contains(alias)) {
            alias = m + ++i;
        }
        return alias;
    }

    private ResolverModuleWrapper getModuleWrapperByAlias(String[] refPath, ResolverModuleWrapper currentModule) {
        ResolverModuleWrapper rt = null;
        ResolverModuleWrapper current = currentModule;
        for (int i = 0; i < refPath.length - 1; ++i) {
            ResolverModuleWrapper src = this.getChildModuleByAlias(refPath[i], current);
            if (src == null) {
                return null;
            }
            rt = src;
            current = src;
        }
        return rt;
    }

    private ResolverModuleWrapper getChildModuleByAlias(String alias, ResolverModuleWrapper currentModule) {
        for (Module.UseSpec use : currentModule.getUseSpec()) {
            String a = use.getIdentifier();
            if (!alias.equals(a)) continue;
            return this.getModuleWrapper(use.getStoreID());
        }
        return null;
    }

    private static TreeSet<String> getReferencedObjectnames(ResolverModuleWrapper currentModule, TreeSet<String> required) {
        TreeSet<String> rt = new TreeSet<String>();
        List<QuerySubject> allQSs = currentModule.getQuerySubject();
        for (QuerySubject aQS : allQSs) {
            List refs;
            String name;
            if (required != null && !required.contains(name = aQS.getIdentifier()) || (refs = aQS.getRef()) == null) continue;
            rt.addAll(refs);
        }
        return rt;
    }

    private boolean distributeReferencedObjects(ResolverModuleWrapper currentModule, TreeSet<String> required) {
        TreeSet<String> refObjects = LogicalModuleResolver.getReferencedObjectnames(currentModule, required);
        for (String ref : refObjects) {
            String[] parts = ref.split("\\.");
            if (this.distributeToSubModule(currentModule, parts)) continue;
            return false;
        }
        for (Module.UseSpec use : currentModule.getUseSpec()) {
            boolean b;
            TreeSet<String> subRequired;
            ResolverModuleWrapper subModule = this.getModuleWrapper(use.getStoreID());
            if (subModule == null) {
                return false;
            }
            if (LogicalModuleResolver.isLeafVertex(subModule) || (subRequired = this.getRequiredObjects(subModule.getStoreId())) == null || (b = this.distributeReferencedObjects(subModule, subRequired))) continue;
            return false;
        }
        return true;
    }

    private TreeSet<String> getRequiredObjects(String id) {
        return this.requiredObjects.get(id);
    }

    private boolean distributeToSubModule(ResolverModuleWrapper currentModule, String[] parts) {
        if (parts.length == 0) {
            return false;
        }
        if (parts.length == 1) {
            String id = currentModule.getStoreId();
            TreeSet<String> rt = this.getRequiredObjects(id);
            if (rt == null) {
                rt = new TreeSet();
                this.requiredObjects.put(id, rt);
            }
            rt.add(parts[0]);
            return true;
        }
        String alias = parts[0];
        ResolverModuleWrapper subModule = this.getChildModuleByAlias(alias, currentModule);
        if (subModule == null) {
            return false;
        }
        String[] subParts = new String[parts.length - 1];
        System.arraycopy(parts, 1, subParts, 0, subParts.length);
        return this.distributeToSubModule(subModule, subParts);
    }

    private static void cleanUseSpec(Module module, Set<String> subModuleIds) {
        ArrayList<Module.UseSpec> toRemove = new ArrayList<Module.UseSpec>();
        List definedUseSpec = module.getUseSpec();
        for (Module.UseSpec use : definedUseSpec) {
            if (ModuleUtil.isPackageOrLWModuleOrReport(use.getType()) || subModuleIds.contains(use.getStoreID())) continue;
            toRemove.add(use);
        }
        definedUseSpec.removeAll(toRemove);
    }

    private void returnAllSubModules(IModuleObjectManager mm, Map<String, Module> subModules) {
        for (Map.Entry<String, ResolverModuleWrapper> entry : this.seenModules.entrySet()) {
            String physicalDef;
            String storeId = entry.getKey();
            ResolverModuleWrapper wrapper = entry.getValue();
            if (wrapper.topModule || UseSpecType.PACKAGE.equals((Object)wrapper.getType())) continue;
            Module module = wrapper.getModule();
            module.getRelationship().clear();
            module.getCalculation().clear();
            module.getFilter().clear();
            module.getMetadataTreeView().clear();
            subModules.put(storeId, module);
            if (!UseSpecType.DATABASE.equals((Object)wrapper.getType()) && !UseSpecType.FILE.equals((Object)wrapper.getType()) && !UseSpecType.DATASET.equals((Object)wrapper.getType()) && !UseSpecType.LW_OLAP.equals((Object)wrapper.getType()) || (physicalDef = (String)wrapper.theModuleDef.get((Object)"physicalDefinition")) == null || physicalDef.isEmpty()) continue;
            ModuleObjectManagerCM cm = (ModuleObjectManagerCM)mm;
            Module retPhysical = cm.decodeModule(physicalDef, null, null);
            if (UseSpecType.DATABASE.equals((Object)wrapper.getType())) {
                cm.updateDataSourceFromAncestor(retPhysical, (JSONArray)wrapper.theModuleDef.get((Object)"ancestors"));
                WKCUtil.updateJDBCConnection(mm, retPhysical);
            }
            subModules.put(storeId + ".physicalmodule", retPhysical);
        }
    }

    private void returnRequiredModules(IModuleObjectManager mm, Map<String, Module> subModules) {
        for (Map.Entry<String, ResolverModuleWrapper> entry : this.seenModules.entrySet()) {
            Module retPhysical;
            Module module;
            String storeId = entry.getKey();
            ResolverModuleWrapper wrapper = entry.getValue();
            if (wrapper.topModule || TYPES_PKG_REPORT.contains(wrapper.getType()) || (module = wrapper.getModule()) == null) continue;
            module.getRelationship().clear();
            module.getCalculation().clear();
            module.getFilter().clear();
            module.getMetadataTreeView().clear();
            if (!UseSpecType.WA_DATA_ASSET.equals((Object)wrapper.getType()) && !UseSpecType.URL.equals((Object)wrapper.getType())) {
                subModules.put(storeId, module);
            }
            if (!UseSpecType.DATABASE.equals((Object)wrapper.getType()) && !UseSpecType.FILE.equals((Object)wrapper.getType()) && !UseSpecType.DATASET.equals((Object)wrapper.getType()) && !UseSpecType.LW_OLAP.equals((Object)wrapper.getType())) continue;
            ModuleObjectManagerCM cm = (ModuleObjectManagerCM)mm;
            String physicalDef = (String)wrapper.theModuleDef.get((Object)"physicalDefinition");
            if (physicalDef == null || physicalDef.isEmpty() || (retPhysical = cm.decodeModule(physicalDef, null, null)) == null) continue;
            if (UseSpecType.DATABASE.equals((Object)wrapper.getType())) {
                cm.updateDataSourceFromAncestor(retPhysical, (JSONArray)wrapper.theModuleDef.get((Object)"ancestors"));
                WKCUtil.updateJDBCConnection(mm, retPhysical);
            }
            subModules.put(storeId + ".physicalmodule", retPhysical);
        }
    }

    static {
        TYPES_NOT_LEAF.add(UseSpecType.MODULE);
        TYPES_PKG_REPORT.add(UseSpecType.PACKAGE);
        TYPES_PKG_REPORT.add(UseSpecType.REPORT);
    }

    private static final class ResolverModuleWrapper {
        protected boolean topModule;
        protected UseSpecType type;
        protected String storeId;
        protected String searchPath;
        protected Module theModule;
        protected JSONObject theModuleDef;
        protected String packageName;

        private ResolverModuleWrapper() {
        }

        protected String getStoreId() {
            return this.storeId;
        }

        protected String getSearchPath() {
            return this.searchPath;
        }

        protected Module getModule() {
            return this.theModule;
        }

        protected UseSpecType getType() {
            return this.type;
        }

        protected List<Module.UseSpec> getUseSpec() {
            if (this.theModule != null) {
                return this.theModule.getUseSpec();
            }
            return new ArrayList<Module.UseSpec>();
        }

        protected List<QuerySubject> getQuerySubject() {
            if (this.theModule != null) {
                return this.theModule.getQuerySubject();
            }
            return new ArrayList<QuerySubject>();
        }

        protected List<Relationship> getRelationship() {
            if (this.theModule != null) {
                return this.theModule.getRelationship();
            }
            return new ArrayList<Relationship>();
        }

        protected String getUseSpecAlias(String sId) {
            for (Module.UseSpec use : this.getUseSpec()) {
                if (!sId.equals(use.getStoreID())) continue;
                return use.getIdentifier();
            }
            return null;
        }

        protected boolean isEmpty() {
            return this.storeId == null && this.searchPath == null && this.theModule == null && this.packageName == null && this.type == null;
        }
    }

    private static final class ModuleWrapperLoader
    implements Runnable {
        private final IModuleObjectManager mm;
        private final Module.UseSpec useSpec;
        private final ResolverModuleWrapper wrapper;
        private final ResolverModuleWrapper currentModuleWrapper;
        private final MoserMetadataContext metadataContext;
        private final List<String> metadataIDs;
        private final ArrayBlockingQueue<Boolean> threadQueue;

        public ModuleWrapperLoader(IModuleObjectManager mm, Module.UseSpec useSpec, ResolverModuleWrapper wrapper, ResolverModuleWrapper currentModuleWrapper, MoserMetadataContext metadataContext, List<String> metadataIDs, ArrayBlockingQueue<Boolean> threadQueue) {
            this.mm = mm;
            this.useSpec = useSpec;
            this.wrapper = wrapper;
            this.currentModuleWrapper = currentModuleWrapper;
            this.metadataContext = metadataContext;
            this.metadataIDs = metadataIDs;
            this.threadQueue = threadQueue;
        }

        @Override
        public void run() {
            try {
                this.threadQueue.put(Boolean.TRUE);
                try {
                    ModuleUseSpecUpdater updater;
                    this.loadModule();
                    if (this.wrapper.isEmpty() && (updater = new ModuleUseSpecUpdater(this.mm.getReqEnvironment(), this.useSpec)).update()) {
                        this.loadModule();
                    }
                }
                finally {
                    this.threadQueue.take();
                }
            }
            catch (InterruptedException e) {
                LoggerAdapter.errorExceptionStack(this, e);
            }
        }

        private void loadModule() {
            switch (this.useSpec.getType()) {
                case MODULE: {
                    LogicalModuleResolver.getBusinessModule(this.mm, this.wrapper, this.useSpec);
                    break;
                }
                case DATABASE: {
                    LogicalModuleResolver.getBaseModuleForDatabase(this.mm, this.wrapper, this.useSpec, this.metadataContext);
                    break;
                }
                case PACKAGE: {
                    LogicalModuleResolver.getModuleWrapperForPackage(this.mm, this.wrapper, this.useSpec, this.metadataContext, this.currentModuleWrapper, this.metadataIDs);
                    break;
                }
                case LW_OLAP: {
                    LogicalModuleResolver.getModuleWrapperForLWOLAP(this.mm, this.wrapper, this.useSpec);
                    break;
                }
                case REPORT: {
                    LogicalModuleResolver.getModuleWrapperForReport(this.mm, this.wrapper, this.useSpec);
                    break;
                }
                default: {
                    LogicalModuleResolver.getBaseModule(this.mm, this.wrapper, this.useSpec, this.metadataContext);
                }
            }
        }

        public ResolverModuleWrapper getWrapper() {
            return this.wrapper;
        }

        public Module.UseSpec getUseSpec() {
            return this.useSpec;
        }
    }
}

