/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.util;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Column;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.EditModeType;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.PhysicalObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.SourceCategoryType;
import com.ibm.bi.platform.moser.common.generated.metadata.Table;
import com.ibm.bi.platform.moser.common.generated.metadata.TableItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.module.util.DataModuleExtractor;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ModuleUtil {
    private static final String NULL_STRING = "null";

    private ModuleUtil() {
    }

    public static String buildUniqueModuleIdentifier(String use, String identifier) {
        String[] parts = use.split("\\.");
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.isEmpty()) {
                buff.append("nl");
            } else {
                buff.append(part.charAt(0));
                buff.append(part.charAt(part.length() - 1));
            }
            if (i >= parts.length - 1) continue;
            buff.append('_');
        }
        buff.append(".");
        buff.append(identifier);
        return buff.toString();
    }

    public static String getIdentifier(BaseObjectType obj) {
        if (obj instanceof PhysicalObjectType) {
            return ((PhysicalObjectType)obj).getName();
        }
        if (obj instanceof ObjectType) {
            return ((ObjectType)obj).getIdentifier();
        }
        return null;
    }

    public static void setIdentifier(BaseObjectType obj, String id) {
        if (obj instanceof PhysicalObjectType) {
            ((PhysicalObjectType)obj).setName(id);
        } else if (obj instanceof ObjectType) {
            ((ObjectType)obj).setIdentifier(id);
        }
    }

    public static BaseObjectType getTableOrQuerySubject(String identifier, Module module) {
        List datasources = module.getDataSource();
        for (DataSource ds : datasources) {
            List tables = ds.getTable();
            for (Table table : tables) {
                if (!table.getName().equals(identifier)) continue;
                return table;
            }
        }
        return ModuleUtil.getQuerySubject(identifier, module);
    }

    public static QuerySubject getQuerySubject(String identifier, Module module) {
        return module.getQuerySubject().stream().filter(qs -> identifier.equals(qs.getIdentifier())).findFirst().orElse(null);
    }

    public static Module cloneModule(Module originalModule) {
        return (Module)ModuleUtil.cloneBaseObjectType((BaseObjectType)originalModule);
    }

    public static QuerySubject cloneQuerySubject(QuerySubject originalQuerySubject) {
        return (QuerySubject)ModuleUtil.cloneBaseObjectType((BaseObjectType)originalQuerySubject);
    }

    public static QueryItem cloneQueryItem(QueryItem originalQueryItem) {
        return (QueryItem)ModuleUtil.cloneBaseObjectType((BaseObjectType)originalQueryItem);
    }

    public static Relationship cloneRelationship(Relationship originalRelationship) {
        return (Relationship)ModuleUtil.cloneBaseObjectType((BaseObjectType)originalRelationship);
    }

    public static Calculation cloneCalculation(Calculation originalCalculation) {
        return (Calculation)ModuleUtil.cloneBaseObjectType((BaseObjectType)originalCalculation);
    }

    public static Filter cloneFilter(Filter originalFilter) {
        return (Filter)ModuleUtil.cloneBaseObjectType((BaseObjectType)originalFilter);
    }

    private static BaseObjectType cloneBaseObjectType(BaseObjectType originalObject) {
        BaseObjectType object = null;
        try {
            object = (BaseObjectType)originalObject.clone();
        }
        catch (CloneNotSupportedException e) {
            LoggerAdapter.errorExceptionStack(ModuleUtil.class, e);
        }
        return object;
    }

    public static boolean isMatching(String str1, String str2) {
        String cmpStr1 = str1;
        if (str1 == null || NULL_STRING.equalsIgnoreCase(str1)) {
            cmpStr1 = "";
        }
        String cmpStr2 = str2;
        if (str2 == null || NULL_STRING.equalsIgnoreCase(str2)) {
            cmpStr2 = "";
        }
        return cmpStr1.equals(cmpStr2);
    }

    public static BaseObjectType findQueryItemOrColumn(Module module, String sourceColumn) {
        String[] parts = sourceColumn.split("\\.");
        String qsName = parts[0];
        String colName = parts[1];
        BaseObjectType qs = ModuleUtil.getTableOrQuerySubject(qsName, module);
        if (qs != null) {
            if (qs instanceof QuerySubject) {
                return MoserObjectUtils.getQueryItems((QuerySubject)((QuerySubject)qs)).stream().filter(qi -> qi.getIdentifier().equals(colName)).findAny().orElse(null);
            }
            if (qs instanceof Table) {
                List tableItem = ((Table)qs).getTableItem();
                for (TableItemType tableItemType : tableItem) {
                    if (!tableItemType.getColumn().getName().equals(colName)) continue;
                    return tableItemType.getColumn();
                }
            }
        }
        return null;
    }

    public static boolean isBaseModule(Module module) {
        if (module.getIdentifier().endsWith(".base")) {
            return true;
        }
        for (String use : module.getUse()) {
            if (!use.endsWith(".physicalmodule")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPackageOrLWModuleOrReport(UseSpecType type) {
        return ModuleUtil.isPackageOrLWModule(type) || UseSpecType.REPORT.equals((Object)type);
    }

    public static boolean isPackageOrLWModule(UseSpecType type) {
        return UseSpecType.PACKAGE.equals((Object)type) || UseSpecType.LW_OLAP.equals((Object)type);
    }

    public static boolean isLWOLAP(Module module) {
        return module.getUseSpec().size() == 1 && UseSpecType.LW_OLAP.equals((Object)((Module.UseSpec)module.getUseSpec().get(0)).getType());
    }

    public static boolean isEmbeddedModule(Module module) {
        if (module != null) {
            return DataModuleExtractor.isEmbeddedModule((List)module.getUseSpec());
        }
        return false;
    }

    public static String getEmbeddedModuleSource(Module module) {
        return ((Module.UseSpec)module.getUseSpec().get(0)).getStoreID();
    }

    public static void adjustExpressionsForUnsupportedDataTypes(Module module) {
        if (module.basicGetQuerySubject() != null) {
            for (QuerySubject qs : module.basicGetQuerySubject()) {
                for (QueryItem qi : MoserObjectUtils.getQueryItems((QuerySubject)qs)) {
                    if (qi.getSourceCategory() != SourceCategoryType.COLUMN && qi.getSourceCategory() != SourceCategoryType.CALCULATION && qi.getSourceCategory() != SourceCategoryType.MEASURE && qi.getSourceCategory() != SourceCategoryType.PROPERTY) continue;
                    ModuleUtil.adjustExpressionIfNotSupported((BaseQueryItemType)qi, null);
                }
            }
        }
        if (module.basicGetCalculation() != null) {
            for (Calculation calc : module.basicGetCalculation()) {
                ModuleUtil.adjustExpressionIfNotSupported((BaseQueryItemType)calc, null);
            }
        }
    }

    public static boolean adjustExpressionIfNotSupported(BaseQueryItemType qi, Column column) {
        String dtWithSize;
        int index;
        if (qi.getDatatype() == null) {
            qi.setDatatype("UNKNOWN");
        }
        if ((index = (dtWithSize = qi.getDatatype().toUpperCase(Locale.ENGLISH)).indexOf(40)) != -1) {
            dtWithSize = dtWithSize.substring(0, index);
        }
        if ((index = dtWithSize.indexOf(32)) != -1) {
            dtWithSize = dtWithSize.substring(0, index);
        }
        if ((index = dtWithSize.indexOf(95)) != -1) {
            dtWithSize = dtWithSize.substring(0, index);
        }
        String dtForSearch = "," + dtWithSize + ",";
        if (!MoserConfig.getInstance().getSupportedDataTypes().contains(dtForSearch)) {
            String unsupportedDatatype = column != null ? column.getVendorType() : qi.getDatatype();
            qi.setExpression("'<unsupported: " + unsupportedDatatype + ">'");
            qi.setUsage(UsageType.ATTRIBUTE);
            qi.setRegularAggregate(RegularAggregateType.NONE);
            qi.setHidden(Boolean.TRUE);
            if (column != null) {
                column.setHidden(Boolean.TRUE);
            }
            return true;
        }
        return false;
    }

    public static boolean moduleNeedUpgradeForPK(Module module) {
        if (module == null) {
            return false;
        }
        float orgVer = module.getOriginalVersion();
        return orgVer > 0.0f && orgVer <= 9.0f;
    }

    public static void setEditMode(MoserObject node, EditModeType mode) {
        if (node instanceof ObjectType) {
            ((ObjectType)node).setEditMode(mode);
        }
        Class<?> objClass = node.getClass();
        ArrayList allFields = new ArrayList();
        for (Class<?> currentClass = objClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(allFields, declaredFields);
        }
        for (Field field : allFields) {
            if (Modifier.isStatic(field.getModifiers()) || field.getName().startsWith("_")) continue;
            field.setAccessible(true);
            try {
                Object obj = field.get(node);
                if (obj instanceof MoserObject) {
                    ModuleUtil.setEditMode((MoserObject)obj, mode);
                    continue;
                }
                if (!(obj instanceof List)) continue;
                List list = (List)obj;
                for (Object child : list) {
                    if (!(child instanceof MoserObject)) continue;
                    ModuleUtil.setEditMode((MoserObject)child, mode);
                }
            }
            catch (IllegalAccessException ex) {
                throw new MoserException((Throwable)ex);
            }
        }
    }
}

