/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.utils.IdentifierUtil;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.metadata.util.ModuleWrapper;
import com.ibm.bi.platform.moser.core.module.verify.IVerifyObject;
import com.ibm.bi.platform.moser.core.module.verify.VCheckSyntaxErrorHandler;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VModule;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.validation.Validator;

public class VBaseObject
implements IVerifyObject {
    protected ObjectType mObj;
    protected VBaseObject mParentVObj;
    protected Locale mLocale;
    protected int mIndex;
    private static final String IDENTIFIER = "identifier";

    public VBaseObject(ObjectType obj, VBaseObject parent, int index) {
        this.mObj = obj;
        this.mParentVObj = parent;
        this.mIndex = index + 1;
        if (parent != null) {
            this.mLocale = parent.mLocale;
        }
    }

    @Override
    public void verify(VContext context, VResults results) {
        if (context.getSeverityError() && context.getCategoryIdentifier()) {
            this.verifyIdentifier(results);
        }
    }

    protected void checkSyntax(Validator validator, JAXBContext jc, VResults results) {
        String locmsg;
        JAXBSource source = null;
        try {
            source = new JAXBSource(jc, (Object)this.mObj);
        }
        catch (JAXBException e) {
            LoggerAdapter.trace(VBaseObject.class, e.getLocalizedMessage(), e);
            IMessageKey.Param0 key = MoserError.MSR_VRF_ERROR_SYNTAX_EXCEPTION;
            String locmsg2 = MoserMessages.getMessage((IMessageKey.Param0)key, (Locale)this.mLocale);
            this.addMessage(results, VContext.ECategory.SYNTAX, VContext.ESeverity.ERROR, locmsg2, this.getPath());
            return;
        }
        VCheckSyntaxErrorHandler errorHandler = new VCheckSyntaxErrorHandler();
        validator.setErrorHandler(errorHandler);
        try {
            validator.validate((Source)source);
        }
        catch (Exception e) {
            LoggerAdapter.trace(VBaseObject.class, e.getLocalizedMessage(), e);
            IMessageKey.Param0 key = MoserError.MSR_VRF_ERROR_SYNTAX_EXCEPTION;
            String locmsg3 = MoserMessages.getMessage((IMessageKey.Param0)key, (Locale)this.mLocale);
            this.addMessage(results, VContext.ECategory.SYNTAX, VContext.ESeverity.ERROR, locmsg3, this.getPath());
            return;
        }
        List<String> warnings = errorHandler.getWarnings();
        for (String w : warnings) {
            IMessageKey.Param1 key = MoserError.MSR_VRF_WARNING_SYNTAX;
            locmsg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.mLocale, (String)w);
            this.addMessage(results, VContext.ECategory.SYNTAX, VContext.ESeverity.WARNING, locmsg, this.getPath());
        }
        List<String> errors = errorHandler.getErrors();
        for (String e : errors) {
            IMessageKey.Param1 key = MoserError.MSR_VRF_ERROR_SYNTAX;
            locmsg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.mLocale, (String)e);
            this.addMessage(results, VContext.ECategory.SYNTAX, VContext.ESeverity.ERROR, locmsg, this.getPath());
        }
    }

    protected void verifyIdentifier(VResults results) {
        String id = this.mObj.getIdentifier();
        if (id == null || id.isEmpty()) {
            IMessageKey.Param2 key = MoserError.MSR_VRF_ERROR_NO_IDENTIFIER;
            String locmsg = MoserMessages.getMessage((IMessageKey.Param2)key, (Locale)this.mLocale, (String)this.getReportObjectType(), (String)this.mObj.getLabel());
            this.addMessage(results, VContext.ECategory.IDENTIFIER, VContext.ESeverity.ERROR, locmsg, this.getPath() + IDENTIFIER);
            return;
        }
        if (!IdentifierUtil.isValidIdentifierForValidation((String)id)) {
            IMessageKey.Param1 key = MoserError.MSR_VRF_ERROR_INVALID_IDENTIFIER;
            String locmsg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.mLocale, (String)id);
            this.addMessage(results, VContext.ECategory.IDENTIFIER, VContext.ESeverity.ERROR, locmsg, this.getPath() + IDENTIFIER);
        }
    }

    protected void addMessage(VResults result, VContext.ECategory eCategory, VContext.ESeverity eSev, String msg, String location) {
        String errorCode = MoserMessages.getErrorCode((String)msg);
        result.addMessage(location, errorCode, eCategory, msg, eSev);
    }

    protected String getPath() {
        StringBuilder sb = new StringBuilder();
        if (this.mParentVObj != null) {
            sb.append(this.mParentVObj.getPath());
            sb.append(this.getObjectType());
            sb.append("[");
            sb.append(this.mIndex);
            sb.append("]/");
        } else {
            sb.append("./");
        }
        return sb.toString();
    }

    protected String getObjectType() {
        String objectType = this.mObj.getClass().getSimpleName();
        char first = Character.toLowerCase(objectType.charAt(0));
        return first + objectType.substring(1);
    }

    protected String getReportObjectType() {
        return MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_OBJ_OBJECT, (Locale)this.mLocale);
    }

    protected VModule getVModule() {
        VBaseObject parent = this.mParentVObj;
        while (parent != null && !(parent instanceof VModule)) {
            parent = parent.mParentVObj;
        }
        return (VModule)parent;
    }

    protected void report(Pair<ResultType, BaseObjectType> result, String refName, String refID, VResults results) {
        if (result.getFirst().equals((Object)ResultType.VALID)) {
            return;
        }
        String objType = this.getReportObjectType();
        String objLabel = this.mObj.getLabel();
        if (this.mObj.getLabel() == null) {
            objLabel = this.mObj.getIdentifier();
        }
        String locmsg = result.getFirst().equals((Object)ResultType.INVALID_REF) ? MoserMessages.getMessage((IMessageKey.Param3)MoserError.MSR_VRF_ERROR_INVALID_REFERENCE, (Locale)this.mLocale, (String)objType, (String)objLabel, (String)refID) : (result.getFirst().equals((Object)ResultType.INVALID_EXPRESSION) ? MoserMessages.getMessage((IMessageKey.Param1)MoserError.MSR_VRF_ERROR_INVALID_EXPRESSION, (Locale)this.mLocale, (String)objLabel) : (result.getFirst().equals((Object)ResultType.INVALID_SORTBY) ? MoserMessages.getMessage((IMessageKey.Param2)MoserError.MSR_VRF_ERROR_SORTBY, (Locale)this.mLocale, (String)objLabel, (String)refID) : MoserMessages.getMessage((IMessageKey.Param3)MoserError.MSR_VRF_ERROR_MISSING_REFERENCE, (Locale)this.mLocale, (String)objType, (String)objLabel, (String)refID)));
        String location = this.getPath() + refName;
        this.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, locmsg, location);
    }

    protected static Pair<ResultType, BaseObjectType> wrapperCheckObjectById(ModuleWrapper moduleWrapper, String checkRef, Class<?>[] expectedClasses) {
        if (moduleWrapper == null) {
            return new Pair<ResultType, Object>(ResultType.UNEXISTING, null);
        }
        ResultType resultType = ResultType.VALID;
        BaseObjectType resultObj = null;
        Class[] classes = new Class[]{QuerySubject.class, Filter.class, Calculation.class, Relationship.class, Query.class};
        ArrayList<BaseObjectType> rtObjects = new ArrayList<BaseObjectType>();
        moduleWrapper.getObjectByIdAndClasses(checkRef, classes, rtObjects);
        if (rtObjects.isEmpty()) {
            resultType = ResultType.UNEXISTING;
        } else {
            boolean bFound = false;
            for (BaseObjectType obj : rtObjects) {
                for (int i = 0; i < expectedClasses.length && !bFound; ++i) {
                    if (!expectedClasses[i].equals(obj.getClass())) continue;
                    bFound = true;
                    resultObj = obj;
                }
                if (!bFound) continue;
                break;
            }
            if (!bFound) {
                resultType = ResultType.INVALID;
                resultObj = (BaseObjectType)rtObjects.get(0);
            }
        }
        return new Pair<ResultType, Object>(resultType, resultObj);
    }

    public static enum ResultType {
        VALID,
        INVALID,
        MISSING,
        UNEXISTING,
        INVALID_REF,
        INVALID_EXPRESSION,
        INVALID_SORTBY;

    }
}

