/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VQuerySubject;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class VColumnDependency
extends VQuerySubject {
    private static String columnDependency = "columnDependency[";
    private static String keyRef = "/keyRef[";
    private static String ref = "/ref";

    public VColumnDependency(QuerySubject obj, VBaseObject parent, int index) {
        super(obj, parent, index);
    }

    @Override
    public void verify(VContext context, VResults results) {
        this.mLocale = context.getLocale();
        if (context.getCategoryDependency()) {
            List qiIds = MoserObjectUtils.getQueryItems((QuerySubject)((QuerySubject)this.mObj)).stream().map(qi -> qi.getIdentifier()).collect(Collectors.toList());
            String objLabel = this.mObj.getLabel();
            List deps = ((QuerySubject)this.mObj).getColumnDependency();
            if (context.getSeverityError()) {
                String columnDependencyPath = this.getPath() + columnDependency;
                for (int i = 0; i < deps.size(); ++i) {
                    String locmsg;
                    String columnDependencyLocation = columnDependencyPath + (i + 1) + "]";
                    QuerySubject.ColumnDependency dep = (QuerySubject.ColumnDependency)deps.get(i);
                    List keyRefs = dep.getKeyRef();
                    if (keyRefs.isEmpty()) {
                        IMessageKey.Param1 key = MoserError.MSR_VRF_ERROR_DEPENDENCY_MISSING_KEYS;
                        locmsg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.mLocale, (String)objLabel);
                        this.addMessage(results, VContext.ECategory.COLUMN_DEPENDENCY, VContext.ESeverity.ERROR, locmsg, columnDependencyLocation);
                    } else {
                        String keyRefPath = columnDependencyLocation + keyRef;
                        for (int j = 0; j < keyRefs.size(); ++j) {
                            String skeyRef = (String)keyRefs.get(j);
                            if (qiIds.contains(skeyRef)) continue;
                            IMessageKey.Param2 key = MoserError.MSR_VRF_ERROR_INVALID_KEY_REFERENCE;
                            locmsg = MoserMessages.getMessage((IMessageKey.Param2)key, (Locale)this.mLocale, (String)objLabel, (String)skeyRef);
                            String keyRefLocation = keyRefPath + (j + 1) + "]";
                            this.addMessage(results, VContext.ECategory.COLUMN_DEPENDENCY, VContext.ESeverity.ERROR, locmsg, keyRefLocation);
                        }
                    }
                    String sref = dep.getRef();
                    if (sref.isEmpty()) {
                        IMessageKey.Param1 key = MoserError.MSR_VRF_ERROR_DEPENDENCY_MISSING_COLUMN;
                        locmsg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.mLocale, (String)objLabel);
                        this.addMessage(results, VContext.ECategory.COLUMN_DEPENDENCY, VContext.ESeverity.ERROR, locmsg, columnDependencyLocation);
                        continue;
                    }
                    if (qiIds.contains(sref)) continue;
                    IMessageKey.Param2 key = MoserError.MSR_VRF_ERROR_INVALID_COLUMN_REFERENCE;
                    locmsg = MoserMessages.getMessage((IMessageKey.Param2)key, (Locale)this.mLocale, (String)objLabel, (String)sref);
                    String refLocation = columnDependencyLocation + ref;
                    this.addMessage(results, VContext.ECategory.COLUMN_DEPENDENCY, VContext.ESeverity.ERROR, locmsg, refLocation);
                }
            }
        }
    }
}

