/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.DrillGroup;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VModule;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.module.verify.VSegment;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class VDrillGroup
extends VBaseObject {
    public VDrillGroup(DrillGroup obj, VBaseObject parent, int index) {
        super((ObjectType)obj, parent, index);
    }

    @Override
    public void verify(VContext options, VResults results) {
        HashSet<String> refSet = new HashSet<String>();
        List segments = ((DrillGroup)this.mObj).getSegment();
        for (int i = 0; i < segments.size(); ++i) {
            DrillGroup.Segment seg = (DrillGroup.Segment)segments.get(i);
            VSegment vseg = new VSegment(seg, this, i, ((VModule)this.mParentVObj).mWrapper);
            vseg.verify(options, results);
            String ref = seg.getRef();
            if (ref == null || ref.isEmpty() || refSet.add(ref)) continue;
            IMessageKey.Param3 key = MoserError.MSR_VRF_ERROR_DRILLGROUP_DUP_REF;
            String msg = MoserMessages.getMessage((IMessageKey.Param3)key, (Locale)this.mLocale, (String)seg.getLabel(), (String)ref, (String)this.mObj.getLabel());
            vseg.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, msg, vseg.getPath());
        }
        if (refSet.size() < 2) {
            IMessageKey.Param1 key = MoserError.MSR_VRF_ERROR_DRILLGROUP_EMPTY;
            String msg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.mLocale, (String)this.mObj.getLabel());
            this.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, msg, this.getPath());
        }
    }
}

