/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VModule;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import com.ibm.bi.platform.moser.core.utils.Pair;
import java.util.List;
import java.util.Locale;

public class VFolder
extends VBaseObject {
    public VFolder(FolderType obj, VBaseObject parent, int index) {
        super((ObjectType)obj, parent, index);
    }

    @Override
    protected String getReportObjectType() {
        return MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_OBJ_FOLDER_ITEM, (Locale)this.mLocale);
    }

    @Override
    public void verify(VContext context, VResults results) {
        if (!context.getCategoryReference()) {
            return;
        }
        List items = ((FolderType)this.mObj).getFolderItem();
        for (int j = 0; j < items.size(); ++j) {
            FolderItemType item = (FolderItemType)items.get(j);
            String ref = item.getRef();
            if (ref != null) {
                Class[] expectedClasses = new Class[]{QuerySubject.class, Calculation.class, Filter.class, Query.class};
                Pair<VBaseObject.ResultType, BaseObjectType> result = this.checkObjectById(ref, expectedClasses);
                this.report(result, "folderItem[" + (j + 1) + "]/ref", ref, results);
                continue;
            }
            FolderType subFolder = item.getFolder();
            if (subFolder == null) continue;
            VFolder vFolder = new VFolder(subFolder, (VBaseObject)this, j);
            vFolder.verify(context, results);
        }
    }

    private Pair<VBaseObject.ResultType, BaseObjectType> checkObjectById(String ref, Class<?>[] expectedClasses) {
        VBaseObject parent = this.mParentVObj;
        while (!(parent instanceof VModule)) {
            parent = parent.mParentVObj;
        }
        return this.getVModule().checkObjectById(ref, expectedClasses);
    }
}

