/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VModule;
import com.ibm.bi.platform.moser.core.module.verify.VQuerySubject;
import com.ibm.bi.platform.moser.core.module.verify.VRelationship;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import java.util.List;
import java.util.Locale;

public class VJoinQuerySubject
extends VQuerySubject {
    public VJoinQuerySubject(QuerySubject obj, VBaseObject parent, int index) {
        super(obj, parent, index);
    }

    @Override
    protected void verifyImpl(QuerySubject qs, VContext context, VResults results) {
        QuerySubject.JoinOperation jnOp = qs.getJoinOperation();
        if (jnOp == null) {
            this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param0)MoserError.MSR_VRF_ERROR_JOIN_QS_MISSING_OPERATION, (Locale)this.mLocale), this.getPath());
            return;
        }
        List joins = jnOp.basicGetRelationship();
        if (joins == null || joins.isEmpty()) {
            this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param0)MoserError.MSR_VRF_ERROR_JOIN_QS_OPERATION_NO_JOINS, (Locale)this.mLocale), this.getPath());
            return;
        }
        for (int i = 0; i < joins.size(); ++i) {
            Relationship join = (Relationship)joins.get(i);
            if (!jnOp.getQueryRef().contains(join.getLeft().getRef())) {
                this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param2)MoserError.MSR_VRF_ERROR_JOIN_QS_NO_REF, (Locale)this.mLocale, (String)join.getLeft().getRef(), (String)join.getLabel()), this.getPath());
            }
            if (!jnOp.getQueryRef().contains(join.getRight().getRef())) {
                this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param2)MoserError.MSR_VRF_ERROR_JOIN_QS_NO_REF, (Locale)this.mLocale, (String)join.getRight().getRef(), (String)join.getLabel()), this.getPath());
            }
            VRelationship vr = new VRelationship((Relationship)joins.get(i), (VBaseObject)this, i);
            vr.verify(context, results);
        }
        super.verifyImpl(qs, context, results);
    }

    @Override
    protected void verifyReferences(VContext context, VResults results) {
        QuerySubject qs = (QuerySubject)this.mObj;
        if (qs.getJoinOperation() == null) {
            this.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param0)MoserError.MSR_VRF_ERROR_JOIN_QS_MISSING_OPERATION, (Locale)this.mLocale), this.getPath());
            return;
        }
        if (qs.getJoinOperation().basicGetQueryRef() != null && !qs.getJoinOperation().basicGetQueryRef().isEmpty()) {
            for (String ref : qs.getJoinOperation().getQueryRef()) {
                Class[] expectedClasses = new Class[]{QuerySubject.class, Query.class};
                ((VModule)this.mParentVObj).checkObjectById(ref, expectedClasses);
            }
        }
    }
}

