/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.DrillGroup;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.metadata.util.ModuleWrapper;
import com.ibm.bi.platform.moser.core.module.FileMarshaller;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.util.ModuleUtil;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VCalculation;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VDrillGroup;
import com.ibm.bi.platform.moser.core.module.verify.VFilter;
import com.ibm.bi.platform.moser.core.module.verify.VFolder;
import com.ibm.bi.platform.moser.core.module.verify.VQuerySubject;
import com.ibm.bi.platform.moser.core.module.verify.VRelationship;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import com.ibm.bi.platform.moser.core.utils.Pair;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class VModule
extends VBaseObject {
    protected IModuleObjectManager mModuleObjectManager;
    private String mModuleStoreId;
    private VContext mContext;
    private VResults mResults;
    protected ModuleWrapper mWrapper;
    protected List<VQuerySubject> mVQuerySubjects;
    protected List<VCalculation> mVCalculations;
    protected List<VFilter> mVFilters;
    protected List<VRelationship> mVRelationships;
    protected Map<String, UseSpecType> mAliasTypes;
    private String mConnSpec = null;
    private Map<String, String> mFailedQSMap = new HashMap<String, String>();
    private List<ModuleWrapper> mUseModules = new ArrayList<ModuleWrapper>();
    private List<String> mFailedModules = new ArrayList<String>();
    private Map<String, ModuleWrapper> mUseBaseModulesMap = new HashMap<String, ModuleWrapper>();

    public VModule(Locale locale, Module obj, String moduleStoreId, IModuleObjectManager moduleObjectManager, String connSpec) {
        super((ObjectType)obj, null, 0);
        int i;
        this.mLocale = locale;
        this.mModuleStoreId = moduleStoreId;
        this.mModuleObjectManager = moduleObjectManager;
        this.mConnSpec = connSpec;
        List querySubjects = obj.getQuerySubject();
        List calculations = obj.getCalculation();
        List filters = obj.getFilter();
        List relationships = obj.getRelationship();
        this.mVQuerySubjects = new ArrayList<VQuerySubject>();
        this.mVCalculations = new ArrayList<VCalculation>();
        this.mVFilters = new ArrayList<VFilter>();
        this.mVRelationships = new ArrayList<VRelationship>();
        List useSpecs = obj.getUseSpec();
        this.mAliasTypes = new HashMap<String, UseSpecType>(useSpecs.size());
        for (Module.UseSpec next : useSpecs) {
            this.mAliasTypes.put(next.getIdentifier(), next.getType());
        }
        for (i = 0; i < querySubjects.size(); ++i) {
            QuerySubject querySubject = (QuerySubject)querySubjects.get(i);
            if (!this.shouldVerify((ObjectType)querySubject)) continue;
            this.mVQuerySubjects.add(VQuerySubject.createVQuerySubject(querySubject, this, i));
        }
        for (i = 0; i < calculations.size(); ++i) {
            Calculation calculation = (Calculation)calculations.get(i);
            if (!this.shouldVerify((ObjectType)calculation)) continue;
            this.mVCalculations.add(new VCalculation(calculation, (VBaseObject)this, i));
        }
        for (i = 0; i < filters.size(); ++i) {
            Filter filter = (Filter)filters.get(i);
            if (!this.shouldVerify((ObjectType)filter)) continue;
            this.mVFilters.add(new VFilter(filter, (VBaseObject)this, i));
        }
        for (i = 0; i < relationships.size(); ++i) {
            Relationship relationship = (Relationship)relationships.get(i);
            if (!this.shouldVerify((ObjectType)relationship)) continue;
            this.mVRelationships.add(new VRelationship(relationship, (VBaseObject)this, i));
        }
    }

    private boolean shouldVerify(ObjectType item) {
        String[] parts = item.getIdentifier().split("\\.");
        if (parts.length > 0) {
            String alias = parts[0];
            return !ModuleUtil.isPackageOrLWModule(this.mAliasTypes.get(alias));
        }
        return true;
    }

    public boolean shouldVerify(String reference) {
        String[] parts = reference.split("\\.");
        if (parts.length > 0) {
            String alias = parts[0];
            return !ModuleUtil.isPackageOrLWModule(this.mAliasTypes.get(alias));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void verify(VContext context, VResults results) {
        this.mContext = context;
        this.mResults = results;
        this.initialize();
        this.checkExpressions();
        this.checkDrillGroup();
        if (context.getSeverityError()) {
            if (context.getCategoryIdentifier()) {
                this.checkUniqueIdentifiers();
            }
            if (context.getCategoryReference()) {
                void var4_5;
                this.getImportModules();
                List views = this.mWrapper.getModule().getMetadataTreeView();
                boolean bl = false;
                while (var4_5 < views.size()) {
                    FolderType folder = (FolderType)views.get((int)var4_5);
                    VFolder vFolder = new VFolder(folder, (VBaseObject)this, (int)var4_5);
                    vFolder.verify(context, results);
                    ++var4_5;
                }
            }
        }
        if (context.getSeverityWarning() && context.getCategoryRelationship()) {
            this.checkMultiJoins();
        }
        for (VBaseObject vBaseObject : this.mVQuerySubjects) {
            vBaseObject.verify(context, results);
        }
        for (VBaseObject vBaseObject : this.mVCalculations) {
            vBaseObject.verify(context, results);
        }
        for (VBaseObject vBaseObject : this.mVFilters) {
            vBaseObject.verify(context, results);
        }
        for (VBaseObject vBaseObject : this.mVRelationships) {
            vBaseObject.verify(context, results);
        }
    }

    private void getImportModules() {
        List uses = this.mWrapper.getModule().getUse();
        for (String use : uses) {
            Module m = this.getUseModuleFromUse(use);
            if (m == null) {
                this.reportFailedModule(use);
                continue;
            }
            ModuleWrapper importModule = new ModuleWrapper(m);
            importModule.collectInfoWalkTree((BaseObjectType)m, null);
            this.mUseModules.add(importModule);
        }
    }

    private Module getUseModuleFromUse(String use) {
        Module useModule;
        if (MoserConfig.getInstance().getModuleStorage().equals("toCM")) {
            useModule = this.mModuleObjectManager.getBusinessModuleMetadataById(use);
            if (useModule == null) {
                useModule = this.mModuleObjectManager.getBaseModule(use, null);
            }
        } else {
            String baseModulesDir = MoserConfig.getInstance().getBaseModulesDirectory();
            String useModuleId = baseModulesDir + use + ".xml";
            File f = new File(useModuleId);
            useModule = (Module)new FileMarshaller().unmarshal(f, Module.class);
        }
        return useModule;
    }

    private void reportFailedModule(String refModule) {
        if (!this.mFailedModules.contains(refModule)) {
            this.mFailedModules.add(refModule);
            IMessageKey.Param1 msgkey = MoserError.UNKNOWN_USE_ERROR;
            String locmsg = MoserMessages.getMessage((IMessageKey.Param1)msgkey, (Locale)this.mLocale, (String)refModule);
            this.addMessage(this.mResults, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, locmsg, "./");
        }
    }

    private void checkExpressions() {
        JSONObject response = this.mModuleObjectManager.checkExpressions(this.mModuleStoreId, this.mConnSpec);
        if (response != null) {
            JSONArray jArratMsg = (JSONArray)response.get((Object)"messages");
            HashSet<JSONObject> hs = new HashSet<JSONObject>();
            hs.addAll((Collection<JSONObject>)jArratMsg);
            this.mResults.addJArray(hs);
        }
    }

    private void initialize() {
        this.mWrapper = new ModuleWrapper((Module)this.mObj);
        this.mWrapper.collectInfoWalkTree((BaseObjectType)this.mObj, null);
    }

    private void checkUniqueIdentifiers() {
        for (VQuerySubject mVQuerySubject : this.mVQuerySubjects) {
            this.checkUnique(mVQuerySubject);
        }
        for (VCalculation mVCalculation : this.mVCalculations) {
            this.checkUnique(mVCalculation);
        }
        for (VFilter mVFilter : this.mVFilters) {
            this.checkUnique(mVFilter);
        }
        for (VRelationship mVRelationship : this.mVRelationships) {
            this.checkUnique(mVRelationship);
        }
    }

    private void checkUnique(VBaseObject vobj) {
        IMessageKey.Param1 msgkey = MoserError.MSR_VRF_ERROR_ID_NOT_UNIQUE;
        Class[] classes = new Class[]{QuerySubject.class, Filter.class, Calculation.class, Relationship.class, Query.class};
        ArrayList<BaseObjectType> rtObjects = new ArrayList<BaseObjectType>();
        this.mWrapper.getObjectByIdAndClasses(vobj.mObj.getIdentifier(), classes, rtObjects);
        BaseObjectType scope = this.mWrapper.getParentContainer((BaseObjectType)vobj.mObj);
        Iterator iter = rtObjects.iterator();
        while (iter.hasNext()) {
            BaseObjectType otherScope = this.mWrapper.getParentContainer((BaseObjectType)iter.next());
            if (scope == null && otherScope == null || scope != null && scope.equals(otherScope)) continue;
            iter.remove();
        }
        if (rtObjects.size() > 1) {
            String locmsg = MoserMessages.getMessage((IMessageKey.Param1)msgkey, (Locale)this.mLocale, (String)vobj.mObj.getIdentifier());
            vobj.addMessage(this.mResults, VContext.ECategory.IDENTIFIER, VContext.ESeverity.ERROR, locmsg, vobj.getPath() + "identifier");
        }
    }

    private void checkMultiJoins() {
        HashMap<String, String> leftRightQSMap = new HashMap<String, String>();
        HashMap<Pair<String, String>, Relationship> visitedRelationshipMap = new HashMap<Pair<String, String>, Relationship>();
        List relationships = ((Module)this.mObj).getRelationship();
        for (int i = 0; i < relationships.size(); ++i) {
            Relationship relationship = (Relationship)relationships.get(i);
            if (relationship.getInstanceType() == InstanceType.MISSING || !this.shouldVerify((ObjectType)relationship)) continue;
            String leftId = relationship.getLeft().getRef();
            String rightId = relationship.getRight().getRef();
            Pair<String, String> qsPair = new Pair<String, String>(leftId, rightId);
            String value = (String)leftRightQSMap.get(leftId);
            if (value != null && value.equals(rightId)) {
                Relationship previousRelationship = (Relationship)visitedRelationshipMap.get(qsPair);
                if (previousRelationship != null) {
                    this.addMessage(previousRelationship, leftId, rightId, i - 1);
                    visitedRelationshipMap.remove(qsPair);
                }
                this.addMessage(relationship, leftId, rightId, i);
                continue;
            }
            if (leftRightQSMap.containsKey(rightId) && ((String)leftRightQSMap.get(rightId)).equals(leftId)) {
                Pair<String, String> qsPair2 = new Pair<String, String>(rightId, leftId);
                Relationship previousRelationship = (Relationship)visitedRelationshipMap.get(qsPair2);
                if (previousRelationship != null) {
                    this.addMessage(previousRelationship, rightId, leftId, i - 1);
                    visitedRelationshipMap.remove(qsPair2);
                }
                this.addMessage(relationship, leftId, rightId, i);
                continue;
            }
            leftRightQSMap.put(leftId, rightId);
            visitedRelationshipMap.put(qsPair, relationship);
        }
    }

    private void addMessage(Relationship relationship, String leftId, String rightId, int index) {
        QuerySubject left = (QuerySubject)ModuleUtil.getTableOrQuerySubject(leftId, (Module)this.mObj);
        String leftLabel = left != null ? left.getLabel() : leftId;
        QuerySubject right = (QuerySubject)ModuleUtil.getTableOrQuerySubject(rightId, (Module)this.mObj);
        String rightLabel = right != null ? right.getLabel() : rightId;
        VRelationship vRel = new VRelationship(relationship, (VBaseObject)this, index);
        IMessageKey.Param2 key = MoserError.MSR_VRF_WARNING_MULTIRELATIONSHIPS;
        String msg = MoserMessages.getMessage((IMessageKey.Param2)key, (Locale)this.mLocale, (String)leftLabel, (String)rightLabel);
        vRel.addMessage(this.mResults, VContext.ECategory.RELATIONSHIP, VContext.ESeverity.WARNING, msg, vRel.getPath());
    }

    private void checkDrillGroup() {
        List dgs = ((Module)this.mObj).getDrillGroup();
        for (int i = 0; i < dgs.size(); ++i) {
            if (!this.shouldVerify((ObjectType)dgs.get(i))) continue;
            VDrillGroup dg = new VDrillGroup((DrillGroup)dgs.get(i), (VBaseObject)this, i);
            dg.verify(this.mContext, this.mResults);
        }
    }

    protected void addFailedQS(String id, String ref) {
        this.mFailedQSMap.put(id, ref);
    }

    protected boolean isFailedQSRef(String id) {
        return this.mFailedQSMap.containsKey(id);
    }

    protected Pair<VBaseObject.ResultType, BaseObjectType> checkObjectById(String ref, Class<?>[] expectedClass) {
        Pair<VBaseObject.ResultType, BaseObjectType> result;
        if (ref.isEmpty()) {
            return new Pair<VBaseObject.ResultType, Object>(VBaseObject.ResultType.MISSING, null);
        }
        if (ref.contains(".")) {
            String refModule = StringUtils.substringBeforeLast((String)ref, (String)".");
            String refId = StringUtils.substringAfterLast((String)ref, (String)".");
            ModuleWrapper mw = this.getBaseModuleFromRef(refModule);
            result = VModule.wrapperCheckObjectById(mw, refId, expectedClass);
        } else if (!ref.isEmpty()) {
            result = VModule.wrapperCheckObjectById(this.mWrapper, ref, expectedClass);
            if (result.getFirst().equals((Object)VBaseObject.ResultType.MISSING) || result.getFirst().equals((Object)VBaseObject.ResultType.UNEXISTING)) {
                ModuleWrapper useModule;
                Iterator<ModuleWrapper> iterator = this.mUseModules.iterator();
                while (iterator.hasNext() && !(result = VModule.wrapperCheckObjectById(useModule = iterator.next(), ref, expectedClass)).getFirst().equals((Object)VBaseObject.ResultType.VALID)) {
                }
            }
        } else {
            return new Pair<VBaseObject.ResultType, Object>(VBaseObject.ResultType.UNEXISTING, null);
        }
        return result;
    }

    private ModuleWrapper getBaseModuleFromRef(String refModule) {
        if (this.mFailedModules.contains(refModule)) {
            return null;
        }
        ModuleWrapper wrapper = this.mUseBaseModulesMap.get(refModule);
        if (wrapper == null) {
            Module baseModule = null;
            String[] tokens = refModule.split("\\.");
            if (tokens.length > 0) {
                Module m = this.mWrapper.getModule();
                baseModule = this.getUseModuleFromUseSpec(m, tokens[0]);
            }
            if (baseModule == null) {
                this.reportFailedModule(refModule);
                return null;
            }
            wrapper = new ModuleWrapper(baseModule);
            wrapper.collectInfoWalkTree((BaseObjectType)baseModule, null);
            this.mUseBaseModulesMap.put(refModule, wrapper);
        }
        return wrapper;
    }

    private Module getUseModuleFromUseSpec(Module module, String useSpecId) {
        Module useModule = null;
        Module.UseSpec useSpec = VModule.getUseSpec(module, useSpecId);
        if (useSpec == null) {
            return useModule;
        }
        if (MoserConfig.getInstance().getModuleStorage().equals("toCM")) {
            if (UseSpecType.MODULE.equals((Object)useSpec.getType())) {
                useModule = this.mModuleObjectManager.getBusinessModuleMetadataById(useSpec.getStoreID());
            } else if (UseSpecType.DATABASE.equals((Object)useSpec.getType())) {
                useModule = this.mModuleObjectManager.getBaseModule(useSpec.getStoreID(), UseSpecType.DATABASE);
            } else if (UseSpecType.FILE.equals((Object)useSpec.getType()) || UseSpecType.DATASET.equals((Object)useSpec.getType())) {
                useModule = this.mModuleObjectManager.getBaseModuleForDataset(useSpec.getStoreID(), "baseDefinition");
            } else if (UseSpecType.PACKAGE.equals((Object)useSpec.getType())) {
                useModule = this.mModuleObjectManager.getBaseModuleForPackage(useSpec.getStoreID(), useSpecId);
            } else if (UseSpecType.LW_OLAP.equals((Object)useSpec.getType())) {
                useModule = this.mModuleObjectManager.getBaseModuleForLWOLAP(useSpec.getStoreID(), useSpecId, null);
            } else if (UseSpecType.REPORT.equals((Object)useSpec.getType())) {
                useModule = this.mModuleObjectManager.getBaseModuleForReport(useSpec.getStoreID());
            }
        } else {
            String baseModulesDir = MoserConfig.getInstance().getBaseModulesDirectory();
            String useModuleId = baseModulesDir + useSpec.getStoreID() + ".xml";
            File f = new File(useModuleId);
            useModule = (Module)new FileMarshaller().unmarshal(f, Module.class);
        }
        return useModule;
    }

    private static Module.UseSpec getUseSpec(Module m, String useSpecId) {
        List useSpecs = m.getUseSpec();
        for (Module.UseSpec useSpec : useSpecs) {
            if (!useSpecId.equals(useSpec.getIdentifier())) continue;
            return useSpec;
        }
        return null;
    }
}

