/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.core.metadata.util.ModuleWrapper;
import com.ibm.bi.platform.moser.core.metadata.util.ReferenceResolver;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VModule;
import com.ibm.bi.platform.moser.core.module.verify.VQuerySubject;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VOperationQuerySubject
extends VQuerySubject {
    public VOperationQuerySubject(QuerySubject obj, VBaseObject parent, int index) {
        super(obj, parent, index);
    }

    @Override
    protected void verifyImpl(QuerySubject qs, VContext context, VResults results) {
        if (qs.getQueryOperation() == null) {
            this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param0)MoserError.MSR_VRF_ERROR_QS_OPERATION_MISSING, (Locale)this.mLocale), this.getPath());
        } else {
            QuerySubject.QueryOperation operation = qs.getQueryOperation();
            switch (operation.getSetOperation()) {
                case UNION: {
                    this.verifyUnion(qs, results);
                    break;
                }
                default: {
                    this.verifyExceptAndIntersect(qs, results);
                }
            }
        }
        super.verifyImpl(qs, context, results);
    }

    private void verifyExceptAndIntersect(QuerySubject qs, VResults results) {
        if (qs.getQueryOperation().basicGetQueryRef() == null || qs.getQueryOperation().basicGetQueryRef().size() != 2) {
            this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param0)MoserError.MSR_VRF_ERROR_QS_EXCEPT_INTERSECT, (Locale)this.mLocale), this.getPath());
        } else {
            this.checkColumnCompatibility(qs, results);
        }
    }

    private void checkColumnCompatibility(QuerySubject qs, VResults results) {
        ModuleWrapper wrapper = ((VModule)this.mParentVObj).mWrapper;
        Class[] qsClasses = new Class[]{QuerySubject.class, Query.class};
        ArrayList<QuerySubject> participant = new ArrayList<QuerySubject>();
        for (String reference : qs.getQueryOperation().basicGetQueryRef()) {
            String[] refPath = reference.split("\\.");
            QuerySubject referencedQS = (QuerySubject)wrapper.findObject(refPath, qsClasses);
            if (referencedQS == null) continue;
            participant.add(referencedQS);
        }
        if (participant.size() < 2) {
            this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param1)MoserError.MSR_VRF_ERROR_QS_OPERATION_REFERENCE, (Locale)this.mLocale, (String)qs.getQueryOperation().getSetOperation().value()), this.getPath());
            return;
        }
        List allBaseline = MoserObjectUtils.getQueryItems((List)qs.getItem());
        ArrayList<QueryItem> baseline = new ArrayList<QueryItem>();
        for (QueryItem qi : allBaseline) {
            if (qi.getExpression() != null) continue;
            baseline.add(qi);
        }
        List<QueryItem> listFirst = VOperationQuerySubject.getQueryItemSkipPostAggrQueryItem(((QuerySubject)participant.get(0)).getItem());
        if (baseline.size() > listFirst.size()) {
            this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param1)MoserError.MSR_VRF_ERROR_QS_OPERATION_INVALID_COLUMNS_NUMBER, (Locale)this.mLocale, (String)qs.getLabel()), this.getPath());
        } else {
            this.compareColumnTypes(baseline, listFirst, ((QuerySubject)participant.get(0)).getLabel(), qs, results);
        }
        for (int i = 1; i < participant.size(); ++i) {
            List<QueryItem> list = VOperationQuerySubject.getQueryItemSkipPostAggrQueryItem(((QuerySubject)participant.get(i)).getItem());
            if (listFirst.size() != list.size()) {
                String tableLabel = ((QuerySubject)participant.get(i)).getLabel();
                this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param3)MoserError.MSR_VRF_ERROR_QS_OPERATION_COLUMNS_NUMBER, (Locale)this.mLocale, (String)tableLabel, (String)String.valueOf(listFirst.size()), (String)qs.getLabel()), this.getPath());
                continue;
            }
            this.compareColumnTypes(listFirst, list, ((QuerySubject)participant.get(i)).getLabel(), qs, results);
        }
    }

    private static List<QueryItem> getQueryItemSkipPostAggrQueryItem(List<ItemType> items) {
        ArrayList<QueryItem> rt = new ArrayList<QueryItem>();
        List allQueryItems = MoserObjectUtils.getQueryItems(items);
        for (QueryItem qi : allQueryItems) {
            RegularAggregateType aggr = qi.getRegularAggregate();
            if (aggr == RegularAggregateType.CALCULATED) continue;
            rt.add(qi);
        }
        return rt;
    }

    private void compareColumnTypes(List<QueryItem> baseline, List<QueryItem> list, String participant, QuerySubject qs, VResults results) {
        for (int i = 0; i < baseline.size(); ++i) {
            QueryItem qiTableOne = baseline.get(i);
            QueryItem qiTableTwo = list.get(i);
            String datatypeCategory = ReferenceResolver.generateDatatypeCategory(qiTableOne.getDatatype());
            if (MoserCommonUtils.areCompatibleDataTypes((String)qiTableOne.getDatatype(), (String)qiTableTwo.getDatatype())) continue;
            this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.WARNING, MoserMessages.getMessage((IMessageKey.Param3)MoserError.MSR_VRF_ERROR_QS_OPERATION_COLUMNS_TYPE, (Locale)this.mLocale, (String)participant, (String)qiTableTwo.getLabel(), (String)datatypeCategory), this.getPath());
        }
    }

    private void verifyUnion(QuerySubject qs, VResults results) {
        if (qs.getQueryOperation().basicGetQueryRef() == null || qs.getQueryOperation().basicGetQueryRef().size() < 2) {
            this.addMessage(results, VContext.ECategory.OPERATION, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param0)MoserError.MSR_VRF_ERROR_QS_UNION, (Locale)this.mLocale), this.getPath());
        } else {
            this.checkColumnCompatibility(qs, results);
        }
    }

    @Override
    protected void verifyReferences(VContext context, VResults results) {
        QuerySubject qs = (QuerySubject)this.mObj;
        if (qs.getQueryOperation() == null) {
            this.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, MoserMessages.getMessage((IMessageKey.Param0)MoserError.MSR_VRF_ERROR_QS_OPERATION_MISSING, (Locale)this.mLocale), this.getPath());
            return;
        }
        if (qs.getQueryOperation().basicGetQueryRef() != null && !qs.getQueryOperation().basicGetQueryRef().isEmpty()) {
            for (String ref : qs.getQueryOperation().getQueryRef()) {
                Class[] expectedClasses = new Class[]{QuerySubject.class, Query.class};
                ((VModule)this.mParentVObj).checkObjectById(ref, expectedClasses);
            }
        }
    }
}

