/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.FacetType;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.SortListType;
import com.ibm.bi.platform.moser.common.generated.metadata.TaxonomyType;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.module.taxonomy.TaxonomyUtil;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VQuerySubject;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.utils.Pair;
import java.util.List;
import java.util.Locale;

public class VQueryItem
extends VBaseObject {
    public VQueryItem(QueryItem obj, VBaseObject parent, int index) {
        super((ObjectType)obj, parent, index);
    }

    @Override
    public void verify(VContext context, VResults results) {
        SortListType sList;
        QueryItem queryItem;
        FacetType facet;
        TaxonomyType tx;
        List taxonomies;
        super.verify(context, results);
        if (context.getSeverityWarning() && context.getCategoryInconsistency() && !(taxonomies = ((QueryItem)this.mObj).getTaxonomy()).isEmpty() && !TaxonomyUtil.validateValues(tx = (TaxonomyType)taxonomies.get(0))) {
            String msg = MoserMessages.getMessage((IMessageKey.Param4)MoserError.MSR_VRF_WARNING_TAXONOMY, (Locale)this.mLocale, (String)this.mObj.getLabel(), (String)tx.getDomain(), (String)tx.getFamily(), (String)tx.getClazz());
            this.addMessage(results, VContext.ECategory.INCONSISTENCY, VContext.ESeverity.WARNING, msg, this.getPath());
        }
        if (context.getCategoryReference() && (facet = (queryItem = (QueryItem)this.mObj).getFacetDefinition()) != null && (sList = facet.getSortList()) != null) {
            List sItems = sList.getSortItem();
            for (SortListType.SortItem item : sItems) {
                String ref = item.getRef();
                if (((VQuerySubject)this.mParentVObj).contains(ref)) continue;
                this.report(new Pair<VBaseObject.ResultType, Object>(VBaseObject.ResultType.INVALID_SORTBY, null), "sortItem", ref, results);
            }
        }
    }

    @Override
    protected String getPath() {
        StringBuilder sb = new StringBuilder();
        if (this.mParentVObj != null) {
            sb.append(this.mParentVObj.getPath());
            sb.append("item");
            sb.append("[");
            sb.append(this.mIndex);
            sb.append("]/");
            sb.append(this.getObjectType());
            sb.append("/");
        } else {
            sb.append("./");
        }
        return sb.toString();
    }

    @Override
    protected String getReportObjectType() {
        return MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_OBJ_COLUMN, (Locale)this.mLocale);
    }
}

