/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.utils.MoserCommonUtils;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VQueryItem;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import java.util.Locale;

public class VQueryItemAggregate
extends VQueryItem {
    public VQueryItemAggregate(QueryItem obj, VBaseObject parent, int index) {
        super(obj, parent, index);
    }

    @Override
    public void verify(VContext options, VResults results) {
        if (options.getSeverityWarning() && options.getCategoryInconsistency()) {
            RegularAggregateType regAggr = ((QueryItem)this.mObj).getRegularAggregate();
            HighLevelDataType hldatatype = ((QueryItem)this.mObj).getHighlevelDatatype();
            if (hldatatype == null) {
                hldatatype = MoserCommonUtils.generateHighlevelDatatype((String)((QueryItem)this.mObj).getDatatype());
            }
            if (regAggr == null || hldatatype == null) {
                return;
            }
            if ((regAggr == RegularAggregateType.TOTAL || regAggr == RegularAggregateType.AVERAGE) && hldatatype == HighLevelDataType.STRING || regAggr == RegularAggregateType.TOTAL && (hldatatype == HighLevelDataType.DATE || hldatatype == HighLevelDataType.DATETIME || hldatatype == HighLevelDataType.TIME) || (regAggr == RegularAggregateType.TOTAL || regAggr == RegularAggregateType.AVERAGE || regAggr == RegularAggregateType.COUNT) && hldatatype == HighLevelDataType.OBJECT) {
                IMessageKey.Param2 key = MoserError.MSR_VRF_WARNING_REGULARAGGREGATE;
                String locmsg = MoserMessages.getMessage((IMessageKey.Param2)key, (Locale)this.mLocale, (String)this.mObj.getLabel(), (String)hldatatype.value());
                String path = this.getPath();
                String location = path + "regularAggregate";
                this.addMessage(results, VContext.ECategory.INCONSISTENCY, VContext.ESeverity.WARNING, locmsg, location);
            }
        }
    }
}

