/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemNormalizationGroupType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QsClassifierType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.SqlOperatorType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VColumnDependency;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VFilter;
import com.ibm.bi.platform.moser.core.module.verify.VJoinQuerySubject;
import com.ibm.bi.platform.moser.core.module.verify.VModule;
import com.ibm.bi.platform.moser.core.module.verify.VOperationQuerySubject;
import com.ibm.bi.platform.moser.core.module.verify.VQueryItem;
import com.ibm.bi.platform.moser.core.module.verify.VQueryItemAggregate;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import com.ibm.bi.platform.moser.core.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.validation.Validator;

public class VQuerySubject
extends VBaseObject {
    private List<String> qItemIDs;

    public VQuerySubject(QuerySubject qs, VBaseObject parent, int index) {
        super((ObjectType)qs, parent, index);
        this.qItemIDs = this.getQueryItemsForSortRef(qs.basicGetItem()).stream().map(qi -> qi.getIdentifier()).collect(Collectors.toList());
    }

    protected List<QueryItem> getQueryItemsForSortRef(List<ItemType> items) {
        ArrayList<QueryItem> qItems = new ArrayList<QueryItem>();
        if (items == null) {
            return qItems;
        }
        for (ItemType item : items) {
            QueryItem qi = item.getQueryItem();
            if (qi != null) {
                if (qi.getRegularAggregate() == RegularAggregateType.CALCULATED) continue;
                qItems.add(qi);
                if (qi.basicGetSplitDefinition() != null) continue;
                qItems.addAll(this.getQueryItemsForSortRef(qi.basicGetItem()));
                continue;
            }
            if (item.getFolder() == null) continue;
            qItems.addAll(this.getQueryItemsForSortRef(item.getFolder().basicGetItem()));
        }
        return qItems;
    }

    public static VQuerySubject createVQuerySubject(QuerySubject obj, VBaseObject parent, int index) {
        if (obj.getClassifier() == null) {
            return new VQuerySubject(obj, parent, index);
        }
        switch (obj.getClassifier()) {
            case OPERATION_QUERY_SUBJECT: {
                return new VOperationQuerySubject(obj, parent, index);
            }
            case JOIN_QUERY_SUBJECT: {
                return new VJoinQuerySubject(obj, parent, index);
            }
        }
        return new VQuerySubject(obj, parent, index);
    }

    public boolean contains(String qiID) {
        return this.qItemIDs.contains(qiID);
    }

    @Override
    public void verify(VContext context, VResults results) {
        this.mLocale = context.getLocale();
        super.verify(context, results);
        QuerySubject qs = (QuerySubject)this.mObj;
        if (this.isAmbiguous(qs, context, results)) {
            return;
        }
        this.verifyImpl(qs, context, results);
    }

    protected boolean isAmbiguous(QuerySubject qs, VContext context, VResults results) {
        int ambiguityCount = 0;
        if (qs.getQueryOperation() != null && qs.getClassifier() != QsClassifierType.OPERATION_QUERY_SUBJECT) {
            ++ambiguityCount;
        }
        if (qs.getJoinOperation() != null && qs.getClassifier() != QsClassifierType.JOIN_QUERY_SUBJECT) {
            ++ambiguityCount;
        }
        if (qs.getSqlQuery() != null && qs.getClassifier() != QsClassifierType.SQL_QUERY_SUBJECT) {
            ++ambiguityCount;
        }
        if (ambiguityCount > 0) {
            IMessageKey.Param1 key = MoserError.MSR_VRF_ERROR_INVALID_QS;
            String locmsg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.mLocale, (String)qs.getLabel());
            this.addMessage(results, VContext.ECategory.INCONSISTENCY, VContext.ESeverity.ERROR, locmsg, this.getPath());
            return qs.getClassifier() == null && ambiguityCount > 1;
        }
        return false;
    }

    protected void verifyImpl(QuerySubject qs, VContext context, VResults results) {
        VColumnDependency vColumnDep = new VColumnDependency(qs, this.mParentVObj, this.mIndex);
        vColumnDep.verify(context, results);
        HashSet<String> qiIds = new HashSet<String>();
        List qItems = MoserObjectUtils.getQueryItems((QuerySubject)qs);
        HashMap<String, QueryItem> itemLookup = new HashMap<String, QueryItem>();
        for (int i = 0; i < qItems.size(); ++i) {
            QueryItem obj = (QueryItem)qItems.get(i);
            VQueryItem vqi = new VQueryItem(obj, (VBaseObject)this, i);
            itemLookup.put(obj.getIdentifier(), obj);
            vqi.verify(context, results);
            if (context.getSeverityError() && context.getCategoryIdentifier() && !qiIds.add(obj.getIdentifier())) {
                IMessageKey.Param1 key = MoserError.MSR_VRF_ERROR_ID_NOT_UNIQUE;
                String locmsg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.mLocale, (String)obj.getIdentifier());
                this.addMessage(results, VContext.ECategory.IDENTIFIER, VContext.ESeverity.ERROR, locmsg, vqi.getPath());
            }
            if (!context.getSeverityWarning() || !context.getCategoryInconsistency()) continue;
            VQueryItemAggregate vAggr = new VQueryItemAggregate(obj, (VBaseObject)this, vqi.mIndex - 1);
            vAggr.verify(context, results);
        }
        HashSet<String> filterIds = new HashSet<String>();
        List filters = MoserObjectUtils.getFilters((QuerySubject)qs);
        for (int i = 0; i < filters.size(); ++i) {
            Filter obj = (Filter)filters.get(i);
            VFilter vf = new VFilter(obj, (VBaseObject)this, i);
            vf.verify(context, results);
            if (!context.getSeverityError() || !context.getCategoryIdentifier() || filterIds.add(obj.getIdentifier())) continue;
            IMessageKey.Param1 key = MoserError.MSR_VRF_ERROR_ID_NOT_UNIQUE;
            String locmsg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.mLocale, (String)obj.getIdentifier());
            this.addMessage(results, VContext.ECategory.IDENTIFIER, VContext.ESeverity.ERROR, locmsg, vf.getPath());
        }
        this.validateNormalizationGroups(qs, itemLookup, results);
        if (context.getCategoryReference()) {
            this.verifyReferences(context, results);
        }
    }

    private static boolean isSQLOperatorAcceptableForFact(SqlOperatorType sqlOperator) {
        return SqlOperatorType.MINIMUM == sqlOperator || SqlOperatorType.MAXIMUM == sqlOperator || SqlOperatorType.AVERAGE == sqlOperator;
    }

    private static boolean isSQLOperatorAcceptableForIdentifierAttribute(SqlOperatorType sqlOperator) {
        return SqlOperatorType.MINIMUM == sqlOperator || SqlOperatorType.MAXIMUM == sqlOperator || SqlOperatorType.GROUP_BY == sqlOperator;
    }

    private void validateNormalizationGroups(QuerySubject qs, Map<String, QueryItem> itemLookup, VResults results) {
        String locmsg;
        IMessageKey.Param3 key;
        if (qs.getItemNormalization() == null) {
            return;
        }
        HashSet<String> queryItemsInGroups = new HashSet<String>();
        List groups = qs.getItemNormalization().getItemNormalizationGroup();
        HashMap<String, ItemNormalizationGroupType> groupLookup = new HashMap<String, ItemNormalizationGroupType>();
        for (Object group : groups) {
            groupLookup.put(group.getIdentifier(), (ItemNormalizationGroupType)group);
            if (group.getKey() != null) {
                String string = group.getKey().getItemRef();
                if (!itemLookup.containsKey(string)) {
                    IMessageKey.Param3 key2 = MoserError.MSR_VRF_ERROR_MISSING_NG_REFERENCE;
                    String locmsg2 = MoserMessages.getMessage((IMessageKey.Param3)key2, (Locale)this.mLocale, (String)group.getLabel(), (String)qs.getLabel(), (String)string);
                    this.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, locmsg2, this.getPath());
                } else {
                    queryItemsInGroups.add(string);
                    QueryItem qi = itemLookup.get(string);
                    if (qi.getUsage() == UsageType.FACT) {
                        key = MoserError.MSR_VRF_ERROR_KEY_FACT_INCOMPATIBLE;
                        locmsg = MoserMessages.getMessage((IMessageKey.Param2)key, (Locale)this.mLocale, (String)qi.getLabel(), (String)group.getLabel());
                        this.addMessage(results, VContext.ECategory.NORMALIZATION_GROUP, VContext.ESeverity.ERROR, locmsg, this.getPath());
                    }
                    if (qi.getRegularAggregate() == RegularAggregateType.CALCULATED) {
                        key = MoserError.MSR_VRF_ERROR_PAA_QUERYITEM_IN_COLUMN_DEPENDENCY;
                        locmsg = MoserMessages.getMessage((IMessageKey.Param1)key, (Locale)this.mLocale, (String)qi.getLabel());
                        this.addMessage(results, VContext.ECategory.NORMALIZATION_GROUP, VContext.ESeverity.ERROR, locmsg, this.getPath());
                    }
                }
            }
            for (ItemNormalizationGroupType.Attribute attribute : group.getAttribute()) {
                String locmsg2;
                IMessageKey.Param2 key2;
                String itemRef = attribute.getItemRef();
                if (!itemLookup.containsKey(itemRef)) {
                    IMessageKey.Param3 key4 = MoserError.MSR_VRF_ERROR_MISSING_NG_REFERENCE;
                    String locmsg4 = MoserMessages.getMessage((IMessageKey.Param3)key4, (Locale)this.mLocale, (String)group.getLabel(), (String)qs.getLabel(), (String)itemRef);
                    this.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, locmsg4, this.getPath());
                    continue;
                }
                queryItemsInGroups.add(itemRef);
                QueryItem qi = itemLookup.get(itemRef);
                if (qi.getRegularAggregate() == RegularAggregateType.CALCULATED) {
                    IMessageKey.Param1 key3 = MoserError.MSR_VRF_ERROR_PAA_QUERYITEM_IN_COLUMN_DEPENDENCY;
                    String locmsg3 = MoserMessages.getMessage((IMessageKey.Param1)key3, (Locale)this.mLocale, (String)qi.getLabel());
                    this.addMessage(results, VContext.ECategory.NORMALIZATION_GROUP, VContext.ESeverity.ERROR, locmsg3, this.getPath());
                    continue;
                }
                if (UsageType.FACT.equals((Object)qi.getUsage())) {
                    if (VQuerySubject.isSQLOperatorAcceptableForFact(attribute.getSqlOperator())) continue;
                    key2 = MoserError.MSR_VRF_ERROR_INCOMPATIBLE_USAGE_SQL_OP_RULE_ONE;
                    locmsg2 = MoserMessages.getMessage((IMessageKey.Param2)key2, (Locale)this.mLocale, (String)group.getLabel(), (String)qi.getLabel());
                    this.addMessage(results, VContext.ECategory.NORMALIZATION_GROUP, VContext.ESeverity.ERROR, locmsg2, this.getPath());
                    continue;
                }
                if (VQuerySubject.isSQLOperatorAcceptableForIdentifierAttribute(attribute.getSqlOperator())) continue;
                key2 = MoserError.MSR_VRF_ERROR_INCOMPATIBLE_USAGE_SQL_OP_RULE_TWO;
                locmsg2 = MoserMessages.getMessage((IMessageKey.Param2)key2, (Locale)this.mLocale, (String)group.getLabel(), (String)qi.getLabel());
                this.addMessage(results, VContext.ECategory.NORMALIZATION_GROUP, VContext.ESeverity.ERROR, locmsg2, this.getPath());
            }
        }
        for (Object group : groupLookup.values()) {
            for (String ref : group.getParentGroupRef()) {
                if (groupLookup.containsKey(ref)) continue;
                key = MoserError.MSR_VRF_ERROR_MISSING_NG_PARENT_REFERENCE;
                locmsg = MoserMessages.getMessage((IMessageKey.Param3)key, (Locale)this.mLocale, (String)group.getLabel(), (String)qs.getLabel(), (String)ref);
                this.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, locmsg, this.getPath());
            }
        }
        HashSet allQyeryItemsInQS = new HashSet();
        for (Map.Entry entry : itemLookup.entrySet()) {
            if (((QueryItem)entry.getValue()).getRegularAggregate() == RegularAggregateType.CALCULATED) continue;
            allQyeryItemsInQS.add(entry.getKey());
        }
        allQyeryItemsInQS.removeAll(queryItemsInGroups);
        if (!allQyeryItemsInQS.isEmpty()) {
            TreeSet<String> queryItemsNotInGroups = new TreeSet<String>();
            for (String idQI : allQyeryItemsInQS) {
                queryItemsNotInGroups.add(itemLookup.get(idQI).getLabel());
            }
            IMessageKey.Param1 param1 = MoserError.MSR_VRF_WARNING_ITEMNORMALIZATION;
            String locmsg5 = MoserMessages.getMessage((IMessageKey.Param1)param1, (Locale)this.mLocale, (String)queryItemsNotInGroups.toString());
            String path = this.getPath();
            String location = path + "itemnormalization";
            this.addMessage(results, VContext.ECategory.INCONSISTENCY, VContext.ESeverity.WARNING, locmsg5, location);
        }
    }

    protected void verifyReferences(VContext context, VResults mResults) {
        block4: {
            List refs;
            block5: {
                InstanceType ins;
                block3: {
                    refs = ((QuerySubject)this.mObj).getRef();
                    ins = ((QuerySubject)this.mObj).getInstanceType();
                    if (ins != null) break block3;
                    if (refs.isEmpty()) break block4;
                    for (String ref : refs) {
                        Class[] expectedClasses = new Class[]{QuerySubject.class, Query.class};
                        Pair<VBaseObject.ResultType, BaseObjectType> result = ((VModule)this.mParentVObj).checkObjectById(ref, expectedClasses);
                        if (result.getFirst() == VBaseObject.ResultType.VALID) continue;
                        ((VModule)this.mParentVObj).addFailedQS(this.mObj.getIdentifier(), ref);
                        this.report(result, "ref", ref, mResults);
                    }
                    break block4;
                }
                if (ins != InstanceType.MISSING) break block5;
                if (refs.isEmpty()) break block4;
                for (String ref : refs) {
                    if (this.refPackage(ref)) continue;
                    String locmsg = MoserMessages.getMessage((IMessageKey.Param3)MoserError.MSR_VRF_WARNING_MISSING_REFERENCE, (Locale)this.mLocale, (String)this.getReportObjectType(), (String)this.mObj.getLabel(), (String)ref);
                    String path = this.getPath();
                    String location = path + "ref";
                    this.addMessage(mResults, VContext.ECategory.REFERENCE, VContext.ESeverity.WARNING, locmsg, location);
                }
                break block4;
            }
            for (String ref : refs) {
                Class[] expectedClasses = new Class[]{QuerySubject.class, Query.class};
                ((VModule)this.mParentVObj).checkObjectById(ref, expectedClasses);
            }
        }
    }

    private boolean refPackage(String ref) {
        List useSpecs = ((Module)this.getVModule().mObj).getUseSpec();
        for (Module.UseSpec useSpec : useSpecs) {
            if (!ref.equals(useSpec.getIdentifier()) || !UseSpecType.PACKAGE.equals((Object)useSpec.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void checkSyntax(Validator validator, JAXBContext jc, VResults results) {
        super.checkSyntax(validator, jc, results);
        List qItems = MoserObjectUtils.getQueryItems((QuerySubject)((QuerySubject)this.mObj));
        for (int i = 0; i < qItems.size(); ++i) {
            QueryItem qi = (QueryItem)qItems.get(i);
            VBaseObject vItem = new VBaseObject((ObjectType)qi, this, i);
            vItem.checkSyntax(validator, jc, results);
        }
    }

    @Override
    protected String getReportObjectType() {
        return MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_OBJ_TABLE, (Locale)this.mLocale);
    }
}

