/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityType;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.utils.MoserMessageKeys;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VModule;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import com.ibm.bi.platform.moser.core.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VRelationship
extends VBaseObject {
    private static final String LINK = "link[";

    public VRelationship(Relationship obj, VBaseObject parent, int index) {
        super((ObjectType)obj, parent, index);
    }

    private static List<String> collectQItemIds(QuerySubject qs) {
        ArrayList<String> qItemIds = new ArrayList<String>();
        if (qs != null) {
            List qItems = MoserObjectUtils.getQueryItems((QuerySubject)qs);
            for (QueryItem qi : qItems) {
                qItemIds.add(qi.getIdentifier());
            }
        }
        return qItemIds;
    }

    private QuerySubject checkCardinality(String checkRef, String refName, VBaseObject vobj, VResults results) {
        if (checkRef.isEmpty()) {
            this.report(new Pair<VBaseObject.ResultType, Object>(VBaseObject.ResultType.MISSING, null), refName, null, results);
        } else if (this.getVModule().isFailedQSRef(checkRef)) {
            this.report(new Pair<VBaseObject.ResultType, Object>(VBaseObject.ResultType.INVALID_REF, null), refName, checkRef, results);
        } else {
            Class[] expectedClasses = new Class[]{QuerySubject.class, Query.class};
            Pair<VBaseObject.ResultType, BaseObjectType> result = this.getVModule().checkObjectById(checkRef, expectedClasses);
            if (result.getFirst() == VBaseObject.ResultType.VALID) {
                return (QuerySubject)result.getSecond();
            }
            this.report(result, refName, checkRef, results);
        }
        return null;
    }

    @Override
    public void verify(VContext context, VResults mResults) {
        Relationship relationship;
        CardinalityType left;
        String leftRef;
        super.verify(context, mResults);
        if (!context.getCategoryReference()) {
            return;
        }
        InstanceType ins = ((Relationship)this.mObj).getInstanceType();
        if (ins == InstanceType.MISSING) {
            String ref = ((Relationship)this.mObj).getRef();
            this.report(new Pair<VBaseObject.ResultType, Object>(VBaseObject.ResultType.UNEXISTING, null), "ref", ref, mResults);
            return;
        }
        VModule mVModule = this.getVModule();
        boolean shouldVerifyLeft = mVModule.shouldVerify(leftRef = (left = (relationship = (Relationship)this.mObj).getLeft()).getRef());
        QuerySubject leftQS = shouldVerifyLeft ? this.checkCardinality(leftRef, "left/ref", this, mResults) : null;
        CardinalityType right = ((Relationship)this.mObj).getRight();
        String rightRef = right.getRef();
        boolean shouldVerifyRight = mVModule.shouldVerify(rightRef);
        QuerySubject rightQS = shouldVerifyRight ? this.checkCardinality(rightRef, "right/ref", this, mResults) : null;
        List<String> leftQItemIds = VRelationship.collectQItemIds(leftQS);
        List<String> rightQItemIds = VRelationship.collectQItemIds(rightQS);
        List links = ((Relationship)this.mObj).getLink();
        for (int i = 0; i < links.size(); ++i) {
            Relationship.Link link = (Relationship.Link)links.get(i);
            String linkLeftRef = link.getLeftRef();
            if (linkLeftRef.isEmpty()) {
                this.report(new Pair<VBaseObject.ResultType, Object>(VBaseObject.ResultType.MISSING, null), LINK + (i + 1) + "]/leftRef", null, mResults);
            } else if (shouldVerifyLeft && !leftQItemIds.contains(linkLeftRef)) {
                this.report(new Pair<VBaseObject.ResultType, Object>(VBaseObject.ResultType.UNEXISTING, null), LINK + (i + 1) + "]/leftRef", linkLeftRef, mResults);
            }
            String linkRightRef = link.getRightRef();
            if (linkRightRef.isEmpty()) {
                this.report(new Pair<VBaseObject.ResultType, Object>(VBaseObject.ResultType.MISSING, null), LINK + (i + 1) + "]/rightRef", null, mResults);
                continue;
            }
            if (!shouldVerifyRight || rightQItemIds.contains(linkRightRef)) continue;
            this.report(new Pair<VBaseObject.ResultType, Object>(VBaseObject.ResultType.UNEXISTING, null), LINK + (i + 1) + "]/rightRef", linkRightRef, mResults);
        }
    }

    @Override
    protected String getReportObjectType() {
        return MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_OBJ_RELATIONSHIP, (Locale)this.mLocale);
    }

    @Override
    protected void report(Pair<VBaseObject.ResultType, BaseObjectType> result, String refName, String refID, VResults results) {
        if (result.getFirst().equals((Object)VBaseObject.ResultType.VALID)) {
            return;
        }
        String objLabel = this.mObj.getLabel();
        String refType = refName.contains("link") ? MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_OBJ_COLUMN, (Locale)this.mLocale) : MoserMessages.getMessage((IMessageKey.Param0)MoserMessageKeys.MSR_OBJ_TABLE, (Locale)this.mLocale);
        String locmsg = MoserMessages.getMessage((IMessageKey.Param3)MoserError.MSR_VRF_ERROR_JOIN_REFERENCE, (Locale)this.mLocale, (String)objLabel, (String)refType, (String)refID);
        String location = this.getPath() + refName;
        this.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, locmsg, location);
    }
}

