/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.core.module.verify.VCategory;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Collection;
import java.util.Locale;

public class VResults {
    private JSONArray mMessages = new JSONArray();
    private Locale mLocale;
    private int mNumErrors = 0;
    private int mNumWarnings = 0;
    private long mStartTime;
    private static final String SEVERITY = "severity";
    private static final String MESSAGE = "message";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String INFO = "info";

    public VResults(Locale locale, long startTime) {
        this.mLocale = locale;
        this.mStartTime = startTime;
    }

    public JSONObject getMessage() {
        if (this.mMessages.isEmpty()) {
            JSONObject jo = new JSONObject();
            String locmsg = MoserMessages.getMessage((IMessageKey.Param0)MoserError.MSR_VRF_NO_ISSUES, (Locale)this.mLocale);
            jo.put((Object)MESSAGE, (Object)locmsg);
            this.mMessages.add((Object)jo);
        }
        JSONObject jMessage = new JSONObject();
        jMessage.put((Object)"validationMessage", (Object)this.mMessages);
        String severity = SEVERITY;
        JSONObject jNum = new JSONObject();
        jNum.put((Object)severity, (Object)INFO);
        String text = "Total number of errors: " + this.mNumErrors + ", warnings: " + this.mNumWarnings;
        jNum.put((Object)"text", (Object)text);
        JSONObject jTime = new JSONObject();
        jTime.put((Object)severity, (Object)INFO);
        String text2 = "Execution time: " + Long.toString(System.currentTimeMillis() - this.mStartTime) + "ms";
        jTime.put((Object)"text", (Object)text2);
        JSONArray jarray = new JSONArray();
        jarray.add((Object)jNum);
        jarray.add((Object)jTime);
        JSONObject jRes = new JSONObject();
        jRes.put((Object)"data", (Object)jMessage);
        jRes.put((Object)"msg", (Object)jarray);
        JSONObject jResult = new JSONObject();
        jResult.put((Object)"feedback", (Object)jRes);
        return jResult;
    }

    public void addMessage(String location, String errorCode, VContext.ECategory eCategory, String msg, VContext.ESeverity eSev) {
        String severity;
        JSONObject jMessage = new JSONObject();
        jMessage.put((Object)"type", (Object)eCategory.toString().toLowerCase(Locale.ENGLISH));
        jMessage.put((Object)"location", (Object)location);
        jMessage.put((Object)"errorCode", (Object)errorCode);
        switch (eSev) {
            case ERROR: {
                severity = ERROR;
                ++this.mNumErrors;
                break;
            }
            case WARNING: {
                severity = WARNING;
                ++this.mNumWarnings;
                break;
            }
            default: {
                severity = INFO;
            }
        }
        jMessage.put((Object)SEVERITY, (Object)severity);
        jMessage.put((Object)"msg", (Object)msg);
        jMessage.put((Object)"ruleId", (Object)VCategory.getRuleId(eCategory));
        this.mMessages.add((Object)jMessage);
    }

    public void addJArray(Collection<JSONObject> jArray) {
        for (JSONObject jMessage : jArray) {
            String msg = (String)jMessage.get((Object)"msg");
            if (msg == null) continue;
            String severity = (String)jMessage.get((Object)SEVERITY);
            if (ERROR.equals(severity)) {
                ++this.mNumErrors;
            } else if (severity.contains(WARNING)) {
                jMessage.put((Object)SEVERITY, (Object)WARNING);
                ++this.mNumWarnings;
            } else if (severity.contains(INFO)) {
                jMessage.put((Object)SEVERITY, (Object)INFO);
            }
            this.mMessages.add((Object)jMessage);
        }
    }
}

