/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.commons.messages.IMessageKey;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.DrillGroup;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.bi.platform.moser.common.utils.MoserMessages;
import com.ibm.bi.platform.moser.common.utils.MoserObjectUtils;
import com.ibm.bi.platform.moser.core.metadata.util.ModuleWrapper;
import com.ibm.bi.platform.moser.core.module.verify.VBaseObject;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.translator.report.query.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class VSegment
extends VBaseObject {
    private ModuleWrapper mWrapper;

    public VSegment(DrillGroup.Segment obj, VBaseObject parent, int index, ModuleWrapper wrapper) {
        super((ObjectType)obj, parent, index);
        this.mWrapper = wrapper;
    }

    @Override
    public void verify(VContext options, VResults results) {
        boolean valid;
        String ref = ((DrillGroup.Segment)this.mObj).getRef();
        boolean bl = valid = ref != null && !ref.isEmpty();
        if (!valid) {
            this.reportInvalid(ref, results);
            return;
        }
        String[] parts = ref.split("\\.");
        if (parts.length == 1) {
            this.reportInvalid(ref, results);
            return;
        }
        Module module = MoserObject.getModuleObject((MoserObject)this.getVModule().mObj);
        for (Module.UseSpec useSpec : module.getUseSpec()) {
            if (!useSpec.getIdentifier().equals(parts[0])) continue;
            switch (useSpec.getType()) {
                case PACKAGE: 
                case LW_OLAP: 
                case REPORT: {
                    return;
                }
            }
        }
        boolean bl2 = valid = parts.length == 2;
        if (!valid) {
            this.reportInvalid(ref, results);
            return;
        }
        Class[] classes = new Class[]{QuerySubject.class, Query.class};
        ArrayList<BaseObjectType> rtObjects = new ArrayList<BaseObjectType>();
        this.mWrapper.getObjectByIdAndClasses(parts[0], classes, rtObjects);
        if (rtObjects.isEmpty()) {
            this.reportInvalid(ref, results);
        } else {
            QuerySubject qs = (QuerySubject)rtObjects.get(0);
            List items = MoserObjectUtils.getQueryItems((QuerySubject)qs);
            for (QueryItem qi : items) {
                if (!parts[1].equals(qi.getIdentifier())) continue;
                if (UsageType.FACT.equals((Object)qi.getUsage())) {
                    this.reportIsMeasure(ref, results);
                } else if (qi.isHidden() != null && qi.isHidden().booleanValue()) {
                    this.reportHidden(ref, results);
                }
                return;
            }
            this.reportInvalid(ref, results);
        }
    }

    private void reportHidden(String ref, VResults results) {
        this.reportWarning(MoserError.MSR_VRF_WARNING_DRILLGROUP_HIDDEN, ref, results);
    }

    private void reportWarning(IMessageKey.Param3 key, String ref, VResults results) {
        String segName = ((DrillGroup.Segment)this.mObj).getLabel();
        String groupName = ((DrillGroup)this.mParentVObj.mObj).getLabel();
        String msg = MoserMessages.getMessage((IMessageKey.Param3)key, (Locale)this.mLocale, (String)segName, (String)groupName, (String)ref);
        this.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.WARNING, msg, this.getPath());
    }

    private void reportInvalid(String ref, VResults results) {
        this.reportError(MoserError.MSR_VRF_ERROR_DRILLGROUP_INVALID_REF, ref, results);
    }

    private void reportIsMeasure(String ref, VResults results) {
        this.reportError(MoserError.MSR_VRF_ERROR_DRILLGROUP_MEASURE, ref, results);
    }

    private void reportError(IMessageKey.Param3 key, String ref, VResults results) {
        String segName = ((DrillGroup.Segment)this.mObj).getLabel();
        String groupName = ((DrillGroup)this.mParentVObj.mObj).getLabel();
        String msg = MoserMessages.getMessage((IMessageKey.Param3)key, (Locale)this.mLocale, (String)segName, (String)ref, (String)groupName);
        this.addMessage(results, VContext.ECategory.REFERENCE, VContext.ESeverity.ERROR, msg, this.getPath());
    }
}

