/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.module.verify;

import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.util.DataModuleExtractor;
import com.ibm.bi.platform.moser.core.module.verify.VContext;
import com.ibm.bi.platform.moser.core.module.verify.VModule;
import com.ibm.bi.platform.moser.core.module.verify.VResults;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Verifier {
    private final RequestEnvironment requestEnv;
    private VResults mResults;
    private IModuleObjectManager mModuleObjectManager;

    public Verifier(RequestEnvironment requestEnv, IModuleObjectManager moduleObjectManager) {
        this.requestEnv = requestEnv;
        this.mModuleObjectManager = moduleObjectManager;
    }

    public JSONObject verify(Module module, String moduleStoreId, long startTime) {
        return this.verify(module, moduleStoreId, startTime, null, null);
    }

    public JSONObject verify(Module module, String moduleStoreId, long startTime, List<VContext.ECategory> cat, List<VContext.ESeverity> sevLevels) {
        List<VContext.ESeverity> severityLevels;
        if (module == null) {
            throw new MoserException(MoserError.INTERNAL_ERROR);
        }
        List<VContext.ECategory> categories = cat;
        if (categories == null) {
            categories = new ArrayList<VContext.ECategory>();
        }
        if (categories.isEmpty()) {
            categories.add(VContext.ECategory.IDENTIFIER);
            categories.add(VContext.ECategory.INCONSISTENCY);
            categories.add(VContext.ECategory.COLUMN_DEPENDENCY);
            categories.add(VContext.ECategory.REFERENCE);
            categories.add(VContext.ECategory.RELATIONSHIP);
        }
        if ((severityLevels = sevLevels) == null) {
            severityLevels = new ArrayList<VContext.ESeverity>();
        }
        if (severityLevels.isEmpty()) {
            severityLevels.add(VContext.ESeverity.ERROR);
            severityLevels.add(VContext.ESeverity.WARNING);
        }
        Locale locale = this.requestEnv.getProductLocale();
        VContext context = new VContext(locale, categories, severityLevels);
        VModule vModule = new VModule(locale, module, moduleStoreId, this.mModuleObjectManager, null);
        this.mResults = new VResults(locale, startTime);
        if (!DataModuleExtractor.isEmbeddedModuleForPackage((List)module.getUseSpec())) {
            vModule.verify(context, this.mResults);
        }
        return this.mResults.getMessage();
    }
}

