/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.provider;

import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.provider.ProviderProperties;
import com.ibm.bi.platform.moser.common.provider.metadata.IMetadataProvider;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.ma.MoserXQESoapBridge;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractSOAPMetadataProvider
implements IMetadataProvider {
    private static final String PROVIDER = "provider";
    private final HttpServletRequest request;
    private final String providerType;
    private String cmDataSource;
    private String providerCode;

    protected AbstractSOAPMetadataProvider(HttpServletRequest request, String providerType, String cmDataSource, String providerCode) {
        this.request = request;
        this.providerType = providerType;
        this.cmDataSource = cmDataSource;
        this.providerCode = providerCode;
    }

    public Map<String, List<String>> getCatalogsAndSchemas(ProviderProperties props, List<Exception> exceptions) {
        TreeMap<String, List<String>> toReturn = new TreeMap<String, List<String>>();
        JSONObject jObj = MoserXQESoapBridge.getCatalogsAndSchemas(null, this.request, MoserXQESoapBridge.buildBaseURL(this.request), this.cmDataSource, this.providerType, this.providerCode, props.getConnectionSpec());
        JSONArray jCatalogs = (JSONArray)jObj.get((Object)"catalogs");
        for (Object o : jCatalogs) {
            JSONObject jCatalog = (JSONObject)o;
            JSONArray jCubes = (JSONArray)jCatalog.get((Object)"cubes");
            TreeSet<String> cubes = new TreeSet<String>();
            for (Object oo : jCubes) {
                cubes.add((String)oo);
            }
            toReturn.put((String)jCatalog.get((Object)"name"), new ArrayList(cubes));
        }
        return toReturn;
    }

    public List<String> getTables(ProviderProperties props, List<Exception> exceptions, Map<String, Object> feedback) {
        props.put((Object)PROVIDER, (Object)this.providerType);
        return Collections.emptyList();
    }

    public Module getPhysicalModule(ProviderProperties props, List<Exception> exceptions, Map<String, Object> feedback) {
        try {
            MoserXQESoapBridge.getOLAPMetadata(this.request, props.getDataSource(), props.getCatalog(), props.getSchema(), null, this.providerCode, null, props.getConnectionSpec(), null);
        }
        catch (MoserException e) {
            exceptions.add((Exception)((Object)e));
            return null;
        }
        ObjectFactory factory = new ObjectFactory();
        DataSource ds = factory.createDataSource();
        ds.setCmDataSource(props.getDataSource());
        ds.setName(props.getDataSource());
        ds.setCatalog(props.getCatalog());
        ds.setSchema(props.getSchema());
        ds.setDatabaseType(this.providerCode);
        Module module = factory.createModule();
        module.setIdentifier("physicalmodule");
        module.setLabel(props.getDataSource());
        module.getDataSource().add(ds);
        module.setVersion("11.1");
        return module;
    }
}

