/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.provider;

import com.ibm.bi.platform.moser.common.provider.ProviderProperties;
import com.ibm.bi.platform.moser.common.provider.metadata.IMetadataProvider;
import com.ibm.bi.platform.moser.core.cm.Connection;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserCommandBlockExecutor;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserMacroExpander;
import com.ibm.bi.platform.moser.core.provider.jdbc.metadata.JDBCMetadataProvider;
import com.ibm.bi.platform.moser.core.provider.olap.metadata.OLAPMetadataProvider;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.wkc.core.provider.jdbc.metadata.JDBCWKCMetadataProvider;
import com.ibm.bi.platform.wkc.core.utils.WKCUtil;
import javax.servlet.http.HttpServletRequest;

public class MetadataProviderFactory {
    public static final String TRUSTED_CONTEXT = "@TRUSTED_CONTEXT";

    private MetadataProviderFactory() {
    }

    public static IMetadataProvider create(String cmDataSource, Connection connection, ProviderProperties properties, RequestEnvironment env) {
        if (WKCUtil.isJDBCWKC(connection)) {
            return new JDBCWKCMetadataProvider();
        }
        String connectionString = connection.getConnectionString();
        String providerCode = MetadataProviderFactory.getInterfaceTypeFromConnectionString(connectionString);
        if (MetadataProviderFactory.isOLAP(providerCode)) {
            HttpServletRequest request = null;
            if (env != null) {
                request = env.getHttpServletRequest();
            }
            return new OLAPMetadataProvider(request, cmDataSource, providerCode);
        }
        return new JDBCMetadataProvider(new MoserCommandBlockExecutor(connectionString, properties.getProperties(), new MoserMacroExpander(env)));
    }

    public static String getInterfaceTypeFromConnectionString(String connectionString) {
        if (connectionString != null) {
            String[] tokens = connectionString.split(";");
            if (tokens.length <= 2) {
                return null;
            }
            String type = tokens[2];
            if ("JSON".equals(type)) {
                for (String token : tokens) {
                    if (!token.contains("=")) continue;
                    String key = token.substring(0, token.indexOf("="));
                    String value = token.substring(key.length() + 1);
                    if (!"SUBTYPE".equals(key)) continue;
                    if ("COUCHDB".equalsIgnoreCase(value)) {
                        type = "COUCHDB";
                        break;
                    }
                    if (!"CLOUDANT".equalsIgnoreCase(value)) break;
                    type = "CLOUDANT";
                    break;
                }
            }
            return type;
        }
        return null;
    }

    public static boolean isOLAP(String dbType) {
        if (dbType == null) {
            return false;
        }
        switch (dbType) {
            case "BW": 
            case "CL": 
            case "CR": 
            case "DO": 
            case "EB": 
            case "IS": 
            case "MO": 
            case "XI": 
            case "RO": 
            case "XO": 
            case "PC": 
            case "YK": 
            case "M8": 
            case "M12": 
            case "M14": 
            case "M16": 
            case "M17": 
            case "M19": 
            case "TM": 
            case "X5": 
            case "X8": 
            case "LA": 
            case "TMR": 
            case "MAZ": {
                return true;
            }
        }
        return false;
    }

    public static boolean isOLAPConnectionString(String connectionString) {
        return MetadataProviderFactory.isOLAP(MetadataProviderFactory.getInterfaceTypeFromConnectionString(connectionString));
    }

    public static boolean isDB2TrustedContext(String connString) {
        return MetadataProviderFactory.isDB2(connString) && connString.contains(TRUSTED_CONTEXT);
    }

    public static boolean isDB2(String connString) {
        String dbType = MetadataProviderFactory.getInterfaceTypeFromConnectionString(connString);
        return dbType != null && dbType.contains("D2");
    }
}

