/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.provider.jdbc;

import com.ibm.bi.platform.moser.common.provider.ProviderProperties;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.cognos.jmd.importer.JDBCImporter;

public class JDBCProviderProperties
extends ProviderProperties {
    private static final long serialVersionUID = 8526198495926916535L;
    private static final String BULK_LOAD_THRESHOLD = "bulkLoadThreshold";
    private static final String DRIVER_CLASS = "driverClass";
    private static final String IMPORT_MODE = "importMode";
    private static final String UNCERTIFIED_ALLOWED = "uncertifiedAllowed";
    private static final String URL = "url";
    private static final String EMPTY_STRING = "";

    public double getBulkLoadThreshold() {
        return (Double)this.getOrDefault(BULK_LOAD_THRESHOLD, MoserConfig.getDBBulkLoadThreshold());
    }

    public String getDriverClass() {
        return this.getProperty(DRIVER_CLASS, EMPTY_STRING);
    }

    public JDBCImporter.ImportMode getImportMode() {
        return (JDBCImporter.ImportMode)this.getOrDefault(IMPORT_MODE, MoserConfig.getDBImportMode());
    }

    public boolean getUncertifiedAllowed() {
        return (Boolean)this.getOrDefault(UNCERTIFIED_ALLOWED, Boolean.FALSE);
    }

    public String getUrl() {
        return this.getProperty(URL, EMPTY_STRING);
    }

    public void setBulkLoadThreshold(double threshold) {
        this.put(BULK_LOAD_THRESHOLD, threshold);
    }

    public void setDriverClass(String driverClass) {
        this.setProperty(DRIVER_CLASS, driverClass);
    }

    public void setImportMode(JDBCImporter.ImportMode importMode) {
        this.put(IMPORT_MODE, importMode);
    }

    public void setUncertifiedAllowed(boolean uncertifiedAllowed) {
        this.put(UNCERTIFIED_ALLOWED, uncertifiedAllowed);
    }

    public void setUrl(String url) {
        this.setProperty(URL, url);
    }
}

