/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.provider.jdbc.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.DataSource;
import com.ibm.bi.platform.moser.common.generated.metadata.ForeignKey;
import com.ibm.bi.platform.moser.common.generated.metadata.Index;
import com.ibm.bi.platform.moser.common.provider.ProviderProperties;
import com.ibm.bi.platform.moser.common.provider.metadata.IMetadataProvider;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.BaseObjectTypeDeserializer;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.FkColumnDeserializer;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.IndexedColumnDeserializer;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.JDBCTraceHandler;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.JMDConnectionFactory;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserCommandBlockExecutor;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.MoserMDImportProgressCallback;
import com.ibm.bi.platform.moser.core.metadata.provider.jdbc.PrimaryKeyColumnDeserializer;
import com.ibm.bi.platform.moser.core.provider.jdbc.JDBCProviderProperties;
import com.ibm.bi.platform.moser.core.provider.jdbc.metadata.MoserJDBCImporter;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.cognos.jmd.connection.IJMDConnection;
import com.ibm.cognos.jmd.connection.JDBCConnectionSpecification;
import com.ibm.cognos.jmd.exception.JMDException;
import com.ibm.cognos.jmd.importer.IJMDProgressCallback;
import com.ibm.cognos.jmd.importer.JDBCImporter;
import com.ibm.cognos.jmd.model.AttributeType;
import com.ibm.cognos.jmd.model.IJMDModel;
import com.ibm.cognos.jmd.model.JMDModelObject;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class JDBCMetadataProvider
implements IMetadataProvider {
    private static final String CONDITION = "condition";
    private static final String CONTAINS = "contains";
    private static final String ENDS_WITH = "endsWith";
    private static final String MATCHES = "matches";
    private static final String STARTS_WITH = "startsWith";
    private static final String VALUE = "value";
    private static final String DOT = ".";
    private static final String NULL_CATALOG = "null";
    private final TaskStatus status;
    private final Locale productLocale;
    private MoserCommandBlockExecutor cmdBlockExecutor;
    private MoserJDBCImporter jdbcImporter = new MoserJDBCImporter();

    public JDBCMetadataProvider() {
        this(new TaskStatus(), Locale.CANADA, null);
    }

    public JDBCMetadataProvider(TaskStatus status, Locale productLocale) {
        this(status, productLocale, null);
    }

    public JDBCMetadataProvider(TaskStatus status, Locale productLocale, MoserCommandBlockExecutor cmdBlockExecutor) {
        this.status = status;
        this.productLocale = productLocale;
        this.cmdBlockExecutor = cmdBlockExecutor;
    }

    public JDBCMetadataProvider(MoserCommandBlockExecutor cmdBlockExecutor) {
        this(new TaskStatus(), Locale.CANADA, cmdBlockExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Map<String, List<String>> getCatalogsAndSchemas(ProviderProperties props, List<Exception> exceptions) {
        JDBCProviderProperties p = (JDBCProviderProperties)props;
        ArrayList<JMDException> jmdExceptions = new ArrayList<JMDException>();
        try {
            Map<String, List<String>> map;
            Throwable throwable;
            JDBCConnectionSpecification connection;
            block21: {
                block22: {
                    connection = JMDConnectionFactory.create(p.getUrl(), p.getDriverClass(), p.getProperties(), p.getUncertifiedAllowed(), JDBCTraceHandler.createTracehandler(this), this.cmdBlockExecutor);
                    throwable = null;
                    boolean debugEnabled = LoggerAdapter.isDebugEnabled(this);
                    if (debugEnabled) {
                        StringBuilder msg = new StringBuilder("Calling JDBCImporter.getCatalogsSchemas() with connection: {");
                        msg.append(connection.toString());
                        msg.append("}");
                        LoggerAdapter.debug(this, msg.toString());
                    }
                    IJMDModel model = this.jdbcImporter.getCatalogsAndSchemas((IJMDConnection)connection, jmdExceptions);
                    if (debugEnabled) {
                        StringBuilder msg = new StringBuilder("Results from calling JDBCImporter.getCatalogsSchemas(): ");
                        msg.append(model.toString());
                        LoggerAdapter.debug(this, msg.toString());
                    }
                    map = JDBCMetadataProvider.extractCatalogSchemas(model);
                    if (connection == null) break block21;
                    if (throwable == null) break block22;
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                connection.close();
            }
            return map;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (connection != null) {
                            if (throwable != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                connection.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (JMDException e) {
                    jmdExceptions.add(e);
                    this.logExceptions(jmdExceptions, "Exception from calling JDBCImporter.getCatalogsSchemas()");
                    exceptions.addAll(jmdExceptions);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        finally {
            this.logExceptions(jmdExceptions, "Exception from calling JDBCImporter.getCatalogsSchemas()");
            exceptions.addAll(jmdExceptions);
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<String> getTables(ProviderProperties props, List<Exception> exceptions, Map<String, Object> feedback) {
        JDBCProviderProperties p = (JDBCProviderProperties)props;
        ArrayList<JMDException> jmdExceptions = new ArrayList<JMDException>();
        try {
            List<String> list;
            Throwable throwable;
            JDBCConnectionSpecification connection;
            block21: {
                block22: {
                    connection = JMDConnectionFactory.create(p.getUrl(), p.getDriverClass(), p.getProperties(), p.getUncertifiedAllowed(), JDBCTraceHandler.createTracehandler(this), this.cmdBlockExecutor);
                    throwable = null;
                    JDBCImporter.ImportSpec jmdSpec = JDBCMetadataProvider.generateJMDImportSpec(p, (IJMDConnection)connection, null, jmdExceptions);
                    jmdSpec.setImportOption(JDBCImporter.ImportOption.TABLES);
                    boolean debugEnabled = LoggerAdapter.isDebugEnabled(this);
                    if (debugEnabled) {
                        StringBuilder m = new StringBuilder("Calling JDBCImporter.importTables() with jmdSpec: {");
                        m.append(jmdSpec.toString());
                        m.append("}");
                        LoggerAdapter.debug(this, m.toString());
                    }
                    IJMDModel model = this.jdbcImporter.importTables(jmdSpec, feedback);
                    if (debugEnabled) {
                        StringBuilder m = new StringBuilder("Results from calling JDBCImporter.importTables(): ");
                        m.append(model.toString());
                        LoggerAdapter.debug(this, m.toString());
                    }
                    list = JDBCMetadataProvider.extractTables(model);
                    if (connection == null) break block21;
                    if (throwable == null) break block22;
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                connection.close();
            }
            return list;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (connection != null) {
                            if (throwable != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                connection.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (JMDException e) {
                    jmdExceptions.add(e);
                    this.logExceptions(jmdExceptions, "Exception from calling JDBCImporter.importTables()");
                    exceptions.addAll(jmdExceptions);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        finally {
            this.logExceptions(jmdExceptions, "Exception from calling JDBCImporter.importTables()");
            exceptions.addAll(jmdExceptions);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public com.ibm.bi.platform.moser.common.generated.metadata.Module getPhysicalModule(ProviderProperties props, List<Exception> exceptions, Map<String, Object> feedback) {
        BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
        JDBCProviderProperties p = (JDBCProviderProperties)props;
        String msg = JDBCMetadataProvider.buildLogMessage(p);
        ArrayList<JMDException> jmdExceptions = new ArrayList<JMDException>();
        try {
            com.ibm.bi.platform.moser.common.generated.metadata.Module module;
            Throwable throwable;
            JDBCConnectionSpecification connection;
            block44: {
                block45: {
                    IJMDModel model;
                    block41: {
                        block42: {
                            block43: {
                                block38: {
                                    block39: {
                                        block40: {
                                            boolean debugEnabled;
                                            JDBCImporter.ImportSpec jmdSpec;
                                            block35: {
                                                com.ibm.bi.platform.moser.common.generated.metadata.Module module2;
                                                block36: {
                                                    block37: {
                                                        connection = JMDConnectionFactory.create(p.getUrl(), p.getDriverClass(), p.getProperties(), p.getUncertifiedAllowed(), JDBCTraceHandler.createTracehandler(this), this.cmdBlockExecutor);
                                                        throwable = null;
                                                        LoggerAdapter.info(this, "Start importing " + msg);
                                                        MoserMDImportProgressCallback callback = new MoserMDImportProgressCallback(this.status, this.productLocale);
                                                        jmdSpec = JDBCMetadataProvider.generateJMDImportSpec(p, (IJMDConnection)connection, callback, jmdExceptions);
                                                        debugEnabled = LoggerAdapter.isDebugEnabled(this);
                                                        if (debugEnabled) {
                                                            StringBuilder m = new StringBuilder("Calling JDBCImporter.importTables() with jmdSpec: {");
                                                            m.append(jmdSpec.toString());
                                                            m.append("}");
                                                            LoggerAdapter.debug(this, m.toString());
                                                        }
                                                        if (!JDBCMetadataProvider.modelIsEmpty(model = this.jdbcImporter.importTables(jmdSpec, feedback))) break block35;
                                                        LoggerAdapter.error(this, "The metadata provider returned an empty model for " + msg);
                                                        module2 = null;
                                                        if (connection == null) break block36;
                                                        if (throwable == null) break block37;
                                                        try {
                                                            connection.close();
                                                        }
                                                        catch (Throwable throwable2) {
                                                            throwable.addSuppressed(throwable2);
                                                        }
                                                        break block36;
                                                    }
                                                    connection.close();
                                                }
                                                return module2;
                                            }
                                            if (!jmdExceptions.isEmpty() && JDBCMetadataProvider.allColumnMissing(model)) {
                                                jmdSpec.setImportMode(JDBCImporter.ImportMode.ITERATIVE);
                                                jmdExceptions.clear();
                                                if (feedback != null) {
                                                    feedback.clear();
                                                }
                                                model = this.jdbcImporter.importTables(jmdSpec, feedback);
                                            }
                                            if (debugEnabled) {
                                                StringBuilder m = new StringBuilder("Results from calling JDBCImporter.importTables(): ");
                                                m.append(model.toString());
                                                LoggerAdapter.debug(this, m.toString());
                                            }
                                            if (!JDBCMetadataProvider.modelIsEmpty(model) && !JDBCMetadataProvider.allColumnMissing(model)) break block38;
                                            LoggerAdapter.error(this, "The metadata provider returned an empty model for " + msg);
                                            module = null;
                                            if (connection == null) break block39;
                                            if (throwable == null) break block40;
                                            try {
                                                connection.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            break block39;
                                        }
                                        connection.close();
                                    }
                                    return module;
                                }
                                if (model.getRoot().getChildren().size() == 1 && ((JMDModelObject)model.getRoot().getChildren().get(0)).getChildren().size() == 1) break block41;
                                LoggerAdapter.error(this, "The metadata provider returned multiple models for " + msg);
                                module = null;
                                if (connection == null) break block42;
                                if (throwable == null) break block43;
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                break block42;
                            }
                            connection.close();
                        }
                        return module;
                    }
                    BaseMoserTask.throwIfCancelled(this.status, "import database metadata");
                    module = JDBCMetadataProvider.createModules((JMDModelObject)model.getRoot().getChildren().get(0), p).get(0);
                    if (connection == null) break block44;
                    if (throwable == null) break block45;
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    break block44;
                }
                connection.close();
            }
            return module;
            catch (Throwable throwable6) {
                try {
                    try {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    catch (Throwable throwable7) {
                        if (connection != null) {
                            if (throwable != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                connection.close();
                            }
                        }
                        throw throwable7;
                    }
                }
                catch (JMDException e) {
                    jmdExceptions.add(e);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        }
        finally {
            this.logExceptions(jmdExceptions, "Exception from calling JDBCImporter.importTables()");
            exceptions.addAll(jmdExceptions);
            LoggerAdapter.info(this, "End importing " + msg);
        }
        return null;
    }

    private static boolean allColumnMissing(IJMDModel model) {
        ArrayList catalogs = model.getRoot().getChildren();
        if (catalogs.size() != 1) {
            return true;
        }
        ArrayList schemas = ((JMDModelObject)catalogs.get(0)).getChildren();
        if (schemas.size() != 1) {
            return true;
        }
        for (JMDModelObject table : ((JMDModelObject)schemas.get(0)).getChildren()) {
            if (table.getChildren() == null || table.getChildren().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static List<com.ibm.bi.platform.moser.common.generated.metadata.Module> createModules(JMDModelObject catalog, JDBCProviderProperties props) {
        String dataSource = props.getDataSource();
        String catalogName = catalog.getAttributes().getString(AttributeType.NAME);
        if (catalogName == null) {
            catalogName = "";
        }
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(BaseObjectType.class, (JsonDeserializer)new BaseObjectTypeDeserializer()).addDeserializer(Index.IndexedColumn.class, (JsonDeserializer)new IndexedColumnDeserializer()).addDeserializer(String.class, (JsonDeserializer)new PrimaryKeyColumnDeserializer()).addDeserializer(ForeignKey.FkColumn.class, (JsonDeserializer)new FkColumnDeserializer());
        mapper.registerModule((Module)module);
        List moduleList = (List)mapper.convertValue((Object)catalog.getChildren(), (TypeReference)new TypeReference<List<BaseObjectType>>(){});
        return JDBCMetadataProvider.postProcessPhysicalModules(dataSource, catalogName, moduleList);
    }

    private static List<com.ibm.bi.platform.moser.common.generated.metadata.Module> postProcessPhysicalModules(String dataSource, String catalog, List<BaseObjectType> moduleList) {
        ArrayList<com.ibm.bi.platform.moser.common.generated.metadata.Module> physicalModules = new ArrayList<com.ibm.bi.platform.moser.common.generated.metadata.Module>();
        for (BaseObjectType aModule : moduleList) {
            String schema = JDBCMetadataProvider.postProcessPhysicalModule(dataSource, catalog, aModule);
            ((com.ibm.bi.platform.moser.common.generated.metadata.Module)aModule).setIdentifier(catalog + schema);
            physicalModules.add((com.ibm.bi.platform.moser.common.generated.metadata.Module)aModule);
        }
        return physicalModules;
    }

    private static String postProcessPhysicalModule(String dataSource, String catalog, BaseObjectType aModule) {
        StringBuilder schema = new StringBuilder();
        for (DataSource ds : ((com.ibm.bi.platform.moser.common.generated.metadata.Module)aModule).getDataSource()) {
            if (ds.getCmDataSource() == null && dataSource != null) {
                ds.setCmDataSource(dataSource);
            }
            if (ds.getName() == null) {
                StringBuilder sb = new StringBuilder();
                if (dataSource != null) {
                    sb.append(dataSource);
                }
                sb.append(DOT);
                sb.append(catalog);
                sb.append(DOT);
                String dsSchema = "";
                if (ds.getSchema() != null) {
                    dsSchema = ds.getSchema();
                }
                sb.append(dsSchema);
                ds.setName(sb.toString());
            }
            if (!catalog.isEmpty()) {
                ds.setCatalog(catalog);
            }
            if (ds.getSchema() == null || ds.getSchema().isEmpty()) continue;
            schema.append(DOT).append(ds.getSchema());
        }
        return schema.toString();
    }

    private static JDBCImporter.ImportSpec generateJMDImportSpec(JDBCProviderProperties props, IJMDConnection connection, MoserMDImportProgressCallback callback, List<JMDException> exceptions) {
        JDBCImporter.ImportSpec jmdSpec = new JDBCImporter.ImportSpec();
        jmdSpec.setCatalog(JDBCMetadataProvider.getFilterFromPattern(props.getCatalog()));
        jmdSpec.setSchema(JDBCMetadataProvider.getFilterFromPattern(props.getSchema()));
        jmdSpec.setTable(JDBCMetadataProvider.getFilterFromPattern(props.getTable()));
        MoserJDBCImporter.setInOrExcludedTablesImportSpec(jmdSpec, props);
        jmdSpec.setImportOption(props.getImportPrimaryForeignKeys() ? JDBCImporter.ImportOption.TABLES_COLUMNS_KEYS : JDBCImporter.ImportOption.TABLES_COLUMNS);
        jmdSpec.setExceptions(exceptions);
        jmdSpec.setConnection(connection);
        jmdSpec.setCallback((IJMDProgressCallback)callback);
        jmdSpec.setBulkLoadThreshold(props.getBulkLoadThreshold());
        jmdSpec.setImportMode(props.getImportMode());
        return jmdSpec;
    }

    public static String getFilterFromPattern(String pattern) {
        return pattern == null || NULL_CATALOG.equals(pattern) ? "\ufffds" : pattern;
    }

    private static Map<String, List<String>> extractCatalogSchemas(IJMDModel model) {
        if (JDBCMetadataProvider.modelIsEmpty(model)) {
            return Collections.emptyMap();
        }
        TreeMap<String, List<String>> catalogSchemas = new TreeMap<String, List<String>>();
        for (JMDModelObject catalog : model.getRoot().getChildren()) {
            ArrayList<String> schemas = null;
            for (JMDModelObject schema : catalog.getChildren()) {
                if (schemas == null) {
                    schemas = new ArrayList<String>();
                }
                String schemaName = schema.getAttributes().getString(AttributeType.NAME);
                schemas.add(schemaName);
            }
            String catalogName = catalog.getAttributes().getString(AttributeType.NAME);
            if (catalogName == null) {
                catalogName = NULL_CATALOG;
            }
            catalogSchemas.put(catalogName, schemas);
        }
        return catalogSchemas;
    }

    private static boolean modelIsEmpty(IJMDModel model) {
        return model == null || model.getRoot() == null || !model.getRoot().hasChildren();
    }

    private static List<String> extractTables(IJMDModel model) {
        if (JDBCMetadataProvider.modelIsEmpty(model)) {
            return Collections.emptyList();
        }
        ArrayList catalogs = model.getRoot().getChildren();
        if (catalogs.size() != 1) {
            return Collections.emptyList();
        }
        ArrayList schemas = ((JMDModelObject)catalogs.get(0)).getChildren();
        if (schemas.size() != 1) {
            return Collections.emptyList();
        }
        ArrayList<String> tables = new ArrayList<String>();
        for (JMDModelObject table : ((JMDModelObject)schemas.get(0)).getChildren()) {
            tables.add(table.getAttributes().getString(AttributeType.NAME));
        }
        return tables;
    }

    private void logExceptions(List<JMDException> jmdException, String message) {
        for (JMDException e : jmdException) {
            LoggerAdapter.warn((Object)this, message, e);
        }
    }

    private static String buildLogMessage(JDBCProviderProperties props) {
        String dataSource = props.getDataSource();
        String catalog = props.getCatalog();
        String schema = props.getSchema();
        boolean noCatalog = catalog == null || catalog.equals("\ufffds");
        boolean noSchema = schema == null || schema.equals("\ufffds");
        StringBuilder msg = new StringBuilder();
        if (noSchema && noCatalog) {
            msg.append("datasource: ");
            msg.append(dataSource);
        } else if (noSchema) {
            msg.append("catalog: ");
            msg.append(catalog);
            msg.append(" (datasource: ");
            msg.append(dataSource);
            msg.append(")");
        } else if (noCatalog) {
            msg.append("schema: ");
            msg.append(schema);
            msg.append(" (datasource: ");
            msg.append(dataSource);
            msg.append(")");
        } else {
            msg.append("schema: ");
            msg.append(schema);
            msg.append(" (catalog: ");
            msg.append(catalog);
            msg.append(", datasource: ");
            msg.append(dataSource);
            msg.append(")");
        }
        return msg.toString();
    }

    public static String buildTableFilter(JSONArray tableFilters) {
        if (tableFilters == null) {
            return "\ufffds";
        }
        StringBuilder tableFilter = new StringBuilder();
        for (Object obj : tableFilters) {
            if (tableFilter.length() > 0) {
                tableFilter.append("\ufffdo");
            }
            JSONObject filter = (JSONObject)obj;
            String condition = (String)filter.get((Object)CONDITION);
            String value = (String)filter.get((Object)VALUE);
            if (STARTS_WITH.equals(condition)) {
                tableFilter.append(value);
                tableFilter.append("\ufffds");
                continue;
            }
            if (ENDS_WITH.equals(condition)) {
                tableFilter.append("\ufffds");
                tableFilter.append(value);
                continue;
            }
            if (MATCHES.equals(condition)) {
                tableFilter.append(value);
                continue;
            }
            if (CONTAINS.equals(condition)) {
                tableFilter.append("\ufffds");
                tableFilter.append(value);
                tableFilter.append("\ufffds");
                continue;
            }
            tableFilter.delete(tableFilter.length() - "\ufffdo".length(), tableFilter.length());
        }
        return tableFilter.length() > 0 ? tableFilter.toString() : "\ufffds";
    }
}

