/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.provider.jdbc.metadata;

import com.ibm.bi.platform.moser.common.provider.ProviderProperties;
import com.ibm.bi.platform.moser.core.api.json.datasource.TablesBody;
import com.ibm.bi.platform.moser.core.provider.jdbc.JDBCProviderProperties;
import com.ibm.bi.platform.moser.core.utils.Pair;
import com.ibm.cognos.jmd.connection.IJMDConnection;
import com.ibm.cognos.jmd.exception.JMDException;
import com.ibm.cognos.jmd.importer.JDBCImporter;
import com.ibm.cognos.jmd.model.IJMDModel;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MoserJDBCImporter {
    public static final String STR_NUM_TABLES = "NumberOfTables";

    public IJMDModel getCatalogsAndSchemas(IJMDConnection connection, List<JMDException> exceptions) throws JMDException {
        return JDBCImporter.getCatalogsSchemas((IJMDConnection)connection, exceptions);
    }

    public IJMDModel importTables(JDBCImporter.ImportSpec jmdSpec, Map<String, Object> feedback) throws JMDException {
        return JDBCImporter.importTablesWithFeedback((JDBCImporter.ImportSpec)jmdSpec, feedback);
    }

    public static void setInOrExcludedTables(JDBCProviderProperties props, TablesBody tablesBody) {
        if (tablesBody == null) {
            return;
        }
        JSONArray tabs = tablesBody.getExcludedTables();
        if (tabs != null) {
            props.setExcludedTables(MoserJDBCImporter.jsonArrayToSet(tabs));
            return;
        }
        tabs = tablesBody.getIncludedTables();
        if (tabs != null) {
            props.setIncludedTables(MoserJDBCImporter.jsonArrayToSet(tabs));
        }
    }

    private static Set<String> jsonArrayToSet(JSONArray tabs) {
        HashSet<String> setTables = new HashSet<String>();
        for (Object obj : tabs) {
            String str = (String)obj;
            setTables.add(str);
        }
        return setTables;
    }

    public static void setInOrExcludedTablesTablesBody(TablesBody tablesBody, JSONObject jObj) {
        if (jObj == null) {
            return;
        }
        JSONArray excludedTables = (JSONArray)jObj.get((Object)"excludedTables");
        if (excludedTables != null) {
            tablesBody.setExcludedTables(excludedTables);
            return;
        }
        JSONArray includedTables = (JSONArray)jObj.get((Object)"includedTables");
        if (includedTables != null) {
            tablesBody.setIncludedTables(includedTables);
        }
    }

    public static void setInOrExcludedTablesProviderProperties(ProviderProperties props, JSONObject jObj) {
        if (jObj == null) {
            return;
        }
        JSONArray excludedTables = (JSONArray)jObj.get((Object)"excludedTables");
        if (excludedTables != null) {
            props.setExcludedTables(MoserJDBCImporter.jsonArrayToSet(excludedTables));
            return;
        }
        JSONArray includedTables = (JSONArray)jObj.get((Object)"includedTables");
        if (includedTables != null) {
            props.setIncludedTables(MoserJDBCImporter.jsonArrayToSet(includedTables));
        }
    }

    public static void setInOrExcludedTablesImportSpec(JDBCImporter.ImportSpec jmdSpec, ProviderProperties props) {
        if (props == null) {
            return;
        }
        Set tabs = props.getExcludedTables();
        if (tabs != null) {
            jmdSpec.setExcludeTables(tabs);
            return;
        }
        tabs = props.getIncludedTables();
        if (tabs != null) {
            jmdSpec.setIncludeTables(tabs);
        }
    }

    public static void setInOrExcludedTablesIfExists(JDBCProviderProperties jdbcProps, Pair<Set<String>, Set<String>> inOrExcludedTables) {
        if (inOrExcludedTables == null) {
            return;
        }
        Set<String> excl = inOrExcludedTables.getFirst();
        if (excl != null) {
            jdbcProps.setExcludedTables(excl);
            return;
        }
        Set<String> incl = inOrExcludedTables.getSecond();
        if (incl != null) {
            jdbcProps.setIncludedTables(incl);
        }
    }

    public static Pair<Set<String>, Set<String>> getInOrExcludedTablesFromTablesBody(TablesBody tablesBody) {
        Pair<Set<String>, Set<String>> r = new Pair<Set<String>, Set<String>>();
        if (tablesBody != null) {
            JSONArray tabs = tablesBody.getExcludedTables();
            if (tabs != null) {
                r.setFirst(MoserJDBCImporter.jsonArrayToSet(tabs));
                return r;
            }
            tabs = tablesBody.getIncludedTables();
            if (tabs != null) {
                r.setSecond(MoserJDBCImporter.jsonArrayToSet(tabs));
            }
        }
        return r;
    }

    public static Pair<Set<String>, Set<String>> getInOrExcludedTablesFromProviderProperties(ProviderProperties props) {
        Pair<Set<String>, Set<String>> r = new Pair<Set<String>, Set<String>>();
        if (props != null) {
            Set tabs = props.getExcludedTables();
            if (tabs != null) {
                r.setFirst(tabs);
                return r;
            }
            tabs = props.getIncludedTables();
            if (tabs != null) {
                r.setSecond(tabs);
            }
        }
        return r;
    }
}

