/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest;

import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.rest.RESTClient;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;

public class RESTClientResponse {
    private static final String RESPONSE_BODY = "Received response BODY {}";
    private static final String RESPONSE_CODE = "Received response CODE {}";
    private static final String RESPONSE_HEADERS = "Received response HEADERS {}";
    private final int responseCode;
    private CaseInsensitiveMap<String, String> responseHeaders;
    private List<Exception> exceptions;
    private byte[] rawResponse;
    private boolean isCachedResponse = false;

    public RESTClientResponse(int responseCode) {
        this(responseCode, null, null, null);
    }

    public RESTClientResponse(int responseCode, RESTClient client) {
        this(responseCode, client, null, null);
    }

    public RESTClientResponse(int responseCode, Exception exception) {
        this(responseCode, null, exception, null);
    }

    public RESTClientResponse(int responseCode, InputStream inputStream) {
        this(responseCode, null, null, inputStream);
    }

    public RESTClientResponse(int responseCode, RESTClient client, InputStream inputStream) {
        this(responseCode, client, null, inputStream);
    }

    private RESTClientResponse(int code, RESTClient client, Exception exception, InputStream inputStream) {
        this.responseCode = code;
        LoggerAdapter.trace((Object)this, RESPONSE_CODE, code);
        this.processClient(client);
        if (inputStream != null) {
            this.processInputStream(inputStream);
        } else {
            this.processClientInputStream(client);
        }
        if (exception != null) {
            this.addException(exception);
        }
    }

    private void processInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                this.rawResponse = IOUtils.toByteArray((InputStream)inputStream);
                if (LoggerAdapter.isTraceEnabled(this)) {
                    LoggerAdapter.trace((Object)this, RESPONSE_BODY, new String(this.rawResponse, StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                LoggerAdapter.error((Object)this, "Failed to read input stream", e);
                this.addException(e);
            }
        }
    }

    private void processClient(RESTClient client) {
        if (client == null) {
            return;
        }
        this.isCachedResponse = client.isCachedResponse();
        Header[] headers = client.getResponseHeaders();
        if (headers == null) {
            return;
        }
        for (Header header : headers) {
            if (this.responseHeaders == null) {
                this.responseHeaders = new CaseInsensitiveMap();
            }
            this.responseHeaders.put((Object)header.getName(), (Object)header.getValue());
        }
        if (LoggerAdapter.isTraceEnabled(this)) {
            LoggerAdapter.trace((Object)this, RESPONSE_HEADERS, this.responseHeaders.toString());
        }
    }

    private void processClientInputStream(RESTClient client) {
        if (client == null || this.getResponseCode() == 204 || this.getResponseCode() == 304) {
            return;
        }
        try (InputStream is = client.getResponseStream();){
            this.processInputStream(is);
        }
        catch (IOException e) {
            LoggerAdapter.error((Object)this, "Failed to read input stream from RESTClient", e);
            this.addException(e);
        }
    }

    public int getResponseCode() {
        return this.responseCode < 100 || this.responseCode > 599 ? 500 : this.responseCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONArtifact getJSONArtifactResponse() {
        if (this.rawResponse == null) {
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.rawResponse);){
            JSONArtifact jSONArtifact = JSON.parse((InputStream)is);
            return jSONArtifact;
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(this, e);
            this.addException(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject getJSONObjectResponse() {
        if (this.rawResponse == null) {
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.rawResponse);){
            JSONObject jSONObject = JSONObject.parse((InputStream)is);
            return jSONObject;
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(this, e);
            this.addException(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONArray getJSONArrayResponse() {
        if (this.rawResponse == null) {
            return null;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.rawResponse);){
            JSONArray jSONArray = JSONArray.parse((InputStream)is);
            return jSONArray;
        }
        catch (IOException e) {
            LoggerAdapter.errorExceptionStack(this, e);
            this.addException(e);
            return null;
        }
    }

    public String getResponseHeader(String name) {
        if (this.responseHeaders == null) {
            return null;
        }
        return (String)this.responseHeaders.get((Object)name);
    }

    public void setResponseHeader(String name, String value) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new CaseInsensitiveMap();
        }
        this.responseHeaders.put((Object)name, (Object)value);
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public byte[] getRawResponse() {
        return this.rawResponse == null ? null : (byte[])this.rawResponse.clone();
    }

    public boolean isCachedResponse() {
        return this.isCachedResponse;
    }

    private void addException(Exception e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<Exception>();
        }
        this.exceptions.add(e);
    }

    public Response toResponse() {
        Response.ResponseBuilder builder = Response.status((int)this.getResponseCode());
        if (this.rawResponse != null) {
            builder = builder.entity((Object)new String(this.rawResponse, StandardCharsets.UTF_8));
        }
        if (this.responseHeaders != null) {
            for (Object o : this.responseHeaders.entrySet()) {
                Map.Entry entry = (Map.Entry)o;
                builder = builder.header((String)entry.getKey(), entry.getValue());
            }
        }
        return builder.build();
    }

    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put((Object)"responseCode", (Object)this.getResponseCode());
        result.put((Object)"isCachedResponse", (Object)this.isCachedResponse);
        if (this.rawResponse != null) {
            result.put((Object)"rawResponse", (Object)new String(this.rawResponse, StandardCharsets.UTF_8));
        }
        if (this.responseHeaders != null) {
            JSONArray headers = new JSONArray();
            for (Object o : this.responseHeaders.entrySet()) {
                Map.Entry entry = (Map.Entry)o;
                JSONObject header = new JSONObject();
                header.put(entry.getKey(), entry.getValue());
                headers.add((Object)header);
            }
            result.put((Object)"responseHeaders", (Object)headers);
        }
        if (this.exceptions != null) {
            JSONArray exp = new JSONArray();
            for (Exception e : this.exceptions) {
                exp.add((Object)e.getLocalizedMessage());
            }
            result.put((Object)"exceptions", (Object)exp);
        }
        if (!(this.responseCode >= 100 && this.responseCode <= 599 || result.containsKey((Object)"rawResponse"))) {
            result.put((Object)"info", (Object)("Request originally returned " + this.responseCode + " response code with no response body, this is considered an internal error due to request timeout."));
        }
        return result;
    }

    public String toString() {
        return this.toJSON().toString();
    }
}

