/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.BaseService;
import com.ibm.bi.platform.moser.core.rest.service.IResource;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.json.java.JSONObject;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;

public abstract class BaseRESTService
extends BaseService {
    protected BaseRESTService(RESTClientConfig c) {
        super(c);
    }

    protected RESTClientResponse deleteResource(IResource resource, String id, IResource subResource, String subResourceId, IResource subSubResource, String subSubResourceId) {
        String url = this.uriBuilder(resource, id, subResource, subResourceId, subSubResource, subSubResourceId, new String[0]).toString();
        return this.delete(url);
    }

    protected RESTClientResponse getResource(IResource resource, String id, IResource subResource, String subResourceId, IResource subSubResource, String subSubResourceId, String ... fields) {
        String url = this.uriBuilder(resource, id, subResource, subResourceId, subSubResource, subSubResourceId, fields).toString();
        return this.get(url);
    }

    protected RESTClientResponse postResource(IResource resource, String id, IResource subResource, String subResourceId, IResource subSubResource, String subSubResourceId, JSONObject value) {
        String url = this.uriBuilder(resource, id, subResource, subResourceId, subSubResource, subSubResourceId, new String[0]).toString();
        return this.post(url, value == null ? new JSONObject() : value);
    }

    protected RESTClientResponse putResource(IResource resource, String id, IResource subResource, String subResourceId, IResource subSubResource, String subSubResourceId, JSONObject value) {
        String url = this.uriBuilder(resource, id, subResource, subResourceId, subSubResource, subSubResourceId, new String[0]).toString();
        return this.put(url, value == null ? new JSONObject() : value);
    }

    protected URIBuilder uriBuilder(IResource resource, String resourceId, IResource subResource, String subResourceId, IResource subSubResource, String subSubResourceId, String ... fields) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append("/");
        url.append(resource);
        if (resourceId != null && !resourceId.isEmpty()) {
            url.append("/");
            url.append(resourceId);
        }
        if (subResource != null) {
            url.append("/");
            url.append(subResource);
        }
        if (subResourceId != null && !subResourceId.isEmpty()) {
            url.append("/");
            url.append(subResourceId);
        }
        if (subSubResource != null) {
            url.append("/");
            url.append(subSubResource);
        }
        if (subSubResourceId != null && !subSubResourceId.isEmpty()) {
            url.append("/");
            url.append(subSubResourceId);
        }
        URIBuilder builder = this.uriBuilder(url.toString());
        String fieldsString = BaseRESTService.buildFields(fields);
        if (fieldsString != null && !fieldsString.isEmpty()) {
            builder.addParameter("fields", fieldsString);
        }
        return builder;
    }

    protected static String buildFields(String[] fields) {
        StringBuilder fieldsString = new StringBuilder();
        boolean first = true;
        for (String field : fields) {
            if (field == null || field.isEmpty()) continue;
            if (first) {
                first = false;
                fieldsString.append(field);
                continue;
            }
            fieldsString.append(",");
            fieldsString.append(field);
        }
        return fieldsString.toString();
    }

    protected URIBuilder uriBuilder(String uri) {
        try {
            return new URIBuilder(uri);
        }
        catch (URISyntaxException e) {
            throw new MoserException((Throwable)e);
        }
    }
}

