/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.json.java.JSONObject;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.apache.http.Header;

public abstract class BaseService {
    public static final String MOSER_SERVICE_ID = "MOSER-REST";
    protected static final String START_GET = "Start GET {}";
    private static final String START_PUT = "Start PUT {}";
    private static final String START_POST = "Start POST {}";
    private static final String START_DELETE = "Start DELETE {}";
    protected static final String RESPONSE_GET = "Response GET {} : {}";
    private static final String RESPONSE_PUT = "Response PUT {} : {}";
    private static final String RESPONSE_POST = "Response POST {} : {}";
    private static final String RESPONSE_DELETE = "Response DELETE {} : {}";
    protected static final String END_GET = "End GET {}";
    private static final String END_PUT = "End PUT {}";
    private static final String END_POST = "End POST {}";
    private static final String END_DELETE = "End DELETE {}";
    protected static final String ERROR_GET = "Failed GET {} : {}";
    private static final String ERROR_ETAG_GET = "Previous GET failed when using ETag {} , re-executing again without any ETag : {}";
    private static final String ERROR_PUT = "Failed PUT {} : {}";
    private static final String ERROR_POST = "Failed POST {} : {}";
    private static final String ERROR_DELETE = "Failed DELETE {} : {}";
    private static final Pattern ERROR_RESPONSE_CODE = Pattern.compile("^\\[\\d\\d\\d\\].*");
    protected String baseURL = MoserConfig.getBaseURL();
    public static final String STRING_FIELD_SEPARATOR = ":";
    protected final RESTClientConfig config;
    private final Set<Integer> errorResponseCodes;
    private final boolean autoRetry;
    private RESTClientFactory factory;

    public BaseService(RESTClientConfig c) {
        this.config = c;
        this.errorResponseCodes = MoserConfig.getErrorResponseCodes();
        this.autoRetry = MoserConfig.getRetryWithoutEtag();
        this.setFactory(RESTClientFactory.getInstance());
    }

    protected void setFactory(RESTClientFactory f) {
        this.factory = f;
    }

    protected void clearETag() {
        this.config.setRequestHeader("If-None-Match", null);
    }

    protected RESTClient getClient() {
        return this.factory.getClient(this.config);
    }

    protected RESTClient getTrustedClient() {
        RESTClient client = this.factory.getClient(this.config);
        client.makeTrusted(MOSER_SERVICE_ID);
        return client;
    }

    protected RESTClientResponse get(String url) {
        return this.get(url, "application/json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected RESTClientResponse get(String url, String mediaType) {
        String etagUsed;
        block24: {
            Object object;
            RESTClient client;
            block21: {
                RESTClientResponse rESTClientResponse;
                block22: {
                    block23: {
                        LoggerAdapter.trace((Object)this, START_GET, url);
                        Header ifNoneMatch = this.config.getRequestHeader("If-None-Match");
                        etagUsed = ifNoneMatch == null ? null : ifNoneMatch.getValue();
                        client = this.getClient();
                        object = null;
                        RESTClientResponse resp = this.getClientResource(url, mediaType, client);
                        if (this.autoRetry && etagUsed != null && this.isError(resp.getResponseCode())) break block21;
                        rESTClientResponse = resp;
                        if (client == null) break block22;
                        if (object == null) break block23;
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        break block22;
                    }
                    client.close();
                }
                LoggerAdapter.trace((Object)this, END_GET, url);
                return rESTClientResponse;
            }
            try {
                if (client != null) {
                    if (object != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
                break block24;
                {
                    catch (Throwable throwable) {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (client != null) {
                                if (object != null) {
                                    try {
                                        client.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    client.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Exception e) {
                try {
                    object = this.handleException(e, ERROR_GET, url);
                }
                catch (Throwable throwable) {
                    LoggerAdapter.trace((Object)this, END_GET, url);
                    throw throwable;
                }
                LoggerAdapter.trace((Object)this, END_GET, url);
                return object;
            }
        }
        LoggerAdapter.trace((Object)this, END_GET, url);
        return this.getWithoutEtag(url, mediaType, etagUsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private RESTClientResponse getWithoutEtag(String url, String mediaType, String etagUsed) {
        RESTClientResponse rESTClientResponse;
        Object object;
        RESTClient client;
        block16: {
            block17: {
                LoggerAdapter.error((Object)this, ERROR_ETAG_GET, etagUsed, url);
                LoggerAdapter.trace((Object)this, START_GET, url);
                client = this.getClient();
                object = null;
                client.setRequestHeader("If-None-Match", null);
                rESTClientResponse = this.getClientResource(url, mediaType, client);
                if (client == null) break block16;
                if (object == null) break block17;
                try {
                    client.close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                break block16;
            }
            client.close();
        }
        LoggerAdapter.trace((Object)this, END_GET, url);
        return rESTClientResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (client != null) {
                                if (object != null) {
                                    try {
                                        client.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    client.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        object = this.handleException(e, ERROR_GET, url);
                        LoggerAdapter.trace((Object)this, END_GET, url);
                        return object;
                    }
                }
                catch (Throwable throwable4) {
                    LoggerAdapter.trace((Object)this, END_GET, url);
                    throw throwable4;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected int getStream(BufferedOutputStream bos, String url, String mediaType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated
    protected RESTClientResponse get(String url, String mediaType, String etag) {
        String etagUsed;
        block26: {
            Object object;
            RESTClient client;
            block23: {
                RESTClientResponse rESTClientResponse;
                block24: {
                    block25: {
                        LoggerAdapter.trace((Object)this, START_GET, url);
                        etagUsed = etag;
                        if (etagUsed == null) {
                            Header ifNoneMatch = this.config.getRequestHeader("If-None-Match");
                            etagUsed = ifNoneMatch == null ? null : ifNoneMatch.getValue();
                        }
                        client = this.getClient();
                        object = null;
                        if (etag != null) {
                            client.setRequestHeader("If-None-Match", etag);
                        }
                        RESTClientResponse resp = this.getClientResource(url, mediaType, client);
                        if (this.autoRetry && etagUsed != null && this.isError(resp.getResponseCode())) break block23;
                        rESTClientResponse = resp;
                        if (client == null) break block24;
                        if (object == null) break block25;
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        break block24;
                    }
                    client.close();
                }
                LoggerAdapter.trace((Object)this, END_GET, url);
                return rESTClientResponse;
            }
            try {
                if (client != null) {
                    if (object != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
                break block26;
                {
                    catch (Throwable throwable) {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (client != null) {
                                if (object != null) {
                                    try {
                                        client.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    client.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Exception e) {
                try {
                    object = this.handleException(e, ERROR_GET, url);
                }
                catch (Throwable throwable) {
                    LoggerAdapter.trace((Object)this, END_GET, url);
                    throw throwable;
                }
                LoggerAdapter.trace((Object)this, END_GET, url);
                return object;
            }
        }
        LoggerAdapter.trace((Object)this, END_GET, url);
        return this.getWithoutEtag(url, mediaType, etagUsed);
    }

    private RESTClientResponse getClientResource(String url, String mediaType, RESTClient client) throws IOException {
        client.accept(mediaType);
        int respCode = client.getResource(url);
        if (304 != respCode) {
            try (InputStream inputStream = client.getResponseStream();){
                RESTClientResponse rESTClientResponse = this.handleResponse(client, respCode, inputStream, RESPONSE_GET, url);
                return rESTClientResponse;
            }
        }
        return this.handleResponse(client, respCode, RESPONSE_GET, url);
    }

    protected RESTClientResponse post(String url, JSONObject value) {
        return this.post(url, value.toString());
    }

    protected RESTClientResponse post(String url, String jsonString) {
        byte[] rawBytes = jsonString.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream is = new ByteArrayInputStream(rawBytes);
        return this.post(url, "application/json", rawBytes.length, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected RESTClientResponse post(String url, String mediaType, long length, InputStream stream) {
        RESTClientResponse rESTClientResponse;
        Object object;
        RESTClient client;
        block16: {
            block17: {
                LoggerAdapter.trace((Object)this, START_POST, url);
                client = this.getClient();
                object = null;
                int respCode = client.createResource(url, mediaType, length, stream);
                rESTClientResponse = this.handleResponse(client, respCode, RESPONSE_POST, url);
                if (client == null) break block16;
                if (object == null) break block17;
                try {
                    client.close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                break block16;
            }
            client.close();
        }
        LoggerAdapter.trace((Object)this, END_POST, url);
        return rESTClientResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (client != null) {
                                if (object != null) {
                                    try {
                                        client.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    client.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        object = this.handleException(e, ERROR_POST, url);
                        LoggerAdapter.trace((Object)this, END_POST, url);
                        return object;
                    }
                }
                catch (Throwable throwable4) {
                    LoggerAdapter.trace((Object)this, END_POST, url);
                    throw throwable4;
                }
            }
        }
    }

    protected RESTClientResponse put(String url, JSONObject value) {
        return this.put(url, value.toString());
    }

    protected RESTClientResponse put(String url, String jsonString) {
        byte[] rawBytes = jsonString.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream is = new ByteArrayInputStream(rawBytes);
        return this.put(url, "application/json", rawBytes.length, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected RESTClientResponse put(String url, String mediaType, long length, InputStream stream) {
        RESTClientResponse rESTClientResponse;
        Object object;
        RESTClient client;
        block16: {
            block17: {
                LoggerAdapter.trace((Object)this, START_PUT, url);
                client = this.getClient();
                object = null;
                int respCode = client.updateResource(url, mediaType, length, stream);
                rESTClientResponse = this.handleResponse(client, respCode, RESPONSE_PUT, url);
                if (client == null) break block16;
                if (object == null) break block17;
                try {
                    client.close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                break block16;
            }
            client.close();
        }
        LoggerAdapter.trace((Object)this, END_PUT, url);
        return rESTClientResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (client != null) {
                                if (object != null) {
                                    try {
                                        client.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    client.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        object = this.handleException(e, ERROR_PUT, url);
                        LoggerAdapter.trace((Object)this, END_PUT, url);
                        return object;
                    }
                }
                catch (Throwable throwable4) {
                    LoggerAdapter.trace((Object)this, END_PUT, url);
                    throw throwable4;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected RESTClientResponse delete(String url) {
        RESTClientResponse rESTClientResponse;
        Object object;
        RESTClient client;
        block16: {
            block17: {
                LoggerAdapter.trace((Object)this, START_DELETE, url);
                client = this.getClient();
                object = null;
                int respCode = client.deleteResource(url, "application/json");
                rESTClientResponse = this.handleResponse(client, respCode, RESPONSE_DELETE, url);
                if (client == null) break block16;
                if (object == null) break block17;
                try {
                    client.close();
                }
                catch (Throwable throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                break block16;
            }
            client.close();
        }
        LoggerAdapter.trace((Object)this, END_DELETE, url);
        return rESTClientResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (client != null) {
                                if (object != null) {
                                    try {
                                        client.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    client.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                    catch (Exception e) {
                        object = this.handleException(e, ERROR_DELETE, url);
                        LoggerAdapter.trace((Object)this, END_DELETE, url);
                        return object;
                    }
                }
                catch (Throwable throwable4) {
                    LoggerAdapter.trace((Object)this, END_DELETE, url);
                    throw throwable4;
                }
            }
        }
    }

    private RESTClientResponse handleResponse(RESTClient client, int respCode, String context, Object ... args) {
        RESTClientResponse resp = new RESTClientResponse(respCode, client);
        this.logResponse(resp, context, args);
        return resp;
    }

    protected RESTClientResponse handleResponse(RESTClient client, int respCode, InputStream inputStream, String context, Object ... args) {
        RESTClientResponse resp = new RESTClientResponse(respCode, client, inputStream);
        this.logResponse(resp, context, args);
        return resp;
    }

    protected RESTClientResponse handleException(Exception e, String context, Object ... args) {
        RESTClientResponse resp;
        String msg = e.getMessage();
        if (msg == null || !ERROR_RESPONSE_CODE.matcher(msg).matches()) {
            resp = new RESTClientResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e);
        } else {
            int responseCode = Integer.parseInt(msg.substring(1, 4));
            resp = new RESTClientResponse(responseCode, e);
        }
        this.logResponse(resp, context, args);
        return resp;
    }

    private void logResponse(RESTClientResponse resp, String context, Object ... args) {
        if (this.isError(resp.getResponseCode())) {
            Object[] newArgs = Arrays.copyOf(args, args.length + 1);
            newArgs[args.length] = resp.toString();
            LoggerAdapter.error((Object)this, context, newArgs);
        } else if (LoggerAdapter.isTraceEnabled(this)) {
            Object[] newArgs = Arrays.copyOf(args, args.length + 1);
            newArgs[args.length] = resp.toString();
            LoggerAdapter.trace((Object)this, context, newArgs);
        }
    }

    private boolean isError(int responseCode) {
        return responseCode < 500 && this.errorResponseCodes.contains(responseCode);
    }
}

