/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.BaseRESTService;
import com.ibm.bi.platform.moser.core.rest.service.IResource;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.ws.rs.core.Response;
import org.apache.http.client.utils.URIBuilder;

public class ContentService
extends BaseRESTService {
    public static final String RESP_DATA = "data";

    protected ContentService(RESTClientConfig c) {
        super(c);
    }

    public RESTClientResponse getBySearchPath(String searchPath, String ... fields) {
        String url = this.uriBuilderSearchPath(searchPath, fields).toString();
        return this.get(url);
    }

    public RESTClientResponse getBySearchPathWithEtag(String searchPath, String eTag, String ... fields) {
        String url = this.uriBuilderSearchPath(searchPath, fields).toString();
        return this.get(url, "application/json", eTag);
    }

    public RESTClientResponse get(ContentResource resource, String id, ContentSubResource subResource, String types, String ... fields) {
        String url = this.uriBuilderGet(resource, id, subResource, types, fields).toString();
        return this.get(url);
    }

    public RESTClientResponse getWithEtag(ContentResource resource, String id, ContentSubResource subResource, String types, String eTag, String ... fields) {
        String url = this.uriBuilderGet(resource, id, subResource, types, fields).toString();
        return this.get(url, "application/json", eTag);
    }

    public RESTClientResponse delete(ContentResource resource, boolean force, boolean recursive, String ... ids) {
        String url = this.uriBuilderDelete(resource, force, recursive, ids).toString();
        return this.delete(url);
    }

    public RESTClientResponse put(ContentResource resource, String id, ContentSubResource subResource, JSONObject value) {
        return this.putResource(resource, id, subResource, null, null, null, value);
    }

    public RESTClientResponse post(ContentResource resource, String id, ContentSubResource subResource, JSONObject value) {
        return this.postResource(resource, id, subResource, null, null, null, value);
    }

    public RESTClientResponse copy(String destinationParentID, String sourceID, String newName) {
        URIBuilder builder = this.uriBuilderCopy(destinationParentID, sourceID);
        String body = "";
        if (newName != null) {
            JSONObject update = new JSONObject();
            update.put((Object)"defaultName", (Object)newName);
            body = update.toString();
        }
        return this.post(builder.toString(), body);
    }

    private URIBuilder uriBuilderCopy(String destinationId, String sourceId) {
        URIBuilder builder = super.uriBuilder(ContentResource.OBJECTS, destinationId, ContentSubResource.ITEMS, null, null, null, new String[0]);
        builder.addParameter("recursive", Boolean.TRUE.toString());
        builder.addParameter("source", sourceId);
        return builder;
    }

    public static String[] appendFields(String[] fields, String ... newFields) {
        if (newFields == null || newFields.length == 0) {
            return fields;
        }
        if (fields == null || fields.length == 0) {
            return newFields;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(Arrays.asList(fields));
        result.addAll(Arrays.asList(newFields));
        return result.toArray(new String[result.size()]);
    }

    public static String buildTypes(String ... types) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String type : types) {
            if (type == null || type.isEmpty()) continue;
            if (first) {
                result.append(type);
                first = false;
                continue;
            }
            result.append(",");
            result.append(type);
        }
        return result.toString();
    }

    public static JSONObject extractData(RESTClientResponse resp) {
        if (resp.getResponseCode() != Response.Status.OK.getStatusCode()) {
            return null;
        }
        JSONObject json = resp.getJSONObjectResponse();
        if (json == null) {
            return null;
        }
        JSONArray data = (JSONArray)json.get((Object)RESP_DATA);
        if (data == null || data.isEmpty()) {
            return null;
        }
        return (JSONObject)data.get(0);
    }

    private URIBuilder uriBuilderSearchPath(String searchPath, String ... fields) {
        URIBuilder builder = super.uriBuilder(ContentResource.SEARCH_PATH, null, null, null, null, null, fields);
        builder.addParameter("searchPath", searchPath);
        return builder;
    }

    private URIBuilder uriBuilderGet(ContentResource resource, String id, ContentSubResource subResource, String types, String ... fields) {
        URIBuilder builder = super.uriBuilder(resource, id, subResource, null, null, null, fields);
        if (types != null && !types.isEmpty()) {
            builder.addParameter("types", types);
        }
        return builder;
    }

    private URIBuilder uriBuilderDelete(ContentResource resource, boolean force, boolean recursive, String ... ids) {
        if (ids.length == 1) {
            return this.uriBuilderDeleteSingleton(resource, force, recursive, ids[0]);
        }
        URIBuilder builder = super.uriBuilder(resource, null, null, null, null, null, new String[0]);
        StringBuilder idsString = new StringBuilder();
        boolean first = true;
        for (String id : ids) {
            if (id == null || id.isEmpty()) continue;
            if (first) {
                first = false;
                idsString.append(id);
                continue;
            }
            idsString.append(",");
            idsString.append(id);
        }
        if (!first) {
            builder.addParameter("ids", idsString.toString());
        }
        if (force) {
            builder.addParameter("force", Boolean.TRUE.toString());
        }
        if (recursive) {
            builder.addParameter("recursive", Boolean.TRUE.toString());
        }
        return builder;
    }

    private URIBuilder uriBuilderDeleteSingleton(ContentResource resource, boolean force, boolean recursive, String id) {
        URIBuilder builder = super.uriBuilder(resource, id, null, null, null, null, new String[0]);
        if (force) {
            builder.addParameter("force", Boolean.TRUE.toString());
        }
        if (recursive) {
            builder.addParameter("recursive", Boolean.TRUE.toString());
        }
        return builder;
    }

    public static final class Permissions {
        public static final String EXECUTE = "execute";
        public static final String READ = "read";
        public static final String SET_POLICY = "setPolicy";
        public static final String TRAVERCE = "traverse";
        public static final String WRITE = "write";

        private Permissions() {
        }
    }

    public static final class Field {
        public static final String ALL = "*";
        public static final String AAS_AFFINE_CONNECTIONS = "aasAffineConnections";
        public static final String AAS_AUDIT_LEVEL = "aasAuditLevel";
        public static final String AAS_EXECUTION_TIME_LIMIT = "aasExecutionTimeLimit";
        public static final String AAS_MAXIMUM_PROCESSES = "aasMaximumProcesses";
        public static final String AAS_NON_AFFINE_CONNECTIONS = "aasNonAffineConnections";
        public static final String AAS_PEAK_AFFINE_CONNECTIONS = "aasPeakAffineConnections";
        public static final String AAS_PEAK_MAXIMUM_PROCESSES = "aasPeakMaximumProcesses";
        public static final String AAS_PEAK_NON_AFFINE_CONNECTIONS = "aasPeakNonAffineConnections";
        public static final String ACTION = "action";
        public static final String ACTIVE = "active";
        public static final String ACTIVE_JMX_PROXY_URI = "activeJMXProxyURI";
        public static final String ACTUAL_COMPLETION_TIME = "actualCompletionTime";
        public static final String ACTUAL_EXECUTION_TIME = "actualExecutionTime";
        public static final String ADVANCED_SETTINGS = "advancedSettings";
        public static final String AGGREGATES = "aggregates";
        public static final String ALIAS_ROOT = "aliasRoot";
        public static final String ALLOW_ANNOTATIONS = "allowAnnotations";
        public static final String ALLOW_NOTIFICATION = "allowNotification";
        public static final String ALLOW_SUBSCRIPTION = "allowSubscription";
        public static final String ANALYTICS = "analytics";
        public static final String ANCESTORS = "ancestors";
        public static final String ANS_ANNOTATION_LIFETIME = "ansAnnotationLifetime";
        public static final String ANS_AUDIT_LEVEL = "ansAuditLevel";
        public static final String API_TOKEN = "apiToken";
        public static final String APPLICATION_GUID = "applicationGUID";
        public static final String APPLICATION_ID = "applicationID";
        public static final String APPLICATION_STATE = "applicationState";
        public static final String APPLICATION_URL = "applicationURL";
        public static final String ARCHIVE_LOCATION_FILE_SCHEME_ROOT = "archiveLocationFileSchemeRoot";
        public static final String AS_AUDIT_LEVEL = "asAuditLevel";
        public static final String AS_CONNECTIONS = "asConnections";
        public static final String AS_MAXIMUM_E_MAIL_ATTACHMENT_SIZE = "asMaximumEMailAttachmentSize";
        public static final String AS_OF_TIME = "asOfTime";
        public static final String AS_PEAK_CONNECTIONS = "asPeakConnections";
        public static final String BASE = "base";
        public static final String BASE_ANALYTICS = "baseAnalytics";
        public static final String BASE_DEFINITION = "baseDefinition";
        public static final String BASE_OVERRIDES = "baseOverrides";
        public static final String BCS_AFFINE_CONNECTIONS = "bcsAffineConnections";
        public static final String BCS_AUDIT_LEVEL = "bcsAuditLevel";
        public static final String BCS_EXECUTION_TIME_LIMIT = "bcsExecutionTimeLimit";
        public static final String BCS_MAXIMUM_PROCESSES = "bcsMaximumProcesses";
        public static final String BCS_NON_AFFINE_CONNECTIONS = "bcsNonAffineConnections";
        public static final String BCS_PEAK_AFFINE_CONNECTIONS = "bcsPeakAffineConnections";
        public static final String BCS_PEAK_MAXIMUM_PROCESSES = "bcsPeakMaximumProcesses";
        public static final String BCS_PEAK_NON_AFFINE_CONNECTIONS = "bcsPeakNonAffineConnections";
        public static final String BINDING = "binding";
        public static final String BINDING_NAME = "bindingName";
        public static final String BOOKMARK_ITEM = "bookmarkItem";
        public static final String BOOKMARK_TEXT = "bookmarkText";
        public static final String BPM_REST_URI = "bpmRestURI";
        public static final String BRS_AFFINE_CONNECTIONS = "brsAffineConnections";
        public static final String BRS_AUDIT_LEVEL = "brsAuditLevel";
        public static final String BRS_AUDIT_NATIVE_QUERY = "brsAuditNativeQuery";
        public static final String BRS_CHART_HOTSPOT_LIMIT = "brsChartHotspotLimit";
        public static final String BRS_DATA_SOURCE_CHANGE = "brsDataSourceChange";
        public static final String BRS_EXECUTION_TIME_LIMIT = "brsExecutionTimeLimit";
        public static final String BRS_MAXIMUM_E_MAIL_ATTACHMENT_SIZE = "brsMaximumEMailAttachmentSize";
        public static final String BRS_MAXIMUM_PROCESSES = "brsMaximumProcesses";
        public static final String BRS_NON_AFFINE_CONNECTIONS = "brsNonAffineConnections";
        public static final String BRS_PDF_CHARACTER_ENCODING = "brsPDFCharacterEncoding";
        public static final String BRS_PDF_COMPRESSION_LEVEL = "brsPDFCompressionLevel";
        public static final String BRS_PDF_COMPRESSION_TYPE = "brsPDFCompressionType";
        public static final String BRS_PDF_EMBED_FONTS = "brsPDFEmbedFonts";
        public static final String BRS_PEAK_AFFINE_CONNECTIONS = "brsPeakAffineConnections";
        public static final String BRS_PEAK_MAXIMUM_PROCESSES = "brsPeakMaximumProcesses";
        public static final String BRS_PEAK_NON_AFFINE_CONNECTIONS = "brsPeakNonAffineConnections";
        public static final String BULK_EVENTS = "bulkEvents";
        public static final String BUSINESS_PHONE = "businessPhone";
        public static final String CACHED_CA_CERTIFICATES = "cachedCACertificates";
        public static final String CAN_BURST = "canBurst";
        public static final String CAN_CUSTOMIZE = "canCustomize";
        public static final String CAPABILITIES = "capabilities";
        public static final String CAPACITY = "capacity";
        public static final String CATALOG = "catalog";
        public static final String CHANNEL = "channel";
        public static final String CLOSE_CONNECTION_COMMANDS = "closeConnectionCommands";
        public static final String CLOSE_SESSION_COMMANDS = "closeSessionCommands";
        public static final String CMCS_AUDIT_LEVEL = "cmcsAuditLevel";
        public static final String CMCS_HEAP_LIMIT = "cmcsHeapLimit";
        public static final String CMS_AUDIT_LEVEL = "cmsAuditLevel";
        public static final String CMS_CONNECTIONS = "cmsConnections";
        public static final String CMS_PEAK_CONNECTIONS = "cmsPeakConnections";
        public static final String COLLABORATION_DISCOVERY_URI = "collaborationDiscoveryURI";
        public static final String COMMON_SYMMETRIC_KEY = "commonSymmetricKey";
        public static final String COMPONENT_ID = "componentID";
        public static final String CONFIGURATION = "configuration";
        public static final String CONNECTIONS = "connections";
        public static final String CONNECTION_STRING = "connectionString";
        public static final String CONSUMERS = "consumers";
        public static final String CONTACT = "contact";
        public static final String CONTACT_E_MAIL = "contactEMail";
        public static final String CONTENT = "content";
        public static final String CONTENT_LOCALE = "contentLocale";
        public static final String CONTENT_LOCALE_MAP = "contentLocaleMap";
        public static final String CONTENT_TYPE = "contentType";
        public static final String CONTEXT = "context";
        public static final String CONTEXT_BLOCK_COUNT = "contextBlockCount";
        public static final String COOKIE_CAM_PASSPORT_HTTP_ONLY = "cookieCAMPassportHttpOnly";
        public static final String COOKIE_DOMAIN = "cookieDomain";
        public static final String COOKIE_PATH = "cookiePath";
        public static final String COOKIE_SECURE = "cookieSecure";
        public static final String CREATION_TIME = "creationTime";
        public static final String CREDENTIAL = "credential";
        public static final String CREDENTIAL_NAMESPACES = "credentialNamespaces";
        public static final String CREDENTIALS = "credentials";
        public static final String CREDENTIALS_EX = "credentialsEx";
        public static final String CROSSTAB_ITEM_DISPLAY_COUNT_DEFAULT = "crosstabItemDisplayCountDefault";
        public static final String CROSSTAB_ITEM_DISPLAY_COUNT_LIMIT = "crosstabItemDisplayCountLimit";
        public static final String CS_AFFINE_CONNECTIONS = "csAffineConnections";
        public static final String CS_AUDIT_LEVEL = "csAuditLevel";
        public static final String CS_EXECUTION_TIME_LIMIT = "csExecutionTimeLimit";
        public static final String CS_MAXIMUM_PROCESSES = "csMaximumProcesses";
        public static final String CS_NON_AFFINE_CONNECTIONS = "csNonAffineConnections";
        public static final String CS_PEAK_AFFINE_CONNECTIONS = "csPeakAffineConnections";
        public static final String CS_PEAK_MAXIMUM_PROCESSES = "csPeakMaximumProcesses";
        public static final String CS_PEAK_NON_AFFINE_CONNECTIONS = "csPeakNonAffineConnections";
        public static final String CUBE_CONTENT_NAME = "cubeContentName";
        public static final String DAILY_PERIOD = "dailyPeriod";
        public static final String DAS_AUDIT_LEVEL = "dasAuditLevel";
        public static final String DATA = "data";
        public static final String DATA_BLOCKS = "dataBlocks";
        public static final String DATA_DESCRIPTOR = "dataDescriptor";
        public static final String DATA_MODIFICATION_TIME = "dataModificationTime";
        public static final String DATA_PATH_INFO = "dataPathInfo";
        public static final String DATA_SET_BASE = "dataSetBase";
        public static final String DATA_SET_SIZE = "dataSetSize";
        public static final String DATA_SIZE = "dataSize";
        public static final String DATA_SOURCE_ACCESS_ACCOUNT = "dataSourceAccessAccount";
        public static final String DATA_SOURCE_CONNECTION_NAME = "dataSourceConnectionName";
        public static final String DATA_SOURCE_NAME = "dataSourceName";
        public static final String DATA_TYPE = "dataType";
        public static final String DATA_TYPEADVANCED_SETTINGS = "dataTypeadvancedSettings";
        public static final String DATA_TYPEFORMAT = "dataTypeformat";
        public static final String DATA_TYPEGOVERNORS = "dataTypegovernors";
        public static final String DATA_TYPEHEIGHT = "dataTypeheight";
        public static final String DATA_TYPELOCALE = "dataTypelocale";
        public static final String DDS_AUDIT_LEVEL = "ddsAuditLevel";
        public static final String DDS_CONNECTIONS = "ddsConnections";
        public static final String DDS_LISTENERS_PER_PROCESSOR = "ddsListenersPerProcessor";
        public static final String DDS_PEAK_CONNECTIONS = "ddsPeakConnections";
        public static final String DECLARED_EDIT_RIGHTS = "declaredEditRights";
        public static final String DECLARED_SUBMIT_RIGHTS = "declaredSubmitRights";
        public static final String DECLARED_VIEW_RIGHTS = "declaredViewRights";
        public static final String DESCRIPTION = "description";
        public static final String DEFAULT_ANALYSIS = "defaultAnalysis";
        public static final String DEFAULT_DESCRIPTION = "defaultDescription";
        public static final String DEFAULT_DESCRIPTIONDESCRIPTION = "defaultDescriptiondescription";
        public static final String DEFAULT_FONT = "defaultFont";
        public static final String DEFAULT_NAME = "defaultName";
        public static final String DEFAULT_NAMEOBJECT_CLASS = "defaultNameobjectClass";
        public static final String DEFAULT_OUTPUT_FORMAT = "defaultOutputFormat";
        public static final String DEFAULT_PORTAL_ACTION = "defaultPortalAction";
        public static final String DEFAULT_SCREEN_TIP = "defaultScreenTip";
        public static final String DEFAULT_TRIGGER_DESCRIPTIONMETADATA_MODEL = "defaultTriggerDescriptionmetadataModel";
        public static final String DEFINITION = "definition";
        public static final String DEPLOYED_OBJECT = "deployedObject";
        public static final String DEPLOYED_OBJECT_ANCESTOR_DEFAULT_NAMES = "deployedObjectAncestorDefaultNames";
        public static final String DEPLOYED_OBJECT_CLASS = "deployedObjectClass";
        public static final String DEPLOYED_OBJECT_DEFAULT_NAME = "deployedObjectDefaultName";
        public static final String DEPLOYED_OBJECT_STATUS = "deployedObjectStatus";
        public static final String DEPLOYED_OBJECT_USAGE = "deployedObjectUsage";
        public static final String DEPLOYMENT_OPTIONS = "deploymentOptions";
        public static final String DEPLOYMENT_REFERENCES = "deploymentReferences";
        public static final String DEPTH = "depth";
        public static final String DETAIL = "detail";
        public static final String DETAILS = "details";
        public static final String DETAIL_TIME = "detailTime";
        public static final String DETECT_CHANGES = "detectChanges";
        public static final String DIMS_AFFINE_CONNECTIONS = "dimsAffineConnections";
        public static final String DIMS_AUDIT_LEVEL = "dimsAuditLevel";
        public static final String DIMS_EXECUTION_TIME_LIMIT = "dimsExecutionTimeLimit";
        public static final String DIMS_MAXIMUM_PROCESSES = "dimsMaximumProcesses";
        public static final String DIMS_NON_AFFINE_CONNECTIONS = "dimsNonAffineConnections";
        public static final String DIMS_PEAK_AFFINE_CONNECTIONS = "dimsPeakAffineConnections";
        public static final String DIMS_PEAK_MAXIMUM_PROCESSES = "dimsPeakMaximumProcesses";
        public static final String DIMS_PEAK_NON_AFFINE_CONNECTIONS = "dimsPeakNonAffineConnections";
        public static final String DIMS_QUEUE_LIMIT = "dimsQueueLimit";
        public static final String DISABLED = "disabled";
        public static final String DIS_AUDIT_LEVEL = "disAuditLevel";
        public static final String DIS_CONNECTIONS = "disConnections";
        public static final String DISPATCHER_AUDIT_LEVEL = "dispatcherAuditLevel";
        public static final String DISPATCHER_ID = "dispatcherID";
        public static final String DISPATCHER_PATH = "dispatcherPath";
        public static final String DISPLAY_SEQUENCE = "displaySequence";
        public static final String DIS_PEAK_CONNECTIONS = "disPeakConnections";
        public static final String DISTRIBUTION_MEMBERS = "distributionMembers";
        public static final String DMS_AFFINE_CONNECTIONS = "dmsAffineConnections";
        public static final String DMS_AUDIT_LEVEL = "dmsAuditLevel";
        public static final String DMS_CONNECTIONS = "dmsConnections";
        public static final String DMS_EXECUTION_TIME_LIMIT = "dmsExecutionTimeLimit";
        public static final String DMS_MAXIMUM_PROCESSES = "dmsMaximumProcesses";
        public static final String DMS_NON_AFFINE_CONNECTIONS = "dmsNonAffineConnections";
        public static final String DMS_PEAK_AFFINE_CONNECTIONS = "dmsPeakAffineConnections";
        public static final String DMS_PEAK_MAXIMUM_PROCESSES = "dmsPeakMaximumProcesses";
        public static final String DMS_PEAK_NON_AFFINE_CONNECTIONS = "dmsPeakNonAffineConnections";
        public static final String DMS_QUEUE_LIMIT = "dmsQueueLimit";
        public static final String DOCUMENT_TYPE = "documentType";
        public static final String DS_AUDIT_LEVEL = "dsAuditLevel";
        public static final String DS_COMPRESS_ATTACHMENT_LIMIT = "dsCompressAttachmentLimit";
        public static final String DS_CONNECTIONS = "dsConnections";
        public static final String DS_MAXIMUM_E_MAIL_SIZE = "dsMaximumEMailSize";
        public static final String DS_PEAK_CONNECTIONS = "dsPeakConnections";
        public static final String EDITION = "edition";
        public static final String EDITIONS = "editions";
        public static final String EFFECTIVE_GLOBAL_PARAMETERS = "effectiveGlobalParameters";
        public static final String EFFECTIVE_USER_CAPABILITIES = "effectiveUserCapabilities";
        public static final String EMAIL = "email";
        public static final String EMAIL_ENCODING = "emailEncoding";
        public static final String EMS_AUDIT_LEVEL = "emsAuditLevel";
        public static final String END_DATE = "endDate";
        public static final String END_TYPE = "endType";
        public static final String EVENT_ID = "eventID";
        public static final String EVENT_KEY = "eventKey";
        public static final String EVENT_TYPES = "eventTypes";
        public static final String EVERY_N_PERIODS = "everyNPeriods";
        public static final String EVS_AUDIT_LEVEL = "evsAuditLevel";
        public static final String EXECUTION_DETAILS = "executionDetails";
        public static final String EXECUTION_FORMAT = "executionFormat";
        public static final String EXECUTION_LOCALE = "executionLocale";
        public static final String EXECUTION_PAGE_DEFINITION = "executionPageDefinition";
        public static final String EXECUTION_PAGE_ORIENTATION = "executionPageOrientation";
        public static final String EXECUTION_PROMPT = "executionPrompt";
        public static final String EXPIRATION_TIME = "expirationTime";
        public static final String FAX_PHONE = "faxPhone";
        public static final String FILTER_DATA_ITEM_NAME = "filterDataItemName";
        public static final String FORMAT = "format";
        public static final String FORMAT_SPECIFICATION_LOCATION = "formatSpecificationLocation";
        public static final String FS_AFFINE_CONNECTIONS = "fsAffineConnections";
        public static final String FS_AUDIT_LEVEL = "fsAuditLevel";
        public static final String FS_EXECUTION_TIME_LIMIT = "fsExecutionTimeLimit";
        public static final String FS_MAXIMUM_PROCESSES = "fsMaximumProcesses";
        public static final String FS_NON_AFFINE_CONNECTIONS = "fsNonAffineConnections";
        public static final String FS_PEAK_AFFINE_CONNECTIONS = "fsPeakAffineConnections";
        public static final String FS_PEAK_MAXIMUM_PROCESSES = "fsPeakMaximumProcesses";
        public static final String FS_PEAK_NON_AFFINE_CONNECTIONS = "fsPeakNonAffineConnections";
        public static final String GATEWAY = "gateway";
        public static final String GIVEN_NAME = "givenName";
        public static final String GLOSSARY_URI = "glossaryURI";
        public static final String GOVERNORS = "governors";
        public static final String GROUP_AND_ROLE_SETTINGS = "groupAndRoleSettings";
        public static final String GS_AFFINE_CONNECTIONS = "gsAffineConnections";
        public static final String GS_AUDIT_LEVEL = "gsAuditLevel";
        public static final String GS_EXECUTION_TIME_LIMIT = "gsExecutionTimeLimit";
        public static final String GS_MAXIMUM_PROCESSES = "gsMaximumProcesses";
        public static final String GS_NON_AFFINE_CONNECTIONS = "gsNonAffineConnections";
        public static final String GS_PEAK_AFFINE_CONNECTIONS = "gsPeakAffineConnections";
        public static final String GS_PEAK_MAXIMUM_PROCESSES = "gsPeakMaximumProcesses";
        public static final String GS_PEAK_NON_AFFINE_CONNECTIONS = "gsPeakNonAffineConnections";
        public static final String GS_QUEUE_LIMIT = "gsQueueLimit";
        public static final String HANDLE = "handle";
        public static final String HAS_CHILDREN = "hasChildren";
        public static final String HAS_MESSAGE = "hasMessage";
        public static final String HAS_PROMPTS = "hasPrompts";
        public static final String HIDDEN = "hidden";
        public static final String HISTORY = "history";
        public static final String HOME_PHONE = "homePhone";
        public static final String HORIZONTAL_ELEMENTS_RENDERING_LIMIT = "horizontalElementsRenderingLimit";
        public static final String HTS_AUDIT_LEVEL = "htsAuditLevel";
        public static final String HTS_COMPLETED_TASK_LIFETIME = "htsCompletedTaskLifetime";
        public static final String ICON_URI = "iconURI";
        public static final String ID = "id";
        public static final String IDENTITY = "identity";
        public static final String IDS_AUDIT_LEVEL = "idsAuditLevel";
        public static final String IDS_CONNECTIONS = "idsConnections";
        public static final String IDS_PEAK_CONNECTIONS = "idsPeakConnections";
        public static final String ID_VIZ_AUDIT_LEVEL = "idVizAuditLevel";
        public static final String INPUT_MESSAGE_NAME = "inputMessageName";
        public static final String INTRADAY_RECURRENCE_END = "intradayRecurrenceEnd";
        public static final String INTRADAY_RECURRENCE_INTERVAL = "intradayRecurrenceInterval";
        public static final String INTRADAY_RECURRENCE_START = "intradayRecurrenceStart";
        public static final String ISOLATION_LEVEL = "isolationLevel";
        public static final String ISS_AUDIT_LEVEL = "issAuditLevel";
        public static final String ISS_CONNECTIONS = "issConnections";
        public static final String ISS_PEAK_CONNECTIONS = "issPeakConnections";
        public static final String ITEM_ID = "itemID";
        public static final String IUS_AUDIT_LEVEL = "iusAuditLevel";
        public static final String IUS_CONNECTIONS = "iusConnections";
        public static final String IUS_PEAK_CONNECTIONS = "iusPeakConnections";
        public static final String JMX_PROXY_HOST_DISPATCHERS = "jmxProxyHostDispatchers";
        public static final String JS_AUDIT_LEVEL = "jsAuditLevel";
        public static final String JS_CONNECTIONS = "jsConnections";
        public static final String JSM_NON_PEAK_DEMAND_BEGIN_HOUR = "jsmNonPeakDemandBeginHour";
        public static final String JSM_NON_PEAK_DEMAND_MAXIMUM_JOBS = "jsmNonPeakDemandMaximumJobs";
        public static final String JSM_PEAK_DEMAND_BEGIN_HOUR = "jsmPeakDemandBeginHour";
        public static final String JSM_PEAK_DEMAND_MAXIMUM_JOBS = "jsmPeakDemandMaximumJobs";
        public static final String JS_PEAK_CONNECTIONS = "jsPeakConnections";
        public static final String LAST_ANALYSIS_COLLECTION = "lastAnalysisCollection";
        public static final String LAST_CONFIGURATION_MODIFICATION_TIME = "lastConfigurationModificationTime";
        public static final String LAST_OVERRIDE_UPDATE = "lastOverrideUpdate";
        public static final String LAST_PUBLISH_DATE = "lastPublishDate";
        public static final String LAST_PAGE = "lastPage";
        public static final String LAUNCHABLE_TYPE = "launchableType";
        public static final String LAYOUT = "layout";
        public static final String LINK = "link";
        public static final String LINK_PATHS = "linkPaths";
        public static final String LOAD_BALANCING_MODE = "loadBalancingMode";
        public static final String LOCALE = "locale";
        public static final String LOCATION = "location";
        public static final String LS_AUDIT_ADMIN_LEVEL = "lsAuditAdminLevel";
        public static final String LS_AUDIT_LEVEL = "lsAuditLevel";
        public static final String LS_AUDIT_NATIVE_QUERY = "lsAuditNativeQuery";
        public static final String LS_AUDIT_OTHER_LEVEL = "lsAuditOtherLevel";
        public static final String LS_AUDIT_USAGE_LEVEL = "lsAuditUsageLevel";
        public static final String MAXIMUM_DETAIL_SEVERITY = "maximumDetailSeverity";
        public static final String MAXIMUM_STORAGE_SIZE_MB = "maximumStorageSizeMB";
        public static final String MBS_AUDIT_LEVEL = "mbsAuditLevel";
        public static final String MBS_CONNECTIONS = "mbsConnections";
        public static final String MBS_PEAK_CONNECTIONS = "mbsPeakConnections";
        public static final String MDS_AFFINE_CONNECTIONS = "mdsAffineConnections";
        public static final String MDS_AUDIT_LEVEL = "mdsAuditLevel";
        public static final String MDS_EXECUTION_TIME_LIMIT = "mdsExecutionTimeLimit";
        public static final String MDS_MAXIMUM_PROCESSES = "mdsMaximumProcesses";
        public static final String MDS_NON_AFFINE_CONNECTIONS = "mdsNonAffineConnections";
        public static final String MDS_PEAK_AFFINE_CONNECTIONS = "mdsPeakAffineConnections";
        public static final String MDS_PEAK_MAXIMUM_PROCESSES = "mdsPeakMaximumProcesses";
        public static final String MDS_PEAK_NON_AFFINE_CONNECTIONS = "mdsPeakNonAffineConnections";
        public static final String MDS_QUEUE_LIMIT = "mdsQueueLimit";
        public static final String MEMBER_DISPLAY_COUNT_DEFAULT = "memberDisplayCountDefault";
        public static final String MEMBER_DISPLAY_COUNT_LIMIT = "memberDisplayCountLimit";
        public static final String MEMBERS = "members";
        public static final String MESSAGE = "message";
        public static final String METADATA = "metadata";
        public static final String METADATA_INFORMATION_URI = "metadataInformationURI";
        public static final String METADATA_MODEL = "metadataModel";
        public static final String METADATA_MODEL_PACKAGE = "metadataModelPackage";
        public static final String MIS_AUDIT_LEVEL = "misAuditLevel";
        public static final String MIS_CONNECTIONS = "misConnections";
        public static final String MIS_PEAK_CONNECTIONS = "misPeakConnections";
        public static final String MMS_AUDIT_LEVEL = "mmsAuditLevel";
        public static final String MMS_CONNECTIONS = "mmsConnections";
        public static final String MMS_PEAK_CONNECTIONS = "mmsPeakConnections";
        public static final String MOBILE_CONFIGURATION = "mobileConfiguration";
        public static final String MOBILE_DEVICE_ID = "mobileDeviceID";
        public static final String MOBILE_PHONE = "mobilePhone";
        public static final String MODE = "mode";
        public static final String MODEL = "model";
        public static final String MODEL_NAME = "modelName";
        public static final String MODIFICATION_TIME = "modificationTime";
        public static final String MODULE = "module";
        public static final String MONTHLY_ABSOLUTE_DAY = "monthlyAbsoluteDay";
        public static final String MONTHLY_RELATIVE_DAY = "monthlyRelativeDay";
        public static final String MONTHLY_RELATIVE_WEEK = "monthlyRelativeWeek";
        public static final String MOST_RECENT_EVENT_LIST = "mostRecentEventList";
        public static final String MS_AUDIT_LEVEL = "msAuditLevel";
        public static final String MS_NON_PEAK_DEMAND_BEGIN_HOUR = "msNonPeakDemandBeginHour";
        public static final String MS_NON_PEAK_DEMAND_MAXIMUM_TASKS = "msNonPeakDemandMaximumTasks";
        public static final String MS_PEAK_DEMAND_BEGIN_HOUR = "msPeakDemandBeginHour";
        public static final String MS_PEAK_DEMAND_MAXIMUM_TASKS = "msPeakDemandMaximumTasks";
        public static final String NAME = "name";
        public static final String NAMESPACE_FORMAT = "namespaceFormat";
        public static final String NON_PEAK_DEMAND_BEGIN_HOUR = "nonPeakDemandBeginHour";
        public static final String NOTIFICATION_E_MAIL = "notificationEMail";
        public static final String NOTIFICATION_LIST = "notificationList";
        public static final String NOTIFICATION_LIST_IS_EMPTY = "notificationListIsEmpty";
        public static final String OBJECTS = "objects";
        public static final String OPEN_CONNECTION_COMMANDS = "openConnectionCommands";
        public static final String OPEN_SESSION_COMMANDS = "openSessionCommands";
        public static final String OPERATION_NAME = "operationName";
        public static final String OPTIONS = "options";
        public static final String OUTPUT = "output";
        public static final String OUTPUT_MESSAGE_NAME = "outputMessageName";
        public static final String OUTPUTS = "outputs";
        public static final String OVERRIDE_OPTIONS = "overrideOptions";
        public static final String OWNER = "owner";
        public static final String OWNER_EVENT_ID = "ownerEventID";
        public static final String OWNER_PASSPORT = "ownerPassport";
        public static final String PACKAGE_BASE = "packageBase";
        public static final String PACS_AUDIT_LEVEL = "pacsAuditLevel";
        public static final String PACS_CONNECTIONS = "pacsConnections";
        public static final String PACS_PEAK_CONNECTIONS = "pacsPeakConnections";
        public static final String PAGE = "page";
        public static final String PAGELET = "pagelet";
        public static final String PAGE_ORIENTATION = "pageOrientation";
        public static final String PAGER_PHONE = "pagerPhone";
        public static final String PARAMETER_ASSIGNMENTS = "parameterAssignments";
        public static final String PARAMETERS = "parameters";
        public static final String PARENT = "parent";
        public static final String PARENT_ID = "parentID";
        public static final String PATHS = "paths";
        public static final String PDS_AUDIT_LEVEL = "pdsAuditLevel";
        public static final String PDS_CONNECTIONS = "pdsConnections";
        public static final String PDS_E_LIST_ACCESS_CACHE_LIMIT = "pdsEListAccessCacheLimit";
        public static final String PDS_MAXIMUM_PROCESSES = "pdsMaximumProcesses";
        public static final String PDS_PEAK_CONNECTIONS = "pdsPeakConnections";
        public static final String PDS_PEAK_MAXIMUM_PROCESSES = "pdsPeakMaximumProcesses";
        public static final String PDS_SHOW_CELL_ANNOTATIONS = "pdsShowCellAnnotations";
        public static final String PEAK_DEMAND_BEGIN_HOUR = "peakDemandBeginHour";
        public static final String PERIODICAL_DOCUMENT_VERSION_RETENTION_AGE = "periodicalDocumentVersionRetentionAge";
        public static final String PERIODICAL_DOCUMENT_VERSION_RETENTION_COUNT = "periodicalDocumentVersionRetentionCount";
        public static final String PERIODICAL_PRODUCER = "periodicalProducer";
        public static final String PERMISSIONS = "permissions";
        public static final String PHYSICAL_ANALYTICS = "physicalAnalytics";
        public static final String PHYSICAL_DEFINITION = "physicalDefinition";
        public static final String POLICIES = "policies";
        public static final String PORTAL_PAGE = "portalPage";
        public static final String PORTAL_PAGES = "portalPages";
        public static final String PORTAL_PREFERENCES = "portalPreferences";
        public static final String PORTLET = "portlet";
        public static final String POSITION = "position";
        public static final String POSTAL_ADDRESS = "postalAddress";
        public static final String POWER_PLAY8_CONFIGURATION = "powerPlay8Configuration";
        public static final String PPS_AFFINE_CONNECTIONS = "ppsAffineConnections";
        public static final String PPS_AUDIT_LEVEL = "ppsAuditLevel";
        public static final String PPS_EXECUTION_TIME_LIMIT = "ppsExecutionTimeLimit";
        public static final String PPS_MAXIMUM_E_MAIL_ATTACHMENT_SIZE = "ppsMaximumEMailAttachmentSize";
        public static final String PPS_NON_AFFINE_CONNECTIONS = "ppsNonAffineConnections";
        public static final String PPS_PEAK_AFFINE_CONNECTIONS = "ppsPeakAffineConnections";
        public static final String PPS_PEAK_NON_AFFINE_CONNECTIONS = "ppsPeakNonAffineConnections";
        public static final String PPS_QUEUE_LIMIT = "ppsQueueLimit";
        public static final String PREVIEW_IMAGE_LOCATION = "previewImageLocation";
        public static final String PRINTER_ADDRESS = "printerAddress";
        public static final String PRIORITY = "priority";
        public static final String PRODUCER = "producer";
        public static final String PRODUCT_LOCALE = "productLocale";
        public static final String PRODUCT_LOCALE_MAP = "productLocaleMap";
        public static final String PROFILE_RANK = "profileRank";
        public static final String PROFILE_ROLE = "profileRole";
        public static final String PROPERTIES = "properties";
        public static final String PRS_AUDIT_LEVEL = "prsAuditLevel";
        public static final String PRS_CONNECTIONS = "prsConnections";
        public static final String PRS_PEAK_CONNECTIONS = "prsPeakConnections";
        public static final String PS_AUDIT_LEVEL = "psAuditLevel";
        public static final String PTS_AUDIT_LEVEL = "ptsAuditLevel";
        public static final String PTS_CONNECTIONS = "ptsConnections";
        public static final String PTS_PEAK_CONNECTIONS = "ptsPeakConnections";
        public static final String PUBLISHED = "published";
        public static final String QS_ADDITIONAL_JVM_ARGUMENTS = "qsAdditionalJVMArguments";
        public static final String QS_AUDIT_LEVEL = "qsAuditLevel";
        public static final String QS_DIAGNOSTICS_ENABLED = "qsDiagnosticsEnabled";
        public static final String QS_DISABLE_QUERY_PLAN_CACHE = "qsDisableQueryPlanCache";
        public static final String QS_DISABLE_VERBOSE_GC_LOGGING = "qsDisableVerboseGCLogging";
        public static final String QS_DUMP_MODEL_TO_FILE = "qsDumpModelToFile";
        public static final String QS_GC_POLICY = "qsGCPolicy";
        public static final String QS_GENERATE_COMMENTS_IN_NATIVE_SQL = "qsGenerateCommentsInNativeSQL";
        public static final String QS_IDLE_CONNECTION_TIMEOUT = "qsIdleConnectionTimeout";
        public static final String QS_INITIAL_JVM_HEAP_SIZE = "qsInitialJVMHeapSize";
        public static final String QS_INITIAL_JVM_NURSERY_SIZE = "qsInitialJVMNurserySize";
        public static final String QS_JVM_HEAP_SIZE_LIMIT = "qsJVMHeapSizeLimit";
        public static final String QS_JVM_NURSERY_SIZE_LIMIT = "qsJVMNurserySizeLimit";
        public static final String QS_MANUAL_CUBE_START = "qsManualCubeStart";
        public static final String QS_METRICS_ENABLED = "qsMetricsEnabled";
        public static final String QS_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT = "qsMultiDimensionalQuerySizeLimit";
        public static final String QS_QUERY_EXECUTION_TRACE = "qsQueryExecutionTrace";
        public static final String QS_QUERY_PLANNING_TRACE = "qsQueryPlanningTrace";
        public static final String QS_RESULT_SET_CACHE_QUERY_TIME_THRESHOLD = "qsResultSetCacheQueryTimeThreshold";
        public static final String QS_ROLAP_CUBE_ADMINISTRATION_COMMAND_TIMEOUT = "qsROLAPCubeAdministrationCommandTimeout";
        public static final String QS_ROLAP_CUBE_CONFIGURATIONS = "qsROLAPCubeConfigurations";
        public static final String QS_ROLAP_MEMBER_CACHE_ALIAS_ROOT = "qsROLAPMemberCacheAliasRoot";
        public static final String QS_ROLAP_MEMBER_CACHE_LOCATION = "qsROLAPMemberCacheLocation";
        public static final String QS_VERBOSE_GC_LOG_LIMIT = "qsVerboseGCLogLimit";
        public static final String QUALIFIER = "qualifier";
        public static final String QUERY_MODE = "queryMode";
        public static final String RDS_AUDIT_LEVEL = "rdsAuditLevel";
        public static final String RDS_GATEWAY_MAPPINGS = "rdsGatewayMappings";
        public static final String RDS_MAXIMUM_DATA_SIZE = "rdsMaximumDataSize";
        public static final String RECIPIENTS = "recipients";
        public static final String RECIPIENTS_E_MAIL = "recipientsEMail";
        public static final String REFERENCE_TO_FILE_ON_SHARED_DISK = "referenceToFileOnSharedDisk";
        public static final String REGISTRATION = "registration";
        public static final String RELATED = "related";
        public static final String REPLACEMENT = "replacement";
        public static final String REPORT = "report";
        public static final String REPOS_AUDIT_LEVEL = "reposAuditLevel";
        public static final String REPOS_CACHE_OBJ_TTL = "reposCacheObjTTL";
        public static final String REPOSITORY_CREDENTIALS = "repositoryCredentials";
        public static final String REPOSITORY_RULES = "repositoryRules";
        public static final String REPOSITORY_RULESBURST_I_DBURST_KEY = "repositoryRulesburstIDburstKey";
        public static final String REPOS_NUM_OBJ_DISK = "reposNumObjDisk";
        public static final String REPOS_NUM_OBJ_MEM = "reposNumObjMem";
        public static final String REQUESTED_EXECUTION_TIME = "requestedExecutionTime";
        public static final String RESOLVED_EDIT_RIGHTS = "resolvedEditRights";
        public static final String RESOLVED_SUBMIT_RIGHTS = "resolvedSubmitRights";
        public static final String RESOLVED_VIEW_RIGHTS = "resolvedViewRights";
        public static final String RESOURCE_LOCATION = "resourceLocation";
        public static final String RESOURCE_TYPE = "resourceType";
        public static final String RESTART_EVENT_ID = "restartEventID";
        public static final String RETENTIONS = "retentions";
        public static final String RETENTIONSBURST_I_DBURST_KEY = "retentionsburstIDburstKey";
        public static final String RMDS_AFFINE_CONNECTIONS = "rmdsAffineConnections";
        public static final String RMDS_AUDIT_LEVEL = "rmdsAuditLevel";
        public static final String RMDS_CONNECTIONS = "rmdsConnections";
        public static final String RMDS_EXECUTION_TIME_LIMIT = "rmdsExecutionTimeLimit";
        public static final String RMDS_NON_AFFINE_CONNECTIONS = "rmdsNonAffineConnections";
        public static final String RMDS_PEAK_AFFINE_CONNECTIONS = "rmdsPeakAffineConnections";
        public static final String RMDS_PEAK_CONNECTIONS = "rmdsPeakConnections";
        public static final String RMDS_PEAK_NON_AFFINE_CONNECTIONS = "rmdsPeakNonAffineConnections";
        public static final String ROUTING_HINTS = "routingHints";
        public static final String ROUTING_SERVER_GROUP = "routingServerGroup";
        public static final String ROUTING_SERVER_GROUP_EDITION = "routingServerGroupEdition";
        public static final String ROUTING_TABLE = "routingTable";
        public static final String RS_AFFINE_CONNECTIONS = "rsAffineConnections";
        public static final String RS_AUDIT_LEVEL = "rsAuditLevel";
        public static final String RS_AUDIT_NATIVE_QUERY = "rsAuditNativeQuery";
        public static final String RS_CHART_HOTSPOT_LIMIT = "rsChartHotspotLimit";
        public static final String RS_DATA_SOURCE_CHANGE = "rsDataSourceChange";
        public static final String RS_EXECUTION_TIME_LIMIT = "rsExecutionTimeLimit";
        public static final String RS_MAXIMUM_E_MAIL_ATTACHMENT_SIZE = "rsMaximumEMailAttachmentSize";
        public static final String RS_MAXIMUM_PROCESSES = "rsMaximumProcesses";
        public static final String RS_NON_AFFINE_CONNECTIONS = "rsNonAffineConnections";
        public static final String RS_PDF_CHARACTER_ENCODING = "rsPDFCharacterEncoding";
        public static final String RS_PDF_COMPRESSION_LEVEL = "rsPDFCompressionLevel";
        public static final String RS_PDF_COMPRESSION_TYPE = "rsPDFCompressionType";
        public static final String RS_PDF_EMBED_FONTS = "rsPDFEmbedFonts";
        public static final String RS_PEAK_AFFINE_CONNECTIONS = "rsPeakAffineConnections";
        public static final String RS_PEAK_MAXIMUM_PROCESSES = "rsPeakMaximumProcesses";
        public static final String RS_PEAK_NON_AFFINE_CONNECTIONS = "rsPeakNonAffineConnections";
        public static final String RS_QUEUE_LIMIT = "rsQueueLimit";
        public static final String RUN_AS_OWNER = "runAsOwner";
        public static final String RUN_CONDITION = "runCondition";
        public static final String RUN_IN_ADVANCED_VIEWER = "runInAdvancedViewer";
        public static final String RUNNING_STATE = "runningState";
        public static final String RUN_OPTIONS = "runOptions";
        public static final String RUN_WITH_OWNER_CAPABILITIES = "runWithOwnerCapabilities";
        public static final String SA_CAM_AUDIT_LEVEL = "saCAMAuditLevel";
        public static final String SCHEDULE_TRIGGER_NAME = "scheduleTriggerName";
        public static final String SCHEDULE_TYPE = "scheduleType";
        public static final String SCHEMA = "schema";
        public static final String SCHEMA_TYPE = "schemaType";
        public static final String SCOPE = "scope";
        public static final String SCREEN_TIP = "screenTip";
        public static final String SEARCH_PATH = "searchPath";
        public static final String SEARCH_PATH_FOR_URL = "searchPathForURL";
        public static final String SECURITY_MEMBERS = "securityMembers";
        public static final String SELECTION_CONTEXT = "selectionContext";
        public static final String SEQUENCING = "sequencing";
        public static final String SERVER_GROUP = "serverGroup";
        public static final String SERVER_LOCALE = "serverLocale";
        public static final String SERVER_TIME_ZONE_ID = "serverTimeZoneID";
        public static final String SERVICE_DEFAULT_OPTIONS = "serviceDefaultOptions";
        public static final String SERVICE_DESCRIPTION = "serviceDescription";
        public static final String SERVICE_NAME = "serviceName";
        public static final String SEVERITY = "severity";
        public static final String SHOWNBUSINESS_PHONE = "shownbusinessPhone";
        public static final String SIZE_INFO_ARRAY = "sizeInfoArray";
        public static final String SNAP_SHOT = "snapShot";
        public static final String SNAP_SHOT_ENABLED = "snapShotEnabled";
        public static final String SOURCE = "source";
        public static final String SPECIFICATION = "specification";
        public static final String SS_AUDIT_LEVEL = "ssAuditLevel";
        public static final String START_AS_ACTIVE = "startAsActive";
        public static final String START_DATE = "startDate";
        public static final String STATE = "state";
        public static final String STATUS = "status";
        public static final String STATUS_INFO = "statusInfo";
        public static final String STEP_OBJECT = "stepObject";
        public static final String STORED_PROCEDURE_NAME = "storedProcedureName";
        public static final String STORE_ID = "storeID";
        public static final String STS_AFFINE_CONNECTIONS = "stsAffineConnections";
        public static final String STS_AUDIT_LEVEL = "stsAuditLevel";
        public static final String STS_EXECUTION_TIME_LIMIT = "stsExecutionTimeLimit";
        public static final String STS_MAXIMUM_PROCESSES = "stsMaximumProcesses";
        public static final String STS_NON_AFFINE_CONNECTIONS = "stsNonAffineConnections";
        public static final String STS_PEAK_AFFINE_CONNECTIONS = "stsPeakAffineConnections";
        public static final String STS_PEAK_MAXIMUM_PROCESSES = "stsPeakMaximumProcesses";
        public static final String STS_PEAK_NON_AFFINE_CONNECTIONS = "stsPeakNonAffineConnections";
        public static final String STS_QUEUE_LIMIT = "stsQueueLimit";
        public static final String SUPPORTED_CONTENT_LOCALES = "supportedContentLocales";
        public static final String SUPPORTED_CURRENCIES = "supportedCurrencies";
        public static final String SUPPORTED_FONTS = "supportedFonts";
        public static final String SUPPORTED_PRODUCT_LOCALES = "supportedProductLocales";
        public static final String SURNAME = "surname";
        public static final String SYSTEM_METRIC = "systemMetric";
        public static final String TARGET = "target";
        public static final String TARGET_OPTIONS = "targetOptions";
        public static final String TARGET_PARAMETERS = "targetParameters";
        public static final String TASK_ID = "taskID";
        public static final String TASK_OBJECT = "taskObject";
        public static final String TEMPORARY_OBJECT_LIFETIME = "temporaryObjectLifetime";
        public static final String TEMPORARY_OBJECT_LOCATION = "temporaryObjectLocation";
        public static final String TENANT_I_DEXTENSIONS = "tenantIDextensions";
        public static final String TENANT_MEMBERS = "tenantMembers";
        public static final String TIME_ZONE_ID = "timeZoneID";
        public static final String TITLE = "title";
        public static final String TRIGGER_DESCRIPTION = "triggerDescription";
        public static final String TRIGGER_NAME = "triggerName";
        public static final String TYPE = "type";
        public static final String UNIT = "unit";
        public static final String UNIX_REPOSITORY_URI = "unixRepositoryURI";
        public static final String UNIX_URI = "unixURI";
        public static final String URI = "uri";
        public static final String USAGE = "usage";
        public static final String USE_ACCESSIBILITY_FEATURES = "useAccessibilityFeatures";
        public static final String USER = "user";
        public static final String USER_CAPABILITIES = "userCapabilities";
        public static final String USER_CAPABILITY = "userCapability";
        public static final String USER_CAPABILITY_POLICIES = "userCapabilityPolicies";
        public static final String USER_CAPABILITY_POLICIESDATA = "userCapabilityPoliciesdata";
        public static final String USER_INTERFACE = "userInterface";
        public static final String USER_INTERFACES = "userInterfaces";
        public static final String USER_NAME = "userName";
        public static final String USER_PROFILE_SETTINGS = "userProfileSettings";
        public static final String USER_PROFILE_SETTINGSLAST_LOGIN = "userProfileSettingslastLogin";
        public static final String VERSION = "version";
        public static final String VERTICAL_ELEMENTS_RENDERING_LIMIT = "verticalElementsRenderingLimit";
        public static final String VIEWED = "viewed";
        public static final String WEEKLY_FRIDAY = "weeklyFriday";
        public static final String WEEKLY_MONDAY = "weeklyMonday";
        public static final String WEEKLY_SATURDAY = "weeklySaturday";
        public static final String WEEKLY_SUNDAY = "weeklySunday";
        public static final String WEEKLY_THURSDAY = "weeklyThursday";
        public static final String WEEKLY_TUESDAY = "weeklyTuesday";
        public static final String WEEKLY_WEDNESDAY = "weeklyWednesday";
        public static final String WIDTH = "width";
        public static final String WINDOWS_REPOSITORY_URI = "windowsRepositoryURI";
        public static final String WINDOWS_URI = "windowsURI";
        public static final String YEARLY_ABSOLUTE_DAY = "yearlyAbsoluteDay";
        public static final String YEARLY_ABSOLUTE_MONTH = "yearlyAbsoluteMonth";
        public static final String YEARLY_RELATIVE_DAY = "yearlyRelativeDay";
        public static final String YEARLY_RELATIVE_MONTH = "yearlyRelativeMonth";
        public static final String YEARLY_RELATIVE_WEEK = "yearlyRelativeWeek";
        public static final String RECURSIVE = "recursive";
        public static final String MOSER_SCHEMA_ID = "moserSchemaId";

        private Field() {
        }
    }

    public static final class Type {
        public static final String ACCOUNT = "account";
        public static final String ADAPTIVE_ANALYTICS_SERVICE = "adaptiveAnalyticsService";
        public static final String ADMIN_FOLDER = "adminFolder";
        public static final String AGENT_DEFINITION = "agentDefinition";
        public static final String AGENT_DEFINITION_VIEW = "agentDefinitionView";
        public static final String AGENT_OUTPUT_HOT_LIST = "agentOutputHotList";
        public static final String AGENT_SERVICE = "agentService";
        public static final String AGENT_STATE = "agentState";
        public static final String AGENT_TASK_DEFINITION = "agentTaskDefinition";
        public static final String AGENT_TASK_STATE = "agentTaskState";
        public static final String ALIAS_LOCATION = "aliasLocation";
        public static final String ALIAS_ROOT = "aliasRoot";
        public static final String ANALYSIS = "analysis";
        public static final String ANNOTATION = "annotation";
        public static final String ANNOTATION_FOLDER = "annotationFolder";
        public static final String ANNOTATION_SERVICE = "annotationService";
        public static final String ARCHIVE_LOCATION = "archiveLocation";
        public static final String AUTHORED_AGENT_DEFINITION = "authoredAgentDefinition";
        public static final String AUTHORED_POWER_PLAY8_REPORT = "authoredPowerPlay8Report";
        public static final String AUTHORED_REPORT = "authoredReport";
        public static final String BASE_AGENT_DEFINITION = "baseAgentDefinition";
        public static final String BASE_CLASS = "baseClass";
        public static final String BASE_DATA_INTEGRATION_TASK = "baseDataIntegrationTask";
        public static final String BASE_DATA_MOVEMENT_TASK = "baseDataMovementTask";
        public static final String BASE_HISTORY = "baseHistory";
        public static final String BASE_HISTORY_DETAIL = "baseHistoryDetail";
        public static final String BASE_MODULE = "baseModule";
        public static final String BASE_POWER_PLAY8_REPORT = "basePowerPlay8Report";
        public static final String BASE_POWER_PLAY_CLASS = "basePowerPlayClass";
        public static final String BASE_REPORT = "baseReport";
        public static final String BASE_REPORT_METADATA = "baseReportMetadata";
        public static final String BASE_ROLAP_DATA_SOURCE = "baseROLAPDataSource";
        public static final String BASE_RSS_TASK = "baseRSSTask";
        public static final String BATCH_CONTROLLER_SERVICE = "batchControllerService";
        public static final String BATCH_REPORT_SERVICE = "batchReportService";
        public static final String CACHE_OUTPUT = "cacheOutput";
        public static final String CAPABILITY = "capability";
        public static final String CATALOG = "catalog";
        public static final String CATALOG_FOLDER = "catalogFolder";
        public static final String CM_SYSTEM_PROPERTIES = "CMSystemProperties";
        public static final String CONFIGURATION = "configuration";
        public static final String CONFIGURATION_FOLDER = "configurationFolder";
        public static final String CONTACT = "contact";
        public static final String CONTENT = "content";
        public static final String CONTENT_MANAGER_CACHE_SERVICE = "contentManagerCacheService";
        public static final String CONTENT_MANAGER_SERVICE = "contentManagerService";
        public static final String CONTENT_TASK = "contentTask";
        public static final String CONTROLLER_SERVICE = "controllerService";
        public static final String CREDENTIAL = "credential";
        public static final String CUSTOMIZATION = "customization";
        public static final String DASHBOARD = "dashboard";
        public static final String DATA_ADVISOR_SERVICE = "dataAdvisorService";
        public static final String DATA_INTEGRATION_SERVICE = "dataIntegrationService";
        public static final String DATA_MOVEMENT_SERVICE = "dataMovementService";
        public static final String DATA_MOVEMENT_TASK = "dataMovementTask";
        public static final String DATA_MOVEMENT_TASK_ALIAS = "dataMovementTaskAlias";
        public static final String DATA_SET = "dataSet";
        public static final String DATA_SET2 = "dataSet2";
        public static final String DATA_SET_FOLDER = "dataSetFolder";
        public static final String DATA_SOURCE = "dataSource";
        public static final String DATA_SOURCE_CONNECTION = "dataSourceConnection";
        public static final String DATA_SOURCE_CREDENTIAL = "dataSourceCredential";
        public static final String DATA_SOURCE_FILE_CONNECTION = "dataSourceFileConnection";
        public static final String DATA_SOURCE_FILE_CONNECTION_INFORMATION = "dataSourceFileConnectionInformation";
        public static final String DATA_SOURCE_NAME_BINDING = "dataSourceNameBinding";
        public static final String DATA_SOURCE_SCHEMA = "dataSourceSchema";
        public static final String DATA_SOURCE_SIGNON = "dataSourceSignon";
        public static final String DELIVERY_SERVICE = "deliveryService";
        public static final String DEPLOYMENT_DETAIL = "deploymentDetail";
        public static final String DEPLOYMENT_HISTORY = "deploymentHistory";
        public static final String DIMENSIONAL_DATA_SERVICE = "dimensionalDataService";
        public static final String DIMENSION_MANAGEMENT_SERVICE = "dimensionManagementService";
        public static final String DIRECTORY = "directory";
        public static final String DISPATCHER = "dispatcher";
        public static final String DISPATCHER_STATUS = "dispatcherStatus";
        public static final String DISTRIBUTION_LIST = "distributionList";
        public static final String DOCUMENT = "document";
        public static final String DOCUMENT_CONTENT = "documentContent";
        public static final String DOCUMENT_VERSION = "documentVersion";
        public static final String DRILL_PATH = "drillPath";
        public static final String EVENT_MANAGEMENT_SERVICE = "eventManagementService";
        public static final String EV_SERVICE = "EVService";
        public static final String EXPLORATION = "exploration";
        public static final String EXPORT_DEPLOYMENT = "exportDeployment";
        public static final String EXPORT_DEPLOYMENT_FOLDER = "exportDeploymentFolder";
        public static final String FAVORITES_FOLDER = "favoritesFolder";
        public static final String FINANCIAL_SERVICE = "financialService";
        public static final String FOLDER = "folder";
        public static final String GENERIC = "generic";
        public static final String GRAPHIC = "graphic";
        public static final String GRAPHICS_SERVICE = "graphicsService";
        public static final String GROUP = "group";
        public static final String HISTORY = "history";
        public static final String HISTORY_DETAIL = "historyDetail";
        public static final String HISTORY_DETAIL_AGENT_SERVICE = "historyDetailAgentService";
        public static final String HISTORY_DETAIL_DATA_MOVEMENT_SERVICE = "historyDetailDataMovementService";
        public static final String HISTORY_DETAIL_MOSER_SERVICE = "historyDetailMoserService";
        public static final String HISTORY_DETAIL_RELATED_HISTORY = "historyDetailRelatedHistory";
        public static final String HISTORY_DETAIL_RELATED_REPORTS = "historyDetailRelatedReports";
        public static final String HISTORY_DETAIL_REPORT_SERVICE = "historyDetailReportService";
        public static final String HISTORY_DETAIL_REQUEST_ARGUMENTS = "historyDetailRequestArguments";
        public static final String HUMAN_TASK = "humanTask";
        public static final String HUMAN_TASK_SERVICE = "humanTaskService";
        public static final String ID_VIZ_SERVICE = "idVizService";
        public static final String IMPORT_DEPLOYMENT = "importDeployment";
        public static final String IMPORT_DEPLOYMENT_FOLDER = "importDeploymentFolder";
        public static final String INDEX_DATA_SERVICE = "indexDataService";
        public static final String INDEX_SEARCH_SERVICE = "indexSearchService";
        public static final String INDEX_UPDATE_SERVICE = "indexUpdateService";
        public static final String INDEX_UPDATE_TASK = "indexUpdateTask";
        public static final String INSTALLED_COMPONENT = "installedComponent";
        public static final String INTERACTIVE_REPORT = "interactiveReport";
        public static final String JOB_AND_SCHEDULE_MONITORING_SERVICE = "jobAndScheduleMonitoringService";
        public static final String JOB_DEFINITION = "jobDefinition";
        public static final String JOB_HISTORY = "jobHistory";
        public static final String JOB_SERVICE = "jobService";
        public static final String JOB_STEP_DEFINITION = "jobStepDefinition";
        public static final String JUPYTER_NOTEBOOK = "jupyterNotebook";
        public static final String LAUNCHABLE = "launchable";
        public static final String LOG_SERVICE = "logService";
        public static final String MEMO = "memo";
        public static final String METADATA_SERVICE = "metadataService";
        public static final String METRICS_DATA_SOURCE_ETL_TASK = "metricsDataSourceETLTask";
        public static final String METRICS_EXPORT_TASK = "metricsExportTask";
        public static final String METRICS_FILE_IMPORT_TASK = "metricsFileImportTask";
        public static final String METRICS_MAINTENANCE_TASK = "metricsMaintenanceTask";
        public static final String METRICS_MANAGER_SERVICE = "metricsManagerService";
        public static final String MIGRATION_SERVICE = "migrationService";
        public static final String MIGRATION_TASK = "migrationTask";
        public static final String MOBILE_SERVICE = "mobileService";
        public static final String MODEL = "model";
        public static final String MODEL_VIEW = "modelView";
        public static final String MODULE = "module";
        public static final String MONITOR_SERVICE = "monitorService";
        public static final String MRU_FOLDER = "mruFolder";
        public static final String NAMESPACE = "namespace";
        public static final String NAMESPACE_FOLDER = "namespaceFolder";
        public static final String NIL = "nil";
        public static final String OUTPUT = "output";
        public static final String PACKAGE = "package";
        public static final String PACKAGE_CONFIGURATION = "packageConfiguration";
        public static final String PAGE = "page";
        public static final String PAGE_DEFINITION = "pageDefinition";
        public static final String PAGELET = "pagelet";
        public static final String PAGELET_FOLDER = "pageletFolder";
        public static final String PAGELET_INSTANCE = "pageletInstance";
        public static final String PERIODICAL = "periodical";
        public static final String PERSONALIZATION = "personalization";
        public static final String PERSONALIZATION_FOLDER = "personalizationFolder";
        public static final String PLANNING_ADMINISTRATION_CONSOLE_SERVICE = "planningAdministrationConsoleService";
        public static final String PLANNING_APPLICATION = "planningApplication";
        public static final String PLANNING_DATA_SERVICE = "planningDataService";
        public static final String PLANNING_E_LIST = "planningEList";
        public static final String PLANNING_MACRO_TASK = "planningMacroTask";
        public static final String PLANNING_RUNTIME_SERVICE = "planningRuntimeService";
        public static final String PLANNING_TASK = "planningTask";
        public static final String PLANNING_TASK_SERVICE = "planningTaskService";
        public static final String PORTAL = "portal";
        public static final String PORTAL_PACKAGE = "portalPackage";
        public static final String PORTAL_SKIN = "portalSkin";
        public static final String PORTAL_SKIN_FOLDER = "portalSkinFolder";
        public static final String PORTLET = "portlet";
        public static final String PORTLET_FOLDER = "portletFolder";
        public static final String PORTLET_INSTANCE = "portletInstance";
        public static final String PORTLET_PRODUCER = "portletProducer";
        public static final String POWER_PLAY8_REPORT = "powerPlay8Report";
        public static final String POWER_PLAY8_REPORT_VIEW = "powerPlay8ReportView";
        public static final String POWER_PLAY_CUBE = "powerPlayCube";
        public static final String POWER_PLAY_REPORT = "powerPlayReport";
        public static final String POWER_PLAY_SERVICE = "powerPlayService";
        public static final String PRESENTATION_SERVICE = "presentationService";
        public static final String PRINTER = "printer";
        public static final String QUERY = "query";
        public static final String QUERY_SERVICE = "queryService";
        public static final String QUERY_SERVICE_TASK = "queryServiceTask";
        public static final String RELATIONAL_METADATA_SERVICE = "relationalMetadataService";
        public static final String REPORT = "report";
        public static final String REPORT_CACHE = "reportCache";
        public static final String REPORT_DATA_SERVICE = "reportDataService";
        public static final String REPORT_DATA_SERVICE_AGENT_DEFINITION = "reportDataServiceAgentDefinition";
        public static final String REPORT_HISTORY = "reportHistory";
        public static final String REPORT_METADATA = "reportMetadata";
        public static final String REPORT_METADATA_CACHE = "reportMetadataCache";
        public static final String REPORT_SERVICE = "reportService";
        public static final String REPORT_TEMPLATE = "reportTemplate";
        public static final String REPORT_VERSION = "reportVersion";
        public static final String REPORT_VIEW = "reportView";
        public static final String REPOSITORY_SERVICE = "repositoryService";
        public static final String RESOURCE = "resource";
        public static final String ROLAP_DATA_SOURCE = "rolapDataSource";
        public static final String ROLAP_VIRTUAL_DATA_SOURCE = "rolapVirtualDataSource";
        public static final String ROLE = "role";
        public static final String ROOT = "root";
        public static final String RUN_TIME_STATE = "runTimeState";
        public static final String SA_CAM_SERVICE = "saCAMService";
        public static final String SCHEDULE = "schedule";
        public static final String SECURED_FEATURE = "securedFeature";
        public static final String SECURED_FUNCTION = "securedFunction";
        public static final String SERVICE_STATUS = "serviceStatus";
        public static final String SESSION = "session";
        public static final String SHORTCUT = "shortcut";
        public static final String SHORTCUT_AGENT_RSS_TASK = "shortcutAgentRSSTask";
        public static final String SHORTCUT_RSS_TASK = "shortcutRSSTask";
        public static final String SQL = "SQL";
        public static final String STATISTICS_SERVICE = "statisticsService";
        public static final String STORED_PROCEDURE_TASK = "storedProcedureTask";
        public static final String SUBSCRIPTION_FOLDER = "subscriptionFolder";
        public static final String SYSTEM_METRIC_THRESHOLDS = "systemMetricThresholds";
        public static final String SYSTEM_SERVICE = "systemService";
        public static final String TENANT = "tenant";
        public static final String TENANTS = "tenants";
        public static final String TRANSIENT_STATE_FOLDER = "transientStateFolder";
        public static final String UI_CLASS = "uiClass";
        public static final String UI_PROFILE = "uiProfile";
        public static final String UI_PROFILE_FOLDER = "uiProfileFolder";
        public static final String UPLOADED_FILE = "uploadedFile";
        public static final String URL = "URL";
        public static final String URL_RSS_TASK = "urlRSSTask";
        public static final String USER_INTERFACE_PROFILE = "userInterfaceProfile";
        public static final String VISUALIZATION = "visualization";
        public static final String WEB_SERVICE_TASK = "webServiceTask";

        private Type() {
        }
    }

    public static enum ContentSubResource implements IResource
    {
        BASE_MODULE("base_module"),
        ITEMS("items"),
        PERMISSIONS("permissions");

        private final String value;

        private ContentSubResource(String v) {
            this.value = v;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    public static enum ContentResource implements IResource
    {
        OBJECTS("objects"),
        SEARCH_PATH("search_path");

        private final String value;

        private ContentResource(String v) {
            this.value = v;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }
}

