/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.BaseRESTService;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.json.java.JSONObject;
import org.apache.http.client.utils.URIBuilder;

public class DatasetService
extends BaseRESTService {
    protected DatasetService(RESTClientConfig c) {
        super(c);
    }

    public RESTClientResponse getDatasets(String datasetId, String type, String module) {
        String url = this.uriBuilder(datasetId, type, module).toString();
        return this.get(url);
    }

    public RESTClientResponse getData(String datasetId, String type, JSONObject querySpec) {
        String url = this.uriBuilder(datasetId, type, querySpec, "data").toString();
        return this.get(url);
    }

    public RESTClientResponse getSubset(String datasetId, String type, JSONObject querySpec) {
        String url = this.uriBuilder(datasetId, type, querySpec, "subset").toString();
        return this.get(url);
    }

    private URIBuilder uriBuilder(String datasetId, String type, String module) {
        URIBuilder builder = super.uriBuilder(this.baseURL + "/datasets/" + datasetId);
        if (type != null && !type.isEmpty()) {
            builder.addParameter("type", type);
        }
        if (module != null && !module.isEmpty()) {
            builder.addParameter("module", module);
        }
        return builder;
    }

    private URIBuilder uriBuilder(String datasetId, String type, JSONObject querySpec, String dataOrSubset) {
        URIBuilder builder = super.uriBuilder(this.baseURL + "/datasets/" + datasetId + "/" + dataOrSubset);
        if (type != null && !type.isEmpty()) {
            builder.addParameter("type", type);
        }
        if (querySpec != null && !querySpec.isEmpty()) {
            builder.addParameter("querySpec", querySpec.toString());
        }
        return builder;
    }
}

