/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.RESTUtils;
import com.ibm.bi.platform.moser.core.rest.service.BaseService;
import com.ibm.bi.platform.moser.core.rest.service.DependencyServiceCache;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.json.java.JSONObject;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class DependencyService
extends BaseService {
    private static final String CACHE_CREATED = "Dependency cache created for ETag: {}";
    private static final String CACHE_HIT = "Dependency cache hit for ETag: {}";
    private static final String CACHE_INVALIDATED = "Dependency cache invalidated for ETag: {}";
    private static final String CACHE_MISS = "Dependency cache miss for ETag: {}";
    private static final String CACHE_STORED = "Dependency cache miss, but now stored for ETag: {}";
    private static final String CACHE_REUSE = "Dependency cache reused for ETag: {}";
    private static final String DEPENDENCY_URL = MoserConfig.getBaseURL() + "/temp/dependency/";
    private static final DependencyServiceCache cache = new DependencyServiceCache(MoserConfig.getDependencyServiceCacheSize(), MoserConfig.getDependencyServiceCacheExpiry());

    public DependencyService(RESTClientConfig r) {
        super(r);
    }

    @Override
    protected RESTClient getClient() {
        return this.getTrustedClient();
    }

    public JSONObject getDependencies(String etagID) {
        if (StringUtils.isEmpty((CharSequence)etagID)) {
            return null;
        }
        String etag = MoserUtil.trimDoubleQuotes(etagID);
        JSONObject json = cache.getIfPresent(etag);
        if (json != null) {
            LoggerAdapter.debug((Object)this, CACHE_HIT, etag);
            return json;
        }
        RESTClientResponse r = this.get(DEPENDENCY_URL + etag);
        if (r.getResponseCode() != Response.Status.OK.getStatusCode()) {
            LoggerAdapter.debug((Object)this, CACHE_MISS, etag);
            return null;
        }
        json = r.getJSONObjectResponse();
        cache.put(etag, json);
        LoggerAdapter.debug((Object)this, CACHE_STORED, etag);
        return json;
    }

    public String postDependency(JSONObject dependencies) {
        String etag = cache.getIfPresent(dependencies);
        if (etag != null) {
            LoggerAdapter.debug((Object)this, CACHE_REUSE, etag);
            return etag;
        }
        RESTClientResponse resp = this.post(DEPENDENCY_URL, dependencies);
        etag = RESTUtils.getLocationStoreId(resp);
        if (StringUtils.isNotEmpty((CharSequence)etag)) {
            cache.put(etag, dependencies);
            LoggerAdapter.debug((Object)this, CACHE_CREATED, etag);
        }
        return etag;
    }

    public void deleteDependency(String etagID) {
        String etag = MoserUtil.trimDoubleQuotes(etagID);
        cache.invalidate(etag);
        LoggerAdapter.debug((Object)this, CACHE_INVALIDATED, etag);
        this.delete(DEPENDENCY_URL + etag);
    }
}

