/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ibm.json.java.JSONObject;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DependencyServiceCache {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final Cache<String, JSONObject> jsonCache;
    private final Cache<JSONObject, String> etagCache;

    public DependencyServiceCache(long size, long expiry) {
        this.jsonCache = CacheBuilder.newBuilder().maximumSize(size).expireAfterAccess(expiry, TimeUnit.SECONDS).build();
        this.etagCache = CacheBuilder.newBuilder().maximumSize(size).expireAfterAccess(expiry, TimeUnit.SECONDS).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getIfPresent(String etag) {
        String otherEtag;
        JSONObject json;
        this.readLock.lock();
        try {
            json = (JSONObject)this.jsonCache.getIfPresent((Object)etag);
            if (json == null) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            otherEtag = (String)this.etagCache.getIfPresent((Object)json);
            if (otherEtag != null && etag.compareTo(otherEtag) >= 0) {
                JSONObject jSONObject = json;
                return jSONObject;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            otherEtag = (String)this.etagCache.getIfPresent((Object)json);
            if (otherEtag == null || etag.compareTo(otherEtag) < 0) {
                this.etagCache.put((Object)json, (Object)etag);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIfPresent(JSONObject json) {
        JSONObject otherJSON;
        String etag;
        this.readLock.lock();
        try {
            etag = (String)this.etagCache.getIfPresent((Object)json);
            if (etag == null) {
                String string = null;
                return string;
            }
            otherJSON = (JSONObject)this.jsonCache.getIfPresent((Object)etag);
            if (json.equals((Object)otherJSON)) {
                String string = etag;
                return string;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            otherJSON = (JSONObject)this.jsonCache.getIfPresent((Object)etag);
            if (!json.equals((Object)otherJSON)) {
                this.jsonCache.put((Object)etag, (Object)json);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return etag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String etag, JSONObject json) {
        this.writeLock.lock();
        try {
            this.jsonCache.put((Object)etag, (Object)json);
            String otherEtag = (String)this.etagCache.getIfPresent((Object)json);
            if (otherEtag == null || etag.compareTo(otherEtag) < 0) {
                this.etagCache.put((Object)json, (Object)etag);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void invalidate(String etag) {
        this.writeLock.lock();
        try {
            JSONObject json = (JSONObject)this.jsonCache.getIfPresent((Object)etag);
            if (json == null) {
                return;
            }
            this.jsonCache.invalidate((Object)etag);
            this.etagCache.invalidate((Object)json);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

