/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.ibm.bi.json.JsonArray;
import com.ibm.bi.json.JsonObject;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.platform.moser.common.exceptions.MoserError;
import com.ibm.bi.platform.moser.common.generated.info.MoserInfo;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManagerCM;
import com.ibm.bi.platform.moser.core.module.container.BaseModuleContainer;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.RESTUtils;
import com.ibm.bi.platform.moser.core.rest.service.BaseService;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.RequestEnvironment;
import com.ibm.bi.platform.moser.core.rest.service.UserProfileService;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserInfoUtil;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.soap.services.BiBus;
import com.ibm.bi.soap.services.CamException;
import com.ibm.bi.soap.services.SoapContext;
import com.ibm.bi.soap.services.SoapTransportFactory;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ModuleStorageCM
extends BaseService {
    private static final String TRUSTED_HEADER = "X-CA-Authorization";
    private static final String XQE_SERVICE_ID = "XQE";
    private static final String OBJECTS = "/objects/";
    private static final String ITEMS = "/items";
    private static final String UPS_MODULES_URL = "/temp/modules/";
    private static final String DATASETS_PREFIX = "datasets:";
    private static final String COMMA = ",";
    private static final String EXECUTING = "executing";
    private static final String LOADED = "loaded";
    private static final String SUCCEEDED = "succeeded";
    private static final String TASK_STATUS = "taskStatus";
    protected RESTClientResponse resp;
    private final HttpServletRequest request;
    private final String trustedServiceID;

    protected ModuleStorageCM(RequestEnvironment runtime) {
        super(runtime.getRESTClientConfig());
        this.request = runtime.getHttpServletRequest();
        this.trustedServiceID = this.verifyToken(this.request.getHeader(TRUSTED_HEADER)) ? "MOSER-REST" : null;
    }

    @Override
    protected RESTClient getClient() {
        RESTClient client = super.getClient();
        if (this.isTrusted()) {
            client.makeTrusted(this.trustedServiceID);
        }
        return client;
    }

    public RESTClientResponse getResource(String objectId, String ... fields) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append(OBJECTS);
        url.append(ModuleStorageCM.encodeURIComponent(objectId));
        ModuleStorageCM.addFieldsToURL(url, fields);
        return this.get(url.toString(), "application/json");
    }

    public RESTClientResponse getItems(String objectId, String type, String ... fields) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append(OBJECTS);
        url.append(ModuleStorageCM.encodeURIComponent(objectId));
        url.append(ITEMS);
        boolean fieldsAdded = ModuleStorageCM.addFieldsToURL(url, fields);
        if (type != null && !type.isEmpty()) {
            if (!fieldsAdded) {
                url.append("?types=");
            } else {
                url.append("&types=");
            }
            url.append(type);
        }
        return this.get(url.toString(), "application/json");
    }

    private RESTClientResponse getItems(String objectId, List<String> types, String ... fields) {
        String url = this.buildItemsURL(objectId, types, fields);
        return this.get(url, "application/json");
    }

    private String buildItemsURL(String objectId, List<String> types, String ... fields) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append(OBJECTS);
        url.append(ModuleStorageCM.encodeURIComponent(objectId));
        url.append(ITEMS);
        ModuleStorageCM.addFieldsToURL(url, fields);
        if (types != null && !types.isEmpty()) {
            if (fields == null || fields.length == 0) {
                url.append("?types=");
            } else {
                url.append("&types=");
            }
            boolean first = true;
            for (String type : types) {
                if (type == null) continue;
                if (!first) {
                    url.append(COMMA);
                } else {
                    first = false;
                }
                url.append(type);
            }
        }
        return url.toString();
    }

    public JSONArray getUploadedFileOutputObject(String objectId) {
        this.resp = this.getItems(objectId, "reportVersion", "id");
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        JSONArray children = (JSONArray)this.resp.getJSONObjectResponse().get((Object)"data");
        if (children.size() != 1) {
            return null;
        }
        JSONObject reportVersion = (JSONObject)children.get(0);
        String reportVersionID = reportVersion.get((Object)"id").toString();
        this.resp = this.getItems(reportVersionID, "output", "*");
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        return (JSONArray)this.resp.getJSONObjectResponse().get((Object)"data");
    }

    public JSONObject getBaseModule(String objectId, String ... fields) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append(OBJECTS);
        url.append(ModuleStorageCM.encodeURIComponent(objectId));
        url.append("/base_module");
        ModuleStorageCM.addFieldsToURL(url, fields);
        this.resp = this.get(url.toString(), "application/json");
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        JSONObject objectJSON = this.resp.getJSONObjectResponse();
        if (objectJSON == null) {
            return null;
        }
        JSONArray dataArray = (JSONArray)objectJSON.get((Object)"data");
        if (dataArray == null || dataArray.isEmpty()) {
            return null;
        }
        return (JSONObject)dataArray.get(0);
    }

    public RESTClientResponse putResource(String objectId, JSONObject object) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append(OBJECTS);
        url.append(ModuleStorageCM.encodeURIComponent(objectId));
        return this.put(url.toString(), object);
    }

    public RESTClientResponse putData(String objectId, String mediaType, long length, InputStream stream) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append(OBJECTS);
        url.append(ModuleStorageCM.encodeURIComponent(objectId));
        url.append("/data");
        return this.put(url.toString(), mediaType, length, stream);
    }

    public int getData(String objectId, BufferedOutputStream bos) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append(OBJECTS);
        url.append(ModuleStorageCM.encodeURIComponent(objectId));
        url.append("/data");
        return this.getStream(bos, url.toString(), "application/vnd.ibm.bi.pq");
    }

    public RESTClientResponse delete(String objectId, boolean force, boolean recursive) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append(OBJECTS);
        url.append(ModuleStorageCM.encodeURIComponent(objectId));
        if (force) {
            url.append("?force=true");
        }
        if (recursive) {
            if (force) {
                url.append("&recursive=true");
            } else {
                url.append("?recursive=true");
            }
        }
        return this.delete(url.toString());
    }

    public RESTClientResponse postItems(String objectId, JSONObject object) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append(OBJECTS);
        url.append(ModuleStorageCM.encodeURIComponent(objectId));
        url.append(ITEMS);
        return this.post(url.toString(), object);
    }

    public RESTClientResponse saveBusinessModule(RequestEnvironment runtime, String location, Module module, boolean bTemp, boolean overwrite) {
        String url;
        JSONArray deploymentRefs;
        String xCaRouting;
        String moduleXML = MoserUtil.encode(module, MoserConfig.getStoreModuleZipped());
        JSONObject moduleCM = new JSONObject();
        moduleCM.put((Object)"definition", (Object)moduleXML);
        if (bTemp && (xCaRouting = this.request.getHeader("X-CA-Routing")) != null) {
            moduleCM.put((Object)"routingServerGroup", (Object)xCaRouting);
        }
        if (module.getLabel() == null || "".equals(module.getLabel())) {
            throw new MoserException(MoserError.MODULE_NO_LABEL_ERROR, module.getIdentifier());
        }
        if (module.getExpressionLocale() == null || "".equals(module.getExpressionLocale())) {
            throw new MoserException(MoserError.MODULE_NO_LOCALE_ERROR, module.getIdentifier());
        }
        MoserUtil.checkNameForCM(module);
        moduleCM.put((Object)"defaultName", (Object)module.getLabel());
        moduleCM.put((Object)"type", (Object)"module");
        moduleCM.put((Object)"status", (Object)SUCCEEDED);
        String storeID = bTemp ? null : this.getModuleStoreID(location, module);
        List useSpecs = module.getUseSpec();
        if (useSpecs != null && !useSpecs.isEmpty() && !bTemp) {
            deploymentRefs = this.createDeploymentRefs(module);
            if (!deploymentRefs.isEmpty()) {
                moduleCM.put((Object)"deploymentReferences", (Object)deploymentRefs);
            }
        } else if (!bTemp) {
            deploymentRefs = new JSONArray();
            ModuleObjectManagerCM mom = (ModuleObjectManagerCM)runtime.getModuleObjectManager();
            Map<String, JSONObject> used = mom.getUsedModulesMap(storeID, module);
            for (Map.Entry<String, JSONObject> use : used.entrySet()) {
                MoserInfo useInfo = MoserInfoUtil.createMoserInfo(use.getValue());
                String useID = useInfo.getId();
                JSONObject deploymentRef = new JSONObject();
                JSONObject name = new JSONObject();
                name.put((Object)"locale", (Object)module.getExpressionLocale());
                name.put((Object)"value", (Object)use.getKey());
                JSONArray names = new JSONArray();
                names.add((Object)name);
                deploymentRef.put((Object)"name", (Object)names);
                JSONObject searchPath = new JSONObject();
                if (useID != null && !"".equals(useID)) {
                    if (useID.startsWith(DATASETS_PREFIX)) {
                        useID = useID.substring(DATASETS_PREFIX.length());
                    }
                    searchPath.put((Object)"searchPath", (Object)("storeID('" + useID + "')"));
                } else {
                    searchPath.put((Object)"searchPath", (Object)"unknown");
                }
                searchPath.put((Object)"type", (Object)"module");
                JSONArray searchPaths = new JSONArray();
                searchPaths.add((Object)searchPath);
                deploymentRef.put((Object)"objects", (Object)searchPaths);
                deploymentRefs.add((Object)deploymentRef);
            }
            if (!deploymentRefs.isEmpty()) {
                moduleCM.put((Object)"deploymentReferences", (Object)deploymentRefs);
            }
        }
        String sessionIdSuffix = "";
        if (bTemp) {
            url = this.baseURL + UPS_MODULES_URL;
            sessionIdSuffix = "_sessionTemp";
        } else {
            url = this.baseURL + OBJECTS + ModuleStorageCM.encodeURIComponent(location) + ITEMS;
            if (overwrite) {
                url = url + "?updateAction=replace";
            }
        }
        this.resp = this.post(url, moduleCM);
        String resource = RESTUtils.getLocationStoreId(this.resp);
        if (resource != null) {
            this.resp.setResponseHeader("location", resource + sessionIdSuffix);
        }
        return this.resp;
    }

    private JSONArray createDeploymentRefs(Module module) {
        JSONArray deploymentRefs = new JSONArray();
        for (Module.UseSpec use : module.getUseSpec()) {
            JSONObject childModule = null;
            if (MoserUtil.isStoreId(use.getStoreID())) {
                childModule = this.getObjectFromCM(use.getStoreID(), "id", "searchPath");
            }
            if (childModule == null && StringUtils.isNotEmpty((CharSequence)use.getSearchPath())) {
                childModule = this.getObjectUsingSearchPath(use.getSearchPath(), "id", "searchPath");
            }
            if (childModule == null) continue;
            use.setStoreID((String)childModule.get((Object)"id"));
            use.setSearchPath((String)childModule.get((Object)"searchPath"));
            JSONObject deploymentRef = new JSONObject();
            JSONObject name = new JSONObject();
            name.put((Object)"locale", (Object)module.getExpressionLocale());
            name.put((Object)"value", (Object)use.getIdentifier());
            JSONArray names = new JSONArray();
            names.add((Object)name);
            deploymentRef.put((Object)"name", (Object)names);
            JSONObject searchPath = new JSONObject();
            searchPath.put((Object)"searchPath", (Object)("storeID('" + use.getStoreID() + "')"));
            if (UseSpecType.MODULE.equals((Object)use.getType())) {
                searchPath.put((Object)"type", (Object)"module");
            } else {
                searchPath.put((Object)"type", (Object)"baseModule");
            }
            JSONArray searchPaths = new JSONArray();
            searchPaths.add((Object)searchPath);
            deploymentRef.put((Object)"objects", (Object)searchPaths);
            deploymentRefs.add((Object)deploymentRef);
        }
        return deploymentRefs;
    }

    private String getModuleStoreID(String location, Module module) {
        String getModulesURL = this.baseURL + OBJECTS + ModuleStorageCM.encodeURIComponent(location) + ITEMS;
        this.resp = this.get(getModulesURL);
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        JSONObject objectJSON = this.resp.getJSONObjectResponse();
        if (objectJSON == null) {
            return null;
        }
        JSONArray children = (JSONArray)objectJSON.get((Object)"data");
        ListIterator it = children.listIterator();
        while (it.hasNext()) {
            JSONObject current = (JSONObject)it.next();
            if (!"module".equals(current.get((Object)"type")) || !((String)current.get((Object)"defaultName")).equalsIgnoreCase(module.getLabel())) continue;
            return (String)current.get((Object)"id");
        }
        return null;
    }

    public RESTClientResponse createBaseModuleForDatabase(String owner, BaseModuleContainer baseModule) {
        JSONObject baseModuleCM = new JSONObject();
        baseModuleCM.put((Object)"catalog", (Object)baseModule.getCatalog());
        baseModuleCM.put((Object)"schema", (Object)baseModule.getSchema());
        baseModuleCM.put((Object)"type", (Object)"baseModule");
        baseModuleCM.put((Object)"status", (Object)baseModule.getStatus());
        JSONObject moduleInfo = new JSONObject();
        moduleInfo.put((Object)"id", (Object)baseModule.getDatabaseId());
        JSONArray history = new JSONArray();
        history.add((Object)moduleInfo);
        baseModuleCM.put((Object)"history", (Object)history);
        return this.postRequest(owner, baseModuleCM);
    }

    private RESTClientResponse postRequest(String owner, JSONObject baseModuleCM) {
        String url = this.baseURL + OBJECTS + ModuleStorageCM.encodeURIComponent(owner) + ITEMS;
        return this.post(url, baseModuleCM);
    }

    public int saveBaseModuleForDatabase(BaseModuleContainer baseModule, boolean isZipped) {
        JSONObject baseModuleCM = ModuleStorageCM.prepareBaseModuleJSONForCM(baseModule, isZipped);
        String url = this.baseURL + OBJECTS + baseModule.getStoreId();
        return this.put(url, baseModuleCM).getResponseCode();
    }

    private static JSONObject prepareBaseModuleJSONForCM(BaseModuleContainer baseModule, boolean isZipped) {
        JSONObject baseModuleCM = new JSONObject();
        baseModuleCM.put((Object)"type", (Object)"baseModule");
        if (baseModule.getDefaultName() != null) {
            baseModuleCM.put((Object)"defaultName", (Object)baseModule.getDefaultName());
        }
        if (baseModule.getCatalog() != null) {
            baseModuleCM.put((Object)"catalog", (Object)baseModule.getCatalog());
        }
        if (baseModule.getSchema() != null) {
            baseModuleCM.put((Object)"schema", (Object)baseModule.getSchema());
        }
        if (baseModule.getStatus() != null) {
            baseModuleCM.put((Object)"status", (Object)baseModule.getStatus());
        }
        if (baseModule.getPhysicalModule() != null) {
            String physicalJSON = MoserUtil.encode(baseModule.getPhysicalModule(), isZipped);
            baseModuleCM.put((Object)"physicalDefinition", (Object)physicalJSON);
        }
        if (baseModule.getBaseBusinessModule() != null) {
            String baseJSON = MoserUtil.encode(baseModule.getBaseBusinessModule(), isZipped);
            baseModuleCM.put((Object)"baseDefinition", (Object)baseJSON);
        }
        if (baseModule.getBaseModuleOverride() != null) {
            Module overrides = baseModule.getBaseModuleOverride();
            if (overrides.basicGetQuerySubject() == null || overrides.basicGetQuerySubject().isEmpty()) {
                baseModuleCM.put((Object)"baseOverrides", null);
            } else {
                String baseJSON = MoserUtil.encode(baseModule.getBaseModuleOverride(), isZipped);
                baseModuleCM.put((Object)"baseOverrides", (Object)baseJSON);
            }
        }
        JSONObject moduleInfo = new JSONObject();
        moduleInfo.put((Object)"id", (Object)baseModule.getDatabaseId());
        if (baseModule.getStartTime() != null) {
            moduleInfo.put((Object)"startTime", (Object)baseModule.getStartTime().toString());
        }
        if (baseModule.getEndTime() != null) {
            moduleInfo.put((Object)"endTime", (Object)baseModule.getEndTime().toString());
        }
        if (baseModule.saveStatistics()) {
            moduleInfo.put((Object)"samplingSize", (Object)baseModule.getSamplingSize());
            moduleInfo.put((Object)"numberTables", (Object)baseModule.getNumberTables());
            moduleInfo.put((Object)"numberColumns", (Object)baseModule.getNumberColumns());
            moduleInfo.put((Object)"numberPrimaryKeys", (Object)baseModule.getNumberPrimaryKeys());
            moduleInfo.put((Object)"numberForeignKeys", (Object)baseModule.getNumberForeignKeys());
            moduleInfo.put((Object)"numberIndexes", (Object)baseModule.getNumberIndexes());
        }
        if (baseModule.getJmdExceptions() != null) {
            JSONArray exceptions = new JSONArray();
            List<Exception> jmdExceptions = baseModule.getJmdExceptions();
            for (Exception jmdException : jmdExceptions) {
                JSONObject exception = new JSONObject();
                exception.put((Object)"exceptionMsg", (Object)jmdException.getMessage());
                exception.put((Object)"exceptionStack", (Object)Arrays.toString(jmdException.getStackTrace()));
                Throwable t = jmdException.getCause();
                if (t != null) {
                    exception.put((Object)"exceptionCauseMsg", (Object)t.getMessage());
                    exception.put((Object)"exceptionCauseStack", (Object)Arrays.toString(t.getStackTrace()));
                }
                exceptions.add((Object)exception);
            }
            moduleInfo.put((Object)"jmdExceptions", (Object)exceptions);
        }
        JSONArray history = new JSONArray();
        history.add((Object)moduleInfo);
        if (baseModule.getHistoryMessage() != null) {
            JSONObject jmsg = new JSONObject();
            jmsg.put((Object)"message", (Object)baseModule.getHistoryMessage());
            history.add((Object)jmsg);
        }
        baseModuleCM.put((Object)"history", (Object)history);
        return baseModuleCM;
    }

    public JSONObject getBaseModuleForDatasourceConnection(String storeId, String catalog, String schema, String ... fields) {
        this.resp = this.getItems(storeId, "baseModule,dataSourceSchema", ContentService.appendFields(fields, "catalog", "schema", "defaultName"));
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        JSONObject baseModule = null;
        JSONArray children = (JSONArray)this.resp.getJSONObjectResponse().get((Object)"data");
        for (Object c : children) {
            JSONObject child = (JSONObject)c;
            if (!catalog.equals(child.get((Object)"catalog")) || !schema.equals(child.get((Object)"schema"))) continue;
            if ("dataSourceSchema".equals(child.get((Object)"type"))) {
                return this.getBaseModuleForDataSourceSchema((String)child.get((Object)"id"), fields);
            }
            baseModule = child;
        }
        return baseModule;
    }

    public JSONObject getBaseModuleForDataSourceSchema(String storeId, String ... fields) {
        return this.getBaseModuleChild(storeId, fields);
    }

    public JSONObject getBaseModuleChild(String storeId, String ... fields) {
        Object[] allFields = ContentService.appendFields(fields, "status", "modificationTime", "defaultName");
        if (ArrayUtils.contains((Object[])allFields, (Object)"baseDefinition")) {
            allFields = ContentService.appendFields((String[])allFields, "baseOverrides");
        }
        this.resp = this.getItems(storeId, "baseModule", (String[])allFields);
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        JSONObject result = null;
        String modificationTime = "";
        JSONArray children = (JSONArray)this.resp.getJSONObjectResponse().get((Object)"data");
        for (Object child : children) {
            String modTime;
            JSONObject baseModule = (JSONObject)child;
            String status = (String)baseModule.get((Object)"status");
            if (!SUCCEEDED.equals(status) && !LOADED.equals(status) && (!EXECUTING.equals(status) || !"storeID".equals(fields[0])) || (modTime = (String)baseModule.get((Object)"modificationTime")).compareTo(modificationTime) <= 0) continue;
            result = baseModule;
            modificationTime = modTime;
        }
        return result;
    }

    public boolean deleteObject(String id) {
        String url = this.baseURL + OBJECTS + ModuleStorageCM.encodeURIComponent(id) + "?recursive=true";
        int responseCode = this.delete(url).getResponseCode();
        return responseCode == 200 || responseCode == 204;
    }

    public JSONObject getObjectFromUPS(String id) {
        String url = this.constructUPSModuleURL(id);
        this.resp = this.get(url, "application/json");
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        return this.resp.getJSONObjectResponse();
    }

    private String constructUPSModuleURL(String id) {
        String upsId = id.substring(0, id.length() - "_sessionTemp".length());
        return this.baseURL + UPS_MODULES_URL + ModuleStorageCM.encodeURIComponent(upsId);
    }

    public JSONObject getModuleJSONWithFields(String moduleId, String[] fields) {
        if (UserProfileService.isSessionModule(moduleId)) {
            return this.getObjectFromUPS(moduleId);
        }
        return this.getObjectFromCM(moduleId, fields);
    }

    Object[] getBusinessModuleWithFields(String moduleId, String ... fields) {
        Object[] result = new Object[fields.length];
        JSONObject cmModule = this.getModuleJSONWithFields(moduleId, fields);
        if (cmModule == null) {
            return result;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] == null) continue;
            result[i] = cmModule.get((Object)fields[i]);
        }
        return result;
    }

    public JSONObject getObjectFromCM(String parent, String ... fields) {
        if (!MoserUtil.isStoreId(parent)) {
            return null;
        }
        StringBuilder url = new StringBuilder(this.baseURL).append(OBJECTS).append(ModuleStorageCM.encodeURIComponent(parent));
        ModuleStorageCM.addFieldsToURL(url, fields);
        this.resp = this.get(url.toString(), "application/json");
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        JSONObject objectJSON = this.resp.getJSONObjectResponse();
        if (objectJSON == null) {
            return null;
        }
        JSONArray jArr = (JSONArray)objectJSON.get((Object)"data");
        if (!jArr.isEmpty()) {
            return (JSONObject)jArr.get(0);
        }
        return null;
    }

    private static boolean addFieldsToURL(StringBuilder url, String ... fields) {
        boolean fieldsAdded = false;
        if (fields != null && fields.length > 0) {
            for (String field : fields) {
                if (field == null) continue;
                if (!fieldsAdded) {
                    url.append("?fields=");
                    fieldsAdded = true;
                } else {
                    url.append(COMMA);
                }
                url.append(field);
            }
        }
        return fieldsAdded;
    }

    public boolean updateBaseModule(String id, Module module) {
        return this.updateBaseModule(id, module, "baseDefinition");
    }

    private boolean updateBaseModule(String id, Module module, String baseProp) {
        int responseCode;
        if (id == null || module == null) {
            return false;
        }
        JSONObject baseModule = this.getBaseModuleChild(id, "id");
        String baseModuleStoreID = null;
        if (baseModule != null) {
            baseModuleStoreID = (String)baseModule.get((Object)"id");
        }
        JSONObject moduleCM = new JSONObject();
        moduleCM.put((Object)"type", (Object)"baseModule");
        String moduleXML = MoserUtil.encode(module, MoserConfig.getStoreModuleZipped());
        moduleCM.put((Object)baseProp, (Object)moduleXML);
        moduleCM.put((Object)"defaultName", (Object)module.getLabel());
        if (baseModuleStoreID != null) {
            String url = this.baseURL + OBJECTS + ModuleStorageCM.encodeURIComponent(baseModuleStoreID);
            responseCode = this.put(url, moduleCM).getResponseCode();
        } else {
            String url = this.baseURL + OBJECTS + ModuleStorageCM.encodeURIComponent(id);
            responseCode = this.put(url, moduleCM).getResponseCode();
            if (responseCode != 204 && responseCode != 200) {
                moduleCM.put((Object)"status", (Object)SUCCEEDED);
                responseCode = this.postRequest(id, moduleCM).getResponseCode();
            }
        }
        return responseCode == 204 || responseCode == 200;
    }

    public boolean updateResourceHistory(String sourceID, XMLGregorianCalendar lastAnalysisCollection, XMLGregorianCalendar lastOverridesUpdate, String specification, TaskStatus status) {
        JSONObject historyDetailMoserService = this.getHistoryDetailMoserService(sourceID);
        if (historyDetailMoserService == null) {
            JSONObject history = new JSONObject();
            history.put((Object)"type", (Object)"history");
            RESTClientResponse childResp = this.postItems(sourceID, history);
            if (childResp.getResponseCode() != 201) {
                return false;
            }
            String historyStoreId = RESTUtils.getLocationStoreId(childResp);
            historyDetailMoserService = new JSONObject();
            JSONObject statusInfo = new JSONObject();
            ModuleStorageCM.setHistoryData(historyDetailMoserService, statusInfo, lastAnalysisCollection, lastOverridesUpdate, specification, status);
            historyDetailMoserService.put((Object)"type", (Object)"historyDetailMoserService");
            childResp = this.postItems(historyStoreId, historyDetailMoserService);
            if (childResp.getResponseCode() != 201) {
                return false;
            }
        } else {
            JSONObject statusInfo = (JSONObject)historyDetailMoserService.get((Object)"statusInfo");
            if (statusInfo == null) {
                statusInfo = new JSONObject();
            }
            ModuleStorageCM.setHistoryData(historyDetailMoserService, statusInfo, lastAnalysisCollection, lastOverridesUpdate, specification, status);
            String storeID = (String)historyDetailMoserService.get((Object)"id");
            String putModuleURL = this.baseURL + OBJECTS + ModuleStorageCM.encodeURIComponent(storeID);
            int responseCode = this.put(putModuleURL, historyDetailMoserService).getResponseCode();
            if (responseCode != 204 && responseCode != 200) {
                return false;
            }
        }
        return true;
    }

    private static void setHistoryData(JSONObject historyDetailMoserService, JSONObject statusInfo, XMLGregorianCalendar lastAnalysisCollection, XMLGregorianCalendar lastOverridesUpdate, String specification, TaskStatus status) {
        if (lastAnalysisCollection != null) {
            statusInfo.put((Object)"lastAnalysisCollection", (Object)lastAnalysisCollection.toString());
        }
        if (lastOverridesUpdate != null) {
            statusInfo.put((Object)"lastOverrideUpdate", (Object)lastOverridesUpdate.toString());
        }
        if (status != null) {
            statusInfo.put((Object)TASK_STATUS, (Object)status.toJSON());
        }
        if (specification != null) {
            try {
                JSONObject jObj = JSONObject.parse((String)specification);
                historyDetailMoserService.put((Object)"specification", (Object)jObj);
            }
            catch (IOException e) {
                LoggerAdapter.error(ModuleStorageCM.class, "JSON specification cannot be parsed", e);
            }
        }
        historyDetailMoserService.put((Object)"statusInfo", (Object)statusInfo);
    }

    public boolean updateBusinessModule(String id, Module module) {
        String url;
        if (id == null) {
            return false;
        }
        String moduleXML = MoserUtil.encode(module, MoserConfig.getStoreModuleZipped());
        JSONObject moduleCM = new JSONObject();
        moduleCM.put((Object)"definition", (Object)moduleXML);
        if (!UserProfileService.isSessionModule(id)) {
            JSONObject obj;
            String name;
            RESTClientResponse result = this.getResource(id, "defaultName");
            if (result.getResponseCode() != Response.Status.OK.getStatusCode()) {
                throw new MoserException(MoserError.INTERNAL_ERROR);
            }
            JSONArray data = (JSONArray)result.getJSONObjectResponse().get((Object)"data");
            if (!data.isEmpty() && !(name = (String)(obj = (JSONObject)data.get(0)).get((Object)"defaultName")).equals(module.getLabel())) {
                MoserException e = new MoserException(MoserError.RENAMED_MODULE_WHILE_EDIT, name);
                e.setHTTPStatus(Response.Status.FORBIDDEN.getStatusCode());
                throw e;
            }
        }
        moduleCM.put((Object)"defaultName", (Object)module.getLabel());
        moduleCM.put((Object)"type", (Object)"module");
        if (UserProfileService.isSessionModule(id)) {
            url = this.constructUPSModuleURL(id);
        } else {
            JSONArray deploymentReferences = this.createDeploymentRefs(module);
            moduleCM.put((Object)"deploymentReferences", (Object)deploymentReferences);
            url = this.baseURL + OBJECTS + ModuleStorageCM.encodeURIComponent(id);
        }
        int responseCode = this.put(url, moduleCM).getResponseCode();
        return responseCode == 204 || responseCode == 200;
    }

    public boolean deleteBusinessModule(String id) {
        if (UserProfileService.isSessionModule(id)) {
            String url = this.constructUPSModuleURL(id);
            int responseCode = this.delete(url).getResponseCode();
            return responseCode == 200 || responseCode == 204;
        }
        return this.deleteObject(id);
    }

    public JSONArray getChildrenFromCMFilterByType(String owner, String[] fields, String type) {
        if (!MoserUtil.isStoreId(owner)) {
            return null;
        }
        this.resp = this.getItems(owner, type, fields);
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        JSONObject objectJSON = this.resp.getJSONObjectResponse();
        if (objectJSON == null) {
            return null;
        }
        return (JSONArray)objectJSON.get((Object)"data");
    }

    public JSONObject getBaseModuleFromDefaultOutput(String id, String ... property) {
        return this.getBaseModule(id, property);
    }

    private boolean verifyToken(String token) {
        if (token == null || token.isEmpty()) {
            return false;
        }
        try {
            String serviceID = JCAMCrypto.createTrustedRequestSession().getServiceIDAndVerifyToken(token);
            return XQE_SERVICE_ID.equals(serviceID);
        }
        catch (com.ibm.bi.platform.commons.crypto.CAMCryptoException e) {
            LoggerAdapter.info((Object)this, "problem verifying trust token", e);
            return false;
        }
    }

    public JSONObject getObjectSearchPath(String searchPath, List<String> properties) {
        try {
            TrustedContext soapContext = this.isTrusted() ? new TrustedContext(this.request) : new SoapContext(this.request);
            BiBus biBus = new BiBus(SoapTransportFactory.getInstance().create(), (SoapContext)soapContext, this.baseURL);
            List rt = biBus.contentManager.query(searchPath, properties, null, null);
            Iterator iterator = rt.iterator();
            if (iterator.hasNext()) {
                Object v = iterator.next();
                JsonObject jo = (JsonObject)v;
                JSONObject retJo = new JSONObject();
                this.copyToJSONObject(jo, retJo);
                return retJo;
            }
            return null;
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    private void copyToJSONObject(JsonObject jo, JSONObject retJo) {
        for (Map.Entry e : jo.entrySet()) {
            JsonObject src;
            Object v;
            String key = (String)e.getKey();
            Object newV = v = e.getValue();
            if (v instanceof JsonObject) {
                src = (JsonObject)v;
                newV = new JSONObject();
                this.copyToJSONObject(src, (JSONObject)newV);
            } else if (v instanceof JsonArray) {
                src = (JsonArray)v;
                newV = new JSONArray();
                this.copyToJSONArray((JsonArray)src, (JSONArray)newV);
            }
            retJo.put((Object)key, newV);
        }
    }

    private void copyToJSONArray(JsonArray jo, JSONArray retJo) {
        Iterator iterator = jo.iterator();
        while (iterator.hasNext()) {
            JsonObject src;
            Object v;
            Object newV = v = iterator.next();
            if (v instanceof JsonObject) {
                src = (JsonObject)v;
                newV = new JSONObject();
                this.copyToJSONObject(src, (JSONObject)newV);
            } else if (v instanceof JsonArray) {
                src = (JsonArray)v;
                newV = new JSONArray();
                this.copyToJSONArray((JsonArray)src, (JSONArray)newV);
            }
            retJo.add(newV);
        }
    }

    public JSONObject getParent(String id, String ... fields) {
        JSONObject obj = this.getObjectFromCM(id, "parent");
        JSONObject parent = (JSONObject)((JSONArray)obj.get((Object)"parent")).get(0);
        if (fields != null) {
            parent = this.getObjectFromCM((String)parent.get((Object)"id"), fields);
        }
        return parent;
    }

    public RESTClientResponse getRestClientResponse() {
        return this.resp;
    }

    public void setRestClientResponse(RESTClientResponse response) {
        this.resp = response;
    }

    private static String encodeURIComponent(String input) {
        try {
            return URLEncoder.encode(input, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            LoggerAdapter.errorExceptionStack(BaseService.class, e);
            return input;
        }
    }

    public List<JSONObject> getCMObjectViaSoapBridge(String searchPath, List<String> properties, String securityBlob) throws CamException {
        ArrayList<JSONObject> results = new ArrayList<JSONObject>();
        try {
            SoapContext soapContext = new SoapContext(this.request);
            if (securityBlob != null) {
                soapContext.setSecurityBlobInSoapHeader(securityBlob);
                LoggerAdapter.debug(this, "Modified soap header with security blob: " + soapContext.getSoapHeader().toString());
            }
            BiBus biBus = new BiBus(SoapTransportFactory.getInstance().create(), soapContext, this.baseURL);
            List rt = biBus.contentManager.query(searchPath, properties, null, null);
            for (Object v : rt) {
                JsonObject jo = (JsonObject)v;
                JSONObject retJo = new JSONObject();
                this.copyToJSONObject(jo, retJo);
                results.add(retJo);
            }
            if (LoggerAdapter.isDebugEnabled(this)) {
                LoggerAdapter.debug(this, "CM SOAP-bridge results: " + ((Object)results).toString());
            }
            return results;
        }
        catch (CamException e) {
            JsonObject jObj = (JsonObject)e.getErrorDetails();
            LoggerAdapter.debug(this, "CAMException error Details: " + jObj.toString());
            throw e;
        }
        catch (Exception e) {
            throw new MoserException((Throwable)e);
        }
    }

    public JSONObject getPackageInfo(String packageId) {
        JSONObject packageInfo = new JSONObject();
        ArrayList<String> types = new ArrayList<String>();
        types.add("baseModule");
        types.add("model");
        JSONArray items = this.getItemsArray(packageId, types, "id", "modificationTime");
        if (items == null) {
            return null;
        }
        for (Object o : items) {
            JSONObject statusInfo;
            JSONObject moserDetail;
            JSONObject j = (JSONObject)o;
            if ("model".equals(j.get((Object)"type"))) {
                packageInfo.put((Object)"lastPublishDate", j.get((Object)"modificationTime"));
            }
            if (!"baseModule".equals(j.get((Object)"type")) || (moserDetail = this.getHistoryDetailMoserService((String)j.get((Object)"id"))) == null) continue;
            JSONObject specification = (JSONObject)moserDetail.get((Object)"specification");
            if (specification != null) {
                packageInfo.put((Object)"specification", (Object)specification.toString());
            }
            if ((statusInfo = (JSONObject)moserDetail.get((Object)"statusInfo")) == null) continue;
            String attribute = (String)statusInfo.get((Object)"lastAnalysisCollection");
            if (attribute != null) {
                packageInfo.put((Object)"lastAnalysisCollection", (Object)attribute);
            }
            if ((attribute = (String)statusInfo.get((Object)"lastOverrideUpdate")) == null) continue;
            packageInfo.put((Object)"lastOverrideUpdate", (Object)attribute);
        }
        return packageInfo;
    }

    public JSONObject getHistoryDetailMoserService(String parentID) {
        ArrayList<String> types = new ArrayList<String>();
        types.add("history");
        JSONArray histories = this.getItemsArray(parentID, types, "id", "modificationTime");
        if (histories == null) {
            return null;
        }
        types.clear();
        types.add("historyDetailMoserService");
        long lastModified = 0L;
        JSONArray moserDetails = null;
        for (Object h : histories) {
            long currLastModified;
            JSONObject history = (JSONObject)h;
            String historyID = (String)history.get((Object)"id");
            JSONArray currMoserDetails = this.getItemsArray(historyID, types, "id", "statusInfo", "specification", "modificationTime");
            if (currMoserDetails == null || currMoserDetails.isEmpty() || (currLastModified = MoserUtil.getLastModifiedFromCS((JSONObject)currMoserDetails.get(0))) <= lastModified) continue;
            moserDetails = currMoserDetails;
            lastModified = currLastModified;
        }
        if (moserDetails == null || moserDetails.isEmpty()) {
            return null;
        }
        return (JSONObject)moserDetails.get(0);
    }

    private JSONArray getItemsArray(String objectId, List<String> types, String ... fields) {
        this.resp = this.getItems(objectId, types, fields);
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        JSONObject json = this.resp.getJSONObjectResponse();
        if (json == null) {
            return null;
        }
        return (JSONArray)json.get((Object)"data");
    }

    public String getBaseModuleStoreID(String id) {
        JSONObject baseModule = this.getBaseModule(id, "id");
        if (baseModule != null) {
            return (String)baseModule.get((Object)"id");
        }
        return null;
    }

    public int putBaseModule(BaseModuleContainer baseModule, boolean isZipped) {
        JSONObject baseModuleCM = ModuleStorageCM.prepareBaseModuleJSONForCM(baseModule, isZipped);
        return this.putBaseModule(baseModule.getParentId(), baseModuleCM).getResponseCode();
    }

    private RESTClientResponse putBaseModule(String storeID, JSONObject baseModuleCM) {
        return this.put(this.getBaseModuleURL(storeID), baseModuleCM);
    }

    private String getBaseModuleURL(String storeID) {
        return this.baseURL + OBJECTS + storeID + "/base_module";
    }

    public boolean isTrusted() {
        return this.trustedServiceID != null && !this.trustedServiceID.isEmpty();
    }

    public JSONObject getObjectUsingSearchPath(String searchPath, String ... fields) {
        StringBuilder url = new StringBuilder(this.baseURL);
        url.append("/search_path");
        ModuleStorageCM.addFieldsToURL(url, fields);
        url.append("&searchPath=" + searchPath);
        this.resp = this.get(url.toString(), "application/json");
        if (this.resp.getResponseCode() != 200) {
            return null;
        }
        JSONObject objectJSON = this.resp.getJSONObjectResponse();
        if (objectJSON == null) {
            return null;
        }
        JSONArray children = (JSONArray)objectJSON.get((Object)"data");
        if (children == null || children.isEmpty()) {
            return null;
        }
        return (JSONObject)children.get(0);
    }

    private static class TrustedContext
    extends SoapContext {
        public TrustedContext(HttpServletRequest request) {
            super(request);
        }

        public boolean isTrusted() {
            return true;
        }

        public byte[] setMessageTrust(byte[] request) {
            try {
                CAMFactory factory = new CAMFactory("MOSER-REST");
                TrustedRequestSession session = factory.createTrustedSession();
                return session.setMessageTrust("MOSER-REST", request);
            }
            catch (CAMCryptoException e) {
                LoggerAdapter.errorExceptionStack(ModuleStorageCM.class, e);
                return request;
            }
        }
    }
}

