/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.BaseRESTService;
import com.ibm.bi.platform.moser.core.rest.service.IResource;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.json.java.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;

public class ReportService
extends BaseRESTService {
    public static final String OBJECT_PATH = "objectPath";
    public static final String SPECIFICATION = "specification";
    public static final String STORE_ID = "storeID(\"%s\")";

    protected ReportService(RESTClientConfig c) {
        super(c);
    }

    @Override
    protected RESTClient getClient() {
        RESTClient client = super.getClient();
        client.makeTrusted("MOSER-REST");
        return client;
    }

    public RESTClientResponse normalizedSpec(String id, String spec) {
        JSONObject body = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            body.put((Object)OBJECT_PATH, (Object)(MoserUtil.isStoreId(id) ? String.format(STORE_ID, id) : id));
        }
        if (StringUtils.isNotEmpty((CharSequence)spec)) {
            body.put((Object)SPECIFICATION, (Object)spec);
        }
        this.acceptXMLText();
        return this.postResource(ReportResource.REPORTS, null, ReportSubResource.NORMALIZED_SPEC, null, null, null, body);
    }

    private void acceptXMLText() {
        String accept;
        Header acceptHeader = this.config.getRequestHeader("Accept");
        String string = accept = acceptHeader == null ? null : acceptHeader.getValue();
        if (StringUtils.isEmpty((CharSequence)accept) || !accept.contains("text/xml")) {
            accept = StringUtils.isEmpty((CharSequence)accept) ? "text/xml" : accept + ", " + "text/xml";
        }
        this.config.setRequestHeader("Accept", accept);
    }

    public static enum ReportSubResource implements IResource
    {
        NORMALIZED_SPEC("normalizedspec");

        private final String value;

        private ReportSubResource(String v) {
            this.value = v;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    public static enum ReportResource implements IResource
    {
        REPORTS("reports");

        private final String value;

        private ReportResource(String v) {
            this.value = v;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }
}

