/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.ibm.bi.platform.commons.shared.UserPreferences;
import com.ibm.bi.platform.moser.common.utils.MoserConnectionSpec;
import com.ibm.bi.platform.moser.core.cm.AdminDatabaseService;
import com.ibm.bi.platform.moser.core.cm.SchemaDescriptor;
import com.ibm.bi.platform.moser.core.cm.SearchService;
import com.ibm.bi.platform.moser.core.cm.TrustedSearchService;
import com.ibm.bi.platform.moser.core.cm.UserProfile;
import com.ibm.bi.platform.moser.core.cm.kerberos.CAMCryptoDancer;
import com.ibm.bi.platform.moser.core.cm.kerberos.ICryptoDancer;
import com.ibm.bi.platform.moser.core.config.MoserConfig;
import com.ibm.bi.platform.moser.core.metadata.MetadataEngine;
import com.ibm.bi.platform.moser.core.metadata.config.MetadataEngineConfig;
import com.ibm.bi.platform.moser.core.module.IModuleObjectManager;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManagerCM;
import com.ibm.bi.platform.moser.core.module.ModuleObjectManagerFile;
import com.ibm.bi.platform.moser.core.rest.service.AccountService;
import com.ibm.bi.platform.moser.core.rest.service.AdminService;
import com.ibm.bi.platform.moser.core.rest.service.ClonePassportService;
import com.ibm.bi.platform.moser.core.rest.service.ContentService;
import com.ibm.bi.platform.moser.core.rest.service.DatasetService;
import com.ibm.bi.platform.moser.core.rest.service.DependencyService;
import com.ibm.bi.platform.moser.core.rest.service.GenericService;
import com.ibm.bi.platform.moser.core.rest.service.ModuleStorageCM;
import com.ibm.bi.platform.moser.core.rest.service.MoserCommandService;
import com.ibm.bi.platform.moser.core.rest.service.NotificationService;
import com.ibm.bi.platform.moser.core.rest.service.ReportService;
import com.ibm.bi.platform.moser.core.rest.service.SchedulingService;
import com.ibm.bi.platform.moser.core.rest.service.SmartsService;
import com.ibm.bi.platform.moser.core.rest.service.TrustedContentService;
import com.ibm.bi.platform.moser.core.rest.service.UserProfileService;
import com.ibm.bi.platform.moser.core.rest.service.VersionService;
import com.ibm.bi.platform.moser.core.tasks.MoserTaskManager;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.bi.soap.services.ClonedServletRequest;
import com.ibm.json.java.JSONArray;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RequestEnvironment {
    public static final String IBMCOGNOS_PASSPORT = "IBMCOGNOS_PASSPORT";
    public static final String IBMCOGNOS_SG_DEST = "IBMCOGNOS_SG_DEST";
    public static final String EMPTY_ROUTING_SERVER_GROUP = "__IBMCOGNOS_EMPTY_ROUTING_SERVER_GROUP__";
    private static final String CAM_PASSPORT = "cam_passport";
    private static final String NO_NAME = "no_name";
    private static final String DEFAULT_LOCALE = "en";
    private static final String CAPABILITY_UPLOAD_FILES = "canUploadFiles";
    private static final String CAPABILITY_CAN_RECEIVE_DETAIL_ERRORS = "canReceiveDetailedErrors";
    private boolean trusted;
    private RESTClientConfig config;
    private final ClonedServletRequest request;
    private final UserPreferences userPreferences;
    private final Map<String, Object> parameters;
    private final String baseURL;
    private final Locale contentLocale;
    private final Locale productLocale;
    private TaskStatus taskStatus;
    private final UserProfile userProfile;
    private final String camPassport;
    private final Map<String, JSONArray> ancestorsMap;
    private final Map<String, String> routingServerGroupsMap;
    private Set<String> capabilities;
    private MoserTaskManager taskManager;
    private AccountService accountService;
    private AdminService adminService;
    private ContentService contentService;
    private NotificationService notificationService;
    private ReportService reportService;
    private SchedulingService schedulingService;
    private SearchService searchService;
    private SmartsService smartsService;
    private UserProfileService userProfileService;
    private ModuleStorageCM moduleStorageCM;
    private AdminDatabaseService adminDatabaseService;
    private IModuleObjectManager moduleObjectManager;
    private MoserCommandService moserCommandService;
    private DatasetService datasetService;
    private ClonePassportService clonePassportService;
    private DependencyService dependencyService;
    private VersionService versionService;
    private GenericService genericService;
    private ICryptoDancer camNegotiator;
    private ExecutorService executorService;

    public RequestEnvironment(HttpServletRequest request, UserPreferences userPreferences, String baseURL) {
        this.config = new RESTClientConfig(request);
        this.request = new ClonedServletRequest(request);
        this.userPreferences = userPreferences;
        this.parameters = new HashMap<String, Object>();
        this.baseURL = baseURL;
        this.contentLocale = Locale.forLanguageTag(RequestEnvironment.getOrDefault(userPreferences.getContentLocale(), DEFAULT_LOCALE));
        this.productLocale = Locale.forLanguageTag(RequestEnvironment.getOrDefault(userPreferences.getProductLocale(), DEFAULT_LOCALE));
        this.taskStatus = new TaskStatus();
        this.userProfile = new UserProfile(this);
        this.taskManager = null;
        this.camPassport = this.getCookie(CAM_PASSPORT);
        this.ancestorsMap = new ConcurrentHashMap<String, JSONArray>();
        this.routingServerGroupsMap = new ConcurrentHashMap<String, String>();
    }

    public RequestEnvironment(RESTClientConfig config) {
        this.config = config;
        this.request = null;
        this.userPreferences = new UserPreferences();
        this.parameters = new HashMap<String, Object>();
        this.baseURL = null;
        this.contentLocale = Locale.forLanguageTag(RequestEnvironment.getOrDefault(this.userPreferences.getContentLocale(), DEFAULT_LOCALE));
        this.productLocale = Locale.forLanguageTag(RequestEnvironment.getOrDefault(this.userPreferences.getProductLocale(), DEFAULT_LOCALE));
        this.taskStatus = new TaskStatus();
        this.userProfile = new UserProfile(this);
        this.taskManager = null;
        this.camPassport = null;
        this.ancestorsMap = new ConcurrentHashMap<String, JSONArray>();
        this.routingServerGroupsMap = new ConcurrentHashMap<String, String>();
    }

    public RequestEnvironment(HttpServletRequest request, RequestEnvironment otherRequestEnv) {
        this.config = new RESTClientConfig(request);
        this.request = new ClonedServletRequest(request);
        this.userPreferences = otherRequestEnv.getUserPreferences();
        this.parameters = otherRequestEnv.getParameters();
        this.baseURL = otherRequestEnv.baseURL;
        this.contentLocale = Locale.forLanguageTag(RequestEnvironment.getOrDefault(this.userPreferences.getContentLocale(), DEFAULT_LOCALE));
        this.productLocale = Locale.forLanguageTag(RequestEnvironment.getOrDefault(this.userPreferences.getProductLocale(), DEFAULT_LOCALE));
        this.taskStatus = otherRequestEnv.getTaskStatus();
        this.userProfile = new UserProfile(this);
        this.taskManager = null;
        this.camPassport = otherRequestEnv.getCamPassport();
        this.ancestorsMap = new ConcurrentHashMap<String, JSONArray>(otherRequestEnv.getAncestorsMap());
        this.routingServerGroupsMap = new ConcurrentHashMap<String, String>(otherRequestEnv.getRoutingServerGroupsMap());
    }

    public RequestEnvironment(RESTClientConfig config, boolean trusted) {
        this(config);
        this.trusted = trusted;
    }

    public RESTClientConfig getRESTClientConfig() {
        return this.config;
    }

    @Deprecated
    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public Object getUserPreference(String name, String defaultValue) {
        return RequestEnvironment.getOrDefault(this.userPreferences.getPreference(name), defaultValue);
    }

    public String getUserName() {
        return RequestEnvironment.getOrDefault(this.userPreferences.getUserName(), NO_NAME);
    }

    public String getUserDisplayName() {
        return RequestEnvironment.getOrDefault(this.userPreferences.getUserDisplayName(), NO_NAME);
    }

    public String getUserId() {
        return this.userPreferences.getPreference("id");
    }

    public String getCamPassport() {
        return this.camPassport;
    }

    private String getCookie(String name) {
        Object[] cookies;
        if (this.request != null && ArrayUtils.isNotEmpty((Object[])(cookies = this.request.getCookies()))) {
            for (Object cookie : cookies) {
                if (!name.equalsIgnoreCase(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public Locale getProductLocale() {
        return this.productLocale;
    }

    public Locale getContentLocale() {
        return this.contentLocale;
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public Object setParam(String key, Object value) {
        if (key == null) {
            return null;
        }
        return this.parameters.put(key, value);
    }

    public Object getParam(String key) {
        if (key == null) {
            return null;
        }
        return this.parameters.get(key);
    }

    public String getStringParam(String key) {
        return (String)this.getParam(key);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    private static String getOrDefault(String value, String defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public synchronized boolean hasCapability(String capability) {
        if (this.capabilities == null) {
            this.capabilities = new HashSet<String>((Collection<String>)this.userProfile.getUserCapabilities());
        }
        return this.capabilities.contains(capability);
    }

    public MoserTaskManager getTaskManager() {
        return this.taskManager;
    }

    public void setTaskManager(MoserTaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public AccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = this.createAccountService();
        }
        return this.accountService;
    }

    public AccountService createAccountService() {
        return new AccountService(this.getRESTClientConfig());
    }

    public AdminService getAdminService() {
        if (this.adminService == null) {
            this.adminService = this.createAdminService();
        }
        return this.adminService;
    }

    public AdminService createAdminService() {
        return new AdminService(this.getRESTClientConfig());
    }

    public ContentService getContentService() {
        if (this.contentService == null) {
            this.contentService = this.createContentService();
        }
        return this.contentService;
    }

    public ContentService createContentService() {
        return this.trusted ? new TrustedContentService(this.getRESTClientConfig()) : new ContentService(this.getRESTClientConfig());
    }

    public NotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = this.createNotificationService();
        }
        return this.notificationService;
    }

    public NotificationService createNotificationService() {
        return new NotificationService(this.getRESTClientConfig());
    }

    public ReportService getReportService() {
        if (this.reportService == null) {
            this.reportService = this.createReportService();
        }
        return this.reportService;
    }

    public ReportService createReportService() {
        return new ReportService(this.getRESTClientConfig());
    }

    public SchedulingService getSchedulingService() {
        if (this.schedulingService == null) {
            this.schedulingService = this.createSchedulingService();
        }
        return this.schedulingService;
    }

    public SchedulingService createSchedulingService() {
        return new SchedulingService(this.getRESTClientConfig());
    }

    public SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = this.createSearchService();
        }
        return this.searchService;
    }

    public SearchService createSearchService() {
        return this.trusted ? new TrustedSearchService(this.getRESTClientConfig()) : new SearchService(this.getRESTClientConfig());
    }

    public SmartsService getSmartsService() {
        if (this.smartsService == null) {
            this.smartsService = this.createSmartsService();
        }
        return this.smartsService;
    }

    public SmartsService createSmartsService() {
        return SmartsService.from(this.getRESTClientConfig());
    }

    public UserProfileService getUserProfileService() {
        if (this.userProfileService == null) {
            this.userProfileService = this.createUserProfileService();
        }
        return this.userProfileService;
    }

    public UserProfileService createUserProfileService() {
        return new UserProfileService(this.getRESTClientConfig());
    }

    public ModuleStorageCM getModuleStorageCM() {
        if (this.moduleStorageCM == null) {
            this.moduleStorageCM = this.createModuleStorageCM();
        }
        return this.moduleStorageCM;
    }

    public ModuleStorageCM createModuleStorageCM() {
        return new ModuleStorageCM(this);
    }

    public AdminDatabaseService getAdminDatabaseService() {
        if (this.adminDatabaseService == null) {
            this.adminDatabaseService = this.createAdminDatabaseService();
        }
        return this.adminDatabaseService;
    }

    public AdminDatabaseService createAdminDatabaseService() {
        return new AdminDatabaseService(this);
    }

    public MoserCommandService getMoserCommandService() {
        if (this.moserCommandService == null) {
            this.moserCommandService = this.createMoserCommandService();
        }
        return this.moserCommandService;
    }

    public MoserCommandService createMoserCommandService() {
        return new MoserCommandService(this.getRESTClientConfig());
    }

    public DatasetService getDatasetService() {
        if (this.datasetService == null) {
            this.datasetService = this.createDatasetService();
        }
        return this.datasetService;
    }

    public DatasetService createDatasetService() {
        return new DatasetService(this.getRESTClientConfig());
    }

    public ClonePassportService getClonePassportService() {
        if (this.clonePassportService == null) {
            this.clonePassportService = this.createClonePassportService();
        }
        return this.clonePassportService;
    }

    public ClonePassportService createClonePassportService() {
        return new ClonePassportService(this.getRESTClientConfig());
    }

    public DependencyService getDependencyService() {
        if (this.dependencyService == null) {
            this.dependencyService = this.createDependencyService();
        }
        return this.dependencyService;
    }

    public DependencyService createDependencyService() {
        return new DependencyService(this.getRESTClientConfig());
    }

    public VersionService getVersionService() {
        if (this.versionService == null) {
            this.versionService = this.createVersionService();
        }
        return this.versionService;
    }

    public VersionService createVersionService() {
        return new VersionService(this.getRESTClientConfig());
    }

    public GenericService getGenericService() {
        if (this.genericService == null) {
            this.genericService = this.createGenericService();
        }
        return this.genericService;
    }

    public GenericService createGenericService() {
        return new GenericService(this.getRESTClientConfig());
    }

    public IModuleObjectManager getModuleObjectManager() {
        if (this.moduleObjectManager == null) {
            this.moduleObjectManager = this.createModuleObjectManager(null);
        }
        return this.moduleObjectManager;
    }

    public IModuleObjectManager createModuleObjectManager(String connectionSpecJSON) {
        String target = MoserConfig.getInstance().getModuleStorage();
        MoserConnectionSpec connSpec = connectionSpecJSON != null ? new MoserConnectionSpec(null, connectionSpecJSON) : null;
        switch (target) {
            case "toCM": {
                return new ModuleObjectManagerCM(this, connSpec);
            }
        }
        return new ModuleObjectManagerFile(this);
    }

    public ICryptoDancer getCryptoDancer() {
        if (this.camNegotiator == null) {
            this.camNegotiator = this.createCryptoDancer();
        }
        return this.camNegotiator;
    }

    private ICryptoDancer createCryptoDancer() {
        return new CAMCryptoDancer(this);
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSmartsService(SmartsService smartsService) {
        this.smartsService = smartsService;
    }

    public void setUserProfileService(UserProfileService userProfileService) {
        this.userProfileService = userProfileService;
    }

    public void setModuleObjectManager(IModuleObjectManager moduleObjectManager) {
        this.moduleObjectManager = moduleObjectManager;
    }

    public void setMoserCommandService(MoserCommandService moserCommandService) {
        this.moserCommandService = moserCommandService;
    }

    public void setModuleStorageCM(ModuleStorageCM moduleStorageCM) {
        this.moduleStorageCM = moduleStorageCM;
    }

    public void setAdminDatabaseService(AdminDatabaseService adminDatabaseService) {
        this.adminDatabaseService = adminDatabaseService;
    }

    public void setAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    public void setClonePassportService(ClonePassportService clonePassportService) {
        this.clonePassportService = clonePassportService;
    }

    public void setGenericService(GenericService genericService) {
        this.genericService = genericService;
    }

    public boolean hasFileUploadCapability() {
        return this.hasCapability(CAPABILITY_UPLOAD_FILES);
    }

    public boolean canReceiveDetailErrorsCapability() {
        return this.hasCapability(CAPABILITY_CAN_RECEIVE_DETAIL_ERRORS);
    }

    public void setPassportProperty(Properties properties) {
        if (properties.containsKey(IBMCOGNOS_SG_DEST) && this.camPassport != null) {
            properties.put(IBMCOGNOS_PASSPORT, this.camPassport);
        }
    }

    public MetadataEngine createMetadataEngine(MetadataEngineConfig c) {
        return new MetadataEngine(this, c);
    }

    public SchemaDescriptor createSchemaDescriptor(MetadataEngine engine) {
        return new SchemaDescriptor(this, engine);
    }

    public synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.getExecutorServiceFromRequest();
            if (this.executorService == null) {
                this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            }
        }
        return this.executorService;
    }

    private ExecutorService getExecutorServiceFromRequest() {
        if (this.request == null) {
            return null;
        }
        ServletContext context = this.request.getServletContext();
        if (context == null) {
            return null;
        }
        return (ExecutorService)context.getAttribute("execSvc");
    }

    public Map<String, JSONArray> getAncestorsMap() {
        return this.ancestorsMap;
    }

    public JSONArray addAncestorsMap(String key, JSONArray value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return null;
        }
        return this.ancestorsMap.put(key, value);
    }

    public Map<String, String> getRoutingServerGroupsMap() {
        return this.routingServerGroupsMap;
    }

    public String addRoutingServerGroupsMap(String key, String value) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        String value2 = value;
        if (StringUtils.isEmpty((CharSequence)value2)) {
            value2 = EMPTY_ROUTING_SERVER_GROUP;
        }
        return this.routingServerGroupsMap.put(key, value2);
    }

    public static final class Parameters {
        public static final String CATALOG_NAME = "catalogName";
        public static final String CONNECTION_SPEC = "connectionSpec";
        public static final String DATA_SOURCE_CONNECTION_ID = "dataSourceConnectionId";
        public static final String DATA_SOURCE_CONNECTION_NAME = "dataSourceConnectionName";
        public static final String DATA_SOURCE_ID = "dataSourceId";
        public static final String DATA_SOURCE_NAME = "dataSourceName";
        public static final String DATA_SOURCE_SIGNON_NAME = "dataSourceSignonName";
        public static final String SCHEMA_NAME = "schemaName";

        private Parameters() {
        }
    }
}

