/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.core.rest.service;

import com.ibm.bi.platform.moser.core.module.SmartsStatusUpdater;
import com.ibm.bi.platform.moser.core.rest.RESTClientResponse;
import com.ibm.bi.platform.moser.core.rest.service.BaseRESTService;
import com.ibm.bi.platform.moser.core.rest.service.IResource;
import com.ibm.bi.platform.moser.core.tasks.BaseMoserTask;
import com.ibm.bi.platform.moser.core.tasks.TaskStatus;
import com.ibm.bi.platform.moser.core.utils.LoggerAdapter;
import com.ibm.bi.platform.moser.core.utils.MoserUtil;
import com.ibm.bi.platform.moser.core.utils.Pair;
import com.ibm.bi.rest.RESTClientConfig;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.JAXBHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import javax.ws.rs.core.UriBuilder;

public class SmartsService
extends BaseRESTService {
    public static final String SMARTS_BASE = "/smarts";
    public static final String SMART_PROGRESS_URI = "progressUri";
    public static final String SMART_MODULE_URI = "smartModuleUri";
    public static final String COMPLETED_SMARTS_MODULE = "completedSmartsModule";
    private static Function<RESTClientConfig, SmartsService> creator;

    protected SmartsService(RESTClientConfig c) {
        super(c);
        this.baseURL = this.baseURL + SMARTS_BASE;
    }

    public static void setCreator(Function<RESTClientConfig, SmartsService> creatorFunction) {
        creator = creatorFunction;
    }

    public static SmartsService from(RESTClientConfig c) {
        if (creator == null) {
            return new SmartsService(c);
        }
        return creator.apply(c);
    }

    public RESTClientResponse getSmartsModule(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)this.baseURL).path(SmartsResource.MODULE.toString()).path("{id}");
        return this.get(builder.build(new Object[]{id}).toString());
    }

    public RESTClientResponse getSmartsModuleByUri(String uri) {
        return this.get(uri);
    }

    public RESTClientResponse getProgress(String id) {
        UriBuilder builder = UriBuilder.fromPath((String)this.baseURL).path(SmartsResource.MODULE.toString()).path("{id}").path(SmartsSubResource.PROGRESS.toString());
        return this.get(builder.build(new Object[]{id}).toString());
    }

    public RESTClientResponse getProgressByUri(String uri) {
        return this.get(uri);
    }

    public RESTClientResponse createSmartsModule(String id, String moduleUri, String type, AnalysisMode analysisMode, JSONObject loadOptions, String connections) {
        UriBuilder builder = UriBuilder.fromPath((String)this.baseURL).path(SmartsResource.MODULE.toString()).path("{id}").queryParam("type", new Object[]{type}).queryParam("analysisMode", new Object[]{analysisMode}).queryParam("moduleUri", new Object[]{moduleUri});
        if (connections != null) {
            try {
                builder = builder.queryParam("connections", new Object[]{connections});
            }
            catch (IllegalArgumentException e) {
                LoggerAdapter.error((Object)this, "bad connectionInfo specification: " + connections, e);
            }
        }
        if (loadOptions != null) {
            LoggerAdapter.info(this, "Smarts module created with loadOptions: " + loadOptions);
            return this.post(builder.build(new Object[]{id}).toString(), loadOptions);
        }
        return this.post(builder.build(new Object[]{id}).toString(), new JSONObject());
    }

    public RESTClientResponse postModule(JSONObject jModule) {
        UriBuilder builder = UriBuilder.fromPath((String)this.baseURL).path(SmartsResource.MODULE.toString());
        return this.post(builder.build(new Object[0]).toString(), jModule);
    }

    public RESTClientResponse getModuleProposals(String intent, String assetId, int maxNumberOfProposals) {
        UriBuilder builder = UriBuilder.fromPath((String)this.baseURL).path(SmartsResource.MODELING.toString()).path(SmartsResource.MODULE.toString()).path("{id}").path(SmartsSubResource.MODULE_PROPOSALS.toString()).queryParam("intent", new Object[]{intent}).queryParam("maxNumberOfProposals", new Object[]{maxNumberOfProposals});
        return this.get(builder.build(new Object[]{assetId}).toString());
    }

    public RESTClientResponse getJoinProposals(String moduleId, String ... querySubjects) {
        UriBuilder builder = UriBuilder.fromPath((String)this.baseURL).path(SmartsResource.MODELING.toString()).path(SmartsResource.MODULE.toString()).path("{id}").path(SmartsSubResource.JOIN_PROPOSALS.toString()).queryParam("max", new Object[]{1}).queryParam("querySubjects", (Object[])Arrays.copyOf(querySubjects, querySubjects.length, Object[].class));
        return this.get(builder.build(new Object[]{moduleId}).toString());
    }

    public SmartsModule getSmartsModule(String smartsModuleUri, String progressUri, TaskStatus status, Locale productLocale) {
        this.waitForKnowledgeDiscoveryComplete(progressUri, status, productLocale);
        BaseMoserTask.throwIfCancelled(status, "collect smarts");
        if (status.isError()) {
            return null;
        }
        RESTClientResponse smartsModuleResponse = this.getSmartsModuleByUri(smartsModuleUri);
        byte[] smartsModuleBytes = smartsModuleResponse.getRawResponse();
        if (smartsModuleBytes.length == 0) {
            LoggerAdapter.error(this, "Missing smarts module: " + smartsModuleUri);
        }
        BaseMoserTask.throwIfCancelled(status, "collect smarts");
        return SmartsService.decodeSmartsModule(smartsModuleBytes);
    }

    public void waitForKnowledgeDiscoveryComplete(String progressUri, TaskStatus status, Locale productLocale) {
        BaseMoserTask.throwIfCancelled(status, "collect smarts");
        RESTClientResponse resp = this.getProgressByUri(progressUri);
        String msg = new String(resp.getRawResponse(), StandardCharsets.UTF_8);
        JSONObject msgObj = new JSONObject();
        try {
            msgObj = JSONObject.parse((String)msg);
        }
        catch (IOException e1) {
            LoggerAdapter.error((Object)this, "Invalid Progress response", e1);
        }
        BaseMoserTask.throwIfCancelled(status, "collect smarts");
        String state = SmartsStatusUpdater.update(status, msgObj, productLocale);
        if (status.isError()) {
            return;
        }
        int numIterations = 0;
        while ((resp.getResponseCode() == 200 || resp.getResponseCode() == 202) && state == "EXECUTING") {
            try {
                Thread.sleep(MoserUtil.getPollingTime(numIterations++, 25, 25, 10, 5000));
            }
            catch (InterruptedException e) {
                LoggerAdapter.error((Object)this, "InterruptedException Waiting for Smarts progress", e);
            }
            BaseMoserTask.throwIfCancelled(status, "collect smarts");
            resp = this.getProgressByUri(progressUri);
            msgObj = resp.getJSONObjectResponse();
            if (LoggerAdapter.isDebugEnabled(this)) {
                LoggerAdapter.debug(this, "Smarts status response: " + msgObj.toString());
            }
            BaseMoserTask.throwIfCancelled(status, "collect smarts");
            state = SmartsStatusUpdater.update(status, msgObj, productLocale);
            if (!status.isError()) continue;
            return;
        }
    }

    public static SmartsModule decodeSmartsModule(byte[] smartsModuleBytes) {
        SmartsModule result = null;
        try (ByteArrayInputStream smartsModuleStream = new ByteArrayInputStream(smartsModuleBytes);){
            result = (SmartsModule)JAXBHelper.unmarshalFromJSON(SmartsModule.class, (InputStream)smartsModuleStream);
        }
        catch (IOException e) {
            LoggerAdapter.error(SmartsService.class, "Invalid smarts module", e);
        }
        return result;
    }

    public Pair<String, String> parseCreateSmartsModuleResponse(RESTClientResponse response) {
        String smartsModuleUri = null;
        String progressUri = null;
        if (response != null && response.getRawResponse() != null) {
            String responseString = new String(response.getRawResponse(), StandardCharsets.UTF_8);
            try {
                JSONObject responseJson = JSONObject.parse((String)responseString);
                smartsModuleUri = (String)responseJson.get((Object)SMART_MODULE_URI);
                progressUri = smartsModuleUri + "/progressSummary";
            }
            catch (IOException e) {
                LoggerAdapter.error((Object)this, "Failed to parse smarts module response.", e);
            }
        }
        return new Pair<Object, Object>(smartsModuleUri, progressUri);
    }

    public void cancelSmartsCollection(String resourceID) {
        UriBuilder builder = UriBuilder.fromPath((String)this.baseURL).path(SmartsResource.MODULE.toString()).path("{id}");
        RESTClientResponse resp = this.delete(builder.build(new Object[]{resourceID}).toString());
        LoggerAdapter.info(this, "Sent cancel to smart service: response code = " + resp.getResponseCode());
    }

    public static enum AnalysisMode {
        DEEP("deep"),
        SHALLOW("shallow");

        private final String value;

        private AnalysisMode(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SmartsSubResource implements IResource
    {
        JOIN_PROPOSALS("join-proposals"),
        PROGRESS("progress"),
        MODULE_PROPOSALS("module-proposals");

        private final String value;

        private SmartsSubResource(String v) {
            this.value = v;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    public static enum SmartsResource implements IResource
    {
        MODULE("module"),
        MODELING("modeling");

        private final String value;

        private SmartsResource(String v) {
            this.value = v;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }
}

